/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.common.document.impl;

import dguv.daleuv.common.document.DaleSegment;
import dguv.unidav.common.document.UniDavDocumentException;
import dguv.unidav.common.utils.DateTimeHelper;
import java.sql.Date;
import java.sql.Time;
import java.text.ParseException;
import java.util.Enumeration;
import java.util.Vector;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XSLException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DaleSegmentImpl
implements DaleSegment {
    private XMLElement segment = null;

    public DaleSegmentImpl(XMLElement aSegment) {
        this.segment = aSegment;
    }

    @Override
    public String getString(String aElementName) throws UniDavDocumentException {
        try {
            NodeList lNodes = this.segment.selectNodes(aElementName + "/text()", this.segment);
            if (lNodes.getLength() > 0) {
                return lNodes.item(0).getNodeValue().trim();
            }
            return "";
        }
        catch (XSLException e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public Integer getInteger(String aElementName) throws UniDavDocumentException {
        String lValue = this.getString(aElementName);
        if (lValue != null && lValue.length() > 0) {
            return new Integer(lValue);
        }
        return null;
    }

    @Override
    public Date getDate(String aElementName) throws UniDavDocumentException {
        return this.getDate(aElementName, "dd.MM.yyyy");
    }

    @Override
    public Date getDate(String aElementName, String aMaske) throws UniDavDocumentException {
        try {
            String lValue = this.getString(aElementName);
            if (lValue != null && lValue.length() > 0) {
                return DateTimeHelper.getDateFrom(lValue, aMaske);
            }
            return null;
        }
        catch (ParseException e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public Time getTime(String aElementName) throws UniDavDocumentException {
        try {
            String lValue = this.getString(aElementName);
            if (lValue != null && lValue.length() > 0) {
                return DateTimeHelper.getTimeFrom(lValue, "HH.mm");
            }
            return null;
        }
        catch (ParseException e) {
            throw new UniDavDocumentException(e.getMessage(), e);
        }
    }

    @Override
    public Enumeration<DaleSegment> getSegments(String aSegmentName) throws UniDavDocumentException {
        NodeList lNodes = this.segment.getElementsByTagName(aSegmentName);
        Vector<DaleSegmentImpl> lSegmentList = new Vector<DaleSegmentImpl>();
        for (int i = 0; i < lNodes.getLength(); ++i) {
            Node lNode = lNodes.item(i);
            if (!(lNode instanceof XMLElement)) continue;
            DaleSegmentImpl lDaleSegment = new DaleSegmentImpl((XMLElement)lNode);
            lSegmentList.add(lDaleSegment);
        }
        return lSegmentList.elements();
    }

    public Element getXMLElement() {
        return this.segment;
    }
}

