/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.common.sftp;

import ch.ethz.ssh2.Connection;
import ch.ethz.ssh2.SFTPv3Client;
import ch.ethz.ssh2.SFTPv3FileAttributes;
import ch.ethz.ssh2.SFTPv3FileHandle;
import ch.ethz.ssh2.Session;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;

public class SFTPConnector {
    private static final Logger mLogger = Logger.getLogger(SFTPConnector.class);
    private transient SFTPv3Client mSFTPClient = null;
    private transient Session mSFTPSession = null;
    private transient Connection mSFTPConnection = null;
    private static int ONCE_MAX_BYTES = 32768;
    private String mServerAdresse;
    private String mServerBenutzer;
    private String mServerPasswort;

    public SFTPConnector(String aHost, String aUsername, String aPassword) {
        this.mServerAdresse = aHost;
        this.mServerBenutzer = aUsername;
        this.mServerPasswort = aPassword;
    }

    public void connectToSFTPServer() throws IOException {
        if (this.mSFTPConnection == null) {
            this.mSFTPConnection = new Connection(this.mServerAdresse);
            this.mSFTPConnection.connect();
            boolean success = this.mSFTPConnection.authenticateWithPassword(this.mServerBenutzer, this.mServerPasswort);
            if (!success) {
                throw new IOException("Authentifizierung am SFTP-Server fehlgeschlagen");
            }
            this.mSFTPSession = this.mSFTPConnection.openSession();
            this.mSFTPClient = new SFTPv3Client(this.mSFTPConnection);
            mLogger.debug((Object)"Verbindung mit dem SFTP-Server hergestellt");
        }
    }

    public void disconnectFromSFTPServer() {
        boolean lClosed = false;
        if (this.mSFTPSession != null) {
            try {
                this.mSFTPSession.close();
            }
            catch (Exception e) {
                mLogger.debug((Object)"Fehler beim Schliessen der SFTP-Session", (Throwable)e);
            }
            this.mSFTPSession = null;
        }
        if (this.mSFTPClient != null) {
            try {
                this.mSFTPClient.close();
            }
            catch (Exception e) {
                mLogger.debug((Object)"Fehler beim Schliessen des SFTP-Clients", (Throwable)e);
            }
            this.mSFTPClient = null;
        }
        if (this.mSFTPConnection != null) {
            try {
                this.mSFTPConnection.close();
                lClosed = true;
            }
            catch (Exception e) {
                mLogger.debug((Object)"Fehler beim Schliessen der SFTP-Connection", (Throwable)e);
            }
            this.mSFTPConnection = null;
        }
        if (lClosed) {
            mLogger.debug((Object)"Verbindung mit dem SFTP-Server geschlossen");
        }
    }

    public InputStream readFileAsInputStream(String path) {
        byte[] lFileAsByteArray = this.readFileAsByteArray(path);
        return new ByteArrayInputStream(lFileAsByteArray);
    }

    public byte[] readFileAsByteArray(String path) {
        int startid = 0;
        try {
            if (!this.isDir(path)) {
                SFTPv3FileHandle handle = this.mSFTPClient.openFileRO(path);
                byte[] result = new byte[]{};
                byte[] tempResult = new byte[ONCE_MAX_BYTES];
                int len = this.mSFTPClient.read(handle, (long)startid, tempResult, 0, ONCE_MAX_BYTES);
                while (len == ONCE_MAX_BYTES) {
                    result = this.byteMerger(result, tempResult);
                    len = this.mSFTPClient.read(handle, (long)(startid += len), tempResult, 0, ONCE_MAX_BYTES);
                }
                if (len > 0) {
                    byte[] lastResult = new byte[len];
                    System.arraycopy(tempResult, 0, lastResult, 0, len);
                    result = this.byteMerger(result, lastResult);
                }
                this.mSFTPClient.closeFile(handle);
                return result;
            }
            return new byte[0];
        }
        catch (IOException e) {
            mLogger.error((Object)e.getMessage());
            return new byte[0];
        }
    }

    private byte[] byteMerger(byte[] byte_1, byte[] byte_2) {
        byte[] byte_3 = new byte[byte_1.length + byte_2.length];
        System.arraycopy(byte_1, 0, byte_3, 0, byte_1.length);
        System.arraycopy(byte_2, 0, byte_3, byte_1.length, byte_2.length);
        return byte_3;
    }

    private boolean isDir(String path) {
        try {
            SFTPv3FileAttributes attrs = this.mSFTPClient.stat(path);
            return attrs == null ? false : attrs.isDirectory();
        }
        catch (IOException e) {
            mLogger.error((Object)e.getMessage());
            return false;
        }
    }
}

