/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.client.io;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;

public class FileHandler {
    private File link = null;

    public FileHandler(File aLink) {
        this.link = aLink;
    }

    protected String getLink() {
        return this.link.getAbsolutePath();
    }

    public String getFileName() {
        return this.link.getAbsoluteFile().getName();
    }

    public String getPathName() {
        return this.link.getParent() + File.separator;
    }

    public boolean isFile() {
        return this.link.isFile();
    }

    public boolean isDirectory() {
        return this.link.isDirectory();
    }

    protected void write(String aString) throws Exception {
        FileWriter lWriter = null;
        try {
            lWriter = new FileWriter(this.link);
            lWriter.write(aString);
        }
        catch (Exception ex) {
            throw new Exception("0300");
        }
        finally {
            if (lWriter != null) {
                try {
                    ((Writer)lWriter).close();
                }
                catch (Exception ex) {
                    throw new Exception("0301");
                }
            }
        }
    }

    protected void write(byte[] aBytes) throws Exception {
        FileOutputStream lWriter = null;
        try {
            lWriter = new FileOutputStream(this.link);
            ((OutputStream)lWriter).write(aBytes, 0, aBytes.length);
        }
        catch (Exception ex) {
            throw new Exception("0300");
        }
        finally {
            if (lWriter != null) {
                try {
                    ((OutputStream)lWriter).close();
                }
                catch (Exception ex) {
                    throw new Exception("0301");
                }
            }
        }
    }

    public String readString() throws Exception {
        Reader lReader = null;
        StringBuffer lData = new StringBuffer();
        try {
            FileReader lFileReader = new FileReader(this.link);
            lReader = new BufferedReader(lFileReader);
            String lLine = null;
            while ((lLine = ((BufferedReader)lReader).readLine()) != null) {
                lData.append(lLine);
            }
        }
        catch (Exception ex) {
            throw new Exception("0100");
        }
        finally {
            if (lReader != null) {
                try {
                    lReader.close();
                }
                catch (Exception ex) {
                    throw new Exception("0101");
                }
            }
        }
        return lData.toString();
    }

    public byte[] readByte() throws Exception {
        int offset;
        byte[] lXMLBytes = null;
        FileInputStream is = new FileInputStream(this.link);
        long length = this.link.length();
        if (length > Integer.MAX_VALUE) {
            throw new Exception("0103");
        }
        lXMLBytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < lXMLBytes.length && (numRead = ((InputStream)is).read(lXMLBytes, offset, lXMLBytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < lXMLBytes.length) {
            throw new Exception("0104");
        }
        ((InputStream)is).close();
        return lXMLBytes;
    }
}

