/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.client.io;

import dguv.daleuv.report.BuilderPackage;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.ReportModelBuilderFactory;
import dguv.daleuv.report.client.impl.StandaloneDaleDocumentImpl;
import dguv.daleuv.report.client.io.FileHandler;
import dguv.daleuv.report.client.io.PdfGenerator;
import dguv.daleuv.report.client.test.Candidate;
import dguv.daleuv.report.client.xml.ConfigService;
import dguv.daleuv.report.client.xml.XmlService;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.unidav.common.context.impl.DefaultGVContextImpl;
import dguv.unidav.common.dao.Nachrichtentyp;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class OutputFile
implements Candidate {
    private Document document = null;
    private File args1 = null;
    private FileHandler args0 = null;
    private boolean generateDefault;
    private boolean generateGKV;
    private boolean generateWBA;
    private XmlService xmlService = new XmlService();

    public OutputFile(File aArgs0, File aArgs1, boolean aDefault, boolean aGKV, boolean aWBA) {
        this.args0 = new FileHandler(aArgs0);
        this.args1 = aArgs1;
        this.generateDefault = aDefault;
        this.generateGKV = aGKV;
        this.generateWBA = aWBA;
    }

    private boolean isQuitt() throws Exception {
        Document lDocument = this.getDocument();
        return lDocument.getElementsByTagName("quitt").getLength() == 1;
    }

    private String getUnh_2() throws Exception {
        XmlService lDocumentService = this.xmlService;
        Document lDocument = this.getDocument();
        NodeList lNode = lDocumentService.findNode(lDocument, "unh_2");
        if (lNode == null || lNode.getLength() != 1) {
            throw new Exception("0400");
        }
        return lNode.item(0).getFirstChild().getNodeValue();
    }

    private Document getDocument() throws Exception {
        if (this.document == null) {
            this.document = this.xmlService.createDocument(this.args0.readString());
        }
        return this.document;
    }

    public void out() throws Exception {
        String lNtypDefault = null;
        String lNtypGKV = null;
        String lNtypWBA = null;
        String lUnh_2 = null;
        if (this.isQuitt()) {
            lUnh_2 = "QUITT";
            lNtypDefault = "QUITT";
        } else {
            lUnh_2 = this.getUnh_2();
            if (lUnh_2 == null || lUnh_2.length() == 0) {
                throw new Exception("0402");
            }
            if (this.generateDefault) {
                lNtypDefault = ConfigService.getInstance().getNType(lUnh_2, "DEFAULT");
            }
            if (this.generateGKV) {
                lNtypGKV = ConfigService.getInstance().getNType(lUnh_2, "GKV");
            }
            if (this.generateWBA) {
                lNtypWBA = ConfigService.getInstance().getNType(lUnh_2, "WBA");
            }
        }
        String lFormKennung = ConfigService.getInstance().getFormKennung(lUnh_2);
        if (lNtypDefault == null && lNtypGKV == null && lNtypWBA == null) {
            if (this.generateDefault) {
                throw new Exception("0402");
            }
            throw new Exception("0405");
        }
        byte[] lXmlData = this.args0.readString().getBytes();
        String[] lNtypen = new String[]{lNtypDefault, lNtypGKV, lNtypWBA};
        for (int i = 0; i < lNtypen.length; ++i) {
            if (lNtypen[i] == null) continue;
            String lPdfName = this.getPdfName(lFormKennung);
            if (lNtypen[i].endsWith("WBA") || lNtypen[i].endsWith("ZWIB_KON")) {
                lPdfName = lPdfName + "_WBA";
            } else if (lNtypen[i].endsWith("GKV")) {
                lPdfName = lPdfName + "_GKV";
            }
            lPdfName = lPdfName + ".pdf";
            lPdfName = this.args1.getAbsolutePath() + File.separator + lPdfName;
            this.erzeugePDF(lPdfName, lNtypen[i], lFormKennung, lXmlData);
        }
    }

    private void erzeugePDF(String aPDFName, String aNtyp, String aFormKennung, byte[] aXMLBytes) throws Exception {
        StandaloneDaleDocumentImpl lDaleDocument = new StandaloneDaleDocumentImpl(aNtyp, "", aXMLBytes, true);
        DefaultGVContextImpl lGvContext = new DefaultGVContextImpl(-1);
        Nachrichtentyp lNTyp = new Nachrichtentyp();
        lNTyp.setFormKennung(aFormKennung);
        lNTyp.setTyp(aNtyp);
        lGvContext.setNachrichtentyp(lNTyp);
        lGvContext.setUniDavDocument(lDaleDocument);
        lGvContext.setTestGV(false);
        lGvContext.setNachrichtenkennung(this.getBaseXmlFileName());
        DaleAbstractReportModelBuilder lModelBuilder = (DaleAbstractReportModelBuilder)ReportModelBuilderFactory.getInstance().getModelBuilder(lNTyp, BuilderPackage.DALE);
        String lFormId = lModelBuilder.getFormId();
        ReportModel lReportModel = lModelBuilder.buildModel(lGvContext);
        byte[] lPDFBytes = PdfGenerator.createPDF(lFormId, lReportModel);
        try {
            FileOutputStream lFileOutput = new FileOutputStream(aPDFName);
            lFileOutput.write(lPDFBytes);
            lFileOutput.close();
            System.out.println("PDF-Datei erzeugt: " + aPDFName);
        }
        catch (FileNotFoundException e) {
            throw new Exception("0300");
        }
    }

    private String getBaseXmlFileName() {
        String lFileName = this.args0.getFileName();
        int lExtIdx = lFileName.lastIndexOf(".");
        if (lExtIdx > 0 && lExtIdx == lFileName.length() - 4) {
            return lFileName.substring(0, lExtIdx);
        }
        return lFileName;
    }

    private String getPdfName(String aFormKennung) {
        String lPdfName = this.args0.getFileName();
        if (lPdfName.toLowerCase().endsWith(".xml".toLowerCase())) {
            lPdfName = lPdfName.substring(0, lPdfName.length() - 4);
        }
        if (lPdfName.length() == 0) {
            lPdfName = this.args0.getFileName();
        }
        return lPdfName;
    }

    @Override
    public void examine() throws Exception {
        if (this.args0.getLink() == null) {
            throw new Exception("0001");
        }
        if (this.args1 == null) {
            throw new Exception("0002");
        }
        if (!this.args0.isFile()) {
            throw new Exception("0100");
        }
        if (!this.args1.isDirectory()) {
            throw new Exception("0200");
        }
        if (!this.isQuitt() && this.getUnh_2() == null) {
            throw new Exception("0400");
        }
    }
}

