/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.client.xml;

import dguv.daleuv.report.client.Constants;
import dguv.daleuv.report.client.io.URLHandler;
import dguv.daleuv.report.client.test.Candidate;
import dguv.daleuv.report.client.xml.XmlService;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class ConfigService
implements Candidate {
    private static ConfigService instance = null;
    private URLHandler configFile = new URLHandler(Constants.CONFIGURATION);
    private XmlService xmlService = new XmlService();

    public static ConfigService getInstance() {
        if (instance == null) {
            instance = new ConfigService();
        }
        return instance;
    }

    public String getFormKennung(String aUnh_2) throws Exception {
        Document lDocument = this.xmlService.createDocument(this.configFile.readString());
        NodeList lNodeList = this.xmlService.findNode(lDocument, "unh_2");
        for (int a = 0; a < lNodeList.getLength(); ++a) {
            if (!aUnh_2.equals(this.xmlService.getAttributeValue(lNodeList.item(a), "value"))) continue;
            return this.xmlService.getAttributeValue(lNodeList.item(a), "form_kennung");
        }
        throw new Exception("0403");
    }

    public ArrayList getNTypes(String aUnh_2) throws Exception {
        ArrayList<String> lNTypes = new ArrayList<String>();
        NodeList lNodes = this.getNTypeList(aUnh_2);
        if (lNodes == null) {
            throw new Exception("0404#unh_2=[" + aUnh_2 + "]");
        }
        for (int b = 0; b < lNodes.getLength(); ++b) {
            if (!"ntyp".equals(lNodes.item(b).getNodeName())) continue;
            lNTypes.add(lNodes.item(b).getFirstChild().getNodeValue());
        }
        return lNTypes;
    }

    public String getNType(String aUnh_2, String aBerichtsTyp) throws Exception {
        String lNTypes = null;
        NodeList lNodes = this.getNTypeList(aUnh_2);
        if (lNodes == null) {
            throw new Exception("0404");
        }
        for (int b = 0; b < lNodes.getLength(); ++b) {
            if (!"ntyp".equals(lNodes.item(b).getNodeName()) || !aBerichtsTyp.equals(this.xmlService.getAttributeValue(lNodes.item(b), "type"))) continue;
            lNTypes = lNodes.item(b).getFirstChild().getNodeValue();
        }
        return lNTypes;
    }

    public String getMessage(Throwable aException) throws Exception {
        if (!this.configFile.exists()) {
            return "Konfigurationsdatei [config.xml] nicht gefunden.";
        }
        Document lDocument = this.xmlService.createDocument(this.configFile.readString());
        NodeList lNodeList = this.xmlService.findNode(lDocument, "code");
        StringBuffer lMessage = new StringBuffer();
        if (aException.getMessage() != null) {
            String lExMsg = aException.getMessage();
            String lCode = null;
            String lInfo = null;
            if (lExMsg.indexOf("#") > 0) {
                lCode = lExMsg.substring(0, lExMsg.indexOf("#"));
                lInfo = lExMsg.substring(lExMsg.indexOf("#") + 1, lExMsg.length());
            } else {
                lCode = lExMsg;
            }
            for (int i = 0; i < lNodeList.getLength(); ++i) {
                if (!lCode.equals(this.xmlService.getAttributeValue(lNodeList.item(i), "nr"))) continue;
                if (lMessage.length() > 0) {
                    lMessage.append("\n");
                }
                lMessage.append(lCode).append(": ");
                lMessage.append(this.xmlService.getAttributeValue(lNodeList.item(i), "value"));
                if (lInfo == null) continue;
                lMessage.append(" Details: ").append(lInfo);
            }
        }
        if (lMessage.length() == 0) {
            StringWriter sw = new StringWriter();
            aException.printStackTrace(new PrintWriter(sw));
            lMessage.append(sw.toString());
        }
        return lMessage.toString();
    }

    private NodeList getNTypeList(String aUnh_2) throws Exception {
        NodeList lNodes = null;
        Document lDocument = this.xmlService.createDocument(this.configFile.readString());
        NodeList lNodeList = this.xmlService.findNode(lDocument, "unh_2");
        for (int a = 0; a < lNodeList.getLength(); ++a) {
            if (!aUnh_2.equals(this.xmlService.getAttributeValue(lNodeList.item(a), "value"))) continue;
            lNodes = lNodeList.item(a).getChildNodes();
        }
        return lNodes;
    }

    @Override
    public void examine() throws Exception {
        if (!this.configFile.exists()) {
            System.err.println("Fehler: interne Konfigurationsdatei nicht gefunden; file=[cfg/config.xml]");
            throw new Exception();
        }
    }
}

