/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.report.ReportModel;
import dguv.daleuv.report.model.dale.DisModel;
import dguv.daleuv.report.model.dale.VERBReportModel;
import dguv.daleuv.report.model.dale.VERBReportModelSubreport;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.daleuv.report.modelbuilder.dale.DaleAbstractReportModelBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.AdressBuilder;
import dguv.daleuv.report.modelbuilder.dale.impl.parts.PartModelBuilder;
import dguv.unidav.common.context.GVContext;
import dguv.unidav.common.dao.Nachrichtentyp;
import dguv.unidav.common.document.UniDavDocumentException;

public class VERB_ReportModelBuilder
extends DaleAbstractReportModelBuilder {
    private static final String KONTEXT_TITEL = "Verlaufsbericht";

    public VERB_ReportModelBuilder(Nachrichtentyp aNachrichtentyp) {
        super(aNachrichtentyp);
    }

    @Override
    public ReportModel buildModel(GVContext aGVContext) {
        VERBReportModel lModel = new VERBReportModel();
        lModel.setKontext_BerichtsArt(this.getBerichtsArt());
        try {
            this.fuelleAnschreibenFallsBenoetigt(aGVContext, KONTEXT_TITEL, lModel.getAnschreibenModel());
            this.fuelleKopfUndFussZeile(aGVContext, lModel);
            lModel.getKopfbereichModel().setKontext_BerichtsArt(this.getBerichtsArt());
            PartModelBuilder.fuelleDabeMasterKopfBereich(aGVContext, lModel.getKopfbereichModel(), KONTEXT_TITEL);
            DaleDocument lDaleDocument = (DaleDocument)aGVContext.getUniDavDocument();
            this.fuelleHauptteil(lDaleDocument, lModel.getVerbReportModelSubreport());
            PartModelBuilder.fuelleAbsBereich(lDaleDocument, lModel.getAbsModel());
            PartModelBuilder.fuelleNotBereich(lDaleDocument, lModel.getNotModel());
            PartModelBuilder.fuelleRechnungsInfo(lDaleDocument, lModel.getSriModel());
        }
        catch (UniDavDocumentException e) {
            throw new IllegalArgumentException(e.toString(), e);
        }
        return lModel;
    }

    private void fuelleHauptteil(DaleDocument aDocument, VERBReportModelSubreport aModel) throws UniDavDocumentException {
        aModel.setKontext_BerichtsArt(this.getBerichtsArt());
        ModelBuilderUtils.uebertrageWerte(aModel, aDocument);
        switch (aModel.getBhi13_NichtBeurteilbarWeil()) {
            case "0": {
                aModel.setText_NichtBeurteilbarWeil("aus medizinischen Gr\u00fcnden");
                break;
            }
            case "1": {
                aModel.setText_NichtBeurteilbarWeil("wegen fehlender Arbeitsplatzkenntnisse");
                break;
            }
            case "2": {
                aModel.setText_NichtBeurteilbarWeil("sowohl medizinisch als auch wegen fehlender Arbeitsplatzkenntnisse");
                break;
            }
            default: {
                aModel.setText_NichtBeurteilbarWeil(aModel.getBhi13_NichtBeurteilbarWeil());
            }
        }
        aModel.setNah23645_PraxisAdresseWbhArzt(ModelBuilderUtils.formatAnschrift(aDocument.getString("nah", "nah_2"), aDocument.getString("nah", "nah_3"), aDocument.getString("nah", "nah_6"), aDocument.getString("nah", "nah_4"), aDocument.getString("nah", "nah_5")));
        aModel.setNbh671089_PraxisAdresseWbhArzt(ModelBuilderUtils.formatAnschrift(aDocument.getString("nbh", "nbh_6"), aDocument.getString("nbh", "nbh_7"), aDocument.getString("nbh", "nbh_10"), aDocument.getString("nbh", "nbh_8"), aDocument.getString("nbh", "nbh_9")));
        PartModelBuilder.fuelleDisSegmente(aDocument, m -> aModel.addToDiagnosen((DisModel)m));
    }

    @Override
    protected AdressBuilder getWbaAdressBuilder(DaleDocument aDaleDocument) throws UniDavDocumentException {
        if (!(!"1".equals(aDaleDocument.getString("nah", "nah_13")) || "1".equals(aDaleDocument.getString("nbh", "nbh_11")) && "1".equals(aDaleDocument.getString("nbh", "nbh_1")))) {
            return new AdressBuilder(aDaleDocument, "nah", 2);
        }
        return new AdressBuilder(aDaleDocument, "nbh", 6);
    }
}

