/*
 * Decompiled with CFR 0.152.
 */
package dguv.daleuv.report.modelbuilder.dale.impl.parts;

import dguv.daleuv.common.document.DaleDocument;
import dguv.daleuv.report.modelbuilder.ModelBuilderUtils;
import dguv.unidav.common.document.UniDavDocumentException;

public class AdressBuilder {
    private String mName;
    private String mStrasse;
    private String mLaenderkennung;
    private String mPlz;
    private String mOrt;
    public static final AdressBuilder NULL = new AdressBuilder();

    private AdressBuilder() {
    }

    public AdressBuilder(DaleDocument aDaleDocument, String aSegmentName, int aStartNummer) throws UniDavDocumentException {
        this.mName = aDaleDocument.getString(aSegmentName, aSegmentName + "_" + aStartNummer++);
        this.mStrasse = aDaleDocument.getString(aSegmentName, aSegmentName + "_" + aStartNummer++);
        this.mPlz = aDaleDocument.getString(aSegmentName, aSegmentName + "_" + aStartNummer++);
        this.mOrt = aDaleDocument.getString(aSegmentName, aSegmentName + "_" + aStartNummer++);
        this.mLaenderkennung = aDaleDocument.getString(aSegmentName, aSegmentName + "_" + aStartNummer);
    }

    public String ausgebenEinzeilig() {
        return this == NULL ? "" : this.ausgebenAdresse(", ").replaceAll("(\\r\\n|\\r|\\n)", " ").trim();
    }

    public String ausgebenMehrzeilig() {
        return this == NULL ? "" : this.ausgebenAdresse("\n");
    }

    public String ausgebenZweizeilig(String aTrennzeichen) {
        return this == NULL ? "" : ModelBuilderUtils.formatAdresseZweizeilig(this.mName, this.mStrasse, this.mLaenderkennung, this.mPlz, this.mOrt, aTrennzeichen);
    }

    private String ausgebenAdresse(String aTrennzeichen) {
        return ModelBuilderUtils.formatAdresse(this.mName, this.mStrasse, this.mLaenderkennung, this.mPlz, this.mOrt, aTrennzeichen);
    }
}

