/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.document.impl;

import dguv.unidav.common.document.Auftragsdatensatz;
import dguv.unidav.common.document.UniDavDocumentException;

public class AuftragsdatensatzImpl
implements Auftragsdatensatz {
    private String auftragsdatensatz = null;
    private final int AUF_MIN_LENGTH = 348;
    private final int IDENTIFIKATOR_POS = 0;
    private final int IDENTIFIKATOR_LEN = 6;
    private final int VERSION_POS = 6;
    private final int VERSION_LEN = 2;
    private final int LAENGE_AUFTRAG_POS = 8;
    private final int LAENGE_AUFTRAG_LEN = 8;
    private final int SEQUENZ_NR_POS = 16;
    private final int SEQUENZ_NR_LEN = 3;
    private final int VERFAHREN_KENNUNG_POS = 19;
    private final int VERFAHREN_KENNUNG_LEN = 5;
    private final int TRANSFER_NR_POS = 24;
    private final int TRANSFER_NR_LEN = 3;
    private final int VERFAHREN_KENNUNG_SPEZ_POS = 27;
    private final int VERFAHREN_KENNUNG_SPEZ_LEN = 5;
    private final int ABSENDER_EIGNER_POS = 32;
    private final int ABSENDER_EIGNER_LEN = 15;
    private final int ABSENDER_PHYS_POS = 47;
    private final int ABSENDER_PHYS_LEN = 15;
    private final int EMPFAENGER_NUTZER_POS = 62;
    private final int EMPFAENGER_NUTZER_LEN = 15;
    private final int EMPFAENGER_PHYS_POS = 77;
    private final int EMPFAENGER_PHYS_LEN = 15;
    private final int DATEINAME_POS = 92;
    private final int DATEINAME_LEN = 23;
    private final int DATEINAME_ALT_POS = 104;
    private final int DATEINAME_ALT_LEN = 11;
    private final int DATUM_ERSTELLUNG_POS = 115;
    private final int DATUM_ERSTELLUNG_LEN = 14;
    private final int DATUM_UEBERTRA_SEND_POS = 129;
    private final int DATUM_UEBERTRA_SEND_LEN = 14;
    private final int DATUM_UEBERTRA_EMPF_START_POS = 143;
    private final int DATUM_UEBERTRA_EMPF_START_LEN = 14;
    private final int DATUM_UEBERTRA_EMPF_ENDE_POS = 157;
    private final int DATUM_UEBERTRA_EMPF_ENDE_LEN = 14;
    private final int DATEIVERSION_POS = 171;
    private final int DATEIVERSION_LEN = 6;
    private final int KORREKTUR_POS = 177;
    private final int KORREKTUR_LEN = 1;
    private final int DATEIGROESSE_NUTZ_POS = 178;
    private final int DATEIGROESSE_NUTZ_LEN = 12;
    private final int DATEIGROESSE_UEBTRA_POS = 190;
    private final int DATEIGROESSE_UEBTRA_LEN = 12;
    private final int ZEICHENSATZ_POS = 202;
    private final int ZEICHENSATZ_LEN = 2;
    private final int KOMPRIMIERUNG_POS = 204;
    private final int KOMPRIMIERUNG_LEN = 2;
    private final int VERSCHLUESSELUNG_POS = 206;
    private final int VERSCHLUESSELUNG_LEN = 2;
    private final int ELEK_UNTERSCHRIFT_POS = 208;
    private final int ELEK_UNTERSCHRIFT_LEN = 2;
    private final int SATZFORMAT_POS = 210;
    private final int SATZFORMAT_LEN = 3;
    private final int SATZLAENGE_POS = 213;
    private final int SATZLAENGE_LEN = 5;
    private final int BLOCKLAENGE_POS = 218;
    private final int BLOCKLAENGE_LEN = 8;
    private final int STATUS_POS = 226;
    private final int STATUS_LEN = 1;
    private final int WIEDERHOLUNG_POS = 227;
    private final int WIEDERHOLUNG_LEN = 2;
    private final int UEBTRA_WEG_POS = 229;
    private final int UEBTRA_WEG_LEN = 1;
    private final int VERZOEGERTER_VERSAND_POS = 230;
    private final int VERZOEGERTER_VERSAND_LEN = 10;
    private final int FEHLER_INFO_POS = 240;
    private final int FEHLER_INFO_LEN = 6;
    private final int INFO_POS = 246;
    private final int INFO_LEN = 28;
    private final int DATEINAME_PHYS_POS = 274;
    private final int DATEINAME_PHYS_LEN = 44;
    private final int DATEI_BEZEICHNUNG_POS = 318;
    private final int DATEI_BEZEICHNUNG_LEN = 30;

    public AuftragsdatensatzImpl() {
        this.auftragsdatensatz = this.createEmpty();
    }

    public AuftragsdatensatzImpl(String aAuftragsdatensatz) throws UniDavDocumentException {
        this.auftragsdatensatz = aAuftragsdatensatz;
        if (this.auftragsdatensatz == null) {
            throw new UniDavDocumentException("Fehler: Parameter aAuftragsdatensatz ist null!!");
        }
        if (this.auftragsdatensatz.length() < 348) {
            throw new UniDavDocumentException("Fehler: Auftragsdatensatz entspricht nicht der spezifizierten Anzahl von Zeichen; Anz. Zeichen ist [" + this.auftragsdatensatz.length() + "]; Anz. Zeichen soll [" + 348 + "]");
        }
    }

    public AuftragsdatensatzImpl(String aAuftragsdatensatz, boolean aStrictLengthCheck) throws UniDavDocumentException {
        this.auftragsdatensatz = aAuftragsdatensatz;
        if (this.auftragsdatensatz == null) {
            throw new UniDavDocumentException("Fehler: Parameter aAuftragsdatensatz ist null!!");
        }
        if (this.auftragsdatensatz.length() != 348) {
            throw new UniDavDocumentException("Fehler: Auftragsdatensatz entspricht nicht der spezifizierten Anzahl von Zeichen; Anz. Zeichen ist [" + this.auftragsdatensatz.length() + "]; Anz. Zeichen soll [" + 348 + "]");
        }
    }

    private String getField(int aPos, int aLength) {
        return new String(this.auftragsdatensatz.substring(aPos, aPos + aLength).trim());
    }

    private void writeField(String aValue, int aPos, int aLength) {
        String lNew = this.auftragsdatensatz;
        if (aValue.length() > aLength) {
            aValue = aValue.substring(aLength);
        }
        if (aValue.length() < aLength) {
            StringBuffer sb = new StringBuffer(aLength - aValue.length());
            for (int i = 0; i < sb.capacity(); ++i) {
                sb.append(' ');
            }
            aValue = aValue + sb.toString();
        }
        this.auftragsdatensatz = lNew = this.auftragsdatensatz.substring(0, aPos) + aValue + this.auftragsdatensatz.substring(aPos + aLength);
    }

    private void writeField(int aValue, int aPos, int aLength) {
        String lNew = this.auftragsdatensatz;
        String lValue = String.valueOf(aValue);
        if (lValue.length() > aLength) {
            lValue = lValue.substring(aLength);
        }
        if (lValue.length() < aLength) {
            StringBuffer sb = new StringBuffer(aLength - lValue.length());
            for (int i = 0; i < sb.capacity(); ++i) {
                sb.append('0');
            }
            lValue = sb.toString() + lValue;
        }
        this.auftragsdatensatz = lNew = this.auftragsdatensatz.substring(0, aPos) + lValue + this.auftragsdatensatz.substring(aPos + aLength);
    }

    private String createEmpty() {
        StringBuffer sb = new StringBuffer(348);
        for (int i = 0; i < sb.capacity(); ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    @Override
    public String getIdentifikator() {
        return this.getField(0, 6);
    }

    @Override
    public void setIdentifikator(String aValue) {
        this.writeField(aValue, 0, 6);
    }

    @Override
    public String getVersion() {
        return this.getField(6, 2);
    }

    @Override
    public void setVersion(String aValue) {
        this.writeField(aValue, 6, 2);
    }

    @Override
    public String getLaengeAuftrag() {
        return this.getField(8, 8);
    }

    @Override
    public void setLaengeAuftrag(String aValue) {
        this.writeField(aValue, 8, 8);
    }

    @Override
    public String getSequenzNr() {
        return this.getField(16, 3);
    }

    @Override
    public void setSequenzNr(String aValue) {
        this.writeField(aValue, 16, 3);
    }

    @Override
    public String getVerfahrenkennung() {
        return this.getField(19, 5);
    }

    @Override
    public void setVerfahrenkennung(String aValue) {
        this.writeField(aValue, 19, 5);
    }

    @Override
    public String getTransferNummer() {
        return this.getField(24, 3);
    }

    @Override
    public void setTransferNummer(String aValue) {
        this.writeField(aValue, 24, 3);
    }

    @Override
    public String getNachrichtentyp() {
        return this.getField(27, 5);
    }

    @Override
    public void setNachrichtentyp(String aValue) {
        this.writeField(aValue, 27, 5);
    }

    @Override
    public String getAbsenderEignerIK() {
        String lIk = this.getField(32, 15);
        if (lIk.length() > 9) {
            return lIk.substring(0, 9);
        }
        return lIk;
    }

    @Override
    public void setAbsenderEignerIK(String aValue) {
        this.writeField(aValue, 32, 15);
    }

    @Override
    public String getAbsenderPhysikalischIK() {
        String lIk = this.getField(47, 15);
        if (lIk.length() > 9) {
            return lIk.substring(0, 9);
        }
        return lIk;
    }

    @Override
    public void setAbsenderPhysikalischIK(String aValue) {
        this.writeField(aValue, 47, 15);
    }

    @Override
    public String getEmpfaengerNutzerIK() {
        String lIk = this.getField(62, 15);
        if (lIk.length() > 9) {
            return lIk.substring(0, 9);
        }
        return lIk;
    }

    @Override
    public void setEmpfaengerNutzerIK(String aValue) {
        this.writeField(aValue, 62, 15);
    }

    @Override
    public String getEmpfaengerPhysikalischIK() {
        String lIk = this.getField(77, 15);
        if (lIk.length() > 9) {
            return lIk.substring(0, 9);
        }
        return lIk;
    }

    @Override
    public void setEmpfaengerPhysikalischIK(String aValue) {
        this.writeField(aValue, 77, 15);
    }

    @Override
    public String getDateiNameNutzdaten() {
        String lDateiName = this.getField(104, 11);
        if (lDateiName.startsWith("DU") || lDateiName.startsWith("AU")) {
            return lDateiName;
        }
        lDateiName = this.getField(274, 44);
        if (lDateiName.startsWith("DU") || lDateiName.startsWith("AU")) {
            return lDateiName;
        }
        if (!lDateiName.toUpperCase().endsWith(".XML")) {
            lDateiName = lDateiName + ".xml";
        }
        return lDateiName;
    }

    @Override
    public void setDateiNameNutzdaten(String aValue) {
        if (aValue.length() == 11) {
            this.writeField("000000000000", 92, 23);
            this.writeField(aValue, 104, 11);
        } else {
            this.writeField(aValue, 92, 23);
        }
    }

    @Override
    public String getDatumErstellung() {
        return this.getField(115, 14);
    }

    @Override
    public void setDatumErstellung(String aValue) {
        this.writeField(aValue, 115, 14);
    }

    @Override
    public String getDatumUebertragungGesendet() {
        return this.getField(129, 14);
    }

    @Override
    public void setDatumUebertragungGesendet(String aValue) {
        this.writeField(aValue, 129, 14);
    }

    @Override
    public String getDatumUebertragungEmpfangenStart() {
        return this.getField(143, 14);
    }

    @Override
    public void setDatumUebertragungEmpfangenStart(String aValue) {
        this.writeField(aValue, 143, 14);
    }

    @Override
    public String getDatumUebertragungEmpfangenEnde() {
        return this.getField(157, 14);
    }

    @Override
    public void setDatumUebertragungEmpfangenEnde(String aValue) {
        this.writeField(aValue, 157, 14);
    }

    @Override
    public String getArztSoftwareVersion() {
        return this.getField(171, 6);
    }

    @Override
    public void setArztSoftwareVersion(String aValue) {
        this.writeField(aValue, 171, 6);
    }

    @Override
    public String getKorrekturKz() {
        return this.getField(177, 1);
    }

    @Override
    public void setKorrekturKz(String aValue) {
        this.writeField(aValue, 177, 1);
    }

    @Override
    public String getDateiGroesseNutzdaten() {
        return this.getField(178, 12);
    }

    @Override
    public void setDateiGroesseNutzdaten(int aValue) {
        this.writeField(aValue, 178, 12);
    }

    @Override
    public String getDateiGroesseUebertragung() {
        return this.getField(190, 12);
    }

    @Override
    public void setDateiGroesseUebertragung(int aValue) {
        this.writeField(aValue, 190, 12);
    }

    @Override
    public String getZeichensatz() {
        return this.getField(202, 2);
    }

    @Override
    public void setZeichensatz(String aValue) {
        this.writeField(aValue, 202, 2);
    }

    @Override
    public String getKomprimierung() {
        return this.getField(204, 2);
    }

    @Override
    public void setKomprimierung(String aValue) {
        this.writeField(aValue, 204, 2);
    }

    @Override
    public String getVerschlFormat() {
        return this.getField(206, 2);
    }

    @Override
    public void setVerschlFormat(String aValue) {
        this.writeField(aValue, 206, 2);
    }

    @Override
    public String getSignaturFormat() {
        return this.getField(208, 2);
    }

    @Override
    public void setSignaturFormat(String aValue) {
        this.writeField(aValue, 208, 2);
    }

    @Override
    public String getSatzFormat() {
        return this.getField(210, 3);
    }

    @Override
    public void setSatzFormat(String aValue) {
        this.writeField(aValue, 210, 3);
    }

    @Override
    public String getSatzLaenge() {
        return this.getField(213, 5);
    }

    @Override
    public void setSatzLaenge(String aValue) {
        this.writeField(aValue, 213, 5);
    }

    @Override
    public String getBlockLaenge() {
        return this.getField(218, 8);
    }

    @Override
    public void setBlockLaenge(String aValue) {
        this.writeField(aValue, 218, 8);
    }

    @Override
    public String getStatus() {
        return this.getField(226, 1);
    }

    @Override
    public void setStatus(String aValue) {
        this.writeField(aValue, 226, 1);
    }

    @Override
    public String getWiederholung() {
        return this.getField(227, 2);
    }

    @Override
    public void setWiederholung(String aValue) {
        this.writeField(aValue, 227, 2);
    }

    @Override
    public String getUebertragungsweg() {
        return this.getField(229, 1);
    }

    @Override
    public void setUebertragungsweg(String aValue) {
        this.writeField(aValue, 229, 1);
    }

    @Override
    public String getVerzoegerterVersand() {
        return this.getField(230, 10);
    }

    @Override
    public void setVerzoegerterVersand(String aValue) {
        this.writeField(aValue, 230, 10);
    }

    @Override
    public String getFehlerInfo() {
        return this.getField(240, 6);
    }

    @Override
    public void setFehlerInfo(String aValue) {
        this.writeField(aValue, 240, 6);
    }

    @Override
    public String getInfo() {
        return this.getField(246, 28);
    }

    @Override
    public void setInfo(String aValue) {
        this.writeField(aValue, 246, 28);
    }

    @Override
    public String getDateinamePhysikalisch() {
        return this.getField(274, 44);
    }

    @Override
    public void setDateinamePhysikalisch(String aValue) {
        this.writeField(aValue, 274, 44);
    }

    @Override
    public String getDateiBezeichnung() {
        return this.getField(318, 30);
    }

    @Override
    public void setDateiBezeichnung(String aValue) {
        this.writeField(aValue, 318, 30);
    }

    @Override
    public String getNachrichtenkennung() {
        String lFileName = this.getDateiNameNutzdaten();
        if (lFileName.toUpperCase().startsWith("DU") || lFileName.toUpperCase().startsWith("AU")) {
            StringBuffer lNkennung = new StringBuffer();
            lNkennung.append(this.getAbsenderEignerIK());
            lNkennung.append("_");
            lNkennung.append(this.getDatumErstellung().substring(2, 4));
            lNkennung.append("_0");
            lNkennung.append(lFileName.substring(2, 8));
            lNkennung.append("_01");
            return lNkennung.toString();
        }
        return lFileName.toUpperCase().replaceAll("\\.XML", "").replaceAll("\\.DAT", "");
    }

    @Override
    public void setNachrichtenkennung(String aKennung) {
    }

    @Override
    public String getNachrichtenkennungOriginal() {
        String lFileName = this.getDateiNameNutzdaten();
        if (lFileName.toUpperCase().startsWith("DU") || lFileName.toUpperCase().startsWith("AU")) {
            return lFileName;
        }
        return lFileName.toUpperCase().replaceAll("\\.XML", "").replaceAll("\\.DAT", "");
    }

    @Override
    public void setNachrichtenKennungOriginal(String aKennung) {
    }

    @Override
    public String getStream() {
        return this.auftragsdatensatz;
    }
}

