/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.logging;

import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class SingleLineFormatter
extends Formatter {
    private static final String NEWLINE = System.getProperty("line.separator");

    @Override
    public String format(LogRecord logRecord) {
        StringBuffer buf = new StringBuffer(100);
        buf.append("[Timestamp: ").append(logRecord.getMillis()).append(']');
        buf.append("[Thread: ").append(logRecord.getThreadID()).append(']');
        buf.append("[Level: ").append(logRecord.getLevel().getName()).append(']');
        buf.append("[Class: ").append(logRecord.getSourceClassName()).append(']');
        buf.append("[Method: ").append(logRecord.getSourceMethodName()).append(']');
        buf.append("[Message: ").append(logRecord.getMessage()).append(']');
        Throwable thrownException = logRecord.getThrown();
        if (thrownException != null) {
            buf.append("[Exception: ").append(thrownException.getClass().getName()).append(' ').append(thrownException.getMessage()).append(']');
        }
        buf.append(NEWLINE);
        return buf.toString();
    }
}

