/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils;

import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateTimeHelper {
    public static java.sql.Date getDateFrom(String aDate, String aMask) throws ParseException {
        if (aDate != null) {
            SimpleDateFormat lFormatter = new SimpleDateFormat(aMask);
            Calendar lCalendar = Calendar.getInstance();
            lCalendar.setTime(lFormatter.parse(aDate));
            return new java.sql.Date(lCalendar.getTimeInMillis());
        }
        throw new ParseException("ungueltiges Datum [" + aDate + "]", 0);
    }

    public static Time getTimeFrom(String aTime, String aMask) throws ParseException {
        if (aTime != null) {
            SimpleDateFormat lFormatter = new SimpleDateFormat(aMask);
            Calendar lCalendar = Calendar.getInstance();
            lCalendar.setTime(lFormatter.parse(aTime));
            return new Time(lCalendar.getTimeInMillis());
        }
        throw new ParseException("ungueltige Zeitangabe [" + aTime + "]", 0);
    }

    public static Timestamp getDateTimeFrom(String aDate, String aMask) throws ParseException {
        if (aDate != null) {
            SimpleDateFormat lFormatter = new SimpleDateFormat(aMask);
            Calendar lCalendar = Calendar.getInstance();
            lCalendar.setTime(lFormatter.parse(aDate));
            return new Timestamp(lCalendar.getTimeInMillis());
        }
        throw new ParseException("ungueltiges Datum [" + aDate + "]", 0);
    }

    public static Timestamp getDateTimeFrom(Calendar aCalendar) {
        return new Timestamp(aCalendar.getTimeInMillis());
    }

    public static Calendar getDateTimeFrom(Timestamp aTimestamp) {
        Calendar lCalendar = Calendar.getInstance();
        lCalendar.setTimeInMillis(aTimestamp.getTime());
        return lCalendar;
    }

    public static String getDateFrom(java.sql.Date aDate, String aMask) {
        if (aDate != null) {
            Calendar lCalendar = Calendar.getInstance();
            lCalendar.setTime(aDate);
            SimpleDateFormat lFormatter = new SimpleDateFormat(aMask);
            return lFormatter.format(aDate);
        }
        return "";
    }

    public static String getDateFrom(Date aDate, String aMask) {
        if (aDate == null) {
            return "";
        }
        SimpleDateFormat lFormatter = new SimpleDateFormat(aMask);
        return lFormatter.format(aDate);
    }

    public static String getDateTimeFrom(Timestamp aDateTime, String aMask) {
        if (aDateTime != null) {
            Calendar lCalendar = Calendar.getInstance();
            lCalendar.setTime(aDateTime);
            SimpleDateFormat lFormatter = new SimpleDateFormat(aMask);
            return lFormatter.format(aDateTime);
        }
        return "";
    }

    public static Timestamp getCurrentDate() {
        return new Timestamp(new Date().getTime());
    }

    public static String getCurrentDateAs(String aMask) {
        return DateTimeHelper.getDateTimeFrom(new Timestamp(Calendar.getInstance().getTimeInMillis()), aMask);
    }
}

