/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class GenericMethodInvoker {
    private Object ref = null;
    private String className = null;
    private Class refClass = null;

    public GenericMethodInvoker(Object aRef) throws ClassNotFoundException {
        this.ref = aRef;
        this.initialize();
    }

    public GenericMethodInvoker(Object aRef, String aClassName) throws ClassNotFoundException {
        this.ref = aRef;
        this.className = aClassName;
        this.initialize();
    }

    private void initialize() throws ClassNotFoundException {
        if (this.className == null || this.className.length() == 0) {
            this.className = this.ref.getClass().getName();
            this.refClass = this.ref.getClass();
        } else {
            this.refClass = Class.forName(this.className);
        }
    }

    public Object invoke(String aMethodName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return this.invoke(aMethodName, null);
    }

    public Object invoke(String aMethodName, Object aParam) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object[] lArgs = null;
        if (aParam != null) {
            lArgs = new Object[]{aParam};
        }
        return this.invoke(aMethodName, lArgs);
    }

    public Object invoke(String pMethodName, Object[] pParams) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object lRet = null;
        lRet = pParams != null ? this.invokeImpl(pMethodName, pParams) : this.invokeImpl(pMethodName);
        return lRet;
    }

    protected Object invokeImpl(String pMethodName) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        return this.invokeImpl(pMethodName, null);
    }

    protected Object invokeImpl(String pMethodName, Object[] pParam) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object lRet = null;
        Method lMethod = this.getMethod(pMethodName, pParam);
        lRet = lMethod.invoke(this.ref, pParam);
        return lRet;
    }

    protected Object invokeImpl(String pMethodName, Object[] pParam, Class[] pParamClasses) throws InvocationTargetException, IllegalAccessException, NoSuchMethodException {
        Object lRet = null;
        Method lMethod = this.getMethod(pMethodName, pParamClasses);
        lRet = lMethod.invoke(this.ref, pParam);
        return lRet;
    }

    protected Method getMethod(String pName, Object[] pArgs) throws NoSuchMethodException {
        Method lMethod = null;
        Class[] lParams = null;
        if (pArgs != null) {
            lParams = new Class[pArgs.length];
            for (int i = 0; i < pArgs.length; ++i) {
                lParams[i] = pArgs[i].getClass();
            }
        }
        lMethod = this.getMethod(pName, lParams);
        return lMethod;
    }

    protected Method getMethod(String pName, Class[] pParams) throws NoSuchMethodException {
        return this.getRefClass().getMethod(pName, pParams);
    }

    protected Class getRefClass() {
        return this.refClass;
    }
}

