/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils;

public class IKHelper {
    private static final int[] PRUEF_GEWICHTUNG = new int[]{2, 1, 2, 1, 2, 1};
    private static int LAENGE_SOLL_IK = 9;
    public static final String IK_KLASSIFIKATION_GKV = "10";
    public static final String IK_KLASSIFIKATION_DRV = "11";
    public static final String IK_KLASSIFIKATION_UV_TRAEGER = "12";
    public static final String IK_KLASSIFIKATION_PVS = "22";
    public static final String IK_KLASSIFIKATION_KRANKENHAEUSER = "26";
    public static final String IK_KLASSIFIKATION_ABRZ = "66";

    public static boolean istIKNummerTechnischKorrekt(String aIK) {
        if (aIK == null || aIK.length() != LAENGE_SOLL_IK) {
            return false;
        }
        for (int i = 0; i < LAENGE_SOLL_IK; ++i) {
            if (Character.isDigit(aIK.charAt(i))) continue;
            return false;
        }
        return !aIK.matches("000000000");
    }

    public static String getIKKlassifikation(String aIK) {
        if (aIK != null && aIK.length() == LAENGE_SOLL_IK) {
            return aIK.substring(0, 2);
        }
        return "";
    }

    public static int getIKPruefzifferSoll(String aIK) {
        if (aIK == null || aIK.length() != LAENGE_SOLL_IK) {
            return -1;
        }
        int lSummeDerProdukte = 0;
        for (int i = 2; i < aIK.length() - 1; ++i) {
            int lZiffer = Character.digit(aIK.charAt(i), 10);
            int lProdukt = lZiffer * PRUEF_GEWICHTUNG[i - 2];
            lSummeDerProdukte += lProdukt > 9 ? IKHelper.getQuersummeFuerZahl(lProdukt) : lProdukt;
        }
        return lSummeDerProdukte % 10;
    }

    public static int getPruefzifferIst(String aIK) {
        if (aIK == null || aIK.length() != LAENGE_SOLL_IK) {
            return -1;
        }
        return Character.digit(aIK.charAt(LAENGE_SOLL_IK - 1), 10);
    }

    private static int getQuersummeFuerZahl(int aZahl) {
        String zahlStr = "" + aZahl;
        int summe = 0;
        for (int i = 0; i < zahlStr.length(); ++i) {
            summe += Character.digit(zahlStr.charAt(i), 10);
        }
        return summe;
    }

    public static boolean isIK000000000(String aIK) {
        if (aIK == null) {
            return false;
        }
        return aIK.equals("000000000");
    }
}

