/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils.grep;

import java.util.ArrayList;

public class XmlElementFinder {
    private static final byte[] END_TAG = new byte[]{60, 47};

    public static String getElementContent(byte[] aXML, String aElementTag) {
        byte[] lElementTag = aElementTag.getBytes();
        int lStartIndex = XmlElementFinder.findIndexFor(lElementTag, aXML, 0);
        if (lStartIndex < 0) {
            return "";
        }
        int lEndIndex = XmlElementFinder.findIndexFor(END_TAG, aXML, lStartIndex);
        String lContent = new String(XmlElementFinder.getDataFrom(aXML, lStartIndex + lElementTag.length, lEndIndex)).trim();
        if (lContent.startsWith("<")) {
            return "";
        }
        return lContent;
    }

    public static String[] getElementContents(byte[] aXML, String aElementTag) {
        int lStartIndex;
        ArrayList<String> lContentList = new ArrayList<String>();
        byte[] lElementTag = aElementTag.getBytes();
        int lOffset = 0;
        do {
            if ((lStartIndex = XmlElementFinder.findIndexFor(lElementTag, aXML, lOffset)) <= -1) continue;
            int lEndIndex = XmlElementFinder.findIndexFor(END_TAG, aXML, lStartIndex);
            String lContent = new String(XmlElementFinder.getDataFrom(aXML, lStartIndex + lElementTag.length, lEndIndex)).trim();
            if (!lContent.startsWith("<")) {
                lContentList.add(lContent);
            }
            lOffset = lEndIndex;
        } while (lStartIndex > -1);
        String[] rContents = new String[lContentList.size()];
        lContentList.toArray(rContents);
        return rContents;
    }

    private static int findIndexFor(byte[] aSearch, byte[] aData, int aOffset) {
        boolean lGotIt = false;
        while (aOffset + aSearch.length < aData.length) {
            int i = 0;
            for (i = 0; i < aSearch.length && aSearch[i] == aData[aOffset + i]; ++i) {
            }
            if (i == aSearch.length) {
                lGotIt = true;
                break;
            }
            ++aOffset;
        }
        if (lGotIt) {
            return aOffset;
        }
        return -1;
    }

    private static byte[] getDataFrom(byte[] aData, int aStart, int aEnd) {
        int lLenght = aEnd - aStart;
        byte[] lData = new byte[lLenght];
        for (int i = 0; aStart + i < aData.length && i < lLenght; ++i) {
            lData[i] = aData[aStart + i];
        }
        return lData;
    }
}

