/*
 * Decompiled with CFR 0.152.
 */
package dguv.unidav.common.utils.zip;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipCreator {
    private OutputStream writer = null;
    private ZipOutputStream zipOutput = null;
    private boolean isClosed = false;

    public ZipCreator() {
        this.writer = new ByteArrayOutputStream();
        this.zipOutput = new ZipOutputStream(this.writer);
    }

    public ZipCreator(byte[] aZipData) throws IOException {
        this();
        ByteArrayInputStream lReader = new ByteArrayInputStream(aZipData);
        ZipInputStream lZipInput = new ZipInputStream(lReader);
        ZipEntry lEntry = lZipInput.getNextEntry();
        while (lEntry != null) {
            this.zipOutput.putNextEntry(new ZipEntry(lEntry.getName()));
            byte[] lBuffer = new byte[65535];
            while (true) {
                int lNbytes;
                if ((lNbytes = lZipInput.read(lBuffer)) == -1) break;
                this.zipOutput.write(lBuffer, 0, lNbytes);
            }
            this.zipOutput.closeEntry();
            lEntry = lZipInput.getNextEntry();
        }
    }

    public ZipCreator(String aZipOutFileName) throws IOException {
        this.writer = new FileOutputStream(aZipOutFileName);
        this.zipOutput = new ZipOutputStream(this.writer);
    }

    public ZipCreator(File aZipFile) throws IOException {
        this.writer = new FileOutputStream(aZipFile);
        this.zipOutput = new ZipOutputStream(this.writer);
    }

    public void setCompressionLevel(int aLevel) {
        this.zipOutput.setLevel(aLevel);
    }

    public void addEntry(String aEntryName, byte[] aData) throws IOException {
        this.zipOutput.putNextEntry(new ZipEntry(aEntryName));
        this.zipOutput.write(aData, 0, aData.length);
        this.zipOutput.closeEntry();
    }

    public void addEntry(String aEntryName, File aFile) throws IOException {
        FileInputStream lIn = new FileInputStream(aFile);
        this.addEntry(aEntryName, lIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(String aEntryName, InputStream aStream) throws IOException {
        try {
            this.zipOutput.putNextEntry(new ZipEntry(aEntryName));
            byte[] lBuffer = new byte[65535];
            while (true) {
                int lNbytes;
                if ((lNbytes = aStream.read(lBuffer)) == -1) {
                    this.zipOutput.closeEntry();
                    break;
                }
                this.zipOutput.write(lBuffer, 0, lNbytes);
            }
        }
        finally {
            aStream.close();
        }
    }

    public byte[] getZipData() throws IOException {
        this.close();
        if (this.writer instanceof ByteArrayOutputStream) {
            return ((ByteArrayOutputStream)this.writer).toByteArray();
        }
        return new byte[0];
    }

    public void close() throws IOException {
        if (!this.isClosed) {
            this.zipOutput.flush();
            this.zipOutput.close();
            this.writer.close();
            this.isClosed = true;
        }
    }
}

