/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.data;

import com.fasterxml.jackson.databind.JsonNode;
import java.io.File;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.JRAbstractTextDataSource;
import net.sf.jasperreports.engine.data.JsonData;
import net.sf.jasperreports.engine.json.JRJsonNode;
import net.sf.jasperreports.engine.util.JsonUtil;
import net.sf.jasperreports.engine.util.json.DefaultJsonQLExecuter;
import net.sf.jasperreports.engine.util.json.JsonQLExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JsonQLDataSource
extends JRAbstractTextDataSource
implements JsonData {
    private static final Log log = LogFactory.getLog(JsonQLDataSource.class);
    public static final String EXCEPTION_MESSAGE_KEY_NO_DATA = "data.json.no.data";
    public static final String EXCEPTION_MESSAGE_KEY_JSON_FIELD_VALUE_NOT_RETRIEVED = "data.json.field.value.not.retrieved";
    public static final String PROPERTY_FIELD_EXPRESSION = "net.sf.jasperreports.jsonql.field.expression";
    private JRJsonNode root;
    private String selectExpression;
    private JRJsonNode currentJsonNode;
    private List<JRJsonNode> nodes;
    private int currentNodeIndex = -1;
    private JsonQLExecuter jsonQLExecuter;
    private Map<String, String> fieldExpressions = new HashMap<String, String>();

    public JsonQLDataSource(File file, String selectExpression) throws JRException {
        this(JsonUtil.parseJson(file), selectExpression);
    }

    public JsonQLDataSource(File file) throws JRException {
        this(file, null);
    }

    public JsonQLDataSource(InputStream jsonInputStream, String selectExpression) throws JRException {
        this(JsonUtil.parseJson(jsonInputStream), selectExpression);
    }

    public JsonQLDataSource(InputStream jsonInputStream) throws JRException {
        this(jsonInputStream, null);
    }

    public JsonQLDataSource(JasperReportsContext jasperReportsContext, String jsonSource, String selectExpression) throws JRException {
        this(JsonUtil.parseJson(jasperReportsContext, jsonSource), selectExpression);
    }

    protected JsonQLDataSource(JsonNode jacksonJsonTree, String selectExpression) throws JRException {
        this(new JRJsonNode(null, jacksonJsonTree), selectExpression);
    }

    protected JsonQLDataSource(JRJsonNode root, String selectExpression) throws JRException {
        this.root = root;
        this.selectExpression = selectExpression;
        this.jsonQLExecuter = new DefaultJsonQLExecuter();
        this.moveFirst();
    }

    @Override
    public void moveFirst() throws JRException {
        if (this.root.getDataNode() == null || this.root.getDataNode().isMissingNode()) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_NO_DATA, (Object[])null);
        }
        this.currentJsonNode = null;
        this.nodes = this.jsonQLExecuter.selectNodes(this.root, this.selectExpression);
        this.currentNodeIndex = -1;
    }

    @Override
    public boolean next() throws JRException {
        if (this.nodes != null && this.currentNodeIndex < this.nodes.size() - 1) {
            this.currentJsonNode = this.nodes.get(++this.currentNodeIndex);
            return true;
        }
        return false;
    }

    @Override
    public Object getFieldValue(JRField jrField) throws JRException {
        String expression;
        if (this.currentJsonNode == null) {
            return null;
        }
        if (this.fieldExpressions.containsKey(jrField.getName())) {
            expression = this.fieldExpressions.get(jrField.getName());
        } else {
            expression = this.getFieldExpression(jrField);
            this.fieldExpressions.put(jrField.getName(), expression);
        }
        if (expression == null || expression.length() == 0) {
            return null;
        }
        JRJsonNode selectedNode = this.jsonQLExecuter.selectNode(this.currentJsonNode, this.root, expression);
        if (selectedNode != null) {
            return this.getConvertedValue(selectedNode, jrField);
        }
        return null;
    }

    @Override
    public JsonQLDataSource subDataSource() throws JRException {
        return this.subDataSource(null);
    }

    @Override
    public JsonQLDataSource subDataSource(String selectExpression) throws JRException {
        if (this.currentJsonNode == null) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_NO_DATA, (Object[])null);
        }
        JsonQLDataSource subDataSource = new JsonQLDataSource(this.currentJsonNode, selectExpression);
        subDataSource.setTextAttributes(this);
        return subDataSource;
    }

    protected Object getConvertedValue(JRJsonNode node, JRField jrField) throws JRException {
        JsonNode dataNode = node.getDataNode();
        Class<?> valueClass = jrField.getValueClass();
        if (log.isDebugEnabled()) {
            log.debug("attempting to convert: " + dataNode + " to class: " + valueClass);
        }
        if (Object.class.equals(valueClass)) {
            return dataNode;
        }
        Object result = null;
        if (!dataNode.isNull()) {
            try {
                result = Boolean.class.equals(valueClass) && dataNode.isBoolean() ? Boolean.valueOf(dataNode.booleanValue()) : (BigDecimal.class.equals(valueClass) && dataNode.isBigDecimal() ? dataNode.decimalValue() : (BigInteger.class.equals(valueClass) && dataNode.isBigInteger() ? dataNode.bigIntegerValue() : (Double.class.equals(valueClass) && dataNode.isDouble() ? Double.valueOf(dataNode.doubleValue()) : (Integer.class.equals(valueClass) && dataNode.isInt() ? Integer.valueOf(dataNode.intValue()) : (Number.class.isAssignableFrom(valueClass) && dataNode.isNumber() ? this.convertNumber(dataNode.numberValue(), valueClass) : this.convertStringValue(dataNode.asText(), valueClass))))));
                if (result == null) {
                    throw new JRException("data.common.cannot.convert.field.type", new Object[]{jrField.getName(), valueClass.getName()});
                }
            }
            catch (Exception e) {
                throw new JRException(EXCEPTION_MESSAGE_KEY_JSON_FIELD_VALUE_NOT_RETRIEVED, new Object[]{jrField.getName(), valueClass.getName()}, e);
            }
        }
        return result;
    }

    protected String getFieldExpression(JRField field) {
        String fieldExpression = null;
        if (field.hasProperties()) {
            fieldExpression = field.getPropertiesMap().getProperty(PROPERTY_FIELD_EXPRESSION);
        }
        if (fieldExpression == null && ((fieldExpression = field.getDescription()) == null || fieldExpression.length() == 0)) {
            fieldExpression = field.getName();
        }
        return fieldExpression;
    }
}

