/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRVirtualizable;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.base.JRVirtualPrintPage;
import net.sf.jasperreports.engine.base.VirtualElementsData;
import net.sf.jasperreports.engine.base.VirtualizablePageElements;
import net.sf.jasperreports.engine.fill.BaseReportFiller;
import net.sf.jasperreports.engine.fill.ElementEvaluationAction;
import net.sf.jasperreports.engine.fill.EvaluationBoundAction;
import net.sf.jasperreports.engine.fill.FillPageKey;
import net.sf.jasperreports.engine.fill.JREvaluationTime;
import net.sf.jasperreports.engine.fill.JRFillContext;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.fill.StandardBoundActionExecutionContext;
import net.sf.jasperreports.engine.fill.VirtualizationListener;
import net.sf.jasperreports.engine.fill.VirtualizedPageEvaluationAction;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.util.LinkedMap;
import net.sf.jasperreports.engine.util.UniformPrintElementVisitor;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DelayedFillActions
implements VirtualizationListener<VirtualElementsData> {
    private static final Log log = LogFactory.getLog(DelayedFillActions.class);
    protected static final String FILL_CACHE_KEY_ID = DelayedFillActions.class.getName() + "#id";
    public static final String EXCEPTION_MESSAGE_KEY_ELEMENT_NOT_FOUND = "fill.delayed.fill.actions.element.not.found";
    private final int id;
    private final BaseReportFiller reportFiller;
    private final JRFillContext fillContext;
    private final HashMap<JREvaluationTime, LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>>> actionsMap;
    private Map<Integer, JRFillElement> fillElements;
    private Set<Integer> masterFillElementIds;
    private Set<JRVirtualizationContext> listenedContexts;
    private Set<Integer> transferredIds;

    public DelayedFillActions(BaseReportFiller reportFiller) {
        this.id = DelayedFillActions.assignId(reportFiller);
        this.reportFiller = reportFiller;
        this.fillContext = reportFiller.fillContext;
        this.actionsMap = new HashMap();
        this.fillElements = new HashMap<Integer, JRFillElement>();
        this.masterFillElementIds = new HashSet<Integer>();
        this.listenedContexts = new HashSet<JRVirtualizationContext>();
    }

    private static int assignId(BaseReportFiller reportFiller) {
        AtomicInteger counter = (AtomicInteger)reportFiller.fillContext.getFillCache(FILL_CACHE_KEY_ID);
        if (counter == null) {
            counter = new AtomicInteger();
            reportFiller.fillContext.setFillCache(FILL_CACHE_KEY_ID, counter);
        }
        return counter.incrementAndGet();
    }

    public int getId() {
        return this.id;
    }

    public void createDelayedEvaluationTime(JREvaluationTime evaluationTime) {
        LinkedHashMap evaluationActions = new LinkedHashMap();
        this.actionsMap.put(evaluationTime, evaluationActions);
    }

    protected void registerPage(JRPrintPage page) {
        JRVirtualizationContext virtualizationContext;
        if (page instanceof JRVirtualPrintPage && !this.listenedContexts.contains(virtualizationContext = ((JRVirtualPrintPage)page).getVirtualizationContext())) {
            virtualizationContext.addListener(this);
            this.listenedContexts.add(virtualizationContext);
            if (log.isDebugEnabled()) {
                log.debug(this.id + " registered virtualization listener on " + virtualizationContext);
            }
        }
    }

    public void dispose() {
        for (JRVirtualizationContext virtualizationContext : this.listenedContexts) {
            virtualizationContext.removeListener(this);
            if (!log.isDebugEnabled()) continue;
            log.debug(this.id + " unregistered virtualization listener on " + virtualizationContext);
        }
    }

    public void addDelayedAction(JRFillElement element, JRPrintElement printElement, JREvaluationTime evaluationTime, FillPageKey pageKey) {
        this.registerFillElement(element, evaluationTime);
        ElementEvaluationAction action = new ElementEvaluationAction(element, printElement);
        this.addDelayedAction(printElement, action, evaluationTime, pageKey);
    }

    protected void registerFillElement(JRFillElement element, JREvaluationTime evaluationTime) {
        int fillElementId = element.printElementOriginator.getSourceElementId();
        if (!this.fillElements.containsKey(fillElementId)) {
            this.fillElements.put(fillElementId, element);
            if (evaluationTime.getType() == EvaluationTimeEnum.MASTER) {
                this.masterFillElementIds.add(fillElementId);
            }
        }
    }

    protected void registerTransferredId(int sourceId) {
        boolean added;
        if (this.transferredIds == null) {
            this.transferredIds = new HashSet<Integer>();
        }
        if ((added = this.transferredIds.add(sourceId)) && log.isDebugEnabled()) {
            log.debug(this.id + " transferred id " + sourceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDelayedAction(Object actionKey, EvaluationBoundAction action, JREvaluationTime evaluationTime, FillPageKey pageKey) {
        if (log.isDebugEnabled()) {
            log.debug(this.id + " adding delayed action " + action + " at " + evaluationTime + ", key " + pageKey);
        }
        LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> pagesMap = this.actionsMap.get(evaluationTime);
        this.fillContext.lockVirtualizationContext();
        try {
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = pagesMap;
            synchronized (linkedHashMap) {
                LinkedMap<Object, EvaluationBoundAction> boundElementsMap = this.pageActionsMap(pagesMap, pageKey);
                boundElementsMap.add(actionKey, action);
            }
        }
        finally {
            this.fillContext.unlockVirtualizationContext();
        }
    }

    protected LinkedMap<Object, EvaluationBoundAction> pageActionsMap(LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> map, FillPageKey pageKey) {
        LinkedMap<Object, EvaluationBoundAction> pageMap = map.get(pageKey);
        if (pageMap == null) {
            pageMap = new LinkedMap();
            map.put(pageKey, pageMap);
            this.registerPage(pageKey.page);
        }
        return pageMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runActions(JREvaluationTime evaluationTime, byte evaluation) throws JRException {
        boolean hasEntry;
        if (log.isDebugEnabled()) {
            log.debug(this.id + " running delayed actions on " + evaluationTime);
        }
        LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> pagesMap = this.actionsMap.get(evaluationTime);
        do {
            this.reportFiller.checkInterrupted();
            this.fillContext.lockVirtualizationContext();
            try {
                LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = pagesMap;
                synchronized (linkedHashMap) {
                    Iterator<Map.Entry<FillPageKey, LinkedMap<Object, EvaluationBoundAction>>> pagesIt = pagesMap.entrySet().iterator();
                    hasEntry = pagesIt.hasNext();
                    if (hasEntry) {
                        Map.Entry<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> pageEntry = pagesIt.next();
                        int pageIdx = pageEntry.getKey().index;
                        if (log.isDebugEnabled()) {
                            log.debug(this.id + " running actions for page " + pageEntry.getKey().page + " at " + pageIdx);
                        }
                        StandardBoundActionExecutionContext context = new StandardBoundActionExecutionContext();
                        context.setCurrentPageIndex(pageIdx);
                        JasperPrint jasperPrint = this.fillContext.getMasterFiller().getJasperPrint();
                        context.setTotalPages(jasperPrint.getPages().size());
                        context.setEvaluationTime(evaluationTime);
                        context.setExpressionEvaluationType(evaluation);
                        LinkedMap<Object, EvaluationBoundAction> boundElementsMap = pageEntry.getValue();
                        while (!boundElementsMap.isEmpty()) {
                            EvaluationBoundAction action = boundElementsMap.pop();
                            action.execute(context);
                        }
                        pagesIt.remove();
                        if (this.reportFiller.fillListener != null) {
                            this.reportFiller.fillListener.pageUpdated(jasperPrint, pageIdx);
                        }
                    }
                }
            }
            finally {
                this.fillContext.unlockVirtualizationContext();
            }
        } while (hasEntry);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasDelayedActions(JRPrintPage page) {
        FillPageKey pageKey = new FillPageKey(page);
        for (LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> map : this.actionsMap.values()) {
            this.fillContext.lockVirtualizationContext();
            try {
                LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = map;
                synchronized (linkedHashMap) {
                    block9: {
                        LinkedMap<Object, EvaluationBoundAction> boundMap = map.get(pageKey);
                        if (boundMap == null || boundMap.isEmpty()) break block9;
                        boolean bl = true;
                        return bl;
                    }
                }
            }
            finally {
                this.fillContext.unlockVirtualizationContext();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasMasterDelayedActions(JRPrintPage page) {
        LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> masterActions = this.actionsMap.get(JREvaluationTime.EVALUATION_TIME_MASTER);
        FillPageKey pageKey = new FillPageKey(page);
        this.fillContext.lockVirtualizationContext();
        try {
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = masterActions;
            synchronized (linkedHashMap) {
                LinkedMap<Object, EvaluationBoundAction> pageMasterActions = masterActions.get(pageKey);
                boolean bl = pageMasterActions != null && !pageMasterActions.isEmpty();
                return bl;
            }
        }
        finally {
            this.fillContext.unlockVirtualizationContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveActions(FillPageKey fromKey, FillPageKey toKey) {
        if (log.isDebugEnabled()) {
            log.debug(this.id + " moving actions from " + fromKey + " to " + toKey);
        }
        for (LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> map : this.actionsMap.values()) {
            this.fillContext.lockVirtualizationContext();
            try {
                LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = map;
                synchronized (linkedHashMap) {
                    LinkedMap subreportMap = (LinkedMap)map.remove(fromKey);
                    if (subreportMap != null && !subreportMap.isEmpty()) {
                        LinkedMap<Object, EvaluationBoundAction> masterMap = this.pageActionsMap(map, toKey);
                        masterMap.addAll(subreportMap);
                    }
                }
            }
            finally {
                this.fillContext.unlockVirtualizationContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void beforeExternalization(JRVirtualizable<VirtualElementsData> object) {
        JRVirtualizationContext virtualizationContext = object.getContext();
        virtualizationContext.lock();
        try {
            this.writeElementEvaluations(object);
        }
        finally {
            virtualizationContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeElementEvaluations(final JRVirtualizable<VirtualElementsData> object) {
        if (log.isDebugEnabled()) {
            log.debug(this.id + " setting element evaluation for elements in " + object.getUID());
        }
        JRVirtualPrintPage page = ((VirtualizablePageElements)((Object)object)).getPage();
        FillPageKey pageKey = new FillPageKey(page);
        VirtualElementsData virtualData = object.getVirtualData();
        for (Map.Entry<JREvaluationTime, LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>>> boundMapEntry : this.actionsMap.entrySet()) {
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> map;
            final JREvaluationTime evaluationTime = boundMapEntry.getKey();
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = map = boundMapEntry.getValue();
            synchronized (linkedHashMap) {
                final LinkedMap<Object, EvaluationBoundAction> actionsMap = map.get(pageKey);
                if (actionsMap != null && !actionsMap.isEmpty()) {
                    final LinkedHashMap<JRPrintElement, Integer> elementEvaluations = new LinkedHashMap<JRPrintElement, Integer>();
                    UniformPrintElementVisitor<Void> visitor = new UniformPrintElementVisitor<Void>(true){

                        @Override
                        protected void visitElement(JRPrintElement element, Void arg) {
                            ElementEvaluationAction action = (ElementEvaluationAction)actionsMap.remove(element);
                            if (action != null) {
                                elementEvaluations.put(element, action.element.printElementOriginator.getSourceElementId());
                                if (log.isDebugEnabled()) {
                                    log.debug(DelayedFillActions.this.id + " saving evaluation " + evaluationTime + " of element " + element + " on object " + object);
                                }
                            }
                        }
                    };
                    for (JRPrintElement element : virtualData.getElements()) {
                        element.accept(visitor, null);
                    }
                    if (!elementEvaluations.isEmpty()) {
                        virtualData.setElementEvaluations(this.id, evaluationTime, elementEvaluations);
                        VirtualizedPageEvaluationAction virtualizedAction = new VirtualizedPageEvaluationAction(object, this.id);
                        actionsMap.add(null, virtualizedAction);
                        if (log.isDebugEnabled()) {
                            log.debug(this.id + " created action " + virtualizedAction);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterInternalization(JRVirtualizable<VirtualElementsData> object) {
        JRVirtualizationContext virtualizationContext = object.getContext();
        virtualizationContext.lock();
        try {
            this.readElementEvaluations(object);
        }
        finally {
            virtualizationContext.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readElementEvaluations(JRVirtualizable<VirtualElementsData> object) {
        JRVirtualPrintPage page = ((VirtualizablePageElements)((Object)object)).getPage();
        FillPageKey pageKey = new FillPageKey(page);
        for (Map.Entry<JREvaluationTime, LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>>> boundMapEntry : this.actionsMap.entrySet()) {
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> map;
            JREvaluationTime evaluationTime = boundMapEntry.getKey();
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = map = boundMapEntry.getValue();
            synchronized (linkedHashMap) {
                LinkedMap<Object, EvaluationBoundAction> actionsMap = map.get(pageKey);
                this.readElementEvaluations(object, this.id, evaluationTime, actionsMap);
                if (this.transferredIds != null) {
                    for (Integer transferredId : this.transferredIds) {
                        this.readElementEvaluations(object, transferredId, evaluationTime, actionsMap);
                    }
                }
            }
        }
    }

    protected void readElementEvaluations(JRVirtualizable<VirtualElementsData> object, int sourceId, JREvaluationTime evaluationTime, LinkedMap<Object, EvaluationBoundAction> actionsMap) {
        VirtualElementsData elementsData = object.getVirtualData();
        Map<JRPrintElement, Integer> elementEvaluations = elementsData.getElementEvaluations(sourceId, evaluationTime);
        if (elementEvaluations != null) {
            for (Map.Entry<JRPrintElement, Integer> entry : elementEvaluations.entrySet()) {
                JRPrintElement element = entry.getKey();
                int fillElementId = entry.getValue();
                JRFillElement fillElement = this.fillElements.get(fillElementId);
                if (log.isDebugEnabled()) {
                    log.debug(this.id + " got evaluation " + evaluationTime + ", source id " + sourceId + ", on " + element + ", from object " + object + ", using " + fillElement);
                }
                if (fillElement == null) {
                    throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_ELEMENT_NOT_FOUND, new Object[]{fillElementId});
                }
                actionsMap.addFirst(element, new ElementEvaluationAction(fillElement, element));
            }
        }
    }

    public void moveMasterEvaluations(DelayedFillActions sourceActions, JRPrintPage page, int pageIndex) {
        FillPageKey sourcePageKey = new FillPageKey(page);
        FillPageKey destinationPageKey = new FillPageKey(page, pageIndex);
        this.moveMasterEvaluations(sourceActions, sourcePageKey, destinationPageKey);
    }

    public void moveMasterEvaluations(DelayedFillActions sourceActions, FillPageKey pageKey) {
        this.moveMasterEvaluations(sourceActions, pageKey, pageKey);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveMasterEvaluations(DelayedFillActions sourceActions, FillPageKey sourcePageKey, FillPageKey destinationPageKey) {
        if (log.isDebugEnabled()) {
            log.debug(this.id + " moving master actions from " + sourceActions.id + ", source " + sourcePageKey + ", destination " + destinationPageKey);
        }
        this.fillContext.lockVirtualizationContext();
        try {
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> actions;
            LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = actions = sourceActions.actionsMap.get(JREvaluationTime.EVALUATION_TIME_MASTER);
            synchronized (linkedHashMap) {
                LinkedMap pageActions;
                block10: {
                    pageActions = (LinkedMap)actions.remove(sourcePageKey);
                    if (pageActions != null && !pageActions.isEmpty()) break block10;
                    return;
                }
                this.moveMasterActions(pageActions, destinationPageKey);
                for (Integer elementId : sourceActions.masterFillElementIds) {
                    if (this.fillElements.containsKey(elementId)) continue;
                    this.fillElements.put(elementId, sourceActions.fillElements.get(elementId));
                    this.masterFillElementIds.add(elementId);
                }
            }
        }
        finally {
            this.fillContext.unlockVirtualizationContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void moveMasterActions(LinkedMap<Object, EvaluationBoundAction> sourceActions, FillPageKey destinationPageKey) {
        LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> masterActions;
        LinkedHashMap<FillPageKey, LinkedMap<Object, EvaluationBoundAction>> linkedHashMap = masterActions = this.actionsMap.get(JREvaluationTime.EVALUATION_TIME_MASTER);
        synchronized (linkedHashMap) {
            LinkedMap<Object, EvaluationBoundAction> masterPageActions = this.pageActionsMap(masterActions, destinationPageKey);
            while (!sourceActions.isEmpty()) {
                Map.Entry<Object, EvaluationBoundAction> entry = sourceActions.popEntry();
                Object key = entry.getKey();
                EvaluationBoundAction action = entry.getValue();
                masterPageActions.add(key, action);
                this.actionMoved(action);
                if (!log.isDebugEnabled()) continue;
                log.debug(this.id + " moved action " + action);
            }
        }
    }

    protected void actionMoved(EvaluationBoundAction action) {
        if (action instanceof VirtualizedPageEvaluationAction) {
            int sourceId = ((VirtualizedPageEvaluationAction)action).getSourceId();
            this.registerTransferredId(sourceId);
        }
    }
}

