/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.AbstractXlsDataSource;
import net.sf.jasperreports.engine.query.JRAbstractQueryExecuter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractXlsQueryExecuter
extends JRAbstractQueryExecuter {
    private static final Log log = LogFactory.getLog(AbstractXlsQueryExecuter.class);
    private AbstractXlsDataSource datasource;

    protected AbstractXlsQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(jasperReportsContext, dataset, parametersMap);
    }

    protected AbstractXlsQueryExecuter(JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this(DefaultJasperReportsContext.getInstance(), dataset, parametersMap);
    }

    protected void initDatasource(AbstractXlsDataSource datasource) throws JRException {
        this.datasource = datasource;
        if (datasource != null) {
            List<Object> columnNamesList = null;
            String columnNames = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.column.names");
            if (columnNames == null) {
                columnNames = this.getStringParameterOrProperty("net.sf.jasperreports.xls.column.names");
            }
            if (columnNames != null) {
                columnNamesList = new ArrayList<String>();
                columnNamesList.add(columnNames);
            } else {
                String[] columnNamesArray = (String[])this.getParameterValue("XLSX_COLUMN_NAMES_ARRAY", true);
                if (columnNamesArray == null) {
                    columnNamesArray = (String[])this.getParameterValue("XLS_COLUMN_NAMES_ARRAY", true);
                }
                if (columnNamesArray != null) {
                    columnNamesList = Arrays.asList(columnNamesArray);
                } else {
                    String propertiesPrefix = "net.sf.jasperreports.xlsx.column.names";
                    List<JRPropertiesUtil.PropertySuffix> properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                    if (properties != null && !properties.isEmpty()) {
                        columnNamesList = new ArrayList();
                        for (int i = 0; i < properties.size(); ++i) {
                            JRPropertiesUtil.PropertySuffix property = properties.get(i);
                            columnNamesList.add(property.getValue());
                        }
                    } else {
                        propertiesPrefix = "net.sf.jasperreports.xls.column.names";
                        properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                        if (properties != null && !properties.isEmpty()) {
                            columnNamesList = new ArrayList();
                            for (int i = 0; i < properties.size(); ++i) {
                                JRPropertiesUtil.PropertySuffix property = properties.get(i);
                                columnNamesList.add(property.getValue());
                            }
                        } else {
                            JRField[] fields = this.dataset.getFields();
                            if (fields != null && fields.length > 0) {
                                columnNamesList = new ArrayList();
                                for (int i = 0; i < fields.length; ++i) {
                                    columnNamesList.add(fields[i].getName());
                                }
                            }
                        }
                    }
                }
            }
            ArrayList<String> splitColumnNamesList = null;
            if (columnNamesList != null && columnNamesList.size() > 0) {
                splitColumnNamesList = new ArrayList<String>();
                for (int i = 0; i < columnNamesList.size(); ++i) {
                    String names = (String)columnNamesList.get(i);
                    String[] arr$ = names.split(",");
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$; ++i$) {
                        String token = arr$[i$];
                        splitColumnNamesList.add(token.trim());
                    }
                }
            }
            List<Object> columnIndexesList = null;
            String columnIndexes = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.column.indexes");
            if (columnIndexes == null) {
                columnIndexes = this.getStringParameterOrProperty("net.sf.jasperreports.xls.column.indexes");
            }
            if (columnIndexes != null) {
                columnIndexesList = new ArrayList();
                for (String colIndex : columnIndexes.split(",")) {
                    columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                }
            } else {
                Integer[] columnIndexesArray = (Integer[])this.getParameterValue("XLSX_COLUMN_INDEXES_ARRAY", true);
                if (columnIndexesArray == null) {
                    columnIndexesArray = (Integer[])this.getParameterValue("XLS_COLUMN_INDEXES_ARRAY", true);
                }
                if (columnIndexesArray != null) {
                    columnIndexesList = Arrays.asList(columnIndexesArray);
                } else {
                    String propertyValue;
                    String propertiesPrefix = "net.sf.jasperreports.xlsx.column.indexes";
                    List<JRPropertiesUtil.PropertySuffix> properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                    if (properties != null && !properties.isEmpty()) {
                        columnIndexesList = new ArrayList();
                        for (int i = 0; i < properties.size(); ++i) {
                            propertyValue = properties.get(i).getValue();
                            for (String colIndex : propertyValue.split(",")) {
                                columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                            }
                        }
                    } else {
                        propertiesPrefix = "net.sf.jasperreports.xls.column.indexes";
                        properties = this.getPropertiesUtil().getAllProperties(this.dataset, propertiesPrefix);
                        if (properties != null && !properties.isEmpty()) {
                            columnIndexesList = new ArrayList();
                            for (int i = 0; i < properties.size(); ++i) {
                                propertyValue = properties.get(i).getValue();
                                for (String colIndex : propertyValue.split(",")) {
                                    columnIndexesList.add(Integer.valueOf(colIndex.trim()));
                                }
                            }
                        }
                    }
                }
            }
            if (splitColumnNamesList != null) {
                if (columnIndexesList != null) {
                    int[] indexesArray = new int[columnIndexesList.size()];
                    for (int i = 0; i < columnIndexesList.size(); ++i) {
                        indexesArray[i] = (Integer)columnIndexesList.get(i);
                    }
                    datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]), indexesArray);
                } else {
                    datasource.setColumnNames(splitColumnNamesList.toArray(new String[splitColumnNamesList.size()]));
                }
            } else if (columnIndexesList != null) {
                datasource.setColumnIndexes(columnIndexesList.toArray(new Integer[columnIndexesList.size()]));
            } else if (log.isWarnEnabled()) {
                log.warn("No column names or column indexes were specified.");
            }
            DateFormat dateFormat = (DateFormat)this.getParameterValue("XLSX_DATE_FORMAT", true);
            if (dateFormat == null) {
                dateFormat = (DateFormat)this.getParameterValue("XLS_DATE_FORMAT", true);
            }
            if (dateFormat != null) {
                datasource.setDateFormat(dateFormat);
            } else {
                String dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.date.pattern");
                if (dateFormatPattern == null) {
                    dateFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xls.date.pattern");
                }
                if (dateFormatPattern != null) {
                    datasource.setDatePattern(dateFormatPattern);
                }
            }
            NumberFormat numberFormat = (NumberFormat)this.getParameterValue("XLSX_NUMBER_FORMAT", true);
            if (numberFormat == null) {
                numberFormat = (NumberFormat)this.getParameterValue("XLS_NUMBER_FORMAT", true);
            }
            if (numberFormat != null) {
                datasource.setNumberFormat(numberFormat);
            } else {
                String numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.number.pattern");
                if (numberFormatPattern == null) {
                    numberFormatPattern = this.getStringParameterOrProperty("net.sf.jasperreports.xls.number.pattern");
                }
                if (numberFormatPattern != null) {
                    datasource.setNumberPattern(numberFormatPattern);
                }
            }
            Boolean useFirstRowAsHeader = this.getBooleanParameterOrProperty("XLSX_USE_FIRST_ROW_AS_HEADER");
            if (useFirstRowAsHeader == null) {
                useFirstRowAsHeader = this.getBooleanParameterOrProperty("XLS_USE_FIRST_ROW_AS_HEADER", false);
            }
            datasource.setUseFirstRowAsHeader(useFirstRowAsHeader);
            Locale xlsLocale = (Locale)this.getParameterValue("XLSX_LOCALE", true);
            if (xlsLocale == null) {
                xlsLocale = (Locale)this.getParameterValue("XLS_LOCALE", true);
            }
            if (xlsLocale != null) {
                datasource.setLocale(xlsLocale);
            } else {
                String xlsLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.locale.code");
                if (xlsLocaleCode == null) {
                    xlsLocaleCode = this.getStringParameterOrProperty("net.sf.jasperreports.xls.locale.code");
                }
                if (xlsLocaleCode != null) {
                    datasource.setLocale(xlsLocaleCode);
                } else {
                    xlsLocale = (Locale)this.getParameterValue("REPORT_LOCALE", true);
                    if (xlsLocale != null) {
                        datasource.setLocale(xlsLocale);
                    }
                }
            }
            TimeZone xlsTimezone = (TimeZone)this.getParameterValue("XLSX_TIMEZONE", true);
            if (xlsTimezone == null) {
                xlsTimezone = (TimeZone)this.getParameterValue("XLS_TIMEZONE", true);
            }
            if (xlsTimezone != null) {
                datasource.setTimeZone(xlsTimezone);
            } else {
                String xlsTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.xlsx.timezone.id");
                if (xlsTimezoneId == null) {
                    xlsTimezoneId = this.getStringParameterOrProperty("net.sf.jasperreports.xls.timezone.id");
                }
                if (xlsTimezoneId != null) {
                    datasource.setTimeZone(xlsTimezoneId);
                } else {
                    xlsTimezone = (TimeZone)this.getParameterValue("REPORT_TIME_ZONE", true);
                    if (xlsTimezone != null) {
                        datasource.setTimeZone(xlsTimezone);
                    }
                }
            }
            String sheetSelection = this.getStringParameterOrProperty("net.sf.jasperreports.xls.sheet.selection");
            if (sheetSelection != null && sheetSelection.length() > 0) {
                datasource.setSheetSelection(sheetSelection);
            }
        }
    }

    @Override
    public void close() {
        if (this.datasource != null) {
            this.datasource.close();
        }
    }

    @Override
    public boolean cancelQuery() throws JRException {
        return false;
    }

    @Override
    protected String getParameterReplacement(String parameterName) {
        return String.valueOf(this.getParameterValue(parameterName));
    }
}

