/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.extensions;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.util.ClassLoaderResource;
import net.sf.jasperreports.engine.util.ClassUtils;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.ObjectUtils;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;
import net.sf.jasperreports.extensions.ExtensionsRegistry;
import net.sf.jasperreports.extensions.ExtensionsRegistryFactory;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DefaultExtensionsRegistry
implements ExtensionsRegistry {
    private final Log log = LogFactory.getLog(DefaultExtensionsRegistry.class);
    public static final String EXTENSION_RESOURCE_NAME = "jasperreports_extension.properties";
    public static final String PROPERTY_REGISTRY_FACTORY_PREFIX = "net.sf.jasperreports.extension.registry.factory.";
    public static final String PROPERTY_REGISTRY_PREFIX = "net.sf.jasperreports.extension.";
    private final ReferenceMap registrySetCache = new ReferenceMap(2, 0);
    private final ReferenceMap registryCache = new ReferenceMap(2, 0);

    @Override
    public <T> List<T> getExtensions(Class<T> extensionType) {
        List<ExtensionsRegistry> registries = this.getRegistries();
        ArrayList<T> extensions = new ArrayList<T>(registries.size());
        for (ExtensionsRegistry registry : registries) {
            List<T> registryExtensions = registry.getExtensions(extensionType);
            if (registryExtensions == null || registryExtensions.isEmpty()) continue;
            extensions.addAll(registryExtensions);
        }
        return extensions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ExtensionsRegistry> getRegistries() {
        List<ExtensionsRegistry> registries;
        Object cacheKey = ExtensionsEnvironment.getExtensionsCacheKey();
        ReferenceMap referenceMap = this.registrySetCache;
        synchronized (referenceMap) {
            registries = (List<ExtensionsRegistry>)this.registrySetCache.get(cacheKey);
            if (registries == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("Loading registries for cache key " + cacheKey);
                }
                registries = this.loadRegistries();
                this.registrySetCache.put(cacheKey, registries);
            }
        }
        return registries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ExtensionsRegistry> loadRegistries() {
        IdentityHashMap<ExtensionsRegistry, Boolean> registrySet = new IdentityHashMap<ExtensionsRegistry, Boolean>();
        ArrayList<ExtensionsRegistry> allRegistries = new ArrayList<ExtensionsRegistry>();
        List<ClassLoaderResource> extensionResources = this.loadExtensionPropertyResources();
        for (ClassLoaderResource extensionResource : extensionResources) {
            List<ExtensionsRegistry> registries;
            ClassLoader classLoader = extensionResource.getClassLoader();
            Map<URL, URLRegistries> classLoaderRegistries = this.getClassLoaderRegistries(classLoader);
            URL url = extensionResource.getUrl();
            LinkedHashMap<String, Exception> registryExceptions = new LinkedHashMap<String, Exception>();
            Map<URL, URLRegistries> map = classLoaderRegistries;
            synchronized (map) {
                URLRegistries urlRegistries = classLoaderRegistries.get(url);
                if (urlRegistries == null) {
                    JRPropertiesMap properties;
                    URL duplicateURL;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("Loading JasperReports extension properties resource " + url);
                    }
                    if ((duplicateURL = this.detectDuplicate(properties = JRPropertiesMap.loadProperties(url), classLoaderRegistries)) == null) {
                        registries = this.loadRegistries(properties, registryExceptions);
                    } else {
                        this.log.warn("Extension resource " + url + " was found to be a duplicate of " + duplicateURL + " in classloader " + classLoader);
                        registries = Collections.emptyList();
                    }
                    classLoaderRegistries.put(url, new URLRegistries(properties, registries));
                } else {
                    registries = urlRegistries.registries;
                }
            }
            for (Map.Entry entry : registryExceptions.entrySet()) {
                this.log.error("Error instantiating extensions registry for " + (String)entry.getKey() + " from " + url, (Throwable)entry.getValue());
            }
            for (ExtensionsRegistry extensionsRegistry : registries) {
                boolean added;
                boolean bl = added = registrySet.put(extensionsRegistry, Boolean.FALSE) == null;
                if (added) {
                    allRegistries.add(extensionsRegistry);
                    continue;
                }
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug("Found duplicate extension registry " + extensionsRegistry);
            }
        }
        return allRegistries;
    }

    protected List<ClassLoaderResource> loadExtensionPropertyResources() {
        return JRLoader.getClassLoaderResources(EXTENSION_RESOURCE_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Map<URL, URLRegistries> getClassLoaderRegistries(ClassLoader classLoader) {
        ReferenceMap referenceMap = this.registryCache;
        synchronized (referenceMap) {
            HashMap<URL, URLRegistries> registries = (HashMap<URL, URLRegistries>)this.registryCache.get(classLoader);
            if (registries == null) {
                registries = new HashMap<URL, URLRegistries>();
                this.registryCache.put(classLoader, registries);
            }
            return registries;
        }
    }

    protected List<ExtensionsRegistry> loadRegistries(JRPropertiesMap properties, Map<String, Exception> registryExceptions) {
        ArrayList<ExtensionsRegistry> registries = new ArrayList<ExtensionsRegistry>();
        List<JRPropertiesUtil.PropertySuffix> factoryProps = JRPropertiesUtil.getProperties(properties, PROPERTY_REGISTRY_FACTORY_PREFIX);
        for (JRPropertiesUtil.PropertySuffix factoryProp : factoryProps) {
            String registryId = factoryProp.getSuffix();
            String factoryClass = factoryProp.getValue();
            if (this.log.isDebugEnabled()) {
                this.log.debug("Instantiating registry of type " + factoryClass + " for property " + factoryProp.getKey());
            }
            try {
                ExtensionsRegistry registry = this.instantiateRegistry(properties, registryId, factoryClass);
                registries.add(registry);
            }
            catch (Exception e) {
                registryExceptions.put(registryId, e);
            }
        }
        return registries;
    }

    protected ExtensionsRegistry instantiateRegistry(JRPropertiesMap props, String registryId, String factoryClass) {
        if (this.log.isDebugEnabled()) {
            this.log.debug("Instantiating extensions registry for " + registryId + " using factory class " + factoryClass);
        }
        ExtensionsRegistryFactory factory = (ExtensionsRegistryFactory)ClassUtils.instantiateClass(factoryClass, ExtensionsRegistryFactory.class);
        return factory.createRegistry(registryId, props);
    }

    protected URL detectDuplicate(JRPropertiesMap properties, Map<URL, URLRegistries> registries) {
        URL duplicateURL = null;
        for (Map.Entry<URL, URLRegistries> registryEntry : registries.entrySet()) {
            JRPropertiesMap entryProperties = registryEntry.getValue().properties;
            if (!ObjectUtils.equals(properties, entryProperties)) continue;
            duplicateURL = registryEntry.getKey();
            break;
        }
        return duplicateURL;
    }

    protected static class URLRegistries {
        JRPropertiesMap properties;
        List<ExtensionsRegistry> registries;

        public URLRegistries(JRPropertiesMap properties, List<ExtensionsRegistry> registries) {
            this.properties = properties;
            this.registries = registries;
        }
    }
}

