/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.differ;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import javax.swing.JTextPane;
import oracle.xml.async.DOMBuilder;
import oracle.xml.async.DOMBuilderErrorEvent;
import oracle.xml.async.DOMBuilderErrorListener;
import oracle.xml.async.DOMBuilderEvent;
import oracle.xml.async.DOMBuilderListener;
import oracle.xml.async.ResourceManager;
import oracle.xml.differ.Diff;
import oracle.xml.differ.DiffGeneratorManager;
import oracle.xml.differ.DiffStyledDocument;
import oracle.xml.differ.DomHash;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLParseException;
import oracle.xml.parser.v2.XMLUtil;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLDiff
implements DOMBuilderListener,
DOMBuilderErrorListener,
Serializable {
    private XMLDocument m_doc1 = null;
    private XMLDocument m_doc2 = null;
    private Diff m_diff;
    private DOMBuilder m_dom1;
    private DOMBuilder m_dom2;
    private ResourceManager m_rm;
    private static final int ONE = 1;
    private static final int TWO = 2;
    private int m_xsl_indent = 0;
    private DomHash m_dh = new DomHash();
    private boolean m_moves = true;
    private int m_xsl_nodeindent = 0;
    private DOMParser m_domparser = null;
    private boolean m_delWSdeletes = false;

    public void setFiles(File file, File file2) throws IOException, XMLParseException, SAXException, InterruptedException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        BufferedReader bufferedReader2 = new BufferedReader(new FileReader(file2));
        this.m_rm = new ResourceManager(2);
        this.m_rm.getResource();
        this.m_dom1 = new DOMBuilder(1);
        this.m_dom1.addDOMBuilderListener(this);
        this.m_dom1.addDOMBuilderErrorListener(this);
        this.m_dom1.parse(bufferedReader);
        this.m_rm.getResource();
        this.m_dom2 = new DOMBuilder(2);
        this.m_dom2.addDOMBuilderListener(this);
        this.m_dom2.addDOMBuilderErrorListener(this);
        this.m_dom2.parse(bufferedReader2);
        while (this.m_rm.activeFound()) {
            Thread.sleep(100L);
        }
    }

    public void setDocuments(XMLDocument xMLDocument, XMLDocument xMLDocument2) {
        this.m_doc1 = xMLDocument;
        this.m_doc2 = xMLDocument2;
    }

    public void setInput1(File file) throws IOException, XMLParseException, SAXException, InterruptedException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.m_rm = new ResourceManager(1);
        this.m_rm.getResource();
        this.m_dom1 = new DOMBuilder(1);
        this.m_dom1.addDOMBuilderListener(this);
        this.m_dom1.addDOMBuilderErrorListener(this);
        this.m_dom1.parse(bufferedReader);
        while (this.m_rm.activeFound()) {
            Thread.sleep(50L);
        }
    }

    public void setInput2(File file) throws IOException, XMLParseException, SAXException, InterruptedException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        this.m_rm = new ResourceManager(1);
        this.m_rm.getResource();
        this.m_dom2 = new DOMBuilder(2);
        this.m_dom2.addDOMBuilderListener(this);
        this.m_dom2.addDOMBuilderErrorListener(this);
        this.m_dom2.parse(bufferedReader);
        while (this.m_rm.activeFound()) {
            Thread.sleep(50L);
        }
    }

    public void setInput1(XMLDocument xMLDocument) {
        this.m_doc1 = xMLDocument;
    }

    public void setInput2(XMLDocument xMLDocument) {
        this.m_doc2 = xMLDocument;
    }

    public void setInput1(InputSource inputSource) throws IOException, XMLParseException, SAXException {
        this.m_doc1 = this.parseXML(inputSource);
    }

    public void setInput2(InputSource inputSource) throws IOException, XMLParseException, SAXException {
        this.m_doc2 = this.parseXML(inputSource);
    }

    public void setUrl1(String string) throws IOException, XMLParseException, SAXException, InterruptedException {
        URL uRL = XMLUtil.createURL(string);
        this.m_rm = new ResourceManager(1);
        this.m_rm.getResource();
        this.m_dom1 = new DOMBuilder(1);
        this.m_dom1.addDOMBuilderListener(this);
        this.m_dom1.addDOMBuilderErrorListener(this);
        this.m_dom1.parse(uRL.openStream());
        while (this.m_rm.activeFound()) {
            Thread.sleep(50L);
        }
    }

    public void setUrl2(String string) throws IOException, XMLParseException, SAXException, InterruptedException {
        URL uRL = XMLUtil.createURL(string);
        this.m_rm = new ResourceManager(1);
        this.m_rm.getResource();
        this.m_dom2 = new DOMBuilder(2);
        this.m_dom2.addDOMBuilderListener(this);
        this.m_dom2.addDOMBuilderErrorListener(this);
        this.m_dom2.parse(uRL.openStream());
        while (this.m_rm.activeFound()) {
            Thread.sleep(50L);
        }
    }

    public XMLDocument getDocument1() {
        return this.m_doc1;
    }

    public XMLDocument getDocument2() {
        return this.m_doc2;
    }

    public boolean diff() throws NullPointerException {
        if (this.m_doc1 == null || this.m_doc2 == null) {
            throw new NullPointerException();
        }
        this.m_diff = new Diff(this.m_doc1, this.m_doc2, this, this.m_moves);
        return this.m_diff.getDiffCount() != 0;
    }

    public JTextPane getDiffPane1() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setDocument(new DiffStyledDocument(this.m_diff.getDiffTree(1)));
        return jTextPane;
    }

    public JTextPane getDiffPane2() {
        JTextPane jTextPane = new JTextPane();
        jTextPane.setDocument(new DiffStyledDocument(this.m_diff.getDiffTree(2)));
        return jTextPane;
    }

    public void setIndentIncr(int n) {
        this.m_xsl_indent = n;
    }

    public void setNewNodeIndentIncr(int n) {
        this.m_xsl_nodeindent = n;
    }

    public void setDelWSBeforeDeletes(boolean bl) {
        this.m_delWSdeletes = bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateXSLFile(String string) throws IOException {
        if (string != null) {
            BufferedWriter bufferedWriter = null;
            try {
                bufferedWriter = new BufferedWriter(new FileWriter(string));
                this.generateXSL(bufferedWriter);
            }
            finally {
                if (bufferedWriter != null) {
                    bufferedWriter.close();
                }
            }
        }
    }

    public XMLDocument generateXSLDoc() throws FileNotFoundException, SAXException, XMLParseException, IOException {
        StringWriter stringWriter = new StringWriter();
        BufferedWriter bufferedWriter = new BufferedWriter(stringWriter);
        this.generateXSL(bufferedWriter);
        String string = stringWriter.toString();
        return this.parseXML(new InputSource(new StringReader(string)));
    }

    public void generateXSL(Writer writer) throws IOException, NullPointerException {
        if (writer == null) {
            throw new NullPointerException("Input writer is null!");
        }
        DiffGeneratorManager diffGeneratorManager = new DiffGeneratorManager();
        diffGeneratorManager.setGenerator((short)1, writer);
        diffGeneratorManager.setIndentIncr(this.m_xsl_indent);
        diffGeneratorManager.setNewNodeIndentIncr(this.m_xsl_nodeindent);
        diffGeneratorManager.setDelWSBeforeDeletes(this.m_delWSdeletes);
        diffGeneratorManager.generateDiffs(this.m_diff.getDiffTree(1));
    }

    protected boolean equals(Node node, Node node2) {
        byte[] byArray;
        byte[] byArray2 = this.m_dh.getDOMHash(node);
        if (byArray2.length != (byArray = this.m_dh.getDOMHash(node2)).length) {
            return false;
        }
        for (int i = 0; i < byArray2.length; ++i) {
            if (byArray2[i] == byArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public void domBuilderErrorCalled(DOMBuilderErrorEvent dOMBuilderErrorEvent) {
        int n = ((DOMBuilder)dOMBuilderErrorEvent.getSource()).getId();
        String string = null;
        string = n == 1 ? new String("Error in parsing XML file1:") : (n == 2 ? new String("Error in parsing XML file2:") : new String("Error from DOM Builder. File not known.:"));
        System.err.println(string + dOMBuilderErrorEvent.getException().getMessage());
        System.exit(0);
    }

    @Override
    public void domBuilderError(DOMBuilderEvent dOMBuilderEvent) {
    }

    @Override
    public synchronized void domBuilderOver(DOMBuilderEvent dOMBuilderEvent) {
        DOMBuilder dOMBuilder = (DOMBuilder)dOMBuilderEvent.getSource();
        if (dOMBuilder.getId() == 1) {
            this.m_doc1 = dOMBuilder.getDocument();
        } else if (dOMBuilder.getId() == 2) {
            this.m_doc2 = dOMBuilder.getDocument();
        }
        this.m_rm.releaseResource();
    }

    @Override
    public void domBuilderStarted(DOMBuilderEvent dOMBuilderEvent) {
    }

    public void printDiffTree(int n, BufferedWriter bufferedWriter) throws IOException {
        this.m_diff.getDiffTree(n).printNode(bufferedWriter);
    }

    public void setNoMoves() {
        this.m_moves = false;
    }

    private XMLDocument parseXML(InputSource inputSource) throws IOException, XMLParseException, SAXException {
        DOMParser dOMParser = this.getDOMParser();
        dOMParser.setPreserveWhitespace(false);
        dOMParser.parse(inputSource);
        return dOMParser.getDocument();
    }

    private DOMParser getDOMParser() {
        if (this.m_domparser == null) {
            this.m_domparser = new DOMParser();
        } else {
            this.m_domparser.reset();
        }
        return this.m_domparser;
    }
}

