/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.pipeline.processes;

import java.io.Closeable;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import oracle.xml.parser.v2.DOMParser;
import oracle.xml.pipeline.controller.Input;
import oracle.xml.pipeline.controller.Output;
import oracle.xml.pipeline.controller.PipelineException;
import oracle.xml.pipeline.controller.Process;
import oracle.xml.pipeline.controller.Util;
import org.w3c.dom.Node;

public class DOMParserProcess
extends Process {
    @Override
    public void initialize() {
        Input input = this.getInput("xmlsource");
        input.supportType(2);
        input.supportType(8);
        Output output = this.getOutput("dom");
        output.supportType(4);
        output.supportType(8);
    }

    @Override
    public void execute() throws PipelineException {
        Object object;
        Serializable serializable;
        Source source = this.getInputSource("xmlsource");
        String string = (String)this.getInParamValue("baseURL");
        String string2 = (String)this.getInParamValue("preserveWhitespace");
        String string3 = (String)this.getInParamValue("validationMode");
        int n = 0;
        Object object2 = this.getInParamValue("schemaObj");
        DOMParser dOMParser = new DOMParser();
        if (string != null && string.length() != 0) {
            try {
                serializable = Util.createURL(string);
                dOMParser.setBaseURL((URL)serializable);
            }
            catch (MalformedURLException malformedURLException) {
                this.error(30004, 17, malformedURLException);
            }
        }
        if (string2 != null) {
            serializable = Boolean.valueOf(string2);
            dOMParser.setPreserveWhitespace((Boolean)serializable);
        }
        if (string3 != null) {
            if (string3.compareTo("PARTIAL_VALIDATION") == 0) {
                n = 1;
            } else if (string3.compareTo("DTD_VALIDATION") == 0) {
                n = 2;
            } else if (string3.compareTo("SCHEMA_VALIDATION") == 0) {
                n = 3;
            }
        }
        dOMParser.setValidationMode(n);
        if (object2 != null) {
            dOMParser.setXMLSchema(object2);
        }
        serializable = null;
        if (source instanceof StreamSource) {
            object = (StreamSource)source;
            try {
                Closeable closeable = ((StreamSource)object).getInputStream();
                if (closeable != null) {
                    dOMParser.parse((InputStream)closeable);
                } else {
                    closeable = ((StreamSource)object).getReader();
                    if (closeable != null) {
                        dOMParser.parse((Reader)closeable);
                    } else {
                        this.error(30005, 17, new String[]{"xmlsource"});
                    }
                }
                serializable = dOMParser.getDocument();
            }
            catch (Exception exception) {
                if (!this.ignoreError("dom")) {
                    this.error(30001, 17, exception);
                }
                try {
                    this.info(30000, new String[]{"DOMParserProcess", exception.getMessage()});
                    serializable = this.getErrorDocument("dom", true);
                }
                catch (Exception exception2) {
                    this.error(30006, 17, exception2);
                }
            }
        } else {
            this.error(30002, 17, new String[]{"StreamSource"});
        }
        object = new DOMResult((Node)((Object)serializable));
        this.setOutputResult("dom", (Result)object);
        try {
            this.convertFromDOM((DOMResult)object, this.getOutput("dom"));
        }
        catch (Exception exception) {
            this.error(30007, 17, exception);
        }
    }
}

