/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.transx;

import java.util.Enumeration;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.i18n.util.LocaleMapper;

public class LangTag {
    int form;
    public static final int NONE = 0;
    public static final int STANDARD = 1;
    public static final int UPPERCASE = 2;
    public static final int LOWERCASE = 3;

    private LangTag(int n) {
        this.form = n;
    }

    static LangTag getInstance(int n) {
        return new LangTag(n);
    }

    String getLangId(String string, String string2) {
        String string3 = null;
        String string4 = string2 = string2 == null ? new String() : string2;
        if (string != null && !string.startsWith("%")) {
            if (this.form == 0) {
                return string;
            }
            return this.normalize(string);
        }
        if ("%x".equals(string)) {
            string3 = this.normalize(string2);
        } else if (string.startsWith("%l")) {
            string3 = this.getLanguage(string2).toLowerCase();
        } else if (string.startsWith("%L")) {
            string3 = this.getLanguage(string2).toUpperCase();
        } else if (string.startsWith("%c")) {
            string3 = this.getCountry(string2).toLowerCase();
        } else if (string.startsWith("%C")) {
            string3 = this.getCountry(string2).toUpperCase();
        } else if ("%j".equals(string)) {
            string3 = this.getJavaLocale(string2).toString();
        } else if ("%S".equals(string)) {
            string3 = this.getScript(string2);
        } else if ("%o".equals(string)) {
            string3 = this.getOraLanguage(string2);
            string3 = string3 == null ? null : string3.toLowerCase();
        } else if ("%O".equals(string)) {
            string3 = this.getOraLanguage(string2);
            String string5 = string3 = string3 == null ? null : string3.toUpperCase();
        }
        if (string.toLowerCase().startsWith("%c") && string3.length() <= 0) {
            string3 = null;
            if (string.length() > 2) {
                if (string.charAt(2) == 's') {
                    string3 = " ";
                } else if (string.charAt(2) == 'e') {
                    string3 = "";
                }
            }
        }
        if (string.length() > 2 && string.startsWith("%l")) {
            if (string.charAt(2) == 'j') {
                string3 = this.getJavaLocale(string2).getLanguage().toLowerCase();
            }
        } else if (string.length() > 2 && string.startsWith("%L") && string.charAt(2) == 'j') {
            string3 = this.getJavaLocale(string2).getLanguage().toUpperCase();
        }
        if (string3 == null) {
            return string;
        }
        return string3;
    }

    String getOraLanguage(String string) {
        String string2 = LocaleMapper.getOraLanguage(this.getJavaLocale(string));
        String string3 = null;
        if (string2 != null) {
            string3 = LocaleMapper.getOraShortNameFromLanguage(string2);
        }
        return string3;
    }

    String getLanguage(String string) {
        String[] stringArray = string.split("-|_");
        return stringArray[0];
    }

    String getCountry(String string) {
        String[] stringArray = string.split("-|_");
        if (stringArray.length >= 2 && (stringArray[1].length() == 2 || stringArray[1].length() == 3)) {
            return stringArray[1];
        }
        if (stringArray.length >= 3 && (stringArray[2].length() == 2 || stringArray[2].length() == 3)) {
            return stringArray[2];
        }
        return new String();
    }

    String getVariant(String string) {
        String[] stringArray = string.split("-|_");
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this.isVariant(stringArray[i])) continue;
            if (stringBuffer.toString().length() > 0) {
                stringBuffer.append("_");
            }
            stringBuffer.append(stringArray[i]);
        }
        return stringBuffer.toString();
    }

    boolean isVariant(String string) {
        return string.length() >= 5 || string.length() >= 4 && Character.isDigit(string.charAt(0));
    }

    String getScript(String string) {
        String[] stringArray = string.split("-|_");
        if (stringArray.length >= 2 && stringArray[1].length() == 4 && !this.isVariant(stringArray[1])) {
            return this.toTitleCase(stringArray[1]);
        }
        return new String();
    }

    Locale getJavaLocale(String string) {
        return new Locale(this.getLanguage(string), this.getCountry(string), this.getVariant(string));
    }

    String normalize(String string) {
        switch (this.form) {
            case 1: {
                return this.toStandardForm(string);
            }
            case 2: {
                return this.toUpperCase(string);
            }
            case 3: {
                return this.toLowerCase(string);
            }
        }
        return string;
    }

    String toUpperCase(String string) {
        return string.toUpperCase(Locale.US);
    }

    String toLowerCase(String string) {
        return string.toLowerCase(Locale.US);
    }

    String toStandardForm(String string) {
        CharSequence charSequence;
        StringTokenizer stringTokenizer = new StringTokenizer(string, "-_ \t\n\r\f", true);
        Vector<String> vector = new Vector<String>();
        while (stringTokenizer.hasMoreTokens()) {
            vector.add(stringTokenizer.nextToken().toLowerCase(Locale.US));
        }
        if (vector.size() >= 3) {
            charSequence = (String)vector.elementAt(2);
            if (((String)charSequence).length() == 2) {
                vector.set(2, ((String)charSequence).toUpperCase(Locale.US));
            } else if (((String)charSequence).length() == 4) {
                vector.set(2, this.toTitleCase((String)charSequence));
            }
        }
        charSequence = new StringBuffer();
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ((StringBuffer)charSequence).append((String)enumeration.nextElement());
        }
        return ((StringBuffer)charSequence).toString();
    }

    private String toTitleCase(String string) {
        if (string == null || string.length() <= 0) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        char c = stringBuffer.charAt(0);
        stringBuffer.setCharAt(0, Character.toTitleCase(c));
        return stringBuffer.toString();
    }

    public static String testLangTag(String string, String string2) {
        LangTag langTag = new LangTag(1);
        return langTag.getLangId(string, string2);
    }
}

