/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xslt;

import java.util.HashMap;
import java.util.Stack;
import oracle.xml.jaxp.JXTransformerHandler;
import oracle.xml.parser.v2.SAXAttrList;
import oracle.xml.parser.v2.XMLContentHandler;
import oracle.xml.parser.v2.XMLError;
import oracle.xml.parser.v2.XMLParser;
import oracle.xml.util.FastVector;
import oracle.xml.util.QxName;
import oracle.xml.util.XMLUtil;
import oracle.xml.xslt.XSLConstants;
import oracle.xml.xslt.XSLDocumentBuilder;
import oracle.xml.xslt.XSLException;
import oracle.xml.xslt.XSLSAXPrintDriver;
import oracle.xml.xslt.XSLTContext;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.ext.LexicalHandler;

public class XSLEventHandler
implements XSLConstants {
    ContentHandler xmlHandler;
    LexicalHandler lexHandler;
    XMLContentHandler extraHandler;
    Boolean flushExtra = false;
    XSLTContext context;
    XMLError err;
    SAXAttrList attrList;
    String strData;
    char[] charData;
    int size;
    int charlen;
    int currentAttrIndex;
    int currentDataType;
    int currentState;
    int previousState;
    FastVector prefixVect;
    FastVector namespaceVect;
    FastVector oldNSVect;
    HashMap<String, String> nsMap;
    int[] nspStack;
    int nspIndex = 0;
    Stack qNameStack;
    HashMap<String, String> nsConflicts;
    int ds = 0;
    int ed = 0;
    static final int NONE = 0;
    static final int CHAR_DATA = 1;
    static final int STR_DATA = 2;
    static final int DOCUMENT = 0;
    static final int ELEMENT = 1;
    static final int START_ELEMENT = 2;
    static final int ATTRIBUTE = 3;
    static final int PI = 4;
    static final int COMMENT = 5;
    static final int MESSAGE = 6;
    static final int NAMESPACE = 7;
    static final int TEXT = 8;

    public XSLEventHandler() {
        this.init();
    }

    public XSLEventHandler(ContentHandler contentHandler, LexicalHandler lexicalHandler, XSLTContext xSLTContext) throws XSLException {
        this.xmlHandler = contentHandler;
        this.lexHandler = lexicalHandler;
        this.context = xSLTContext;
        this.extraHandler = xSLTContext.getOSBDebugContentHandler();
        this.err = xSLTContext.getError();
        try {
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).init();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        this.init();
    }

    void init() {
        this.prefixVect = new FastVector(16);
        this.namespaceVect = new FastVector(16);
        this.oldNSVect = new FastVector(16);
        this.nsMap = new HashMap(64);
        this.nspStack = new int[16];
        this.nspIndex = 0;
        this.nsConflicts = new HashMap(8);
        this.currentDataType = 0;
        this.currentState = 1;
        this.attrList = new SAXAttrList(4);
        this.size = 1024;
        this.charData = new char[1024];
        this.charlen = 0;
        this.qNameStack = new Stack();
        boolean bl = false;
        boolean bl2 = false;
    }

    public void set2ndHandler() {
        this.extraHandler = this.context.getOSBDebugContentHandler();
        if (this.extraHandler == null) {
            return;
        }
        if (this.extraHandler instanceof XSLSAXPrintDriver) {
            this.flushExtra = true;
        }
        try {
            if (this.flushExtra.booleanValue() && this.xmlHandler != null && this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.extraHandler).setXSLOutput(((XSLSAXPrintDriver)this.xmlHandler).getXSLOutput());
                ((XSLSAXPrintDriver)this.extraHandler).init();
            }
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
    }

    public void reset(ContentHandler contentHandler, LexicalHandler lexicalHandler, XSLTContext xSLTContext) throws XSLException {
        this.xmlHandler = contentHandler;
        this.lexHandler = lexicalHandler;
        this.context = xSLTContext;
        this.err = xSLTContext.getError();
        try {
            if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                ((XSLSAXPrintDriver)this.xmlHandler).init();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        this.prefixVect.setSize(0);
        this.namespaceVect.setSize(0);
        this.oldNSVect.setSize(0);
        this.currentDataType = 0;
        this.currentState = 1;
        this.attrList.reset();
        this.charlen = 0;
        this.nspStack = new int[16];
        this.nspIndex = 0;
        this.nsMap.clear();
        this.qNameStack.clear();
        this.nsConflicts.clear();
        this.size = 1024;
        this.charData = new char[1024];
        boolean bl = false;
        boolean bl2 = false;
    }

    String getData() {
        String string = "";
        string = this.currentDataType == 2 ? this.strData : new String(this.charData, 0, this.charlen);
        this.currentDataType = 0;
        this.charlen = 0;
        return string;
    }

    void flushEvents() throws XSLException {
    }

    Stack getQNameStack() {
        return this.qNameStack;
    }

    void flushExtraOut() {
        try {
            if (this.flushExtra.booleanValue()) {
                ((XSLSAXPrintDriver)this.extraHandler).flushDebugStream();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void reportStartElement() throws XSLException {
        try {
            QxName qxName = (QxName)this.qNameStack.peek();
            String string = qxName.getQName();
            if (!this.nsConflicts.isEmpty()) {
                String string2;
                String string3 = qxName.getPrefix();
                String string4 = this.nsConflicts.get(string3);
                if (string4 != null && !string4.equals(qxName.getNamespaceURI()) && (string2 = qxName.getNamespaceURI()) != null && string2.length() > 0) {
                    string3 = this.context.getNewNamespacePrefix();
                    string = string3 + ":" + qxName.getLocalPart();
                    qxName = new QxName(string2, qxName.getLocalPart(), string3, string);
                    this.qNameStack.pop();
                    this.qNameStack.push(qxName);
                    this.namespaceAttr(string3, string2);
                }
                int n = this.attrList.getLength();
                for (int i = 0; i < n; ++i) {
                    string3 = this.attrList.getPrefix(i);
                    if (string3 == null || string3 == "" || string3.equals("xmlns")) continue;
                    string4 = this.nsConflicts.get(string3);
                    String string5 = this.attrList.getNamespace(i);
                    if (string4 == null || string4.equals(string5)) continue;
                    String string6 = this.getNamespacePrefix(string5);
                    string3 = string6 != null && string6.equals(string3) ? this.context.getNewNamespacePrefix() : string6;
                    this.namespaceAttr(string3, this.attrList.getNamespace(i));
                    this.attrList.setPrefix(i, string3);
                }
            }
            this.xmlHandler.startElement(qxName.getNamespaceURI(), qxName.getLocalPart(), string, this.attrList);
            this.nsConflicts.clear();
            if (this.extraHandler != null) {
                this.extraHandler.startElement(qxName.getNamespaceURI(), qxName.getLocalPart(), string, this.attrList);
                this.flushExtraOut();
            }
            this.attrList.reset();
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    String getNamespacePrefix(String string) {
        int n = this.prefixVect.size();
        for (int i = n - 1; i >= 0; --i) {
            if (!string.equals(this.namespaceVect.elementAt(i))) continue;
            return (String)this.prefixVect.elementAt(i);
        }
        return null;
    }

    void namespaceAttr(String string, String string2) throws XSLException {
        int n = this.prefixVect.size();
        String string3 = this.nsMap.get(string);
        if (string2.equals(string3)) {
            return;
        }
        boolean bl = false;
        for (int i = n - 1; i >= 0; --i) {
            String string4 = this.prefixVect.elementAt(i).toString();
            if (!string4.equals(string)) continue;
            bl = true;
            String string5 = this.namespaceVect.elementAt(i).toString();
            if (string5.equals(string2)) {
                return;
            }
            this.nsConflicts.put(string, string2);
            break;
        }
        this.prefixVect.addElement(string);
        this.context.addPrefix(string);
        this.namespaceVect.addElement(string2);
        this.oldNSVect.addElement(string3);
        this.nsMap.put(string, string2);
        if (string.length() == 0) {
            if (string3 != null || string2.length() > 0) {
                this.attribute(string, "xmlns", "http://www.w3.org/2000/xmlns/", string2);
            }
        } else {
            this.attribute("xmlns", string, "http://www.w3.org/2000/xmlns/", string2);
        }
        try {
            this.xmlHandler.startPrefixMapping(string, string2);
            if (this.extraHandler != null) {
                this.extraHandler.startPrefixMapping(string, string2);
                this.flushExtraOut();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void resetCurrentState() {
        this.currentState = 1;
    }

    void startDocument() throws XSLException {
        try {
            if (XMLUtil.reportDocEvents(this.xmlHandler, XMLParser.getReportedCHClasses()) && !(this.xmlHandler instanceof JXTransformerHandler)) {
                this.xmlHandler.startDocument();
                if (this.extraHandler != null) {
                    this.extraHandler.startDocument();
                    this.flushExtraOut();
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void startXSLDocumentInst() throws XSLException {
        if (this.ds != 0) {
            this.err.error2(1047, 1, this.stateToString(this.currentState), this.stateToString(0));
        }
        this.ds = 1;
    }

    void endDocument() throws XSLException {
        try {
            if (XMLUtil.reportDocEvents(this.xmlHandler, XMLParser.getReportedCHClasses()) && !(this.xmlHandler instanceof JXTransformerHandler)) {
                this.xmlHandler.endDocument();
                if (this.extraHandler != null) {
                    this.extraHandler.endDocument();
                    this.flushExtraOut();
                }
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void endXSLDocumentInst() throws XSLException {
        if (this.ds != 2) {
            this.err.error2(1047, 1, this.stateToString(this.currentState), this.stateToString(0));
        }
        this.ds = 0;
    }

    void startElement(QxName qxName) throws XSLException {
        if (this.ds == 1) {
            ++this.ed;
        } else if (this.ds == 2) {
            this.err.error2(1047, 1, this.stateToString(1), this.stateToString(0));
        }
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(1), this.stateToString(this.currentState));
            }
        }
        this.qNameStack.push(qxName);
        if (this.nspIndex == this.nspStack.length) {
            this.growNamespaceStack();
        }
        this.nspStack[this.nspIndex++] = this.prefixVect.size();
        this.currentState = 2;
    }

    void endElement() throws XSLException {
        if (this.ds == 1) {
            --this.ed;
            if (this.ed == 0) {
                this.ds = 2;
            }
        }
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error0(1900, 1);
            }
        }
        if (this.nspIndex == 0) {
            return;
        }
        int n = this.nspStack[this.nspIndex - 1];
        int n2 = this.prefixVect.size();
        try {
            for (int i = n; i < n2; ++i) {
                String string = (String)this.prefixVect.elementAt(i);
                this.xmlHandler.endPrefixMapping(string);
                String string2 = (String)this.oldNSVect.elementAt(i);
                if (string2 != null) {
                    this.nsMap.put(string, string2);
                } else {
                    this.nsMap.remove(string);
                }
                if (this.extraHandler == null) continue;
                this.extraHandler.endPrefixMapping((String)this.prefixVect.elementAt(i));
                this.flushExtraOut();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
        --this.nspIndex;
        this.prefixVect.setSize(this.nspStack[this.nspIndex]);
        this.namespaceVect.setSize(this.nspStack[this.nspIndex]);
        this.oldNSVect.setSize(this.nspStack[this.nspIndex]);
        this.currentState = 1;
        try {
            QxName qxName = (QxName)this.qNameStack.pop();
            this.xmlHandler.endElement(qxName.getNamespaceURI(), qxName.getLocalPart(), qxName.getQName());
            if (this.extraHandler != null) {
                this.extraHandler.endElement(qxName.getNamespaceURI(), qxName.getLocalPart(), qxName.getQName());
                this.flushExtraOut();
            }
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    void startAttribute(String string, String string2, String string3) throws XSLException {
        if ((this.ds == 1 || this.ds == 2) && this.ed == 0) {
            this.err.error2(1047, 1, this.stateToString(3), this.stateToString(0));
        }
        if (this.currentState != 2) {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(3), this.stateToString(this.currentState));
            }
        } else if (string != "" && !string.equals("xml") && !string.equals("xmlns")) {
            this.namespaceAttr(string, string3);
        }
        this.currentState = 3;
        this.currentAttrIndex = -1;
        this.currentAttrIndex = this.attrList.getIndex(string3, string2);
        if (this.currentAttrIndex == -1) {
            String string4 = string.equals("") ? string2 : string + ":" + string2;
            this.attrList.addAttr(string, string2, string4, "", true, 0, string3);
            this.currentAttrIndex = this.attrList.getLength() - 1;
        }
    }

    void attribute(String string, String string2, String string3, String string4) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startAttribute(string, string2, string3);
        this.strData = string4;
        this.currentDataType = 2;
        this.endAttribute(string, string2, string3);
    }

    void endAttribute(String string, String string2, String string3) throws XSLException {
        if (this.currentState != 3) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 2;
        this.attrList.setValue(this.currentAttrIndex, this.getData());
        this.currentDataType = 0;
    }

    void startProcessingInstruction(String string) throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(4), this.stateToString(this.currentState));
            }
        }
        this.currentState = 4;
    }

    void processingInstruction(String string, String string2, int n) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startProcessingInstruction(string);
        this.strData = string2;
        this.currentDataType = 2;
        this.endProcessingInstruction(string, n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void endProcessingInstruction(String string, int n) throws XSLException {
        if (this.currentState != 4) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 1;
        String string2 = this.getData();
        if (string2.indexOf("?>") == -1) {
            try {
                this.xmlHandler.processingInstruction(string, string2);
                if (this.extraHandler == null) return;
                this.extraHandler.processingInstruction(string, string2);
                this.flushExtraOut();
                return;
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
        }
        if (n == 10) {
            this.err.error1(1011, 1, string2);
            return;
        }
        string2 = this.convertIllegalPIChars(string2);
        try {
            this.xmlHandler.processingInstruction(string, string2);
            if (this.extraHandler == null) return;
            this.extraHandler.processingInstruction(string, string2);
            this.flushExtraOut();
            return;
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    private String convertIllegalPIChars(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[(int)((double)cArray.length * 1.5)];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '?') {
                cArray2[n++] = cArray[i];
                continue;
            }
            if (i != cArray.length - 1 && cArray[i + 1] == '>') {
                cArray2[n++] = cArray[i];
                cArray2[n++] = 32;
                continue;
            }
            cArray2[n++] = cArray[i];
        }
        String string2 = new String(cArray2, 0, n);
        return string2;
    }

    void startNamespace() throws XSLException {
        if (this.currentState != 2) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error2(1047, 1, this.stateToString(3), this.stateToString(this.currentState));
        }
        this.currentState = 7;
    }

    void endNamespace(String string) throws XSLException {
        if (this.currentState != 7) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 2;
        String string2 = this.getData();
        if (string.length() > 0 && string2.length() > 0 && XMLUtil.isFirstNameChar(string.toCharArray()[0])) {
            this.namespaceAttr(string, string2);
        }
    }

    void startComment() throws XSLException {
        if (this.currentState == 2) {
            this.reportStartElement();
        } else {
            if (this.currentState == 6) {
                return;
            }
            if (this.currentState != 1) {
                this.err.error2(1047, 1, this.stateToString(5), this.stateToString(this.currentState));
            }
        }
        this.currentState = 5;
    }

    void comment(String string, int n) throws XSLException {
        if (this.currentState == 6) {
            return;
        }
        this.startComment();
        this.strData = string;
        this.currentDataType = 2;
        this.endComment(n);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void endComment(int n) throws XSLException {
        if (this.currentState != 5) {
            if (this.currentState == 6) {
                return;
            }
            this.err.error0(1900, 1);
        }
        this.currentState = 1;
        String string = this.getData();
        if (string.indexOf("--") == -1 && !string.endsWith("-")) {
            int n2 = string.length();
            if (n2 == 0) {
                return;
            }
            if (n2 > this.charData.length) {
                this.charData = new char[n2];
            }
            string.getChars(0, n2, this.charData, 0);
            try {
                this.lexHandler.comment(this.charData, 0, n2);
                if (this.extraHandler == null) return;
                this.extraHandler.comment(this.charData, 0, n2);
                this.flushExtraOut();
                return;
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
        }
        if (n == 10) {
            this.err.error1(1012, 1, string);
            return;
        }
        this.charData = this.convertCommentString(string);
        try {
            this.lexHandler.comment(this.charData, 0, this.charData.length);
            if (this.extraHandler == null) return;
            this.extraHandler.comment(this.charData, 0, this.charData.length);
            this.flushExtraOut();
            return;
        }
        catch (SAXException sAXException) {
            throw new XSLException(sAXException.getMessage());
        }
    }

    private char[] convertCommentString(String string) {
        char[] cArray = string.toCharArray();
        char[] cArray2 = new char[cArray.length * 2];
        int n = 0;
        for (int i = 0; i < cArray.length; ++i) {
            if (cArray[i] != '-') {
                cArray2[n++] = cArray[i];
                continue;
            }
            if (i != cArray.length - 1 && cArray[i + 1] == '-') {
                cArray2[n++] = cArray[i];
                cArray2[n++] = 32;
                continue;
            }
            if (i == cArray.length - 1) {
                cArray2[n++] = cArray[i];
                cArray2[n++] = 32;
                continue;
            }
            cArray2[n++] = cArray[i];
        }
        String string2 = new String(cArray2, 0, n);
        return string2.toCharArray();
    }

    void startMessage() throws XSLException {
        this.previousState = this.currentState;
        this.currentState = 6;
    }

    void message(String string) throws XSLException {
        this.startMessage();
        this.strData = string;
        this.currentDataType = 2;
        this.endMessage();
    }

    void endMessage() throws XSLException {
        if (this.currentState != 6 && this.currentState != 1) {
            this.err.error0(1900, 1);
        }
        this.currentState = this.previousState;
        String string = this.getData();
        StringBuffer stringBuffer = new StringBuffer();
        Locator locator = this.err.getLocator();
        String string2 = locator.getSystemId();
        int n = locator.getLineNumber();
        int n2 = locator.getColumnNumber();
        if (string2 != null) {
            stringBuffer.append(string2);
        }
        if (n != 0 && n2 != 0 && n != -1 && n2 != -1) {
            stringBuffer.append("<Line " + n + ", Column " + n2 + ">");
            stringBuffer.append(": ");
            System.out.println(stringBuffer.toString());
        } else if (string2 != null) {
            stringBuffer.append(": ");
            System.out.println(stringBuffer.toString());
        }
        System.out.println("Message: " + string);
    }

    void characters(String string, boolean bl) throws XSLException {
        if ((this.ds == 1 || this.ds == 2) && this.ed == 0) {
            this.err.error2(1047, 1, this.stateToString(8), this.stateToString(0));
        }
        if (this.currentState == 2) {
            this.reportStartElement();
            this.currentState = 1;
        }
        if (this.currentState == 1) {
            if (string == null) {
                return;
            }
            int n = string.length();
            if (n == 0) {
                return;
            }
            if (n > this.charData.length) {
                this.charData = new char[n];
            }
            string.getChars(0, n, this.charData, 0);
            try {
                if (bl) {
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(true);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(true);
                    }
                    if (this.extraHandler != null) {
                        if (this.extraHandler instanceof XSLSAXPrintDriver) {
                            ((XSLSAXPrintDriver)this.extraHandler).setDisableOutEsc(true);
                        }
                        this.extraHandler.characters(this.charData, 0, n);
                        this.flushExtraOut();
                    }
                    this.xmlHandler.characters(this.charData, 0, n);
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(false);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(false);
                    }
                    if (this.extraHandler != null && this.extraHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.extraHandler).setDisableOutEsc(false);
                    }
                } else {
                    this.xmlHandler.characters(this.charData, 0, n);
                    if (this.extraHandler != null) {
                        this.extraHandler.characters(this.charData, 0, n);
                        this.flushExtraOut();
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
            return;
        }
        switch (this.currentDataType) {
            case 0: {
                this.strData = string;
                this.currentDataType = 2;
                break;
            }
            case 2: {
                int n = this.strData.length();
                if (this.size < n) {
                    this.size *= 2;
                    this.size = n > this.size ? n : this.size;
                    this.charData = new char[this.size];
                }
                this.strData.getChars(0, n, this.charData, 0);
                this.charlen = n;
            }
            case 1: {
                this.currentDataType = 1;
                int n = string.length();
                int n2 = this.charlen + n;
                if (this.size < n2) {
                    this.size *= 2;
                    this.size = n2 > this.size ? n2 : this.size;
                    char[] cArray = new char[this.size];
                    System.arraycopy(this.charData, 0, cArray, 0, this.charlen);
                    this.charData = cArray;
                }
                string.getChars(0, n, this.charData, this.charlen);
                this.charlen += n;
            }
        }
    }

    void characters(char[] cArray, int n, int n2, boolean bl) throws XSLException {
        if ((this.ds == 1 || this.ds == 2) && this.ed == 0) {
            this.err.error2(1047, 1, this.stateToString(8), this.stateToString(0));
        }
        if (this.currentState == 2) {
            this.reportStartElement();
            this.currentState = 1;
        }
        if (this.currentState == 1) {
            try {
                if (bl) {
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(true);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(true);
                    }
                    if (this.extraHandler != null) {
                        if (this.extraHandler instanceof XSLSAXPrintDriver) {
                            ((XSLSAXPrintDriver)this.extraHandler).setDisableOutEsc(true);
                        }
                        this.extraHandler.characters(cArray, n, n2);
                        this.flushExtraOut();
                    }
                    this.xmlHandler.characters(cArray, n, n2);
                    if (this.xmlHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.xmlHandler).setDisableOutEsc(false);
                    } else if (this.xmlHandler instanceof XSLDocumentBuilder) {
                        ((XSLDocumentBuilder)this.xmlHandler).setDisableOutEsc(false);
                    }
                    if (this.extraHandler != null && this.extraHandler instanceof XSLSAXPrintDriver) {
                        ((XSLSAXPrintDriver)this.extraHandler).setDisableOutEsc(false);
                    }
                } else {
                    this.xmlHandler.characters(cArray, n, n2);
                    if (this.extraHandler != null) {
                        this.extraHandler.characters(cArray, n, n2);
                        this.flushExtraOut();
                    }
                }
            }
            catch (SAXException sAXException) {
                throw new XSLException(sAXException.getMessage());
            }
            return;
        }
        switch (this.currentDataType) {
            case 0: {
                this.currentDataType = 1;
                if (this.size < n2) {
                    this.size *= 2;
                    this.size = n2 > this.size ? n2 : this.size;
                    this.charData = new char[this.size];
                }
                System.arraycopy(cArray, n, this.charData, 0, n2);
                this.charlen = n2;
                break;
            }
            case 2: {
                int n3 = this.strData.length();
                if (this.size < n3) {
                    this.size *= 2;
                    this.size = n3 > this.size ? n3 : this.size;
                    this.charData = new char[this.size];
                }
                this.strData.getChars(0, n3, this.charData, 0);
                this.charlen = n3;
            }
            case 1: {
                this.currentDataType = 1;
                int n4 = this.charlen + n2;
                if (this.size < n4) {
                    this.size *= 2;
                    this.size = n4 > this.size ? n4 : this.size;
                    char[] cArray2 = new char[this.size];
                    System.arraycopy(this.charData, 0, cArray2, 0, this.charlen);
                    this.charData = cArray2;
                }
                System.arraycopy(cArray, n, this.charData, this.charlen, n2);
                this.charlen += n2;
            }
        }
    }

    void growNamespaceStack() {
        int n = this.nspStack.length;
        int[] nArray = new int[n * 2];
        System.arraycopy(this.nspStack, 0, nArray, 0, n);
        this.nspStack = nArray;
    }

    String stateToString(int n) {
        switch (n) {
            case 0: {
                return "Document";
            }
            case 1: {
                return "Element";
            }
            case 2: {
                return "Start element";
            }
            case 3: {
                return "Attribute";
            }
            case 4: {
                return "PI";
            }
            case 5: {
                return "Comment";
            }
            case 6: {
                return "Message";
            }
            case 8: {
                return "Text";
            }
        }
        return "";
    }
}

