/*
 * Decompiled with CFR 0.152.
 */
package oracle.xml.xsql;

import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.xml.parser.v2.NSResolver;
import oracle.xml.parser.v2.XMLDocument;
import oracle.xml.parser.v2.XMLElement;
import oracle.xml.parser.v2.XMLNode;
import oracle.xml.parser.v2.XSLException;
import oracle.xml.xsql.XSQLConfigManager;
import oracle.xml.xsql.XSQLDocumentSerializer;
import oracle.xml.xsql.XSQLErrorHandler;
import oracle.xml.xsql.XSQLPageRequest;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class XSQLUtil {
    private static final String ARRAY_BRACKETS = "[]";
    private static final String URL_PROTOCOL_SEPARATOR = ":/";
    public static final String JARPREF = "jar:";
    public static final String ZIPPREF = "zip:";
    public static final String FILEURLPREF = "file:/";
    public static final String NULL = "(null)";
    public static final String JAVASCHEME = "java:";
    private static final String QUOTE = "'";
    private static final String COMMA = ",";
    private static Boolean loadedDefaultCharset = Boolean.FALSE;
    private static String defaultCharSet = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String defaultCharset() {
        if (loadedDefaultCharset.equals(Boolean.FALSE)) {
            XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
            String string = xSQLConfigManager.getBaseCharsetForConversion();
            Boolean bl = loadedDefaultCharset;
            synchronized (bl) {
                loadedDefaultCharset = Boolean.TRUE;
                defaultCharSet = string;
            }
        }
        return defaultCharSet;
    }

    public static NodeList select(Document document, String string) {
        return XSQLUtil.select((XMLDocument)document, string);
    }

    public static NodeList select(XMLDocument xMLDocument, String string) {
        try {
            return xMLDocument.selectNodes(string, (NSResolver)((Object)xMLDocument.getDocumentElement()));
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    public static NodeList select(Element element, String string) {
        return XSQLUtil.select((XMLElement)element, string);
    }

    public static NodeList select(XMLElement xMLElement, String string) {
        try {
            return xMLElement.selectNodes(string, xMLElement);
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    public static Node selectFirst(Document document, String string) {
        return XSQLUtil.selectFirst((XMLDocument)document, string);
    }

    public static Node selectFirst(XMLDocument xMLDocument, String string) {
        try {
            NodeList nodeList = xMLDocument.selectNodes(string, (NSResolver)((Object)xMLDocument.getDocumentElement()));
            return nodeList.getLength() > 0 ? nodeList.item(0) : null;
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    public static Node selectFirst(Element element, String string) {
        return XSQLUtil.selectFirst((XMLElement)element, string);
    }

    public static Node selectFirst(XMLElement xMLElement, String string) {
        try {
            NodeList nodeList = xMLElement.selectNodes(string, xMLElement);
            return nodeList.getLength() > 0 ? nodeList.item(0) : null;
        }
        catch (XSLException xSLException) {
            return null;
        }
    }

    public static String valueOf(Element element, String string) {
        return XSQLUtil.valueOf((XMLNode)((Object)element), string);
    }

    public static String valueOf(Node node, String string) {
        return XSQLUtil.valueOf((XMLNode)node, string);
    }

    public static String valueOf(XMLElement xMLElement, String string) {
        return XSQLUtil.valueOf((XMLNode)xMLElement, string);
    }

    public static String valueOf(XMLNode xMLNode, String string) {
        try {
            NSResolver nSResolver = null;
            if (xMLNode instanceof XMLElement) {
                nSResolver = (NSResolver)((Object)xMLNode);
            }
            return xMLNode.valueOf(string, nSResolver);
        }
        catch (XSLException xSLException) {
            return "";
        }
    }

    private static String content(XMLElement xMLElement) {
        StringBuffer stringBuffer = new StringBuffer();
        NodeList nodeList = xMLElement.getChildNodes();
        if (nodeList != null && nodeList.getLength() > 0) {
            int n = nodeList.getLength();
            for (int i = 0; i < n; ++i) {
                XMLNode xMLNode = (XMLNode)nodeList.item(i);
                short s = xMLNode.getNodeType();
                if (s == 3) {
                    stringBuffer.append(xMLNode.getNodeValue());
                    continue;
                }
                if (s != 1) continue;
                stringBuffer.append(XSQLUtil.content((XMLElement)xMLNode));
            }
        }
        return stringBuffer.toString();
    }

    public static XMLDocument DictionaryOfParamsAsXMLDocument(Dictionary dictionary) {
        try {
            Enumeration enumeration = null;
            if (dictionary != null) {
                enumeration = dictionary.keys();
            }
            Vector<Object> vector = null;
            boolean bl = false;
            XMLDocument xMLDocument = new XMLDocument();
            Element element = xMLDocument.createElement("request");
            xMLDocument.appendChild(element);
            Element element2 = xMLDocument.createElement("parameters");
            element.appendChild(element2);
            String[] stringArray = null;
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    Object object;
                    int n;
                    String string = (String)enumeration.nextElement();
                    Object v = dictionary.get(string);
                    if (v instanceof String) {
                        stringArray = new String[]{(String)v};
                    } else if (v instanceof String[]) {
                        stringArray = (String[])v;
                    } else if (v instanceof Object[]) {
                        Object[] objectArray = (Object[])v;
                        n = objectArray.length;
                        stringArray = new String[n];
                        for (int i = 0; i < n; ++i) {
                            object = objectArray[i];
                            if (object == null) continue;
                            stringArray[i] = object.toString();
                        }
                    } else {
                        stringArray = new String[]{v.toString()};
                    }
                    int n2 = stringArray.length;
                    if (n2 > 1) {
                        if (vector == null) {
                            vector = new Vector<Object>(5);
                        }
                        for (n = 0; n < n2; ++n) {
                            String string2 = stringArray[n];
                            object = null;
                            if (vector.size() <= n) {
                                object = xMLDocument.createElement("row");
                                element2.appendChild((Node)object);
                                vector.addElement(object);
                            } else {
                                object = (Element)vector.elementAt(n);
                            }
                            Element element3 = xMLDocument.createElement(string);
                            object.appendChild(element3);
                            Text text = xMLDocument.createTextNode(string2);
                            element3.appendChild(text);
                        }
                        continue;
                    }
                    Element element4 = xMLDocument.createElement(string);
                    element2.appendChild(element4);
                    Text text = xMLDocument.createTextNode(stringArray[0]);
                    element4.appendChild(text);
                }
            }
            return xMLDocument;
        }
        catch (Exception exception) {
            XMLDocument xMLDocument = new XMLDocument();
            Element element = xMLDocument.createElement("request");
            String string = exception.getMessage();
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            string = string != null ? string + stringWriter.toString() : stringWriter.toString();
            Text text = xMLDocument.createTextNode(string != null ? string : "");
            element.appendChild(text);
            xMLDocument.appendChild(element);
            return xMLDocument;
        }
    }

    public static String XL(String string, String string2) {
        String string3 = XSQLUtil.defaultCharset();
        if (string3 == null) {
            return string;
        }
        try {
            return new String(string.getBytes(string3), string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return "-?-";
        }
    }

    public static String[] XLArr(String[] stringArray, String string) {
        int n = stringArray.length;
        String[] stringArray2 = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray2[i] = XSQLUtil.XL(stringArray[i], string);
        }
        return stringArray2;
    }

    public static String safeURLAsString(URL uRL) {
        String string = uRL.toExternalForm();
        if (string.startsWith(FILEURLPREF)) {
            return "file:///" + string.substring(6);
        }
        return string;
    }

    public static String translate(String string, String string2) {
        try {
            if (!string.startsWith(FILEURLPREF) && !string.startsWith("http:/")) {
                string = "file:///" + string;
            }
            return XSQLUtil.translate(new URL(string), string2);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String translate(URL uRL, String string) throws Exception {
        try {
            return XSQLUtil.safeURLAsString(new URL(uRL, string));
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String stringParamValue(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length > 0) {
                return stringArray[0];
            }
            return null;
        }
        return null;
    }

    public static String[] stringParamValues(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return new String[]{(String)object};
        }
        if (object instanceof String[]) {
            String[] stringArray = (String[])object;
            if (stringArray.length > 0) {
                return stringArray;
            }
            return null;
        }
        return null;
    }

    public static String resolveParams(String string, XSQLPageRequest xSQLPageRequest) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        int n = 0;
        int n2 = 0;
        while ((n = string.indexOf("{@")) >= 0 && (n2 = string.indexOf("}", n)) != 0) {
            string2 = string.substring(n + 2, n2);
            String string3 = xSQLPageRequest.getParameter(string2);
            string = string.substring(0, n) + (string3 != null ? string3 : "") + string.substring(n2 + 1);
        }
        return string;
    }

    public static String[] tokenizeIntoArray(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        string = string.replace(',', ' ');
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        Vector<String> vector = new Vector<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = (String)vector.elementAt(i);
        }
        return stringArray;
    }

    public static String[] tokenizeIntoArrayUsingCommasIfPresent(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        StringTokenizer stringTokenizer = null;
        stringTokenizer = string.indexOf(44) >= 0 ? new StringTokenizer(string, COMMA) : new StringTokenizer(string);
        Vector<String> vector = new Vector<String>(10);
        while (stringTokenizer.hasMoreTokens()) {
            vector.addElement(stringTokenizer.nextToken());
        }
        int n = vector.size();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            String string2 = (String)vector.elementAt(i);
            stringArray[i] = string2 != null ? string2.trim() : null;
        }
        return stringArray;
    }

    private static String quote(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 2);
        return stringBuffer.append(QUOTE).append(string).append(QUOTE).toString();
    }

    public static String commaSeparatedListOfValues(String[] stringArray, boolean bl) {
        if (stringArray == null) {
            return null;
        }
        int n = stringArray.length;
        if (n == 0) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        for (int i = 0; i < n; ++i) {
            String string = stringArray[i];
            if (string == null || string.equals("")) continue;
            if (bl2) {
                stringBuffer.append(COMMA);
            }
            bl2 = true;
            if (bl) {
                stringBuffer.append(QUOTE);
            }
            stringBuffer.append(stringArray[i]);
            if (!bl) continue;
            stringBuffer.append(QUOTE);
        }
        return stringBuffer.toString();
    }

    public static XSQLDocumentSerializer createSerializer(String string, XSQLPageRequest xSQLPageRequest) {
        Serializable serializable;
        String string2 = null;
        if (string == null) {
            xSQLPageRequest.signalError(25022, new String[]{string2 != null && !string2.equals("") ? string2 : NULL}, null);
            return null;
        }
        if (string.startsWith(JAVASCHEME)) {
            string2 = string.substring(5);
        } else {
            serializable = XSQLConfigManager.getManager().getUserDefinedSerializers();
            string2 = (String)((Hashtable)serializable).get(string);
            if (string2 == null) {
                xSQLPageRequest.signalError(25021, new String[]{string != null && !string.equals("") ? string : NULL}, null);
                return null;
            }
        }
        try {
            serializable = XSQLUtil.classForName(string2);
            return (XSQLDocumentSerializer)((Class)serializable).newInstance();
        }
        catch (ClassCastException classCastException) {
            xSQLPageRequest.signalError(25023, new String[]{string2 != null && !string2.equals("") ? string2 : NULL}, null);
            return null;
        }
        catch (Throwable throwable) {
            xSQLPageRequest.signalError(25022, new String[]{string2 != null && !string2.equals("") ? string2 : NULL}, null);
            return null;
        }
    }

    static XSQLErrorHandler createErrorHandler(String string, XSQLPageRequest xSQLPageRequest) {
        if (string == null) {
            xSQLPageRequest.signalError(25029, new String[]{string != null && !string.equals("") ? string : NULL}, null);
            return null;
        }
        try {
            Class clazz = XSQLUtil.classForName(string);
            return (XSQLErrorHandler)clazz.newInstance();
        }
        catch (ClassCastException classCastException) {
            xSQLPageRequest.signalError(25030, new String[]{string != null && !string.equals("") ? string : NULL}, null);
            return null;
        }
        catch (Throwable throwable) {
            xSQLPageRequest.signalError(25029, new String[]{string != null && !string.equals("") ? string : NULL}, null);
            return null;
        }
    }

    public static boolean isAbsoluteURL(String string) {
        return string != null && string.indexOf(URL_PROTOCOL_SEPARATOR) > 0;
    }

    public static boolean untrustedAbsoluteStylesheetURL(String string) {
        if (XSQLUtil.isAbsoluteURL(string)) {
            XSQLConfigManager xSQLConfigManager = XSQLConfigManager.getManager();
            try {
                URL uRL = new URL(string);
                return !xSQLConfigManager.isTrustedHost(uRL.getHost());
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return false;
    }

    public static String relativize(String string, String string2) {
        if (string != null) {
            boolean bl;
            if (string.indexOf(92) >= 0) {
                string = string.replace('\\', '/');
            }
            boolean bl2 = bl = string.charAt(0) == '/';
            if (bl && string.indexOf("../") < 0) {
                return string;
            }
            String string3 = null;
            if (bl) {
                string3 = "/";
            } else {
                if (string2 != null && string2.indexOf(92) >= 0) {
                    string2 = string2.replace('\\', '/');
                }
                string3 = XSQLUtil.baseUriOf(string2);
            }
            while (string != null && !string.equals("")) {
                if (string.startsWith("./")) {
                    string = string.substring(2);
                    continue;
                }
                if (string.startsWith("../")) {
                    string3 = XSQLUtil.dotdot(string3);
                    string = string.substring(3);
                    continue;
                }
                int n = string.indexOf("../");
                if (n <= 0) break;
                String string4 = string.substring(0, n);
                int n2 = string4.charAt(0) == '/' ? 1 : 0;
                string3 = string3 + string4.substring(n2);
                string = string.substring(n);
            }
            return string3 + string;
        }
        return null;
    }

    private static String dotdot(String string) {
        if (string != null) {
            if (string.equals("/")) {
                return string;
            }
            int n = string.length();
            int n2 = string.lastIndexOf(47);
            if (n2 == n - 1) {
                return XSQLUtil.dotdot(string.substring(0, n2));
            }
            return string.substring(0, n2 + 1);
        }
        return null;
    }

    public static String baseUriOf(String string) {
        if (string != null) {
            int n = string.lastIndexOf(47);
            if (n >= 0) {
                return string.substring(0, n + 1);
            }
            return string;
        }
        return null;
    }

    public static Class classForName(String string) throws ClassNotFoundException {
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader != null) {
                return classLoader.loadClass(string);
            }
        }
        catch (NoSuchMethodError noSuchMethodError) {
            // empty catch block
        }
        return Class.forName(string);
    }

    public static XSQLErrorHandler getErrorHandler() {
        return XSQLConfigManager.getManager().getErrorHandler();
    }

    public static XSQLErrorHandler getDefaultErrorHandler() {
        return XSQLConfigManager.getManager().getDefaultErrorHandler();
    }

    public static boolean isArrayParamName(String string) {
        return string != null ? string.endsWith(ARRAY_BRACKETS) : false;
    }

    public static String arrayParamName(String string) {
        return XSQLUtil.isArrayParamName(string) ? string.substring(0, string.length() - 2) : string;
    }

    public static long timestampOf(String string) {
        File file = null;
        try {
            int n;
            if ((string.startsWith(ZIPPREF) || string.startsWith(JARPREF)) && (n = string.indexOf(33)) >= 0) {
                string = string.substring(4, n);
            }
            if (string.startsWith(FILEURLPREF)) {
                try {
                    URL uRL = new URL(string);
                    string = uRL.getFile();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if ((n = string.indexOf(33)) >= 0) {
                string = string.substring(0, n);
            }
            file = new File(string);
        }
        catch (Exception exception) {
            return 0L;
        }
        return file.lastModified();
    }

    public static String quoteLessThanSigns(String string) {
        if (string == null) {
            return null;
        }
        int n = 0;
        boolean bl = false;
        while ((n = string.indexOf("<")) >= 0) {
            string = string.substring(0, n) + "&lt;" + string.substring(n + 1);
        }
        return string;
    }
}

