/*
 * $RCSfile: DALE_UV.h,v $
 * 
 * created by rieger on 03.04.2006
 * 
 * $Revision: 1.0 $
 * 
 * $Date: 03.04.2006 16:46:20 $
 * 
 * Copyright:
 * Werum Software & Systems AG
 * Wulf-Werum-Strasse 3, 
 * 21337 Lueneburg
 */
#ifndef _DALE_UV_H_
#define _DALE_UV_H_

#include "Report.h"

// <summary>
// Fhrt eine Plausibilittsprfung fr die im Report angegebene XML-Datei und
// schreibt die gefundenen Fehler in den Report.
// </summary>
// <param name="report">Report-Objekt, das sowohl die Eingabeparameter fr die
// Prfung enthlt, als auch die gefundenen Fehler aufnimmt</param>
// <remarks>
// Das Report-Objekt muss den Namen der XML-Datei enthalten und die Information,
// ob es sich um die Vorgngerversion der Plausi handelt.
// </remarks>
__declspec(dllexport) void performPlausi(DaleUvReport* report);

// <summary>
// Fhrt eine Feldprfung fr die im Report angegebenen Nachrichtentyp und
// Version, und schreibt die gefundenen Fehler in den Report.
// </summary>
// <param name="report">Report-Objekt, das sowohl die Eingabeparameter fr die
// Prfung enthlt, als auch die gefundenen Fehler aufnimmt</param>
// <remarks>
// Das Report-Objekt muss den Plausi-Namen sowie den Feldnamen im XPath-Format
// enthalten. Auch der Wert des Feldes muss angegeben sein, falls dieser nicht
// leer ist.
// </remarks>
__declspec(dllexport) void performFieldCheck(DaleUvReport* report);

#endif