/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DOMSatzInterface
implements SatzInterface {
    public static final String DEFAULT_NAME_SEPARATOR = ".";
    public static final String DEFAULT_INDICES_PREFIX = "#";
    public static final String DEFAULT_INDICES_SUFFIX = "";
    private Node node;
    private HashMap subnodes = null;

    public DOMSatzInterface(Node node) {
        this.node = node;
        this.subnodes = new HashMap();
    }

    private DOMSatzInterface(Node node, HashMap hashMap) {
        this.node = node;
        this.subnodes = hashMap;
    }

    @Override
    public boolean getBool(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        boolean bl;
        String string = this.getNodeValue(feldDeskriptorInterface);
        if (string == null) {
            bl = false;
        } else {
            try {
                bl = new Boolean(string);
            }
            catch (Exception exception) {
                throw new WertNichtTypgerechtException(this.createKey(feldDeskriptorInterface));
            }
        }
        return bl;
    }

    @Override
    public double getDouble(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        double d;
        String string = this.getNodeValue(feldDeskriptorInterface);
        if (string == null) {
            d = 0.0;
        } else {
            try {
                NumberValue numberValue = new NumberValue(string);
                d = numberValue.asDouble();
            }
            catch (Exception exception) {
                throw new WertNichtTypgerechtException(this.createKey(feldDeskriptorInterface));
            }
        }
        return d;
    }

    @Override
    public int getLaenge(FeldDeskriptorInterface feldDeskriptorInterface, int[] nArray) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        int n = 0;
        String string = feldDeskriptorInterface.getFeldNameTB();
        List list = this.getSubnodesForNode(string, this.node);
        if (list != null) {
            n = list.size();
        }
        return n;
    }

    @Override
    public long getLong(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        long l;
        String string = this.getNodeValue(feldDeskriptorInterface);
        if (string == null) {
            l = 0L;
        } else {
            try {
                NumberValue numberValue = new NumberValue(string);
                if (string.indexOf(44) >= 0) {
                    throw new WertNichtTypgerechtException(this.createKey(feldDeskriptorInterface));
                }
                l = numberValue.asLong();
            }
            catch (Exception exception) {
                throw new WertNichtTypgerechtException(this.createKey(feldDeskriptorInterface));
            }
        }
        return l;
    }

    @Override
    public String getString(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        String string = this.getNodeValue(feldDeskriptorInterface);
        if (string == null) {
            string = DEFAULT_INDICES_SUFFIX;
        } else if (!(string instanceof String)) {
            throw new WertNichtTypgerechtException(this.createKey(feldDeskriptorInterface));
        }
        return string;
    }

    @Override
    public SatzInterface getSubSatz(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return new DOMSatzInterface(this.getNode(feldDeskriptorInterface), this.subnodes);
    }

    @Override
    public boolean hatWert(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this.getNodeValue(feldDeskriptorInterface) != null;
    }

    private String getNodeValue(FeldDeskriptorInterface feldDeskriptorInterface) {
        return this.getNodeValue(this.getNode(feldDeskriptorInterface));
    }

    private String getNodeValue(Node node) {
        String string = null;
        if (node != null) {
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 3 || (string = node2.getNodeValue()) == null || (string = string.trim()).length() != 0) continue;
                string = null;
            }
        }
        return string;
    }

    private Node getNode(FeldDeskriptorInterface feldDeskriptorInterface) {
        List list;
        Node node = null;
        int n = 0;
        if (feldDeskriptorInterface.getIndizes() != null && feldDeskriptorInterface.getIndizes().length > 0) {
            n = feldDeskriptorInterface.getIndizes()[0];
        }
        if ((list = this.getSubnodesForNode(feldDeskriptorInterface.getFeldNameTB(), this.node)) != null && !list.isEmpty() && list.size() > n) {
            node = (Node)list.get(n);
        }
        return node;
    }

    private List getSubnodesForNode(String string, Node node) {
        if (this.subnodes.containsKey(node) && ((HashMap)this.subnodes.get(node)).containsKey(string)) {
            return (List)((HashMap)this.subnodes.get(node)).get(string);
        }
        LinkedList<Node> linkedList = new LinkedList<Node>();
        if (node != null) {
            HashMap<String, LinkedList<Node>> hashMap = (HashMap<String, LinkedList<Node>>)this.subnodes.get(node);
            if (hashMap == null) {
                hashMap = new HashMap<String, LinkedList<Node>>();
                this.subnodes.put(node, hashMap);
            }
            NodeList nodeList = node.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node2 = nodeList.item(i);
                if (node2.getNodeType() != 1 || !node2.getNodeName().equals(string)) continue;
                linkedList.add(node2);
            }
            hashMap.put(string, linkedList);
        }
        return linkedList;
    }

    private String createKey(FeldDeskriptorInterface feldDeskriptorInterface) {
        StringBuffer stringBuffer = new StringBuffer();
        for (FeldDeskriptorInterface feldDeskriptorInterface2 = feldDeskriptorInterface; feldDeskriptorInterface2 != null; feldDeskriptorInterface2 = feldDeskriptorInterface2.getVorgaenger()) {
            if (feldDeskriptorInterface2.getIndizes() != null) {
                for (int i = 0; i < feldDeskriptorInterface2.getIndizes().length; ++i) {
                    stringBuffer.insert(0, DEFAULT_INDICES_SUFFIX);
                    stringBuffer.insert(0, feldDeskriptorInterface2.getIndizes()[i]);
                    stringBuffer.insert(0, DEFAULT_INDICES_PREFIX);
                }
            }
            stringBuffer.insert(0, feldDeskriptorInterface2.getFeldNameTB());
            if (feldDeskriptorInterface2.getVorgaenger() == null) continue;
            stringBuffer.insert(0, DEFAULT_NAME_SEPARATOR);
        }
        return stringBuffer.toString();
    }

    @Override
    public void setBool(FeldDeskriptorInterface feldDeskriptorInterface, boolean bl) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
    }

    @Override
    public void setDouble(FeldDeskriptorInterface feldDeskriptorInterface, double d) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
    }

    @Override
    public void setLeerWert(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
    }

    @Override
    public void setLong(FeldDeskriptorInterface feldDeskriptorInterface, long l) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
    }

    @Override
    public void setString(FeldDeskriptorInterface feldDeskriptorInterface, String string) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
    }
}

