/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.dale_uv.parser.MessageDigestGenerator;
import de.dale_uv.parser.NodeDef;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

public class DTDCheck {
    private PlausiKontext kontext = null;
    private NodeDef dtdTree = null;
    private XmlNode currentNode = null;
    private boolean buildUpDataMap;
    private Map dataMap = null;
    private MessageDigestGenerator mdGenerator = null;
    private String plausiVersion = null;
    private String checkKey = null;
    private String messageDigest = null;

    public DTDCheck(PlausiKontext plausiKontext, NodeDef nodeDef, boolean bl) {
        this.kontext = plausiKontext;
        this.dtdTree = nodeDef;
        this.buildUpDataMap = bl;
        if (this.buildUpDataMap) {
            this.dataMap = new TreeMap();
        }
        this.mdGenerator = new MessageDigestGenerator();
    }

    public Map getDataMap() {
        return this.dataMap;
    }

    public PlausiKontext getKontext() {
        return this.kontext;
    }

    public String getPlausiVersion() {
        return this.plausiVersion;
    }

    public String getCheckKey() {
        return this.checkKey;
    }

    public String getMessageDigest() {
        return this.messageDigest;
    }

    public void checkStartElement(String string, StringBuffer stringBuffer, List list) {
        Object object;
        if (stringBuffer != null && stringBuffer.toString().trim().length() > 0) {
            this.addXMLFehlerToPlausiKontext("Textinhalt ist nicht au\u00dferhalb von Textelementen erlaubt (hier vor Element " + string + ").");
        }
        if (list != null && list.size() > 0) {
            object = list.toString();
            if (((String)object).length() > 0) {
                object = ((String)object).substring(1, ((String)object).length() - 1);
            }
            this.addXMLFehlerToPlausiKontext("Es sind keine Attribute f\u00fcr XML-Tags zugelassen. Das Element " + string + " hat folgende Attribute: " + (String)object);
        }
        this.currentNode = new XmlNode(string, this.currentNode);
        if (!this.currentNode.isRoot()) {
            this.currentNode.getParent().addChild(this.currentNode);
        }
        if (this.currentNode.isRoot()) {
            if (this.ensureIsRoot(string)) {
                this.currentNode.setNodeDef(this.dtdTree);
            }
        } else if (this.currentNode.getParent().isCorrect() && this.ensureIsChild(this.currentNode.getParent().getNodeDef(), string, this.currentNode.getNumOfOccurences() == 1)) {
            this.currentNode.setNodeDef(this.currentNode.getParent().getNodeDef().getChildByName(string));
            if (this.currentNode.getNumOfOccurences() == 1 || this.ensureCanHaveMoreOccurences(this.currentNode.getNodeDef())) {
                object = this.currentNode.getLastCorrectPrecedingSibling();
                if (object == null) {
                    this.ensureIsFirstChild(this.currentNode.getParent().getNodeDef(), string);
                } else if (!((XmlNode)object).getName().equals(string)) {
                    this.ensureIsFollowingSibling(((XmlNode)object).getNodeDef(), ((XmlNode)object).getParent().getNodeDef(), string);
                }
            }
        }
        if (this.currentNode.isRelevantForMessageDigest()) {
            this.mdGenerator.update(string);
        }
    }

    public void checkEndElement(String string, StringBuffer stringBuffer) {
        if (this.currentNode.isCorrect()) {
            String string2 = this.currentNode.getHierarchyAsString(false);
            String string3 = "";
            if (stringBuffer != null && stringBuffer.length() > 0) {
                string3 = stringBuffer.toString().trim();
            }
            if (this.currentNode.isRelevantForMessageDigest()) {
                this.mdGenerator.update(string3);
            }
            if ("unh_2".equals(string)) {
                this.plausiVersion = string3;
            } else if ("swh_8".equals(string)) {
                this.checkKey = string3;
            }
            if (this.currentNode.getNodeDef().isLeaf()) {
                if (this.buildUpDataMap && string3.length() > 0) {
                    this.dataMap.put(string2, string3);
                }
            } else {
                if (string3.length() > 0) {
                    this.addXMLFehlerToPlausiKontext("Textinhalt ist nicht au\u00dferhalb von Textelementen erlaubt (hier am Ende von Element " + string + ").");
                }
                if (this.buildUpDataMap && !this.currentNode.isRoot()) {
                    this.dataMap.put(string2 + "#anzahl", new Integer(this.currentNode.getNumOfOccurences()));
                }
            }
            if (!this.currentNode.getNodeDef().isLeaf()) {
                XmlNode xmlNode = this.currentNode.getLastCorrectChild();
                if (xmlNode == null) {
                    this.ensureHasNoRequiredChildren(this.currentNode.getNodeDef());
                } else {
                    this.ensureHasNoRequiredFollowingSiblings(xmlNode.getNodeDef(), this.currentNode.getNodeDef());
                }
            }
        }
        if (this.currentNode.isRoot()) {
            this.currentNode = null;
        } else {
            this.currentNode.removeChildren();
            this.currentNode = this.currentNode.getParent();
        }
    }

    public void checkEndDocument() {
        this.messageDigest = this.mdGenerator.getDigest();
    }

    private void addXMLFehlerToPlausiKontext(String string) {
        PlausiFehler plausiFehler = new PlausiFehler();
        plausiFehler.setFehlerId("XML-Fehler");
        plausiFehler.setFehlertextKurz("XML01#1 " + string);
        this.kontext.setFehler(plausiFehler);
    }

    private boolean ensureIsValidNode(NodeDef nodeDef) {
        boolean bl;
        if (nodeDef == null) {
            bl = false;
            this.addXMLFehlerToPlausiKontext("Das Dokument konnte nicht gepr\u00fcft werden, da keine oder eine fehlerhafte DTD angegeben wurde.");
        } else {
            bl = true;
        }
        return bl;
    }

    private boolean ensureIsRoot(String string) {
        boolean bl;
        if (this.ensureIsValidNode(this.dtdTree)) {
            if (!this.dtdTree.getName().equals(string)) {
                bl = false;
                this.addXMLFehlerToPlausiKontext("Das Wurzelelement " + string + " in der Datei passt nicht zu dem Wurzelelement " + this.dtdTree.getName() + " in der DTD.");
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ensureIsChild(NodeDef nodeDef, String string, boolean bl) {
        boolean bl2;
        if (this.ensureIsValidNode(nodeDef)) {
            if (nodeDef.isLeaf() || !nodeDef.hasChild(string)) {
                bl2 = false;
                this.addXMLFehlerToPlausiKontext(string + " ist nicht als Element f\u00fcr " + nodeDef.getName() + " erlaubt.");
            } else {
                bl2 = true;
            }
        } else {
            bl2 = false;
        }
        return bl2;
    }

    private boolean ensureIsFirstChild(NodeDef nodeDef, String string) {
        boolean bl;
        if (this.ensureIsChild(nodeDef, string, true)) {
            bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            int n = nodeDef.getIndexOfChild(string);
            for (int i = 0; i < n; ++i) {
                NodeDef nodeDef2 = nodeDef.getChildAtIndex(i);
                if (nodeDef2.getFrequency() == 2 || nodeDef2.getFrequency() == 3) {
                    bl = false;
                    stringBuffer.delete(0, stringBuffer.length());
                    stringBuffer.append(nodeDef2.getName());
                    continue;
                }
                if (bl) continue;
                stringBuffer.append(", ");
                stringBuffer.append(nodeDef2.getName());
            }
            if (!bl) {
                this.addXMLFehlerToPlausiKontext(string + " darf nur nach " + stringBuffer.toString() + " stehen.");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ensureCanHaveMoreOccurences(NodeDef nodeDef) {
        boolean bl;
        if (this.ensureIsValidNode(nodeDef)) {
            if (nodeDef.getFrequency() == 2) {
                bl = false;
                this.addXMLFehlerToPlausiKontext(nodeDef.getName() + " muss genau ein Mal vorkommen.");
            } else if (nodeDef.getFrequency() == 0) {
                bl = false;
                this.addXMLFehlerToPlausiKontext(nodeDef.getName() + " darf h\u00f6chstens ein Mal vorkommen.");
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ensureIsFollowingSibling(NodeDef nodeDef, NodeDef nodeDef2, String string) {
        boolean bl;
        if (this.ensureIsValidNode(nodeDef)) {
            if (this.ensureIsChild(nodeDef2, string, true)) {
                int n = nodeDef2.getIndexOfChild(string);
                if (n == 0) {
                    bl = false;
                    this.addXMLFehlerToPlausiKontext(string + " darf nur als erstes Element stehen.");
                } else {
                    int n2 = nodeDef2.getIndexOfChild(nodeDef);
                    StringBuffer stringBuffer = new StringBuffer();
                    boolean bl2 = true;
                    bl = false;
                    for (int i = n; i >= 0; --i) {
                        NodeDef nodeDef3 = nodeDef2.getChildAtIndex(i);
                        if (i == n) {
                            if (nodeDef3.getFrequency() != 1 && nodeDef3.getFrequency() != 3) continue;
                            stringBuffer.delete(0, stringBuffer.length());
                            stringBuffer.append(nodeDef3.getName());
                            continue;
                        }
                        if (i == n2) {
                            bl = true;
                            break;
                        }
                        if (nodeDef3.getFrequency() == 2 || nodeDef3.getFrequency() == 3) {
                            bl = false;
                            bl2 = false;
                            if (stringBuffer.length() > 0) {
                                stringBuffer.append(", ");
                            }
                            stringBuffer.append(nodeDef3.getName());
                            break;
                        }
                        if (stringBuffer.length() > 0) {
                            stringBuffer.append(", ");
                        }
                        stringBuffer.append(nodeDef3.getName());
                    }
                    if (!bl) {
                        this.addXMLFehlerToPlausiKontext(string + " darf nur " + (bl2 ? "als erstes Element oder " : "") + "nach " + stringBuffer.toString() + " stehen.");
                    }
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ensureHasNoRequiredChildren(NodeDef nodeDef) {
        boolean bl;
        if (this.ensureIsValidNode(nodeDef)) {
            bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl2 = false;
            for (int i = 0; i < nodeDef.getChildrenCount(); ++i) {
                NodeDef nodeDef2 = nodeDef.getChildAtIndex(i);
                if (nodeDef2.getFrequency() != 2 && nodeDef2.getFrequency() != 3) continue;
                bl = false;
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(", ");
                    bl2 = true;
                }
                stringBuffer.append(nodeDef2.getName());
            }
            if (!bl) {
                this.addXMLFehlerToPlausiKontext(nodeDef.getName() + " muss " + (bl2 ? "die Elemente " : "das Element ") + stringBuffer.toString() + " beinhalten.");
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private boolean ensureHasNoRequiredFollowingSiblings(NodeDef nodeDef, NodeDef nodeDef2) {
        boolean bl;
        if (this.ensureIsValidNode(nodeDef) && this.ensureIsValidNode(nodeDef2)) {
            if (nodeDef2 != null) {
                bl = true;
                StringBuffer stringBuffer = new StringBuffer();
                int n = nodeDef2.getIndexOfChild(nodeDef);
                boolean bl2 = false;
                for (int i = n + 1; i < nodeDef2.getChildrenCount(); ++i) {
                    NodeDef nodeDef3 = nodeDef2.getChildAtIndex(i);
                    if (nodeDef3.getFrequency() == 2 || nodeDef3.getFrequency() == 3) {
                        bl = false;
                        stringBuffer.delete(0, stringBuffer.length());
                        stringBuffer.append(nodeDef3.getName());
                        bl2 = false;
                        continue;
                    }
                    if (bl) continue;
                    stringBuffer.append(", ");
                    stringBuffer.append(nodeDef3.getName());
                    bl2 = true;
                }
                if (!bl) {
                    this.addXMLFehlerToPlausiKontext(nodeDef2.getName() + " muss " + (bl2 ? "eines der Elemente " : "") + stringBuffer.toString() + " als letztes Element haben. " + nodeDef.getName() + " ist nicht als letztes Element f\u00fcr " + nodeDef2.getName() + " erlaubt.");
                }
            } else {
                bl = true;
            }
        } else {
            bl = false;
        }
        return bl;
    }

    private class XmlNode {
        private String name;
        private XmlNode parent;
        private NodeDef nodeDef;
        private Vector children;

        public XmlNode(String string, XmlNode xmlNode) {
            this.name = string;
            this.parent = xmlNode;
            this.children = new Vector();
        }

        public String getName() {
            return this.name;
        }

        public boolean isRoot() {
            return this.parent == null;
        }

        public XmlNode getParent() {
            return this.parent;
        }

        public void setNodeDef(NodeDef nodeDef) {
            this.nodeDef = nodeDef;
        }

        public boolean isCorrect() {
            return this.nodeDef != null;
        }

        public NodeDef getNodeDef() {
            return this.nodeDef;
        }

        public int getNumOfOccurences() {
            int n = 0;
            if (!this.isRoot()) {
                n = this.getParent().getNumOfOccurences(this.getName());
            }
            return n;
        }

        public String getHierarchyAsString(boolean bl) {
            StringBuffer stringBuffer = new StringBuffer();
            if (!this.isRoot()) {
                stringBuffer.append(this.getParent().getHierarchyAsString(true));
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(".");
                }
                stringBuffer.append(this.getName());
                if (bl) {
                    stringBuffer.append("#");
                    stringBuffer.append(this.getNumOfOccurences() - 1);
                }
            }
            return stringBuffer.toString();
        }

        public void addChild(XmlNode xmlNode) {
            this.children.add(xmlNode);
        }

        public Iterator getChildren() {
            return this.children.iterator();
        }

        public int getNumOfOccurences(String string) {
            int n = 0;
            for (XmlNode xmlNode : this.children) {
                if (!xmlNode.getName().equals(string)) continue;
                ++n;
            }
            return n;
        }

        public XmlNode getLastCorrectPrecedingSibling() {
            XmlNode xmlNode = null;
            if (!this.isRoot() && this.getParent().isCorrect()) {
                XmlNode xmlNode2;
                Iterator iterator = this.getParent().getChildren();
                while (iterator.hasNext() && (xmlNode2 = (XmlNode)iterator.next()) != this) {
                    if (!xmlNode2.isCorrect()) continue;
                    xmlNode = xmlNode2;
                }
            }
            return xmlNode;
        }

        public XmlNode getLastCorrectChild() {
            XmlNode xmlNode = null;
            for (XmlNode xmlNode2 : this.children) {
                if (!xmlNode2.isCorrect()) continue;
                xmlNode = xmlNode2;
            }
            return xmlNode;
        }

        public void removeChildren() {
            this.children.clear();
        }

        public boolean isRelevantForMessageDigest() {
            boolean bl = true;
            if (this.getName() != null) {
                if ("swh_8".equals(this.getName())) {
                    bl = false;
                } else if (this.getName().startsWith("swi")) {
                    bl = false;
                }
            }
            return bl;
        }
    }
}

