/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.dale_uv.parser.DTDCheck;
import de.dale_uv.parser.NodeDef;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class EDALNPlausiHandlerDOM {
    private DTDCheck dtdCheck = null;
    private StringBuffer buffer = null;

    public EDALNPlausiHandlerDOM(PlausiKontext plausiKontext, NodeDef nodeDef) {
        this.dtdCheck = new DTDCheck(plausiKontext, nodeDef, false);
        this.buffer = new StringBuffer();
    }

    public void parse(Document document) {
        this.handleNodes(document.getChildNodes());
        this.dtdCheck.checkEndDocument();
    }

    private void handleNodes(NodeList nodeList) {
        if (nodeList != null) {
            String string = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string2 = node.getNodeName();
                if (node.getNodeType() == 3) {
                    String string3 = node.getNodeValue();
                    if (string3 == null || (string3 = string3.trim()).length() <= 0) continue;
                    this.buffer.append(string3);
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                if (string2.equals("unh") && string != null && string.equals("unt")) {
                    this.dtdCheck.checkEndElement("lona", this.buffer);
                    this.dtdCheck.checkStartElement("lona", this.buffer, null);
                }
                this.dtdCheck.checkStartElement(string2, this.buffer, null);
                this.buffer = new StringBuffer();
                this.handleNodes(node.getChildNodes());
                this.dtdCheck.checkEndElement(string2, this.buffer);
                this.buffer = new StringBuffer();
                string = string2;
            }
        }
    }

    public static Document createDOMFromXMLFile(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string));
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public PlausiKontext getKontext() {
        return this.dtdCheck.getKontext();
    }
}

