/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.statspez.pleditor.generator.runtime.NumberValue;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.SatzInterface;
import de.statspez.pleditor.generator.runtime.plausi.WertNichtTypgerechtException;
import java.util.Map;

public class MapSatzInterface
implements SatzInterface {
    public static final String DEFAULT_NAME_SEPARATOR = ".";
    public static final String DEFAULT_INDICES_PREFIX = "#";
    public static final String DEFAULT_INDICES_SUFFIX = "";
    public static final String DEFAULT_NUMBER_OF_SUFFIX = "#anzahl";
    public static final String DEFAULT_DECIMAL_POINT = ",";
    public static final String DEFAULT_THOUSEND_POINT = ".";
    private Map values;
    private String nameSeparator;
    private String indicesPrefix;
    private String indicesSuffix;
    private String numberOfSuffix;
    private String decimalPoint;
    private String thousandPoint;

    public MapSatzInterface(Map map) {
        this.values = map;
        this.nameSeparator = ".";
        this.indicesPrefix = DEFAULT_INDICES_PREFIX;
        this.indicesSuffix = DEFAULT_INDICES_SUFFIX;
        this.numberOfSuffix = DEFAULT_NUMBER_OF_SUFFIX;
        this.decimalPoint = DEFAULT_DECIMAL_POINT;
        this.thousandPoint = ".";
    }

    public String getNameSeparator() {
        return this.nameSeparator;
    }

    public void setNameSeparator(String string) {
        this.nameSeparator = string;
    }

    public String getIndicesPrefix() {
        return this.indicesPrefix;
    }

    public void setIndicesPrefix(String string) {
        this.indicesPrefix = string;
    }

    public String getIndicesSuffix() {
        return this.indicesSuffix;
    }

    public void setIndicesSuffix(String string) {
        this.indicesSuffix = string;
    }

    public String getNumberOfSuffix() {
        return this.numberOfSuffix;
    }

    public void setNumberOfSuffix(String string) {
        this.numberOfSuffix = string;
    }

    public String getDecimalPoint() {
        return this.decimalPoint;
    }

    public void setDecimalPoint(String string) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Dezimaltrenner muss angegeben werden.");
        }
        this.decimalPoint = string;
    }

    public String getThousandPoint() {
        return this.thousandPoint;
    }

    public void setThousandPoint(String string) {
        this.thousandPoint = string;
    }

    private String createKey(FeldDeskriptorInterface feldDeskriptorInterface) {
        StringBuffer stringBuffer = new StringBuffer();
        for (FeldDeskriptorInterface feldDeskriptorInterface2 = feldDeskriptorInterface; feldDeskriptorInterface2 != null; feldDeskriptorInterface2 = feldDeskriptorInterface2.getVorgaenger()) {
            if (feldDeskriptorInterface2.getIndizes() != null) {
                for (int i = 0; i < feldDeskriptorInterface2.getIndizes().length; ++i) {
                    stringBuffer.insert(0, this.getIndicesSuffix());
                    stringBuffer.insert(0, feldDeskriptorInterface2.getIndizes()[i]);
                    stringBuffer.insert(0, this.getIndicesPrefix());
                }
            }
            stringBuffer.insert(0, feldDeskriptorInterface2.getFeldNameTB());
            if (feldDeskriptorInterface2.getVorgaenger() == null) continue;
            stringBuffer.insert(0, this.getNameSeparator());
        }
        return stringBuffer.toString();
    }

    private String getThousandPointEscaped() {
        String string = this.getThousandPoint() == null ? null : (this.getThousandPoint().equals(".") ? "\\." : this.getThousandPoint());
        return string;
    }

    @Override
    public int getLaenge(FeldDeskriptorInterface feldDeskriptorInterface, int[] nArray) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        int n;
        StringBuffer stringBuffer = new StringBuffer(this.createKey(feldDeskriptorInterface));
        if (nArray != null) {
            for (int i = 0; i < nArray.length; ++i) {
                stringBuffer.append(this.getIndicesPrefix());
                stringBuffer.append(nArray[i]);
            }
        }
        stringBuffer.append(this.numberOfSuffix);
        Object v = this.values.get(stringBuffer.toString());
        if (v == null) {
            n = 0;
        } else if (v instanceof Integer) {
            n = (Integer)v;
        } else if (v instanceof String) {
            try {
                n = Integer.parseInt((String)v);
            }
            catch (Exception exception) {
                n = 0;
            }
        } else {
            n = 0;
        }
        return n;
    }

    @Override
    public boolean hatWert(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this.values.get(this.createKey(feldDeskriptorInterface)) != null;
    }

    @Override
    public String getString(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        String string;
        String string2 = this.createKey(feldDeskriptorInterface);
        Object v = this.values.get(string2);
        if (v == null) {
            string = DEFAULT_INDICES_SUFFIX;
        } else if (v instanceof String) {
            string = (String)v;
        } else {
            throw new WertNichtTypgerechtException(string2);
        }
        return string;
    }

    @Override
    public void setString(FeldDeskriptorInterface feldDeskriptorInterface, String string) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptorInterface), string);
    }

    @Override
    public long getLong(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        long l;
        String string = this.createKey(feldDeskriptorInterface);
        Object v = this.values.get(string);
        if (v == null) {
            l = 0L;
        } else if (v instanceof Long) {
            l = (Long)v;
        } else if (v instanceof String) {
            try {
                String string2 = (String)v;
                NumberValue numberValue = new NumberValue(string2);
                if (string2.indexOf(44) >= 0) {
                    throw new WertNichtTypgerechtException(string);
                }
                l = numberValue.asLong();
            }
            catch (Exception exception) {
                throw new WertNichtTypgerechtException(string);
            }
        } else {
            throw new WertNichtTypgerechtException(string);
        }
        return l;
    }

    @Override
    public void setLong(FeldDeskriptorInterface feldDeskriptorInterface, long l) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptorInterface), new Long(l));
    }

    @Override
    public double getDouble(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        double d;
        String string = this.createKey(feldDeskriptorInterface);
        Object v = this.values.get(string);
        if (v == null) {
            d = 0.0;
        } else if (v instanceof Double) {
            d = (Double)v;
        } else if (v instanceof String) {
            try {
                String string2 = (String)v;
                NumberValue numberValue = new NumberValue(string2);
                d = numberValue.asDouble();
            }
            catch (Exception exception) {
                throw new WertNichtTypgerechtException(string);
            }
        } else {
            throw new WertNichtTypgerechtException(string);
        }
        return d;
    }

    @Override
    public void setDouble(FeldDeskriptorInterface feldDeskriptorInterface, double d) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptorInterface), new Double(d));
    }

    @Override
    public boolean getBool(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException, WertNichtTypgerechtException {
        boolean bl;
        String string = this.createKey(feldDeskriptorInterface);
        Object v = this.values.get(string);
        if (v == null) {
            bl = false;
        } else if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else if (v instanceof String) {
            try {
                bl = new Boolean((String)v);
            }
            catch (Exception exception) {
                throw new WertNichtTypgerechtException(string);
            }
        } else {
            throw new WertNichtTypgerechtException(string);
        }
        return bl;
    }

    @Override
    public void setBool(FeldDeskriptorInterface feldDeskriptorInterface, boolean bl) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.put(this.createKey(feldDeskriptorInterface), new Boolean(bl));
    }

    @Override
    public void setLeerWert(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        this.values.remove(this.createKey(feldDeskriptorInterface));
    }

    @Override
    public SatzInterface getSubSatz(FeldDeskriptorInterface feldDeskriptorInterface) throws NoSuchFieldException, ArrayIndexOutOfBoundsException {
        return this;
    }
}

