/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import java.io.UnsupportedEncodingException;

public class MessageDigestGenerator {
    private static final int INIT_DIGEST_1 = 1732584193;
    private static final int INIT_DIGEST_2 = -271733879;
    private static final int INIT_DIGEST_3 = -1732584194;
    private static final char[] DIGEST_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'K', 'M', 'N', 'P', 'R', 'T', 'U', 'W', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'k', 'm', 'n', 'p', 'r', 't', 'u', 'w'};
    private int[] digest = new int[3];

    public MessageDigestGenerator() {
        this.reset();
    }

    public void update(String string) {
        if (string != null && string.length() > 0) {
            try {
                this.update(string.getBytes("ISO-8859-1"));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new RuntimeException(unsupportedEncodingException);
            }
        }
    }

    public void update(byte[] byArray) {
        if (byArray != null && byArray.length > 0) {
            for (int i = 0; i < byArray.length; ++i) {
                this.update(byArray[i]);
            }
        }
    }

    public void update(byte by) {
        this.digest[0] = this.digest[0] + (this.digest[1] & by) * this.digest[2];
        this.digest[1] = this.digest[1] + (this.digest[2] | by) * this.digest[0];
        this.digest[2] = this.digest[2] + this.digest[0] % by * this.digest[1];
    }

    public String getDigest() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.digest.length; ++i) {
            stringBuffer.append(this.getNumberEncoded((this.digest[i] & 0xFFFF0000) >> 16 & 0xFFFF));
            stringBuffer.append(this.getNumberEncoded(this.digest[i] & 0xFFFF));
        }
        return stringBuffer.toString();
    }

    public void reset() {
        this.digest[0] = 1732584193;
        this.digest[1] = -271733879;
        this.digest[2] = -1732584194;
    }

    private String getNumberEncoded(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 3; ++i) {
            int n2 = n % DIGEST_CHARS.length;
            n /= DIGEST_CHARS.length;
            stringBuffer.insert(0, DIGEST_CHARS[n2]);
        }
        return stringBuffer.toString();
    }
}

