/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class NodeDef {
    public static final int ZERO_OR_ONCE = 0;
    public static final int ZERO_OR_MORE = 1;
    public static final int ONCE = 2;
    public static final int ONCE_OR_MORE = 3;
    private NodeDef parent = null;
    private String name = null;
    private int frequency = 2;
    private ArrayList children = null;

    public NodeDef(NodeDef nodeDef, String string) {
        this.parent = nodeDef;
        this.name = string;
        this.children = new ArrayList();
    }

    public boolean isLeaf() {
        return this.children.isEmpty();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public void addChild(NodeDef nodeDef) {
        nodeDef.setParent(this);
        this.children.add(nodeDef);
    }

    public void insertChildAtIndex(NodeDef nodeDef, int n) {
        nodeDef.setParent(this);
        this.children.add(n, nodeDef);
    }

    public int getChildrenCount() {
        return this.children.size();
    }

    public NodeDef getChildAtIndex(int n) {
        return (NodeDef)this.children.get(n);
    }

    public boolean hasChild(String string) {
        boolean bl = false;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((NodeDef)this.children.get(i)).getName().equals(string)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public int getIndexOfChild(String string) {
        int n = -1;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((NodeDef)this.children.get(i)).getName().equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    public int getIndexOfChild(NodeDef nodeDef) {
        int n = -1;
        for (int i = 0; i < this.children.size(); ++i) {
            if (this.children.get(i) != nodeDef) continue;
            n = i;
            break;
        }
        return n;
    }

    public NodeDef getChildByName(String string) {
        NodeDef nodeDef = null;
        for (int i = 0; i < this.children.size(); ++i) {
            if (!((NodeDef)this.children.get(i)).getName().equals(string)) continue;
            nodeDef = (NodeDef)this.children.get(i);
            break;
        }
        return nodeDef;
    }

    public ArrayList getPossiblePredecessors() {
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!this.isRoot() && (n = this.parent.getChildren().indexOf(this)) > 0) {
            int n2 = n - 1;
            NodeDef nodeDef = null;
            boolean bl = true;
            while (bl && n2 >= 0) {
                nodeDef = this.parent.getChildAtIndex(n2);
                if (nodeDef.getFrequency() == 0 || nodeDef.getFrequency() == 1) {
                    arrayList.add(nodeDef.getName());
                    --n2;
                    continue;
                }
                if (nodeDef.getFrequency() != 2 && nodeDef.getFrequency() != 3) continue;
                arrayList.add(nodeDef.getName());
                bl = false;
            }
            if (this.frequency == 3 || this.frequency == 1) {
                arrayList.add(0, this.name);
            }
        }
        return arrayList;
    }

    public boolean hasOnlyOptionalPossiblePredecessors() {
        int n;
        boolean bl = false;
        if (!this.isRoot() && (n = this.parent.getChildren().indexOf(this)) > 0) {
            int n2 = n - 1;
            NodeDef nodeDef = null;
            boolean bl2 = true;
            int n3 = 0;
            int n4 = 0;
            while (bl2 && n2 >= 0) {
                nodeDef = this.parent.getChildAtIndex(n2);
                if (nodeDef.getFrequency() == 0 || nodeDef.getFrequency() == 1) {
                    ++n3;
                    ++n4;
                    --n2;
                    continue;
                }
                if (nodeDef.getFrequency() != 2 && nodeDef.getFrequency() != 3) continue;
                ++n3;
                bl2 = false;
            }
            if (n4 > 0 && n4 == n3) {
                bl = true;
            }
        }
        return bl;
    }

    public Set getLastPossibleElements() {
        HashSet<String> hashSet = new HashSet<String>();
        for (int i = this.children.size() - 1; i >= 0; --i) {
            NodeDef nodeDef = (NodeDef)this.children.get(i);
            if (nodeDef.getFrequency() == 0 || nodeDef.getFrequency() == 1) {
                hashSet.add(nodeDef.getName());
                continue;
            }
            if (nodeDef.getFrequency() != 2 && nodeDef.getFrequency() != 3) continue;
            hashSet.add(nodeDef.getName());
            i = -1;
        }
        return hashSet;
    }

    public void removeChild(NodeDef nodeDef) {
        this.children.remove(nodeDef);
    }

    public void removeChildAtIndex(int n) {
        this.children.remove(n);
    }

    public NodeDef getParent() {
        return this.parent;
    }

    public void setParent(NodeDef nodeDef) {
        this.parent = nodeDef;
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void setChildren(ArrayList arrayList) {
        this.children = arrayList;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public int getFrequency() {
        return this.frequency;
    }

    public void setFrequency(int n) {
        this.frequency = n;
    }

    public String toString() {
        if (this.children.isEmpty()) {
            return this.name;
        }
        return this.name + this.children;
    }
}

