/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.dale_uv.parser.DTDCheck;
import de.dale_uv.parser.NodeDef;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class PlausiHandlerDOM {
    private DTDCheck dtdCheck = null;
    private StringBuffer buffer = null;

    public PlausiHandlerDOM(PlausiKontext plausiKontext, NodeDef nodeDef) {
        this.dtdCheck = new DTDCheck(plausiKontext, nodeDef, false);
        this.buffer = new StringBuffer();
    }

    public void parse(Document document) {
        this.handleNodes(document.getChildNodes());
        this.dtdCheck.checkEndDocument();
    }

    private void handleNodes(NodeList nodeList) {
        if (nodeList != null) {
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                String string = node.getNodeName();
                ArrayList<String> arrayList = null;
                if (node.getAttributes() != null && node.getAttributes().getLength() > 0) {
                    arrayList = new ArrayList<String>();
                    for (int j = 0; j < node.getAttributes().getLength(); ++j) {
                        arrayList.add(node.getAttributes().item(j).getNodeName() + "=" + node.getAttributes().item(j).getNodeValue());
                    }
                }
                if (node.getNodeType() == 3) {
                    String string2 = node.getNodeValue();
                    if (string2 == null || (string2 = string2.trim()).length() <= 0) continue;
                    this.buffer.append(string2);
                    continue;
                }
                if (node.getNodeType() != 1) continue;
                this.dtdCheck.checkStartElement(string, this.buffer, arrayList);
                this.buffer = new StringBuffer();
                this.handleNodes(node.getChildNodes());
                this.dtdCheck.checkEndElement(string, this.buffer);
                this.buffer = new StringBuffer();
            }
        }
    }

    public static Document createDOMFromXMLFile(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string));
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    public PlausiKontext getKontext() {
        return this.dtdCheck.getKontext();
    }

    public String getPlausiVersion() {
        return this.dtdCheck.getPlausiVersion();
    }

    public String getCheckKey() {
        return this.dtdCheck.getCheckKey();
    }

    public String getMessageDigest() {
        return this.dtdCheck.getMessageDigest();
    }
}

