/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.dale_uv.parser.NodeDef;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public class PlausiHandlerDOMGTI
extends DefaultHandler {
    private PlausiKontext kontext = null;
    private int depth = -1;
    private NodeDef dtdTree = null;
    private Map occurencesOfElementsMap = null;
    private ArrayList pathList = null;
    private boolean rootIsOK = false;
    private String predecessorName = null;
    private Set notAllowedTags = null;
    private boolean isAlteVersion = false;

    public PlausiHandlerDOMGTI(PlausiKontext plausiKontext, NodeDef nodeDef, boolean bl) {
        this.kontext = plausiKontext;
        this.dtdTree = nodeDef;
        this.depth = -1;
        this.occurencesOfElementsMap = new TreeMap();
        this.pathList = new ArrayList();
        this.notAllowedTags = new HashSet();
        this.isAlteVersion = bl;
    }

    public void parse(Document document) {
        this.handleNodes(document.getChildNodes());
    }

    private void handleNodes(NodeList nodeList) {
        if (nodeList != null) {
            ++this.depth;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                String string;
                Node node = nodeList.item(i);
                String string2 = node.getNodeName();
                if (this.depth == 0 && node.getNodeType() == 1) {
                    if (string2.equals(this.dtdTree.getName())) {
                        this.rootIsOK = true;
                    } else {
                        this.addXMLFehlerToPlausiKontext("Das Wurzelelement " + string2 + " im DOMTree" + " passt nicht zu dem Wurzelelement " + this.dtdTree.getName() + " in der DTD.");
                    }
                }
                if (!this.rootIsOK) continue;
                NodeDef nodeDef = null;
                if (this.depth > 0 && string2 != null && !string2.startsWith("#") && !string2.equals("")) {
                    this.pathList.add(string2);
                }
                String string3 = "";
                nodeDef = this.dtdTree;
                Iterator iterator = this.pathList.iterator();
                while (iterator.hasNext()) {
                    string = (String)iterator.next();
                    string3 = string3 + string;
                    if (iterator.hasNext()) {
                        string3 = this.occurencesOfElementsMap.containsKey(string3) ? string3 + "#" + ((Integer)this.occurencesOfElementsMap.get(string3) - 1) + "." : string3 + "#0.";
                    }
                    if (nodeDef == null) continue;
                    nodeDef = nodeDef.getChildByName(string);
                }
                if (!(string2 == null || string2.startsWith("#") || string2.equals("") || string3.equals(""))) {
                    if (this.occurencesOfElementsMap.containsKey(string3)) {
                        this.occurencesOfElementsMap.put(string3, new Integer((Integer)this.occurencesOfElementsMap.get(string3) + 1));
                    } else {
                        this.occurencesOfElementsMap.put(string3, new Integer(1));
                    }
                }
                if (!string2.startsWith("#")) {
                    if (nodeDef == null) {
                        if (!this.notAllowedTags.contains(node.getParentNode().getNodeName()) && !this.notAllowedTags.contains(string2)) {
                            this.addXMLFehlerToPlausiKontext(string2 + " ist nicht als Element f\u00fcr " + node.getParentNode().getNodeName() + " erlaubt.");
                            this.notAllowedTags.add(string2);
                        }
                    } else if (nodeDef.getPossiblePredecessors().isEmpty() && nodeDef.getName().equals(this.predecessorName)) {
                        if (nodeDef.getFrequency() == 2) {
                            this.addXMLFehlerToPlausiKontext(string2 + " muss genau ein Mal vorkommen.");
                        } else if (nodeDef.getFrequency() == 0) {
                            this.addXMLFehlerToPlausiKontext(string2 + " darf h\u00f6chstens ein Mal vorkommen.");
                        }
                    } else if (!(this.notAllowedTags.contains(this.predecessorName) || nodeDef.getPossiblePredecessors().isEmpty() || nodeDef.getPossiblePredecessors().contains(this.predecessorName))) {
                        string = string2 + " darf nur nach " + nodeDef.getPossiblePredecessors() + " stehen.";
                        string = string.replaceAll("\\[", "");
                        string = string.replaceAll("\\]", "");
                        if (nodeDef.getName().equals(this.predecessorName)) {
                            if (nodeDef.getFrequency() == 2) {
                                string = string2 + " muss genau ein Mal vorkommen.";
                            } else if (nodeDef.getFrequency() == 0) {
                                string = string2 + " darf h\u00f6chstens ein Mal vorkommen.";
                            }
                            this.addXMLFehlerToPlausiKontext(string);
                        }
                        if (!this.isAlteVersion || !nodeDef.getName().equals("unz_1") && !nodeDef.getName().equals("unz_2")) {
                            this.addXMLFehlerToPlausiKontext(string);
                        }
                    }
                }
                this.handleNodes(node.getChildNodes());
                if (this.depth >= 0 && !string2.startsWith("#")) {
                    string = this.predecessorName;
                    if (this.pathList.size() > 0) {
                        this.predecessorName = (String)this.pathList.get(this.pathList.size() - 1);
                    }
                    if (string != null && nodeDef != null && !nodeDef.getLastPossibleElements().isEmpty() && !nodeDef.getLastPossibleElements().contains(string)) {
                        String string4 = "";
                        if (nodeDef.getLastPossibleElements().size() > 1) {
                            string4 = "eines der Elemente ";
                        }
                        String string5 = "" + nodeDef.getLastPossibleElements();
                        string5 = string5.replaceAll("\\[", "");
                        string5 = string5.replaceAll("\\]", "");
                        if (!this.isAlteVersion || !nodeDef.getName().equals("unz")) {
                            this.addXMLFehlerToPlausiKontext(nodeDef.getName() + " muss " + string4 + string5 + " als letztes Element haben. " + string + " ist nicht als letztes Element f\u00fcr " + nodeDef.getName() + " erlaubt.");
                        }
                    }
                }
                if (string2.startsWith("#") || this.pathList.size() <= 0) continue;
                this.pathList.remove(this.pathList.get(this.pathList.size() - 1));
            }
            --this.depth;
        }
    }

    public static Document createDOMFromXMLFile(String string) {
        Document document = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            document = documentBuilder.parse(new File(string));
        }
        catch (SAXParseException sAXParseException) {
            System.out.println("\n** Parsing error, line " + sAXParseException.getLineNumber() + ", uri " + sAXParseException.getSystemId());
            System.out.println("   " + sAXParseException.getMessage());
            Exception exception = sAXParseException;
            if (sAXParseException.getException() != null) {
                exception = sAXParseException.getException();
            }
            exception.printStackTrace();
        }
        catch (SAXException sAXException) {
            Exception exception = sAXException;
            if (sAXException.getException() != null) {
                exception = sAXException.getException();
            }
            exception.printStackTrace();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            parserConfigurationException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        return document;
    }

    private void addXMLFehlerToPlausiKontext(String string) {
        PlausiFehler plausiFehler = new PlausiFehler();
        plausiFehler.setFehlerId("XML-Fehler");
        plausiFehler.setFehlertextKurz("XML01#1 " + string);
        this.kontext.setFehler(plausiFehler);
    }

    public PlausiKontext getKontext() {
        return this.kontext;
    }
}

