/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.parser;

import de.dale_uv.info.PlausiInfo;
import de.dale_uv.info.PlausiInfoUtil;
import de.dale_uv.parser.DOMSatzInterface;
import de.dale_uv.parser.DOMSatzInterfaceGTI;
import de.dale_uv.parser.DTDParser;
import de.dale_uv.parser.EDALNDOMSatzInterface;
import de.dale_uv.parser.EDALNPlausiHandler;
import de.dale_uv.parser.EDALNPlausiHandlerDOM;
import de.dale_uv.parser.Fehler;
import de.dale_uv.parser.FehlerLog;
import de.dale_uv.parser.NodeDef;
import de.dale_uv.parser.PLLoggerAdapter;
import de.dale_uv.parser.PlausiContext;
import de.dale_uv.parser.PlausiHandler;
import de.dale_uv.parser.PlausiHandlerDOM;
import de.dale_uv.parser.PlausiHandlerDOMGTI;
import de.dale_uv.parser.PlausiHandlerGTI;
import de.dale_uv.parser.SimpleFeldDeskriptor;
import de.statspez.pleditor.generator.interpreter.SimpleDataset;
import de.statspez.pleditor.generator.runtime.BasePlausi;
import de.statspez.pleditor.generator.runtime.FeatureVariable;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorExt;
import de.statspez.pleditor.generator.runtime.FeldDeskriptorImpl;
import de.statspez.pleditor.generator.runtime.PlausiDescriptor;
import de.statspez.pleditor.generator.runtime.PlausiRuntimeContext;
import de.statspez.pleditor.generator.runtime.Value;
import de.statspez.pleditor.generator.runtime.ValueConversionException;
import de.statspez.pleditor.generator.runtime.plausi.FeldDeskriptorInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFactory;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiInterface;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import de.werum.sis.logger.LoggerIfc;
import de.werum.sis.logger.LoggerManager;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.SAXParserFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

public class PlausiPerformer {
    public static final String PL_CONFIG_NAME = "pl_config_daleuv";
    private static final String LINEBREAK = System.getProperty("line.separator");
    private static final String DALE_PLAUSI_PACKAGE_NAME = "de.statspez.plausi.generated";
    private LoggerIfc log = null;
    private PlausiFactory pf = new PlausiFactory();
    private String inputDirectory = "";
    private String outputDirectory = "";
    private String loglevel = "3";
    private Properties configProps = null;
    private String configfilename = "daleuv.ini";
    private String configDir = null;
    public static String PROGRAMMVERZEICHNIS = "Programmverzeichnis";
    public static String EINGABEVERZEICHNIS = "Eingabeverzeichnis";
    public static String AUSGABEVERZEICHNIS = "Ausgabeverzeichnis";
    public static String LOG_DATEI = "Log-Datei";
    public static String LOG_LEVEL = "Log-Level";
    private Boolean onServer = null;

    public PlausiPerformer() {
        this.initLog();
    }

    public PlausiPerformer(String string) {
        this(string, null);
    }

    public PlausiPerformer(String string, String string2) {
        this.configfilename = string;
        this.configDir = string2;
        this.readConfigFile();
        this.initLog();
    }

    public static HashSet getNachrichtentypen() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("dabe");
        hashSet.add("verb");
        hashSet.add("habe");
        hashSet.add("nasb");
        hashSet.add("mahb");
        hashSet.add("re13");
        hashSet.add("zwib");
        hashSet.add("havb");
        hashSet.add("abrz");
        hashSet.add("kneb");
        hashSet.add("koeb");
        hashSet.add("steb");
        hashSet.add("sueb");
        hashSet.add("veeb");
        hashSet.add("lona");
        return hashSet;
    }

    public static HashSet getInterneSegmente() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("unh");
        hashSet.add("unt");
        return hashSet;
    }

    public static HashSet getExterneSegmente() {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("unb");
        hashSet.add("unz");
        return hashSet;
    }

    private void initLog() {
        this.log = LoggerManager.getInstance().getLogger(PlausiPerformer.class);
        try {
            int n = Integer.parseInt(this.loglevel);
            switch (n) {
                case 6: {
                    this.log.setLogLevel(30);
                    break;
                }
                case 5: {
                    this.log.setLogLevel(40);
                    break;
                }
                case 3: 
                case 4: {
                    this.log.setLogLevel(20);
                    break;
                }
                default: {
                    this.log.setLogLevel(10);
                    break;
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            this.log.setLogLevel(30);
            nullPointerException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            this.log.setLogLevel(30);
            numberFormatException.printStackTrace();
        }
    }

    private void readConfigFile() {
        this.configProps = new Properties();
        try {
            Object object;
            Object object2;
            File file;
            if (this.configDir != null && this.configDir.length() > 0) {
                file = new File(this.configDir, this.configfilename);
            } else {
                file = new File(this.configfilename);
                if (!file.exists() && this.getClass().getProtectionDomain() != null && this.getClass().getProtectionDomain().getCodeSource() != null && this.getClass().getProtectionDomain().getCodeSource().getLocation() != null && this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath() != null && ((File)(object2 = (Object)new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().getPath()))).getName().equalsIgnoreCase("daleuv_java_lzu.jar") && ((File)object2).getParentFile() != null && ((File)(object = ((File)object2).getParentFile())).getName().equalsIgnoreCase("lib") && ((File)object).getParentFile() != null) {
                    file = new File(((File)object).getParentFile(), this.configfilename);
                }
            }
            if (file.exists()) {
                object2 = new byte[(int)file.length()];
                object = new FileInputStream(file);
                ((FileInputStream)object).read((byte[])object2);
                ((FileInputStream)object).close();
                for (int i = 0; i < ((byte[])object2).length; ++i) {
                    if (object2[i] != 92) continue;
                    object2[i] = 47;
                }
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object2);
                this.configProps.load(byteArrayInputStream);
                byteArrayInputStream.close();
                this.inputDirectory = this.configProps.getProperty(EINGABEVERZEICHNIS) + "/";
                this.outputDirectory = this.configProps.getProperty(AUSGABEVERZEICHNIS) + "/";
                this.loglevel = this.configProps.getProperty(LOG_LEVEL);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public FehlerLog doPlausi(String string) {
        return this.doPlausi(string, new PlausiContext());
    }

    public FehlerLog doPlausi(String string, String string2) {
        PlausiContext plausiContext = new PlausiContext();
        plausiContext.setPlausiVersion(string2);
        return this.doPlausi(string, plausiContext);
    }

    public FehlerLog doPlausi(String string, PlausiContext plausiContext) {
        String string2;
        String string3;
        String string4;
        FehlerLog fehlerLog;
        block28: {
            fehlerLog = null;
            string4 = null;
            string3 = null;
            string2 = null;
            PlausiKontext plausiKontext = new PlausiKontext();
            plausiKontext.setLogger(new PLLoggerAdapter(this.log));
            boolean bl = false;
            boolean bl2 = false;
            String string5 = null;
            String string6 = "1";
            if (string != null) {
                string5 = this.inputDirectory + string;
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(false);
                try {
                    PlausiInterface plausiInterface = null;
                    if (plausiContext.getPlausiVersion() == null) {
                        plausiInterface = this.resolvePlausi(string5, null, true);
                        string4 = this.resolvePlausiName(string5, null, true);
                    } else {
                        plausiInterface = this.resolvePlausi(string5, plausiContext.getPlausiVersion(), false);
                        string4 = this.resolvePlausiName(string5, plausiContext.getPlausiVersion(), false);
                    }
                    if (string4 == null) {
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("Parameterfehler");
                        plausiFehler.setFehlertextKurz("XML01#1#K Es konnte kein Nachrichtentyp ermittelt werden! Bitte \u00fcberpr\u00fcfen Sie, ob das Element unh_2 angegeben ist.");
                        plausiKontext.setFehler(plausiFehler);
                        fehlerLog = this.createFehlerObjekt(plausiKontext, null, string5, bl, string6);
                        break block28;
                    }
                    if (string4.indexOf("_05_") > -1) {
                        bl = true;
                    } else if (string4.indexOf("LONA") > -1) {
                        bl = true;
                        bl2 = true;
                    }
                    if (plausiInterface != null) {
                        string3 = plausiInterface.getPlausiVersionString();
                        string3 = string3 != null && string3.length() > 7 ? string3.substring(2, 8) : null;
                        NodeDef nodeDef = DTDParser.getDTDTree(PlausiPerformer.resolveDTD(plausiInterface));
                        XMLReader xMLReader = sAXParserFactory.newSAXParser().getXMLReader();
                        FileInputStream fileInputStream = new FileInputStream(string5);
                        InputSource inputSource = new InputSource(fileInputStream);
                        if (bl2) {
                            EDALNPlausiHandler eDALNPlausiHandler = new EDALNPlausiHandler(plausiKontext, nodeDef);
                            xMLReader.setContentHandler(eDALNPlausiHandler);
                            xMLReader.parse(inputSource);
                            ((InputStream)fileInputStream).close();
                            if (eDALNPlausiHandler.getKontext().getAnzahlFehler() == 0) {
                                long l = System.currentTimeMillis();
                                Map map = eDALNPlausiHandler.getDataMap();
                                plausiKontext = eDALNPlausiHandler.getKontext();
                                SimpleDataset simpleDataset = new SimpleDataset(map);
                                plausiKontext.setFehlerGewichtSchranke(1);
                                plausiKontext.setPruefeArrayIndexZugriffe(false);
                                plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                                plausiInterface.gesamtPlausi(simpleDataset, plausiKontext);
                                this.log.info(string5 + "; Dauer: " + (System.currentTimeMillis() - l) + " ms");
                            }
                        } else if (bl) {
                            PlausiHandlerGTI plausiHandlerGTI = new PlausiHandlerGTI(plausiKontext, nodeDef, bl);
                            xMLReader.setContentHandler(plausiHandlerGTI);
                            xMLReader.parse(inputSource);
                            ((InputStream)fileInputStream).close();
                            if (plausiHandlerGTI.getKontext().getAnzahlFehler() == 0) {
                                long l = System.currentTimeMillis();
                                Map map = plausiHandlerGTI.getDataMap();
                                plausiKontext = plausiHandlerGTI.getKontext();
                                SimpleDataset simpleDataset = new SimpleDataset(map);
                                plausiKontext.setFehlerGewichtSchranke(1);
                                plausiKontext.setPruefeArrayIndexZugriffe(false);
                                plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                                plausiInterface.gesamtPlausi(simpleDataset, plausiKontext);
                                this.log.info(string5 + "; Dauer: " + (System.currentTimeMillis() - l) + " ms");
                            }
                        } else {
                            PlausiHandler plausiHandler = new PlausiHandler(plausiKontext, nodeDef);
                            xMLReader.setContentHandler(plausiHandler);
                            xMLReader.parse(inputSource);
                            ((InputStream)fileInputStream).close();
                            string2 = plausiHandler.getCheckKey();
                            string2 = string2 != null && string2.length() > 10 ? string2.substring(5, 11) : null;
                            this.doPrePlausi(plausiKontext, string4, plausiHandler.getPlausiVersion());
                            if (plausiHandler.getKontext().getAnzahlFehler() == 0) {
                                long l = System.currentTimeMillis();
                                Map map = plausiHandler.getDataMap();
                                plausiKontext = plausiHandler.getKontext();
                                SimpleDataset simpleDataset = new SimpleDataset(map);
                                plausiKontext.setFehlerGewichtSchranke(1);
                                plausiKontext.setPruefeArrayIndexZugriffe(false);
                                plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                                plausiInterface.gesamtPlausi(simpleDataset, plausiKontext);
                                this.doPostPlausi(plausiKontext, plausiHandler.getCheckKey(), plausiHandler.getMessageDigest(), plausiContext.isKeyCheckEnabled());
                                if (plausiKontext.getAnzahlFehler() == 0) {
                                    string6 = this.createCheckKey(string4, plausiInterface.getPlausiVersionString(), plausiHandler.getMessageDigest());
                                }
                                this.log.info(string5 + "; Dauer: " + (System.currentTimeMillis() - l) + " ms");
                            }
                        }
                    } else {
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("Plausi-Ermittlungsfehler");
                        plausiFehler.setFehlertextKurz("XML01#1#K Es konnte keine Plausi-Klasse ermittelt werden! Bitte \u00fcberpr\u00fcfen Sie, ob das Element unh_2 den korrekten Nachrichtennamen und die korrekte Version aufweist!");
                        plausiKontext.setFehler(plausiFehler);
                    }
                    fehlerLog = this.createFehlerObjekt(plausiKontext, plausiInterface, string5, bl, string6);
                }
                catch (SAXParseException sAXParseException) {
                    if (plausiKontext != null) {
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("XML-Fehler");
                        String string7 = "";
                        if (!this.isTest()) {
                            string7 = sAXParseException.getMessage() + " ";
                        }
                        plausiFehler.setFehlertextKurz("XML01#1#K " + string7 + "(Zeile: " + sAXParseException.getLineNumber() + ", Spalte: " + sAXParseException.getColumnNumber() + ")");
                        plausiKontext.setFehler(plausiFehler);
                        fehlerLog = this.createFehlerObjekt(plausiKontext, null, string5, bl, string6);
                    }
                    if (this.log != null) {
                        this.log.error("Fehler beim Parsen.", sAXParseException);
                        break block28;
                    }
                    sAXParseException.printStackTrace();
                }
                catch (Exception exception) {
                    if (plausiKontext != null) {
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("Ausnahmefehler");
                        plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Es ist ein Ausnahmefehler aufgetreten.");
                        if (!this.isTest()) {
                            plausiFehler.setLaufzeitFehlerAufgetreten(true);
                            plausiFehler.setLaufzeitException(exception);
                        }
                        plausiKontext.setFehler(plausiFehler);
                        fehlerLog = this.createFehlerObjekt(plausiKontext, null, string5, bl, string6);
                    }
                    if (this.log != null) {
                        this.log.error("Fehler beim Pr\u00fcfen.", exception);
                        break block28;
                    }
                    exception.printStackTrace();
                }
            } else {
                if (plausiKontext != null) {
                    PlausiFehler plausiFehler = new PlausiFehler();
                    plausiFehler.setFehlerId("Parameterfehler");
                    plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Der Parameter fileName fuer die Methode 'doPlausi' muss ungleich null sein. fileName=" + string5);
                    plausiKontext.setFehler(plausiFehler);
                    fehlerLog = this.createFehlerObjekt(plausiKontext, null, string5, bl, string6);
                }
                this.log.error("doPlausi: Der Parameter fileName fuer die Methode 'doPlausi' muss ungleich null sein. fileName=" + string5);
            }
        }
        fehlerLog.setPlausiVersion(string4);
        fehlerLog.setPlausiDatum(string3);
        fehlerLog.setPlausiDatumDatei(string2);
        return fehlerLog;
    }

    public FehlerLog doFeldPlausi(String string, String string2, String string3) {
        return this.doFeldPlausi(string, string2, string3, new PlausiContext());
    }

    public FehlerLog doFeldPlausi(String string, String string2, String string3, String string4) {
        PlausiContext plausiContext = new PlausiContext();
        plausiContext.setPlausiVersion(string4);
        return this.doFeldPlausi(string, string2, string3, plausiContext);
    }

    public FehlerLog doFeldPlausi(String string, String string2, String string3, PlausiContext plausiContext) {
        FehlerLog fehlerLog;
        Object object;
        String string4;
        block13: {
            string4 = null;
            if (plausiContext.getPlausiVersion() == null) {
                object = ResourceBundle.getBundle(PL_CONFIG_NAME);
                string4 = string4 + "_" + ((ResourceBundle)object).getString("plausiversion");
            } else {
                string4 = string3 + "_" + plausiContext.getPlausiVersion();
            }
            object = null;
            fehlerLog = null;
            PlausiKontext plausiKontext = new PlausiKontext();
            plausiKontext.setLogger(new PLLoggerAdapter(this.log));
            boolean bl = false;
            if (string4 != null && string != null && string2 != null && string4.length() == 9) {
                if (string4.indexOf("_05_") > -1 || string4.indexOf("LONA") > -1) {
                    bl = true;
                }
                SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
                sAXParserFactory.setNamespaceAware(false);
                try {
                    PlausiInterface plausiInterface = this.pf.createPlausi(string4);
                    if (plausiInterface != null) {
                        object = plausiInterface.getPlausiVersionString();
                        object = object != null && ((String)object).length() > 7 ? ((String)object).substring(2, 8) : null;
                        long l = System.currentTimeMillis();
                        HashMap<String, String> hashMap = new HashMap<String, String>();
                        String string5 = string.replaceAll("/", ".");
                        string5 = string5.substring(string5.indexOf(".", 1) + 1);
                        hashMap.put(string5, string2);
                        SimpleDataset simpleDataset = new SimpleDataset(hashMap);
                        plausiKontext.setFehlerGewichtSchranke(1);
                        plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                        plausiInterface.feldPlausi(string5, simpleDataset, plausiKontext);
                        this.log.test("," + string4 + "," + (System.currentTimeMillis() - l));
                    } else {
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("Plausi-Ermittlungsfehler");
                        plausiFehler.setFehlertextKurz("PROGRAMMFEHLER02#1#K Es konnte keine Plausi-Klasse f\u00fcr " + string4 + " ermittelt werden!");
                        plausiKontext.setFehler(plausiFehler);
                    }
                    fehlerLog = this.createFehlerObjekt(plausiKontext, plausiInterface, string4, bl, null);
                }
                catch (Exception exception) {
                    if (plausiKontext != null) {
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("Ausnahmefehler");
                        plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Es ist ein Ausnahmefehler aufgetreten.");
                        if (!this.isTest()) {
                            plausiFehler.setLaufzeitFehlerAufgetreten(true);
                            plausiFehler.setLaufzeitException(exception);
                        }
                        plausiKontext.setFehler(plausiFehler);
                        fehlerLog = this.createFehlerObjekt(plausiKontext, null, string4, bl, null);
                    }
                    if (this.log != null) {
                        this.log.error("Fehler beim Pr\u00fcfen.", exception);
                        break block13;
                    }
                    exception.printStackTrace();
                }
            } else {
                if (plausiKontext != null) {
                    PlausiFehler plausiFehler = new PlausiFehler();
                    plausiFehler.setFehlerId("Parameterfehler");
                    plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Die Parameter plausiname, xPathToFeld und value fuer die Methode 'doFeldPlausi' muessen ungleich null sein. plausiname=" + string4 + " xPathToFeld=" + string + " value=" + string2);
                    plausiKontext.setFehler(plausiFehler);
                    fehlerLog = this.createFehlerObjekt(plausiKontext, null, string4, bl, null);
                }
                this.log.error("doPlausi: Die Parameter plausiname, xPathToFeld und value fuer die Methode muessen ungleich null sein. plausiname=" + string4 + " xPathToFeld=" + string + " value=" + string2);
            }
        }
        fehlerLog.setPlausiVersion(string4);
        fehlerLog.setPlausiDatum((String)object);
        return fehlerLog;
    }

    public FehlerLog doPlausi(Document document) {
        return this.doPlausi(document, new PlausiContext());
    }

    public FehlerLog doPlausi(Document document, String string) {
        PlausiContext plausiContext = new PlausiContext();
        plausiContext.setPlausiVersion(string);
        return this.doPlausi(document, plausiContext);
    }

    public FehlerLog doPlausi(Document document, PlausiContext plausiContext) {
        String string;
        String string2;
        String string3;
        FehlerLog fehlerLog;
        block27: {
            fehlerLog = null;
            PlausiKontext plausiKontext = new PlausiKontext();
            boolean bl = false;
            boolean bl2 = false;
            string3 = null;
            string2 = null;
            string = null;
            String string4 = "1";
            if (document != null) {
                string3 = plausiContext.getPlausiVersion() == null ? this.resolvePlausiName(document, null, true) : this.resolvePlausiName(document, plausiContext.getPlausiVersion(), false);
                if (string3 == null) {
                    PlausiFehler plausiFehler = new PlausiFehler();
                    plausiFehler.setFehlerId("Parameterfehler");
                    plausiFehler.setFehlertextKurz("XML01#1#K Es konnte kein Nachrichtentyp ermittelt werden! Bitte \u00fcberpr\u00fcfen Sie, ob das Element unh_2 angegeben ist.");
                    plausiKontext.setFehler(plausiFehler);
                    fehlerLog = this.createFehlerObjekt(plausiKontext, null, string3, bl, string4);
                } else {
                    if (string3.indexOf("_05_") > -1) {
                        bl = true;
                    } else if (string3.indexOf("LONA") > -1) {
                        bl = true;
                        bl2 = true;
                    }
                    try {
                        PlausiInterface plausiInterface = this.pf.createPlausi(string3);
                        if (plausiInterface != null) {
                            string2 = plausiInterface.getPlausiVersionString();
                            string2 = string2 != null && string2.length() > 7 ? string2.substring(2, 8) : null;
                            NodeDef nodeDef = DTDParser.getDTDTree(PlausiPerformer.resolveDTD(plausiInterface));
                            if (bl2) {
                                EDALNPlausiHandlerDOM eDALNPlausiHandlerDOM = new EDALNPlausiHandlerDOM(plausiKontext, nodeDef);
                                eDALNPlausiHandlerDOM.parse(document);
                                if (eDALNPlausiHandlerDOM.getKontext().getAnzahlFehler() == 0) {
                                    long l = System.currentTimeMillis();
                                    plausiKontext = eDALNPlausiHandlerDOM.getKontext();
                                    EDALNDOMSatzInterface eDALNDOMSatzInterface = new EDALNDOMSatzInterface(document.getDocumentElement());
                                    plausiKontext.setFehlerGewichtSchranke(1);
                                    plausiKontext.setPruefeArrayIndexZugriffe(false);
                                    plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                                    plausiInterface.gesamtPlausi(eDALNDOMSatzInterface, plausiKontext);
                                    this.log.info(string3 + "; Dauer: " + (System.currentTimeMillis() - l) + " ms");
                                }
                            } else if (bl) {
                                PlausiHandlerDOMGTI plausiHandlerDOMGTI = new PlausiHandlerDOMGTI(plausiKontext, nodeDef, bl);
                                plausiHandlerDOMGTI.parse(document);
                                if (plausiHandlerDOMGTI.getKontext().getAnzahlFehler() == 0) {
                                    long l = System.currentTimeMillis();
                                    plausiKontext = plausiHandlerDOMGTI.getKontext();
                                    DOMSatzInterfaceGTI dOMSatzInterfaceGTI = new DOMSatzInterfaceGTI(document.getDocumentElement(), bl);
                                    plausiKontext.setFehlerGewichtSchranke(1);
                                    plausiKontext.setPruefeArrayIndexZugriffe(false);
                                    plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                                    plausiInterface.gesamtPlausi(dOMSatzInterfaceGTI, plausiKontext);
                                    this.log.info(string3 + "; Dauer: " + (System.currentTimeMillis() - l) + " ms");
                                }
                            } else {
                                PlausiHandlerDOM plausiHandlerDOM = new PlausiHandlerDOM(plausiKontext, nodeDef);
                                plausiHandlerDOM.parse(document);
                                string = plausiHandlerDOM.getCheckKey();
                                string = string != null && string.length() > 10 ? string.substring(5, 11) : null;
                                this.doPrePlausi(plausiKontext, string3, plausiHandlerDOM.getPlausiVersion());
                                if (plausiHandlerDOM.getKontext().getAnzahlFehler() == 0) {
                                    long l = System.currentTimeMillis();
                                    plausiKontext = plausiHandlerDOM.getKontext();
                                    DOMSatzInterface dOMSatzInterface = new DOMSatzInterface(document.getDocumentElement());
                                    plausiKontext.setFehlerGewichtSchranke(1);
                                    plausiKontext.setPruefeArrayIndexZugriffe(false);
                                    plausiKontext.setMerkmalsPruefungWertAbfrageStrategie(2);
                                    plausiInterface.gesamtPlausi(dOMSatzInterface, plausiKontext);
                                    this.doPostPlausi(plausiKontext, plausiHandlerDOM.getCheckKey(), plausiHandlerDOM.getMessageDigest(), plausiContext.isKeyCheckEnabled());
                                    if (plausiKontext.getAnzahlFehler() == 0) {
                                        string4 = this.createCheckKey(string3, plausiInterface.getPlausiVersionString(), plausiHandlerDOM.getMessageDigest());
                                    }
                                    this.log.info(string3 + "; Dauer: " + (System.currentTimeMillis() - l) + " ms");
                                }
                            }
                        } else {
                            PlausiFehler plausiFehler = new PlausiFehler();
                            plausiFehler.setFehlerId("Plausi-Ermittlungsfehler");
                            plausiFehler.setFehlertextKurz("XML01#1#K Es konnte keine Plausi-Klasse f\u00fcr " + string3 + " ermittelt werden!");
                            plausiKontext.setFehler(plausiFehler);
                        }
                        fehlerLog = this.createFehlerObjekt(plausiKontext, plausiInterface, string3, bl, string4);
                    }
                    catch (SAXParseException sAXParseException) {
                        if (plausiKontext != null) {
                            PlausiFehler plausiFehler = new PlausiFehler();
                            plausiFehler.setFehlerId("XML-Fehler");
                            String string5 = "";
                            if (!this.isTest()) {
                                string5 = sAXParseException.getMessage() + " ";
                            }
                            plausiFehler.setFehlertextKurz("XML01#1#K " + string5 + "(Zeile: " + sAXParseException.getLineNumber() + ", Spalte: " + sAXParseException.getColumnNumber() + ")");
                            plausiKontext.setFehler(plausiFehler);
                            fehlerLog = this.createFehlerObjekt(plausiKontext, null, string3, bl, string4);
                        }
                        if (this.log != null) {
                            this.log.error("Fehler beim Parsen.", sAXParseException);
                            break block27;
                        }
                        sAXParseException.printStackTrace();
                    }
                    catch (Exception exception) {
                        if (plausiKontext != null) {
                            PlausiFehler plausiFehler = new PlausiFehler();
                            plausiFehler.setFehlerId("Ausnahmefehler");
                            plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Es ist ein Ausnahmefehler aufgetreten.");
                            if (!this.isTest()) {
                                plausiFehler.setLaufzeitFehlerAufgetreten(true);
                                plausiFehler.setLaufzeitException(exception);
                            }
                            plausiKontext.setFehler(plausiFehler);
                            fehlerLog = this.createFehlerObjekt(plausiKontext, null, string3, bl, string4);
                        }
                        if (this.log != null) {
                            this.log.error("Fehler beim Pr\u00fcfen.", exception);
                            break block27;
                        }
                        exception.printStackTrace();
                    }
                }
            } else {
                if (plausiKontext != null) {
                    PlausiFehler plausiFehler = new PlausiFehler();
                    plausiFehler.setFehlerId("Parameterfehler");
                    plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Der Parameter document fuer die Methode 'doPlausi' muss ungleich null sein. document=" + document);
                    plausiKontext.setFehler(plausiFehler);
                    fehlerLog = this.createFehlerObjekt(plausiKontext, null, string3, bl, string4);
                }
                this.log.error("doPlausi: Der Parameter document fuer die Methode 'doPlausi' muss ungleich null sein. document=" + document);
            }
        }
        fehlerLog.setPlausiVersion(string3);
        fehlerLog.setPlausiDatum(string2);
        fehlerLog.setPlausiDatumDatei(string);
        return fehlerLog;
    }

    public static NodeDef getDTDTree(String string) throws Exception {
        return DTDParser.getDTDTree(PlausiPerformer.resolveDTD(new PlausiFactory().createPlausi(string)));
    }

    public int writeErrorFile(String string, FehlerLog fehlerLog) {
        String string2 = this.outputDirectory + string;
        int n = 5;
        try {
            FileWriter fileWriter = new FileWriter(string2);
            fileWriter.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + LINEBREAK);
            fileWriter.write("<fehlerlog>" + LINEBREAK);
            if (fehlerLog != null) {
                String string3 = this.getXMLTextISO_8859_1(fehlerLog.getDatenquelle());
                if (string3 != null && string3.length() > 0) {
                    string3 = string3.replaceAll("/", "\\\\");
                }
                fileWriter.write("\t<datenquelle>" + string3 + "</datenquelle>" + LINEBREAK);
                if (fehlerLog.getPlausiVersion() != null) {
                    fileWriter.write("\t<pl_version>" + this.getXMLTextISO_8859_1(fehlerLog.getPlausiVersion()) + "</pl_version>" + LINEBREAK);
                }
                if (fehlerLog.getPruefschluessel() != null && fehlerLog.getPruefschluessel().length() > 0) {
                    fileWriter.write("\t<pruefschluessel>" + this.getXMLTextISO_8859_1(fehlerLog.getPruefschluessel()) + "</pruefschluessel>" + LINEBREAK);
                }
                for (Fehler fehler : fehlerLog.getFehlerliste()) {
                    fileWriter.write("\t<fehler>" + LINEBREAK);
                    fileWriter.write("\t\t<id>" + this.getXMLTextISO_8859_1(fehler.getFehlerID()) + "</id>" + LINEBREAK);
                    if (fehler.getFeldname() != null) {
                        fileWriter.write("\t\t<feldname>" + fehler.getFeldname() + "</feldname>" + LINEBREAK);
                    }
                    if (fehler.getFeldbeschriftung() != null) {
                        fileWriter.write("\t\t<feldbeschriftung>" + fehler.getFeldbeschriftung() + "</feldbeschriftung>" + LINEBREAK);
                    }
                    if (!fehler.getFehlerID().startsWith("XML") && fehler.getReferenzstruktur() != null) {
                        fileWriter.write("\t\t<referenzstruktur>" + this.getXMLTextISO_8859_1(fehler.getReferenzstruktur()) + "</referenzstruktur>" + LINEBREAK);
                    }
                    if (fehler.getFehlerID().startsWith("XML")) {
                        fileWriter.write("\t\t<referenzstruktur>XML-Validierung</referenzstruktur>" + LINEBREAK);
                    } else if (!fehler.getFehlerID().startsWith("Parameterfehler") && !fehler.getFehlerID().startsWith("Plausi-Ermittlungsfehler")) {
                        fileWriter.write("\t\t<gewicht>" + fehler.getFehlerGewicht() + "</gewicht>" + LINEBREAK);
                    }
                    String string4 = fehler.getFehlercode();
                    if (fehler.getFehlercode().indexOf(95) > -1 && fehler.getFehlercode().indexOf(95) != 3) {
                        string4 = fehler.getFehlercode().substring(0, fehler.getFehlercode().indexOf(95));
                    }
                    if (fehler.getFehlerstufe() < n) {
                        n = fehler.getFehlerstufe();
                    }
                    fileWriter.write("\t\t<stufe>" + fehler.getFehlerstufe() + "</stufe>" + LINEBREAK);
                    if (!(fehler.getFehlerID().startsWith("XML") || fehler.getFehlerID().startsWith("Parameterfehler") || fehler.getFehlerID().startsWith("Plausi-Ermittlungsfehler"))) {
                        fileWriter.write("\t\t<code>" + this.getXMLTextISO_8859_1(string4) + "</code>" + LINEBREAK);
                    }
                    if (fehler.getFehlerID().startsWith("XML")) {
                        fileWriter.write("\t\t<text_kurz>Kritischer Syntaxfehler! Bitte wenden Sie sich an Ihr Softwarehaus! Fehler in der XML-Struktur: " + this.getXMLTextISO_8859_1(fehler.getFehlertextKurz()) + "</text_kurz>" + LINEBREAK);
                    } else if (fehler.getFehlerID().startsWith("Ausnahmefehler")) {
                        fileWriter.write("\t\t<text_kurz>Kritischer Fehler! Bitte wenden Sie sich an Ihr Softwarehaus! " + this.getXMLTextISO_8859_1(fehler.getFehlertextKurz()) + "</text_kurz>" + LINEBREAK);
                    } else {
                        Object object = "";
                        if (fehler.isKritisch()) {
                            object = (String)object + "Kritischer Fehler! Bitte wenden Sie sich an Ihr Softwarehaus! ";
                        }
                        if (fehler.getFeldbeschriftung() != null || fehler.getFeldname() != null) {
                            object = (String)object + "Fehler im Feld ";
                            if (fehler.getFeldbeschriftung() != null) {
                                object = (String)object + fehler.getFeldbeschriftung() + " ";
                            }
                            if (fehler.getFeldbeschriftung() != null) {
                                object = (String)object + "(&lt;" + fehler.getFeldname() + "&gt;)";
                            }
                            object = (String)object + ": ";
                        }
                        fileWriter.write("\t\t<text_kurz>" + (String)object + this.getXMLTextISO_8859_1(fehler.getFehlertextKurz()) + "</text_kurz>" + LINEBREAK);
                    }
                    if (fehler.isAusnahmefehler()) {
                        fileWriter.write("\t\t<ausnahmefehler>" + LINEBREAK);
                        fileWriter.write("\t\t\t<klasse>" + this.getXMLTextISO_8859_1(fehler.getAusnahmefehlerKlasse()) + "</klasse>" + LINEBREAK);
                        fileWriter.write("\t\t\t<text>" + this.getXMLTextISO_8859_1(fehler.getAusnahmefehlertext()) + "</text>" + LINEBREAK);
                        for (StackTraceElement stackTraceElement : fehler.getAusnahmefehlerStacktrace()) {
                            fileWriter.write("\t\t\t<position>" + this.getXMLTextISO_8859_1(stackTraceElement.toString()) + "</position>" + LINEBREAK);
                        }
                        fileWriter.write("\t\t</ausnahmefehler>" + LINEBREAK);
                    }
                    fileWriter.write("\t</fehler>" + LINEBREAK);
                }
            } else {
                fileWriter.write("FEHLER - Das uebergebene FehlerLogObjekt ist null!" + LINEBREAK);
                n = -1;
            }
            fileWriter.write("</fehlerlog>" + LINEBREAK);
            fileWriter.close();
        }
        catch (IOException iOException) {
            n = -1;
            iOException.printStackTrace();
        }
        return n == 5 ? 0 : n;
    }

    public int writeErrorFileInOldFormat(String string, FehlerLog fehlerLog) {
        String string2 = this.outputDirectory + string;
        int n = 5;
        try {
            FileWriter fileWriter = new FileWriter(string2);
            if (fehlerLog != null) {
                Date date = new Date();
                DateFormat dateFormat = DateFormat.getDateInstance(2, Locale.GERMAN);
                String string3 = dateFormat.format(date);
                DateFormat dateFormat2 = DateFormat.getTimeInstance(2, Locale.GERMAN);
                String string4 = dateFormat2.format(date);
                fileWriter.write("Strukturpruefungen der Datei: <" + fehlerLog.getDatenquelle() + ">" + LINEBREAK + "am " + string3 + " um " + string4 + " Uhr" + LINEBREAK);
                fileWriter.write("Prueftabellenversion: " + fehlerLog.getPlausiVersion() + LINEBREAK);
                fileWriter.write("################################################################################" + LINEBREAK);
                fileWriter.write("################################################################################" + LINEBREAK + LINEBREAK);
                for (Fehler fehler : fehlerLog.getFehlerliste()) {
                    String string5;
                    String string6 = fehler.getFehlercode();
                    if (fehler.getFehlercode().indexOf(95) > -1 && fehler.getFehlercode().indexOf(95) != 3) {
                        string6 = fehler.getFehlercode().substring(0, fehler.getFehlercode().indexOf(95));
                    }
                    if (fehler.getFehlerstufe() < n) {
                        n = fehler.getFehlerstufe();
                    }
                    String string7 = "";
                    if (fehler.getFehlerID().startsWith("XML")) {
                        string7 = "Kritischer Syntaxfehler! Bitte wenden Sie sich an Ihr Softwarehaus! Fehler in der XML-Struktur: " + fehler.getFehlertextKurz();
                    } else if (fehler.getFehlerID().startsWith("Ausnahmefehler")) {
                        string7 = "Kritischer Fehler! Bitte wenden Sie sich an Ihr Softwarehaus! " + fehler.getFehlertextKurz();
                    } else {
                        string5 = "";
                        if (fehler.isKritisch()) {
                            string5 = string5 + "Kritischer Fehler! Bitte wenden Sie sich an Ihr Softwarehaus! ";
                        }
                        if (fehler.getFeldbeschriftung() != null || fehler.getFeldname() != null) {
                            string5 = string5 + "Fehler im Feld ";
                            if (fehler.getFeldbeschriftung() != null) {
                                string5 = string5 + fehler.getFeldbeschriftung() + " ";
                            }
                            if (fehler.getFeldbeschriftung() != null) {
                                string5 = string5 + "(<" + fehler.getFeldname() + ">)";
                            }
                            string5 = string5 + ": ";
                        }
                        string7 = string5 + fehler.getFehlertextKurz();
                    }
                    if (string7.length() > 79) {
                        int n2 = 0;
                        int n3 = 79;
                        int n4 = string7.length();
                        while (n4 > 79) {
                            int n5 = string7.indexOf(10, n2);
                            if (n5 >= 0 && n5 < n3) {
                                n3 = n5 + 1;
                                fileWriter.write(string7.substring(n2, n3));
                            } else {
                                fileWriter.write(string7.substring(n2, n3) + LINEBREAK);
                            }
                            n4 -= n3 - n2;
                            n2 = n3;
                            n3 += 79;
                        }
                        if (n4 > 0) {
                            fileWriter.write(string7.substring(n2) + LINEBREAK);
                        }
                    } else {
                        fileWriter.write(string7 + LINEBREAK);
                    }
                    if (!fehler.getFehlerID().startsWith("XML")) {
                        fileWriter.write("Fehler-Nr.: <" + string6 + ">, ");
                    }
                    fileWriter.write("Fehlerstufe: <" + fehler.getFehlerstufe() + ">" + LINEBREAK);
                    string5 = fehler.getFeldname();
                    String string8 = "";
                    if (string5 != null) {
                        string8 = string5.substring(string5.indexOf("_") + 1);
                        string5 = string5.substring(0, string5.indexOf("_"));
                    }
                    if (!fehler.getFehlerID().startsWith("XML")) {
                        fileWriter.write("Fehler im " + string8 + ".XML-Tag in <" + string5 + ">." + LINEBREAK);
                    }
                    fileWriter.write("################################################################################" + LINEBREAK);
                }
            } else {
                fileWriter.write("FEHLER-Das uebergebene FehlerLogObjekt ist null!" + LINEBREAK);
                n = -1;
            }
            if (n < 5) {
                fileWriter.write("Bei der Pr\u00fcfung der Datei wurde mindestens ein Fehler mit der Fehlerstufe <" + n + "> gefunden." + LINEBREAK);
            } else {
                fileWriter.write("Bei der Pr\u00fcfung der Datei wurde kein Fehler gefunden." + LINEBREAK);
            }
            if (fehlerLog.getPruefschluessel() != null && fehlerLog.getPruefschluessel().length() > 0) {
                fileWriter.write("Pruefschluessel: " + fehlerLog.getPruefschluessel() + LINEBREAK);
            }
            fileWriter.close();
        }
        catch (IOException iOException) {
            n = -1;
            iOException.printStackTrace();
        }
        return n == 5 ? 0 : n;
    }

    public void writeReturncodeFile(String string, int n) {
        try {
            FileWriter fileWriter = new FileWriter(string);
            fileWriter.write("" + n);
            fileWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private boolean isOnServer() {
        if (this.onServer == null) {
            try {
                ResourceBundle resourceBundle = ResourceBundle.getBundle(PL_CONFIG_NAME);
                this.onServer = new Boolean(resourceBundle.getString("server"));
            }
            catch (Throwable throwable) {
                this.onServer = Boolean.FALSE;
            }
        }
        return this.onServer;
    }

    private String createCheckKey(String string, String string2, String string3) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null && string.length() >= 12 && string2 != null && string2.length() >= 8 && string3 != null && string3.length() == 18) {
            if (this.isTest()) {
                stringBuffer.append("00000000000T");
            } else {
                stringBuffer.append(string.substring(5, 7));
                stringBuffer.append(string.charAt(8));
                stringBuffer.append(string.substring(10));
                stringBuffer.append(string2.substring(2, 8));
                stringBuffer.append("J");
            }
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private void doPrePlausi(PlausiKontext plausiKontext, String string, String string2) {
        String string3;
        String string4;
        if (!this.isOnServer() && string2 != null && string2.length() >= 12 && string != null && string.length() >= 12 && !(string4 = string.substring(5)).equals(string3 = string2.substring(5, 12).replace(':', '_'))) {
            PlausiFehler plausiFehler = new PlausiFehler();
            plausiFehler.setFehlerId("Parameterfehler");
            plausiFehler.setFehlertextKurz("XML01#1#K Das Element unh_2 enth\u00e4lt nicht die g\u00fcltige Version.");
            plausiKontext.setFehler(plausiFehler);
        }
    }

    private void doPostPlausi(PlausiKontext plausiKontext, String string, String string2, boolean bl) {
        if (bl && this.isOnServer() && string2 != null && string2.length() > 0 && string != null && string.length() > 0) {
            if (string.equals("0") || string.equals("1")) {
                PlausiFehler plausiFehler = new PlausiFehler();
                plausiFehler.setFehlerId("Pr\u00fcfschl\u00fcsselfehler");
                plausiFehler.setFehlertextKurz("ALL03#2 Der in der Nachricht enthaltene Pr\u00fcfschl\u00fcssel " + string + " stimmt nicht mit dem berechneten Pr\u00fcfschl\u00fcssel (" + string2 + ") \u00fcberein.");
                plausiFehler.setReferenzFeld(new SimpleFeldDeskriptor("swh_8", "Pr\u00fcfschl\u00fcssel"));
                plausiKontext.setFehler(plausiFehler);
            } else if (string.length() == 30 && !string.endsWith(string2)) {
                PlausiFehler plausiFehler = new PlausiFehler();
                plausiFehler.setFehlerId("Pr\u00fcfschl\u00fcsselfehler");
                plausiFehler.setFehlertextKurz("ALL03#2 Ihr Bericht konnte nicht an den UV-Tr\u00e4ger weitergeleitet werden." + LINEBREAK + "Sie haben mind. ein unzul\u00e4ssiges Zeichen in Ihrem Bericht verwendet (1) oder die von Ihnen eingesetzte Software hat m\u00f6glicherweise einen Fehler (2)." + LINEBREAK + "Bitte beachten Sie zur Fehlerbehebung folgende Vorgehensweise:" + LINEBREAK + "(1) Als Erstes \u00fcberpr\u00fcfen Sie, ob Sie in Ihrem Bericht unzul\u00e4ssige Sonderzeichen (z.B. EURO-Zeichen) verwendet haben." + LINEBREAK + "Wenn ja, bitte \u00e4ndern Sie diese Zeichen ab (z.B. EURO-Zeichen => Euro) und senden Sie eine Korrektur per DALE-UV." + LINEBREAK + "Zul\u00e4ssige Zeichen in DALE-UV-Berichten sind" + LINEBREAK + "- lateinische Buchstaben (A-Za-z)," + LINEBREAK + "- Nummer (0-9)," + LINEBREAK + "- Satzzeichen (. , ; : ! ? ' \" - () [])," + LINEBREAK + "- sonstige Zeichen (z.B. _ \u00a7 % $ # @)" + LINEBREAK + "(2) Wenn Sie keine unzul\u00e4ssigen Zeichen verwendet haben, handelt es sich m\u00f6glicherweise um einen Fehler in der Software." + LINEBREAK + "Bitte wenden Sie sich in diesem Fall an Ihren Softwarehersteller und geben Sie ihm die Meldung \"inkorrekte Implementierung des Pr\u00fcfmoduls in Zusammenhang mit dem Pr\u00fcfschl\u00fcssel\" weiter.");
                plausiFehler.setReferenzFeld(new SimpleFeldDeskriptor("swh_8", "Pr\u00fcfschl\u00fcssel"));
                plausiKontext.setFehler(plausiFehler);
            }
        }
    }

    private PlausiInterface resolvePlausi(String string, String string2, boolean bl) throws Exception {
        return this.pf.createPlausi(this.resolvePlausiName(string, string2, bl));
    }

    private String resolvePlausiName(String string, String string2, boolean bl) throws Exception {
        String string3 = null;
        String string4 = null;
        int n = -1;
        StringBuffer stringBuffer = new StringBuffer();
        FileReader fileReader = new FileReader(string);
        int n2 = -1;
        while ((n2 = fileReader.read()) > -1) {
            stringBuffer.append((char)n2);
        }
        string4 = stringBuffer.toString();
        int n3 = 0;
        boolean bl2 = true;
        while (string4.indexOf("<", n3) > -1 && bl2) {
            n = string4.indexOf("<", n3);
            if ((n3 = n) == -1) {
                bl2 = false;
                continue;
            }
            if (!("" + string4.charAt(n + 1)).equals("!") && !("" + string4.charAt(n + 1)).equals("?")) {
                int n4 = string4.indexOf(">", n3);
                if (n4 <= -1) continue;
                if (string4.substring(n + 1, n + 6).equals("unh_2")) {
                    string3 = string4.substring(string4.indexOf(">", n + 1) + 1, string4.indexOf("<", n + 1));
                    if (string3.length() > 0) {
                        if (string3.indexOf(58) >= 0) {
                            string3 = string3.substring(0, string3.indexOf(58));
                        }
                        if (bl) {
                            ResourceBundle resourceBundle = ResourceBundle.getBundle(PL_CONFIG_NAME);
                            string3 = string3 + "_" + resourceBundle.getString("plausiversion");
                        } else {
                            string3 = string3 + "_" + string2;
                        }
                    } else {
                        string3 = null;
                    }
                    bl2 = false;
                }
                ++n3;
                continue;
            }
            ++n3;
        }
        return string3;
    }

    private String resolvePlausiName(Document document, String string, boolean bl) {
        Object object;
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("unh_2");
        NodeList nodeList = null;
        Node node = null;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext() && node == null) {
            object = (String)iterator.next();
            nodeList = document.getElementsByTagName((String)object);
            node = nodeList.item(0);
        }
        if (node != null) {
            if (node.getChildNodes() != null && node.getChildNodes().getLength() > 0 && (object = node.getChildNodes().item(0)).getNodeValue() != null) {
                string2 = object.getNodeValue().trim();
            }
            if (string2 != null) {
                if (string2.indexOf(58) >= 0) {
                    string2 = string2.substring(0, string2.indexOf(58));
                }
                if (bl) {
                    object = ResourceBundle.getBundle(PL_CONFIG_NAME);
                    string = ((ResourceBundle)object).getString("plausiversion");
                }
                string2 = string2 + "_" + string;
            }
        }
        return string2;
    }

    private static String resolveDTD(PlausiInterface plausiInterface) throws Exception {
        String string = null;
        Field field = plausiInterface.getClass().getDeclaredField("themenbereich");
        Object object = field.get(plausiInterface);
        Method method = object.getClass().getDeclaredMethod("prg_strukturbeschreibung", PlausiRuntimeContext.class);
        PlausiRuntimeContext plausiRuntimeContext = new PlausiRuntimeContext((BasePlausi)plausiInterface);
        Value value = (Value)method.invoke(object, plausiRuntimeContext);
        string = value.asString();
        return string;
    }

    private String getFeldbeschriftung(PlausiInterface plausiInterface, FeldDeskriptorInterface feldDeskriptorInterface) {
        FeatureVariable featureVariable;
        BasePlausi basePlausi;
        PlausiDescriptor plausiDescriptor;
        String string = feldDeskriptorInterface != null ? (feldDeskriptorInterface instanceof SimpleFeldDeskriptor ? ((SimpleFeldDeskriptor)feldDeskriptorInterface).getBeschriftung() : (plausiInterface != null ? ((plausiDescriptor = (basePlausi = (BasePlausi)plausiInterface).plausiDescriptor()) != null ? ((featureVariable = plausiDescriptor.getFeldDeskriptor(((FeldDeskriptorImpl)feldDeskriptorInterface).hierarchyAsString())) != null ? ((FeldDeskriptorExt)featureVariable.getFeldDeskriptor()).getFeldBezeichnung() : null) : null) : null)) : null;
        return string;
    }

    public FehlerLog createFehlerObjekt(PlausiKontext plausiKontext, PlausiInterface plausiInterface, String string, boolean bl, String string2) {
        FehlerLog fehlerLog = new FehlerLog(string);
        fehlerLog.setPruefschluessel(string2);
        for (int i = 0; i < plausiKontext.getAnzahlFehler(); ++i) {
            Fehler fehler = new Fehler();
            PlausiFehler plausiFehler = plausiKontext.getFehler(i);
            fehler.setFehlerID(plausiFehler.getFehlerId());
            if (plausiFehler.getFehlertextKurz() != null && plausiFehler.getFehlertextKurz().indexOf("#") > -1) {
                fehler.setFehlercode(plausiFehler.getFehlertextKurz().substring(0, plausiFehler.getFehlertextKurz().indexOf("#")));
            } else {
                fehler.setFehlercode(plausiFehler.getFehlertextKurz());
            }
            fehler.setMerkmalstyp(plausiFehler.getMerkmalstyp());
            fehler.setWertlaenge(plausiFehler.getWertlaenge());
            String string3 = plausiFehler.getWertebereich();
            if (string3 != null && "Kommazahl".equals(plausiFehler.getMerkmalstyp()) && (string3 = string3.replace(',', ';')).indexOf(46) >= 0) {
                string3 = string3.replaceAll("(\\d)\\.(\\d)", "$1,$2");
            }
            fehler.setWertebereich(string3);
            fehler.setFehlerInfoTyp(plausiFehler.getFehlerInfoTyp());
            fehler.setReferenzstruktur(plausiFehler.getReferenzTB());
            FeldDeskriptorInterface feldDeskriptorInterface = plausiFehler.getReferenzFeld();
            if (feldDeskriptorInterface != null) {
                fehler.setFeldname(feldDeskriptorInterface.getFeldNameTB());
                fehler.setFeldbeschriftung(this.getFeldbeschriftung(plausiInterface, feldDeskriptorInterface));
            } else {
                FeldDeskriptorInterface[] feldDeskriptorInterfaceArray = plausiFehler.getFelder();
                if (feldDeskriptorInterfaceArray != null && feldDeskriptorInterfaceArray.length > 0) {
                    fehler.setFeldname(feldDeskriptorInterfaceArray[0].getFeldNameTB());
                    fehler.setFeldbeschriftung(this.getFeldbeschriftung(plausiInterface, feldDeskriptorInterfaceArray[0]));
                }
            }
            fehler.setFehlerGewicht("" + plausiFehler.getFehlerGewicht());
            int n = 1;
            try {
                String string4;
                if (plausiFehler.getFehlertextKurz() != null) {
                    n = plausiFehler.getFehlertextKurz().indexOf("#") > -1 ? Integer.parseInt(plausiFehler.getFehlertextKurz().substring(plausiFehler.getFehlertextKurz().indexOf("#") + 1, plausiFehler.getFehlertextKurz().indexOf("#") + 2)) : 2;
                }
                fehler.setFehlerstufe(n);
                if (plausiFehler.getFehlertextKurz() != null) {
                    string4 = plausiFehler.getFehlertextKurz();
                    int n2 = string4.indexOf(32);
                    if (n2 > -1) {
                        string4 = string4.substring(0, n2);
                    }
                    if (string4.length() > 0 && (string4.endsWith("#K") || string4.indexOf("#K#") > -1)) {
                        fehler.setKritisch(true);
                    }
                }
                if (plausiFehler.getFehlerInfoTyp() == 3) {
                    if (bl) {
                        fehler.setFehlercode("ALL17");
                    } else {
                        fehler.setFehlercode("ALL16");
                        fehler.setFehlerstufe(2);
                    }
                    string4 = fehler.getFehlertext_Laengenfehler();
                    if (plausiFehler.getMaske() == null || plausiFehler.getFehlertextKurz() != null) {
                        // empty if block
                    }
                    fehler.setFehlertextKurz(string4);
                } else if (fehler.getFehlerInfoTyp() == 1) {
                    if (!bl) {
                        fehler.setFehlerstufe(2);
                    }
                    fehler.setFehlercode("ALL01");
                    fehler.setFehlertextKurz(fehler.getFehlertext_MerkmalNichtAngegeben());
                } else if (fehler.getFehlerInfoTyp() == 2) {
                    if (bl) {
                        fehler.setFehlercode("ALL15");
                    } else {
                        fehler.setFehlercode("ALL03");
                        fehler.setFehlerstufe(2);
                    }
                    string4 = fehler.getFehlertext_Typfehler();
                    if (plausiFehler.getMaske() != null && plausiFehler.getFehlertextKurz() != null) {
                        string4 = plausiFehler.getFehlertextKurz().substring(plausiFehler.getFehlertextKurz().indexOf(" ") + 1);
                    }
                    fehler.setFehlertextKurz(string4);
                } else if (fehler.getFehlerInfoTyp() == 4) {
                    if (!bl) {
                        fehler.setFehlerstufe(2);
                    }
                    if (plausiFehler.getFehlertextKurz() != null && plausiFehler.getFehlertextKurz().indexOf("#KFZ") > -1) {
                        if (bl) {
                            fehler.setFehlercode("ALL27");
                        } else {
                            fehler.setFehlercode("ALL15");
                        }
                        fehler.setFehlertextKurz(fehler.getFehlertext_UngueltigesLaenderkennzeichenfehler());
                    } else {
                        if (bl) {
                            fehler.setFehlercode("ALL07");
                        } else {
                            fehler.setFehlercode("ALL15");
                        }
                        fehler.setFehlertextKurz(fehler.getFehlertext_Wertebereichsfehler());
                    }
                } else if (plausiFehler.getFehlertextKurz() != null) {
                    if (plausiFehler.getFehlerId() != null && plausiFehler.getFehlerId().startsWith("PROGRAMMFEHLER")) {
                        fehler.setFehlerstufe(1);
                        fehler.setKritisch(true);
                    }
                    if (plausiFehler.getFehlertextKurz().indexOf(" ") > -1) {
                        fehler.setFehlertextKurz(plausiFehler.getFehlertextKurz().substring(plausiFehler.getFehlertextKurz().indexOf(" ") + 1));
                    } else {
                        fehler.setFehlertextKurz("Kein Fehlertext_kurz definiert.");
                    }
                } else {
                    fehler.setFehlertextKurz("Kein Fehlertext_kurz definiert.");
                }
            }
            catch (NullPointerException nullPointerException) {
                nullPointerException.printStackTrace();
            }
            catch (NumberFormatException numberFormatException) {
                numberFormatException.printStackTrace();
            }
            if (plausiFehler.istLaufzeitFehlerAufgetreten() && !(plausiFehler.getLaufzeitException() instanceof ValueConversionException)) {
                fehler.setKritisch(true);
                fehler.setAusnahmefehler(plausiFehler.getLaufzeitException());
            }
            fehlerLog.addFehler(fehler);
        }
        return fehlerLog;
    }

    private String getXMLTextISO_8859_1(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        char[] cArray = string.toCharArray();
        block6: for (int i = 0; i < cArray.length; ++i) {
            switch (cArray[i]) {
                case '<': {
                    stringBuffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    stringBuffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    stringBuffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    stringBuffer.append("&quot;");
                    continue block6;
                }
                default: {
                    stringBuffer.append(cArray[i]);
                }
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        Object object;
        int n = -1;
        boolean bl = false;
        if (stringArray.length > 1 && "-dom".equals(stringArray[stringArray.length - 1])) {
            bl = true;
            object = new String[stringArray.length - 1];
            for (int i = 0; i < ((String[])object).length; ++i) {
                object[i] = stringArray[i];
            }
            stringArray = object;
        }
        if (stringArray.length < 1 || stringArray.length > 6 || stringArray.length == 4 && !stringArray[0].equalsIgnoreCase("-f") || stringArray.length == 6 && !stringArray[0].equalsIgnoreCase("-f")) {
            PlausiPerformer.printCommandLineInfo();
        } else {
            object = null;
            if (stringArray.length == 1) {
                if ("-versionInfo".equals(stringArray[0])) {
                    try {
                        List list = PlausiPerformer.getVersionInfo();
                        StringBuffer stringBuffer = new StringBuffer();
                        stringBuffer.append("Version");
                        stringBuffer.append(";");
                        stringBuffer.append("Nachrichtentyp");
                        stringBuffer.append(";");
                        stringBuffer.append("Lieferdatum");
                        stringBuffer.append(";");
                        stringBuffer.append("Generierungsdatum");
                        stringBuffer.append(System.getProperty("line.separator"));
                        for (int i = 0; i < list.size(); ++i) {
                            PlausiInfo plausiInfo = (PlausiInfo)list.get(i);
                            stringBuffer.append(plausiInfo.getVersion());
                            stringBuffer.append(";");
                            stringBuffer.append(plausiInfo.getBerichtsart());
                            stringBuffer.append(";");
                            stringBuffer.append(plausiInfo.getLieferdatum());
                            stringBuffer.append(";");
                            stringBuffer.append(plausiInfo.getGenerierungsdatum());
                            stringBuffer.append(System.getProperty("line.separator"));
                        }
                        System.out.print(stringBuffer.toString());
                        n = 0;
                    }
                    catch (Exception exception) {
                        PlausiPerformer.printCommandLineInfo();
                        System.out.println("Fehler beim Lesen der Pr\u00fcfmodule");
                        exception.printStackTrace();
                    }
                } else {
                    PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini");
                    object = bl ? plausiPerformer.performPlausiAsDom(stringArray[0]) : plausiPerformer.doPlausi(stringArray[0]);
                    n = plausiPerformer.writeErrorFile(stringArray[0] + "_error.xml", (FehlerLog)object);
                }
            } else if (stringArray.length == 2) {
                PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini");
                object = bl ? plausiPerformer.performPlausiAsDom(stringArray[1]) : plausiPerformer.doPlausi(stringArray[1]);
                n = plausiPerformer.writeErrorFileInOldFormat(stringArray[1] + "_SVC_PR_XMLPRUE.txt", (FehlerLog)object);
                plausiPerformer.writeReturncodeFile(stringArray[0], n);
            } else if (stringArray.length == 3 && stringArray[1].equalsIgnoreCase("-ini")) {
                PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini", stringArray[2]);
                object = bl ? plausiPerformer.performPlausiAsDom(stringArray[0]) : plausiPerformer.doPlausi(stringArray[0]);
                n = plausiPerformer.writeErrorFile(stringArray[0] + "_error.xml", (FehlerLog)object);
            } else if (stringArray.length == 3) {
                PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini", stringArray[2]);
                object = bl ? plausiPerformer.performPlausiAsDom(stringArray[1]) : plausiPerformer.doPlausi(stringArray[1]);
                n = plausiPerformer.writeErrorFileInOldFormat(stringArray[1] + "_SVC_PR_XMLPRUE.txt", (FehlerLog)object);
                plausiPerformer.writeReturncodeFile(stringArray[0], n);
            } else if (stringArray.length == 4) {
                if (stringArray[3].length() == 4) {
                    PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini");
                    object = plausiPerformer.doFeldPlausi(stringArray[1], stringArray[2], stringArray[3]);
                    plausiPerformer.writeErrorFile(((FehlerLog)object).getPlausiVersion() + "_error_feldplausi.xml", (FehlerLog)object);
                } else {
                    System.out.println("FEHLER bei Aufruf der Feldplausi: Nachrichtenname muss vierstellig sein.");
                    System.out.println("Beispiel: DABE");
                }
            } else if (stringArray.length == 6) {
                if (stringArray[3].length() == 4) {
                    PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini", stringArray[5]);
                    object = plausiPerformer.doFeldPlausi(stringArray[1], stringArray[2], stringArray[3]);
                    plausiPerformer.writeErrorFile(((FehlerLog)object).getPlausiVersion() + "_error_feldplausi.xml", (FehlerLog)object);
                } else {
                    System.out.println("FEHLER bei Aufruf der Feldplausi: Nachrichtenname muss vierstellig sein.");
                    System.out.println("Beispiel: DABE");
                }
            }
        }
        System.exit(n);
    }

    public static List getVersionInfo() throws Exception {
        return PlausiInfoUtil.listPackage(DALE_PLAUSI_PACKAGE_NAME);
    }

    private FehlerLog performPlausiAsDom(String string) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            FileInputStream fileInputStream = new FileInputStream(new File(this.inputDirectory, string));
            Document document = documentBuilder.parse(fileInputStream);
            return this.doPlausi(document);
        }
        catch (Exception exception) {
            System.out.println("FEHLER bei Parsen des DOM");
            exception.printStackTrace();
            System.exit(-1);
            return null;
        }
    }

    private static void printCommandLineInfo() {
        System.out.println("Aufruf fuer altes Fehlerformat : PlausiPerformer Returncodedatei Datendateiname [INI-Verzeichnis]");
        System.out.println("Aufruf fuer neues Fehlerformat : PlausiPerformer Datendateiname [-ini INI-Verzeichnis]");
        System.out.println("Aufruf einer Feldplausi        : PlausiPerformer -f FeldnameImXPathformat Wert Nachrichtenname");
        System.out.println("Aufruf einer Feldplausi        : PlausiPerformer -f FeldnameImXPathformat Wert Nachrichtenname [-ini INI-Verzeichnis]");
        System.out.println("Aufruf der Versionsinformation f\u00fcr Pr\u00fcfmodule : PlausiPerformer -versionInfo");
    }

    public boolean isTest() {
        boolean bl = false;
        String string = System.getProperty("daleuv.plausi.test");
        if ("true".equalsIgnoreCase(string)) {
            bl = true;
        }
        return bl;
    }

    public LoggerIfc getLog() {
        return this.log;
    }
}

