/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.test;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.StringTokenizer;

public class EDTWriter
extends PrintStream {
    private int runId = 5000;
    private String date;
    private String year;
    private String month;
    private String day;

    public EDTWriter(int n) throws IOException {
        super(new FileOutputStream("test" + File.separatorChar + "Plausi_DALE_UV_RefDat.xml"));
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMdd");
        this.date = simpleDateFormat.format(new Date());
        this.year = this.date.substring(0, 4);
        this.month = this.date.substring(4, 6);
        this.day = this.date.substring(6);
    }

    public void writeHeader() {
        this.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\" ?>");
        this.println("<edt:plausibility refs=\"id\" xmlns:edt=\"http://www.werum.de/pl-editor\" xmlns:ssp=\"http://www.destatis.de/schema/datml-ssp/1.0\" name=\"\" id=\"\" survey-id=\"\" tb-name=\"\" tb-id=\"\" dsb-name=\"\" dsb-id=\"\" mapping-name=\"\" mapping-id=\"\" raw-set-name=\"\" raw-mapping-name=\"\">");
        this.println("  <ssp:context>");
        this.print("    <ssp:survey id=\"DALEUV_");
        this.print(this.date);
        this.println("\">");
        this.println("      <ssp:surveyID class=\"EVAS\">INTRA</ssp:surveyID>");
        this.println("      <surveyName></surveyName>");
        this.println("      <ssp:referencePeriod>");
        this.println("        <ssp:dateTime>");
        this.print("          <ssp:year>");
        this.print(this.year);
        this.println("</ssp:year>");
        this.println("        </ssp:dateTime>");
        this.println("      </ssp:referencePeriod>");
        this.println("    </ssp:survey>");
        this.println("  </ssp:context>");
        this.println("  <ssp:properties>");
        this.println("    <ssp:about>");
        this.println("      <ssp:description></ssp:description>");
        this.println("    </ssp:about>");
        this.println("    <ssp:author>");
        this.println("      <ssp:fullName>Statspez</ssp:fullName>");
        this.println("    </ssp:author>");
        this.println("    <ssp:date>");
        this.print("      <ssp:year>");
        this.print(this.year);
        this.println("</ssp:year>");
        this.print("      <ssp:month>");
        this.print(this.month);
        this.println("</ssp:month>");
        this.print("      <ssp:day>");
        this.print(this.day);
        this.println("</ssp:day>");
        this.println("    </ssp:date>");
        this.println("    <ssp:time>");
        this.println("    </ssp:time>");
        this.println("    <ssp:annotation></ssp:annotation>");
        this.println("  </ssp:properties>");
        this.println("  <ssp:objectContext>");
        this.println("    <ssp:this>");
        this.print("      <ssp:objectID class=\"\">Erhebung:");
        this.print(this.runId++);
        this.println("</ssp:objectID>");
        this.println("      <ssp:objectName class=\"\">DALE-UV</ssp:objectName>");
        this.println("      <ssp:objectPakage>Intrahandel</ssp:objectPakage>");
        this.println("      <ssp:objectClass>de.statspez.material.Erhebung</ssp:objectClass>");
        this.println("      <ssp:objectVersion class=\"\">1</ssp:objectVersion>");
        this.println("    </ssp:this>");
        this.println("  </ssp:objectContext>");
        this.println("  <edt:specifications>");
    }

    public void writeFooter() {
        this.println("  </edt:specifications>");
        this.print("</edt:plausibility>");
    }

    public void startClassification(String string, String string2) {
        this.print("    <edt:classification id=\"");
        this.print(this.runId);
        this.print("\" name=\"");
        this.print(string);
        this.println("\" state=\"locked\" code-type=\"string\" value-type=\"string\">");
        this.println("      <ssp:properties>");
        this.println("        <ssp:about>");
        this.print("          <ssp:description>");
        this.print(string2);
        this.println("</ssp:description>");
        this.println("        </ssp:about>");
        this.println("        <ssp:author>");
        this.println("          <ssp:fullName>Statspez</ssp:fullName>");
        this.println("        </ssp:author>");
        this.println("        <ssp:date>");
        this.print("          <ssp:year>");
        this.print(this.year);
        this.println("</ssp:year>");
        this.print("          <ssp:month>");
        this.print(this.month);
        this.println("</ssp:month>");
        this.print("          <ssp:day>");
        this.print(this.day);
        this.println("</ssp:day>");
        this.println("        </ssp:date>");
        this.println("        <ssp:time>");
        this.println("        </ssp:time>");
        this.print("        <ssp:annotation>");
        this.print(string2);
        this.println("</ssp:annotation>");
        this.println("      </ssp:properties>");
        this.println("      <ssp:objectContext>");
        this.println("        <ssp:this>");
        this.print("          <ssp:objectID class=\"\">Auspraegungsgruppe:");
        this.print(this.runId++);
        this.println("</ssp:objectID>");
        this.print("          <ssp:objectName class=\"\">");
        this.print(string);
        this.println("</ssp:objectName>");
        this.println("          <ssp:objectPakage>DALE-UV</ssp:objectPakage>");
        this.println("          <ssp:objectClass>de.statspez.material.Auspraegungsgruppe</ssp:objectClass>");
        this.println("          <ssp:objectVersion class=\"\">1</ssp:objectVersion>");
        this.println("        </ssp:this>");
        this.println("      </ssp:objectContext>");
    }

    public void endClassification() {
        this.println("    </edt:classification>");
    }

    public void writeClassificationElement(String string, String string2, String string3, String string4) {
        this.println("      <edt:classificationElement>");
        this.print("        <edt:classificationCode>");
        this.print(string);
        this.println("</edt:classificationCode>");
        this.print("        <edt:classificationValue>");
        this.print(string2);
        this.println("</edt:classificationValue>");
        this.print("        <edt:classificationTextShort>");
        this.print(string3);
        this.println("</edt:classificationTextShort>");
        this.println("        <edt:classificationText>");
        this.print(string4);
        this.println("        </edt:classificationText>");
        this.println("      </edt:classificationElement>");
    }

    public static void main(String[] stringArray) {
        try {
            EDTWriter eDTWriter = new EDTWriter(2006);
            eDTWriter.writeHeader();
            eDTWriter.startClassification("KFZ_KENNZEICHEN", "KFZ_KENNZEICHEN");
            FileReader fileReader = new FileReader("kfzkennzeichen.csv");
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer();
            while ((n = fileReader.read()) > -1) {
                stringBuffer.append((char)n);
            }
            String string = stringBuffer.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ";");
                String string3 = stringTokenizer2.nextToken();
                String string4 = stringTokenizer2.nextToken();
                String string5 = stringTokenizer2.nextToken();
                eDTWriter.writeClassificationElement(string3, string4, string5, string5);
            }
            eDTWriter.endClassification();
            eDTWriter.writeFooter();
            eDTWriter.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

