/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.test;

import de.dale_uv.parser.PlausiPerformer;
import java.io.File;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class PerformanceTest {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] stringArray) {
        try {
            long l;
            boolean bl;
            boolean bl2;
            if (stringArray.length < 3 || stringArray.length > 4) {
                throw new IllegalArgumentException("Es wurde nicht die richtige Anzahl der Parameter angegeben.");
            }
            if (stringArray[0].equalsIgnoreCase("sax")) {
                bl2 = false;
            } else {
                if (!stringArray[0].equalsIgnoreCase("dom")) throw new IllegalArgumentException("Die angegebene Parse-Methode " + stringArray[0] + " ist ungueltig.");
                bl2 = true;
            }
            if (stringArray.length == 4) {
                if (!stringArray[1].equalsIgnoreCase("cache")) throw new IllegalArgumentException("Der angegebene Parameter " + stringArray[1] + " ist ungueltig.");
                bl = true;
            } else {
                bl = false;
            }
            try {
                l = stringArray.length == 3 ? Long.parseLong(stringArray[1]) : Long.parseLong(stringArray[2]);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Die angegebene Anzahl der Wiederholungen " + stringArray[1] + " ist ungueltig.");
            }
            if (l < 1L) {
                throw new IllegalArgumentException("Die angegebene Anzahl der Wiederholungen " + stringArray[1] + " ist ungueltig.");
            }
            String string = stringArray.length == 3 ? stringArray[2] : stringArray[3];
            PlausiPerformer plausiPerformer = new PlausiPerformer();
            long l2 = System.currentTimeMillis();
            if (!bl2) {
                plausiPerformer.doPlausi(string);
                PerformanceTest.printDuration(l2, 0L);
                l2 = System.currentTimeMillis();
                for (long i = 0L; i < l; ++i) {
                    plausiPerformer.doPlausi(string);
                }
            } else {
                File file = new File(string);
                if (!file.exists()) {
                    throw new IllegalArgumentException("Die angegebene XML-Datei " + file.getAbsolutePath() + " existiert nicht.");
                }
                if (!file.isFile()) {
                    throw new IllegalArgumentException("Die angegebene XML-Datei " + file.getAbsolutePath() + " ist ungueltig.");
                }
                DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
                Document document = documentBuilder.parse(file);
                plausiPerformer.doPlausi(document);
                PerformanceTest.printDuration(l2, 0L);
                l2 = System.currentTimeMillis();
                for (long i = 0L; i < l; ++i) {
                    if (!bl) {
                        document = documentBuilder.parse(file);
                    }
                    plausiPerformer.doPlausi(document);
                }
            }
            PerformanceTest.printDuration(l2, l);
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.err.println("Usage: PerformanceTest sax|dom [cache] <Wiederholungen> <XML-Datei>");
            return;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    private static void printDuration(long l, long l2) {
        long l3 = System.currentTimeMillis() - l;
        if (l2 == 0L) {
            System.out.print("Dauer [erste Ausfuehrung]: ");
        } else {
            System.out.print("Dauer [" + l2 + " Wiederholung(en)]: ");
        }
        System.out.print(l3 + " ms");
        if (l3 > 999L) {
            System.out.print(" (" + l3 / 3600000L + ":" + l3 % 3600000L / 60000L + ":" + l3 % 3600000L % 60000L / 1000L + "." + l3 % 3600000L % 60000L % 1000L + ")");
        }
        System.out.println();
        if (l2 > 1L) {
            System.out.println("Mittlere Dauer pro Ausfuehrung: " + l3 / l2 + " ms");
        }
    }
}

