/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.test;

import de.dale_uv.parser.DTDParser;
import de.dale_uv.parser.NodeDef;
import de.statspez.pleditor.generator.interpreter.InterpreterContext;
import de.statspez.pleditor.generator.interpreter.ProgramInterpreter;
import de.statspez.pleditor.generator.meta.AbstractElementVisitor;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.IntermediateLanguageParser;
import de.statspez.pleditor.generator.runtime.Value;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.Vector;

public class PlausiConsistencyTest {
    public static final String TAG_CONSISTENCY_TEST = "consistencyTest";
    public static final String TAG_SOURCE_DIR = "sourceDir";
    public static final String TAG_SEGMENT = "segment";
    public static final String TAG_OCCURRENCES = "occurrences";
    public static final String TAG_ELEMENT = "element";
    public static final String TAG_MESSAGE_TYPE = "messageType";
    public static final String ATTRIBUTE_MESSAGE_TYPE = "message-type";
    public static final String ATTRIBUTE_TYPE = "type";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_VALUE_REQUIRED = "value-required";
    public static final String ATTRIBUTE_TAG_REQUIRED = "tag-required";

    public static void main(String[] stringArray) {
        if (stringArray != null && stringArray.length == 2) {
            PlausiConsistencyTest plausiConsistencyTest = new PlausiConsistencyTest();
            try {
                plausiConsistencyTest.generate(new File(stringArray[0]), new File(stringArray[1]), System.out);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                System.exit(-1);
            }
        } else {
            System.err.println("Aufruf: PlausiIntergrityTest <EDT-Verzeichnis> <XML-Datei>");
            System.exit(-1);
        }
        System.exit(0);
    }

    public void generate(File file, File file2, PrintStream printStream) throws Exception {
        if (file == null) {
            throw new IllegalArgumentException("Das EDT-Verzeichnis wurde nicht angegeben.");
        }
        if (!file.exists()) {
            throw new IllegalArgumentException("Das EDT-Verzeichnis " + file + " existiert nicht.");
        }
        if (!file.isDirectory()) {
            throw new IllegalArgumentException("Das EDT-Verzeichnis " + file + " ist ung\u00fcltig.");
        }
        if (file2 == null) {
            throw new IllegalArgumentException("Die XML-Datei wurde nicht angegeben.");
        }
        if (file2.isDirectory()) {
            throw new IllegalArgumentException("Die XML-Datei " + file2 + " ist ung\u00fcltig.");
        }
        File[] fileArray = file.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().toLowerCase().endsWith(".xml");
            }
        });
        if (fileArray == null || fileArray.length == 0) {
            throw new IllegalArgumentException("Das EDT-Verzeichnis " + file + " enth\u00e4lt keine XML-Dateien.");
        }
        Vector vector = new Vector();
        if (printStream != null) {
            printStream.println("Parse EDT-Dateien in " + file + " ...");
        }
        for (int i = 0; i < fileArray.length; ++i) {
            if (printStream != null) {
                printStream.println(fileArray[i].getName());
            }
            this.parseEdtFile(fileArray[i], vector);
        }
        for (Segment segment : vector) {
            segment.checkForDifferentDefinitions();
        }
        if (printStream != null) {
            printStream.println("Generiere XML-Datei " + file2 + " ...");
        }
        this.printXmlFile(file2, file, vector);
        if (printStream != null) {
            printStream.println("Fertig");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseEdtFile(File file, final Vector vector) throws Exception {
        IntermediateLanguageParser intermediateLanguageParser = new IntermediateLanguageParser();
        FileReader fileReader = new FileReader(file);
        try {
            MetaCustomPlausibilisierung metaCustomPlausibilisierung = (MetaCustomPlausibilisierung)intermediateLanguageParser.parse(fileReader);
            final String string = metaCustomPlausibilisierung.rootThemenbereich().getName().substring(0, 4);
            MetaCustomFunktion metaCustomFunktion = (MetaCustomFunktion)metaCustomPlausibilisierung.rootThemenbereich().getFromFunktionen(0);
            MetaProgram metaProgram = metaCustomFunktion.getMetaSpezifikation();
            ProgramInterpreter programInterpreter = new ProgramInterpreter();
            Value value = programInterpreter.execute(metaProgram, new InterpreterContext());
            final NodeDef nodeDef = DTDParser.getDTDTree(value.asString());
            metaCustomPlausibilisierung.rootThemenbereich().accept(new AbstractElementVisitor(){
                private String segmentName = null;
                private NodeDef node = nodeDef;

                @Override
                public void visitThemenbereich(MetaThemenbereich metaThemenbereich) {
                    Iterator iterator = metaThemenbereich.getFelder();
                    while (iterator.hasNext()) {
                        ((MetaElement)iterator.next()).accept(this);
                    }
                }

                @Override
                public void visitTBFeld(MetaTBFeld metaTBFeld) {
                    String string2 = this.segmentName;
                    NodeDef nodeDef2 = this.node;
                    if (metaTBFeld.getKlasse() instanceof MetaThemenbereich) {
                        this.segmentName = metaTBFeld.getName();
                        this.node = this.node.getChildByName(metaTBFeld.getName());
                    }
                    metaTBFeld.getKlasse().accept(this);
                    this.segmentName = string2;
                    this.node = nodeDef2;
                }

                @Override
                public void visitMerkmal(MetaMerkmal metaMerkmal) {
                    Element element;
                    String string2;
                    Object object3;
                    Object object2 = null;
                    for (Object object3 : vector) {
                        if (!((Segment)object3).name.equals(this.segmentName)) continue;
                        object2 = object3;
                        break;
                    }
                    if (object2 == null) {
                        object2 = new Segment();
                        ((Segment)object2).name = this.segmentName;
                        vector.add(object2);
                    }
                    if ((object3 = ((Segment)object2).getOccurrences(string)) == null) {
                        object3 = new Occurrences();
                        ((Occurrences)object3).messageTypeName = string;
                        ((Occurrences)object3).type = this.node.getFrequency();
                        ((Segment)object2).occurrences.add(object3);
                    }
                    if ((string2 = metaMerkmal.getName()).indexOf(95, 4) > 0) {
                        string2 = string2.substring(0, string2.indexOf(95, 4));
                    }
                    if ((element = ((Segment)object2).getElement(string2)) == null) {
                        element = new Element();
                        element.name = string2;
                        ((Segment)object2).elements.add(element);
                    }
                    NodeDef nodeDef2 = this.node.getChildByName(string2);
                    MessageType messageType = new MessageType();
                    messageType.name = string;
                    messageType.valueRequired = !metaMerkmal.getLeer();
                    messageType.tagRequired = nodeDef2.getFrequency() == 2 || nodeDef2.getFrequency() == 3;
                    element.messageTypes.add(messageType);
                }
            });
        }
        finally {
            fileReader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printXmlFile(File file, File file2, Vector vector) throws IOException {
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file));
        try {
            printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
            printWriter.println("<?xml-stylesheet type=\"text/xsl\" href=\"constistency_test.xsl\"?>");
            printWriter.print("<");
            printWriter.print(TAG_CONSISTENCY_TEST);
            printWriter.println(">");
            printWriter.print("  <");
            printWriter.print(TAG_SOURCE_DIR);
            printWriter.print(">");
            printWriter.print(file2.getAbsolutePath());
            printWriter.print("</");
            printWriter.print(TAG_SOURCE_DIR);
            printWriter.println(">");
            for (Segment segment : vector) {
                printWriter.print("  <");
                printWriter.print(TAG_SEGMENT);
                printWriter.print(" ");
                printWriter.print(ATTRIBUTE_NAME);
                printWriter.print("=\"");
                printWriter.print(segment.name);
                printWriter.println("\">");
                for (Object object : segment.occurrences) {
                    printWriter.print("    <");
                    printWriter.print(TAG_OCCURRENCES);
                    printWriter.print(" ");
                    printWriter.print(ATTRIBUTE_MESSAGE_TYPE);
                    printWriter.print("=\"");
                    printWriter.print(((Occurrences)object).messageTypeName);
                    printWriter.print("\" ");
                    printWriter.print(ATTRIBUTE_TYPE);
                    printWriter.print("=\"");
                    switch (((Occurrences)object).type) {
                        case 2: {
                            printWriter.print("1");
                            break;
                        }
                        case 3: {
                            printWriter.print("1-N");
                            break;
                        }
                        case 0: {
                            printWriter.print("0-1");
                            break;
                        }
                        case 1: {
                            printWriter.print("0-N");
                        }
                    }
                    printWriter.println("\"/>");
                }
                for (Element element : segment.elements) {
                    printWriter.print("    <");
                    printWriter.print(TAG_ELEMENT);
                    printWriter.print(" ");
                    printWriter.print(ATTRIBUTE_NAME);
                    printWriter.print("=\"");
                    printWriter.print(element.name);
                    printWriter.print("\"");
                    if (element.valueRequired != null) {
                        printWriter.print(" ");
                        printWriter.print(ATTRIBUTE_VALUE_REQUIRED);
                        printWriter.print("=\"");
                        printWriter.print(element.valueRequired);
                        printWriter.print("\"");
                    }
                    if (element.tagRequired != null) {
                        printWriter.print(" ");
                        printWriter.print(ATTRIBUTE_TAG_REQUIRED);
                        printWriter.print("=\"");
                        printWriter.print(element.tagRequired);
                        printWriter.print("\"");
                    }
                    if (element.valueRequired == null || element.tagRequired == null) {
                        printWriter.println(">");
                        for (MessageType messageType : element.messageTypes) {
                            printWriter.print("      <");
                            printWriter.print(TAG_MESSAGE_TYPE);
                            printWriter.print(" ");
                            printWriter.print(ATTRIBUTE_NAME);
                            printWriter.print("=\"");
                            printWriter.print(messageType.name);
                            printWriter.print("\" ");
                            printWriter.print(ATTRIBUTE_VALUE_REQUIRED);
                            printWriter.print("=\"");
                            printWriter.print(messageType.valueRequired);
                            printWriter.print("\" ");
                            printWriter.print(ATTRIBUTE_TAG_REQUIRED);
                            printWriter.print("=\"");
                            printWriter.print(messageType.tagRequired);
                            printWriter.println("\"/>");
                        }
                        printWriter.print("    </");
                        printWriter.print(TAG_ELEMENT);
                        printWriter.println(">");
                        continue;
                    }
                    printWriter.println("/>");
                }
                printWriter.print("  </");
                printWriter.print(TAG_SEGMENT);
                printWriter.println(">");
            }
            printWriter.print("</");
            printWriter.print(TAG_CONSISTENCY_TEST);
            printWriter.println(">");
        }
        finally {
            printWriter.close();
        }
    }

    private class MessageType {
        public String name;
        public boolean valueRequired;
        public boolean tagRequired;

        private MessageType() {
        }
    }

    private class Element {
        public String name;
        Boolean valueRequired;
        Boolean tagRequired;
        public Vector messageTypes = new Vector();

        private Element() {
        }

        public void checkForDifferentDefinitions() {
            this.valueRequired = null;
            this.tagRequired = null;
            boolean bl = true;
            for (MessageType messageType : this.messageTypes) {
                if (bl) {
                    this.valueRequired = new Boolean(messageType.valueRequired);
                    this.tagRequired = new Boolean(messageType.tagRequired);
                    bl = false;
                    continue;
                }
                if (this.valueRequired != null && this.valueRequired != messageType.valueRequired) {
                    this.valueRequired = null;
                }
                if (this.tagRequired == null || this.tagRequired == messageType.tagRequired) continue;
                this.tagRequired = null;
            }
        }
    }

    private class Occurrences {
        public String messageTypeName;
        public int type;

        private Occurrences() {
        }
    }

    private class Segment {
        public String name;
        public Vector occurrences = new Vector();
        public Vector elements = new Vector();

        private Segment() {
        }

        public Occurrences getOccurrences(String string) {
            Occurrences occurrences = null;
            for (Occurrences occurrences2 : this.occurrences) {
                if (!occurrences2.messageTypeName.equals(string)) continue;
                occurrences = occurrences2;
                break;
            }
            return occurrences;
        }

        public Element getElement(String string) {
            Element element = null;
            for (Element element2 : this.elements) {
                if (!element2.name.equals(string)) continue;
                element = element2;
                break;
            }
            return element;
        }

        public void checkForDifferentDefinitions() {
            for (Element element : this.elements) {
                element.checkForDifferentDefinitions();
            }
        }
    }
}

