/*
 * Decompiled with CFR 0.152.
 */
package de.dale_uv.test;

import de.dale_uv.parser.FehlerLog;
import de.dale_uv.parser.PlausiPerformer;
import de.statspez.pleditor.generator.runtime.plausi.PlausiFehler;
import de.statspez.pleditor.generator.runtime.plausi.PlausiKontext;
import java.io.File;
import java.util.Arrays;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.xml.sax.SAXParseException;

public class PlausiTest {
    private static final String XML_ENDING = ".xml";

    public static void main(String[] stringArray) {
        try {
            File file;
            boolean bl = false;
            boolean bl2 = false;
            if (stringArray.length != 2 && stringArray.length != 3) {
                throw new IllegalArgumentException("Es wurde nicht die richtige Anzahl der Parameter angegeben.");
            }
            if (stringArray[0].equalsIgnoreCase("sax")) {
                bl = false;
            } else if (stringArray[0].equalsIgnoreCase("dom")) {
                bl = true;
            } else {
                throw new IllegalArgumentException("Die angegebene Parse-Methode " + stringArray[0] + " ist ungueltig.");
            }
            String string = stringArray[1];
            if (stringArray.length == 3 && stringArray[2].equals("old")) {
                bl2 = true;
            }
            if (!(file = new File(string)).isDirectory()) {
                if (!file.exists()) {
                    throw new IllegalArgumentException("Das angegebene Quellverzeichnis " + file.getAbsolutePath() + " existiert nicht.");
                }
                throw new IllegalArgumentException("Das angegebene Quellverzeichnis " + file.getAbsolutePath() + " ist kein Verzeichnis.");
            }
            long l = PlausiTest.testFiles(file, bl, "." + File.separator, 0L, bl2);
            System.out.println(l + " Dateien per " + stringArray[0] + " getestet.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException.getMessage());
            System.err.println("Usage: PlausiTest sax|dom sourceDir");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected static long testFiles(File file, boolean bl, String string, long l, boolean bl2) throws Exception {
        Object[] objectArray = file.listFiles();
        long l2 = l;
        PlausiPerformer plausiPerformer = new PlausiPerformer("daleuv.ini");
        if (objectArray != null) {
            Arrays.sort(objectArray);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object;
                if (((File)objectArray[i]).isDirectory()) {
                    System.out.println("Verzeichnis: " + ((File)objectArray[i]).getName());
                    l2 = PlausiTest.testFiles((File)objectArray[i], bl, string + File.separator + ((File)objectArray[i]).getName(), l2, bl2);
                    continue;
                }
                String string2 = ((File)objectArray[i]).getName();
                if (!string2.endsWith(XML_ENDING)) continue;
                System.out.println(string2);
                if (!bl) {
                    long l3 = System.currentTimeMillis();
                    object = plausiPerformer.doPlausi(((File)objectArray[i]).getName());
                    if (bl2) {
                        plausiPerformer.writeErrorFileInOldFormat(string + File.separator + string2 + "_SVC_PR_XMLPRUE.txt", (FehlerLog)object);
                    } else {
                        plausiPerformer.writeErrorFile(string + File.separator + string2 + "_error.xml", (FehlerLog)object);
                    }
                    PlausiTest.printPlausiDatum((FehlerLog)object);
                    PlausiTest.printDuration(l3);
                } else {
                    Object object2;
                    Document document = null;
                    try {
                        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
                        object = documentBuilderFactory.newDocumentBuilder();
                        long l4 = System.currentTimeMillis();
                        document = ((DocumentBuilder)object).parse(((File)objectArray[i]).toURI().toString());
                        System.out.print("Parsvorgang beendet. ");
                        PlausiTest.printDuration(l4);
                    }
                    catch (SAXParseException sAXParseException) {
                        object = new PlausiKontext();
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("XML-Fehler");
                        object2 = "";
                        if (!plausiPerformer.isTest()) {
                            object2 = sAXParseException.getMessage() + " ";
                        }
                        plausiFehler.setFehlertextKurz("XML01#1#K " + (String)object2 + "(Zeile:" + sAXParseException.getLineNumber() + ", Spalte:" + sAXParseException.getColumnNumber() + ")");
                        ((PlausiKontext)object).setFehler(plausiFehler);
                        FehlerLog fehlerLog = plausiPerformer.createFehlerObjekt((PlausiKontext)object, null, ((File)objectArray[i]).getAbsolutePath(), false, null);
                        if (plausiPerformer.getLog() != null) {
                            plausiPerformer.getLog().error("Fehler beim Parsen.", sAXParseException);
                        } else {
                            sAXParseException.printStackTrace();
                        }
                        if (bl2) {
                            plausiPerformer.writeErrorFileInOldFormat(string + File.separator + string2 + "_SVC_PR_XMLPRUE.txt", fehlerLog);
                        } else {
                            plausiPerformer.writeErrorFile(string + File.separator + string2 + "_error.xml", fehlerLog);
                        }
                        document = null;
                    }
                    catch (Exception exception) {
                        object = new PlausiKontext();
                        PlausiFehler plausiFehler = new PlausiFehler();
                        plausiFehler.setFehlerId("Ausnahmefehler");
                        plausiFehler.setFehlertextKurz("PROGRAMMFEHLER01#1#K Es ist ein Ausnahmefehler aufgetreten.");
                        if (!plausiPerformer.isTest()) {
                            plausiFehler.setLaufzeitFehlerAufgetreten(true);
                            plausiFehler.setLaufzeitException(exception);
                        }
                        ((PlausiKontext)object).setFehler(plausiFehler);
                        object2 = plausiPerformer.createFehlerObjekt((PlausiKontext)object, null, ((File)objectArray[i]).getAbsolutePath(), false, null);
                        if (plausiPerformer.getLog() != null) {
                            plausiPerformer.getLog().error("Fehler beim Pr\u00fcfen.", exception);
                        } else {
                            exception.printStackTrace();
                        }
                        if (bl2) {
                            plausiPerformer.writeErrorFileInOldFormat(string + File.separator + string2 + "_SVC_PR_XMLPRUE.txt", (FehlerLog)object2);
                        } else {
                            plausiPerformer.writeErrorFile(string + File.separator + string2 + "_error.xml", (FehlerLog)object2);
                        }
                        document = null;
                    }
                    if (document != null) {
                        long l5 = System.currentTimeMillis();
                        FehlerLog fehlerLog = plausiPerformer.doPlausi(document);
                        fehlerLog.setDatenquelle(((File)objectArray[i]).getAbsolutePath());
                        if (bl2) {
                            plausiPerformer.writeErrorFileInOldFormat(string + File.separator + string2 + "_SVC_PR_XMLPRUE.txt", fehlerLog);
                        } else {
                            plausiPerformer.writeErrorFile(string + File.separator + string2 + "_error.xml", fehlerLog);
                        }
                        PlausiTest.printPlausiDatum(fehlerLog);
                        PlausiTest.printDuration(l5);
                    }
                }
                ++l2;
            }
        }
        return l2;
    }

    public static void printDuration(long l) {
        long l2 = System.currentTimeMillis() - l;
        System.out.print("Dauer: ");
        System.out.print(l2 + " ms");
        if (l2 > 999L) {
            System.out.print(" (" + l2 / 3600000L + ":" + l2 % 3600000L / 60000L + ":" + l2 % 3600000L % 60000L / 1000L + "." + l2 % 3600000L % 60000L % 1000L + ")");
        }
        System.out.println();
    }

    public static void printPlausiDatum(FehlerLog fehlerLog) {
        System.out.println("fehlerLog.getPlausiDatum(): " + fehlerLog.getPlausiDatum());
        System.out.println("fehlerLog.getPlausiDatumDatei(): " + fehlerLog.getPlausiDatumDatei());
        System.out.println("fehlerLog.isPlausiDatumGleich(): " + fehlerLog.isPlausiDatumGleich());
    }
}

