/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.logger;

import de.werum.sis.logger.LoggerIfc;

public abstract class GeneralLogger
implements LoggerIfc {
    int logLevel = -1;
    boolean noDebug = false;
    boolean noInfo = false;
    boolean noTest = false;

    public GeneralLogger(int n) {
        this.setLogLevel(n);
    }

    @Override
    public void setLogLevel(int n) {
        this.logLevel = n;
        if (this.logLevel == 20) {
            this.noInfo = false;
            this.noDebug = true;
            this.noTest = true;
        } else if (this.logLevel == 30) {
            this.noDebug = false;
            this.noInfo = false;
            this.noTest = true;
        } else if (this.logLevel == 10) {
            this.noDebug = true;
            this.noInfo = true;
            this.noTest = true;
        } else if (this.logLevel == 40) {
            this.noDebug = false;
            this.noInfo = false;
            this.noTest = false;
        }
    }

    @Override
    public int getLogLevel() {
        return this.logLevel;
    }

    public String throwableToString(Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("\n[").append(throwable.getClass().getName()).append("] ");
        stringBuffer.append(throwable.getMessage() + "\nStackTrace: \n");
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            stringBuffer.append("    ").append(stackTraceElementArray[i]).append("\n");
        }
        return stringBuffer.toString();
    }
}

