/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codeassist;

import de.statspez.pleditor.generator.codeassist.CodeAssistantResult;
import de.statspez.pleditor.generator.codeassist.CustomSyntaxElement;
import de.statspez.pleditor.generator.codeassist.SyntaxElement;
import de.statspez.pleditor.generator.codeassist.SyntaxKeyword;
import de.statspez.pleditor.generator.codeassist.SyntaxTemplate;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptor;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.SymbolDescriptor;
import de.statspez.pleditor.generator.meta.InternalFunctions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;

public class CodeAssistant {
    public static final int SCOPE_TYPE_FUNKTION = 1;
    public static final int SCOPE_TYPE_EIGENSCHAFT = 2;
    public static final int SCOPE_TYPE_PRUEFUNG = 3;
    public static final int SCOPE_TYPE_ABLAUF = 4;
    public static final int SCOPE_TYPE_WERTEBEREICH = 5;
    public static final int SCOPE_TYPE_MAPPING = 6;
    public static final int SCOPE_TYPE_MASCH_KORREKTUR = 7;
    public static final int SCOPE_TYPE_STRUKTURMODELL_BEDINGUNG = 8;
    public static final int SCOPE_TYPE_STRUKTURMODELL_FUNKTION = 9;
    private static final int SCOPE_TYPE_LIMITED = 0;
    private int[] relatedTypes = null;
    private int lastWhiteSpacePos;
    private String codeBeforeWhiteSpace;
    private String prefix;
    private String filter;
    private String context;
    private List localVars;
    private List plParameter;
    private List ablaeufe;
    private List auspraegungen;
    private List eigenschaften;
    private List funktionen;
    private List pruefungen;
    private List tbFelder;
    private List themenbereiche;
    private List plVariablen;
    private List initwerte;
    private List materialreferenzen;
    private List dsbFelder;
    private List dsbStrukturen;
    private List sdfFelder;
    private List sdfStrukturen;
    private List sdfKontextfelder;
    private List sdfKontextstrukturen;

    public CodeAssistantResult computeChoices(ScopeImpl scope, int scopeType, CustomSyntaxElement[] customChoices, String code, int offset) {
        this.localVars = new ArrayList();
        this.ablaeufe = new ArrayList();
        this.auspraegungen = new ArrayList();
        this.eigenschaften = new ArrayList();
        this.funktionen = new ArrayList();
        this.initwerte = new ArrayList();
        this.materialreferenzen = new ArrayList();
        this.plParameter = new ArrayList();
        this.plVariablen = new ArrayList();
        this.pruefungen = new ArrayList();
        this.tbFelder = new ArrayList();
        this.themenbereiche = new ArrayList();
        this.dsbFelder = new ArrayList();
        this.dsbStrukturen = new ArrayList();
        this.sdfFelder = new ArrayList();
        this.sdfStrukturen = new ArrayList();
        this.sdfKontextfelder = new ArrayList();
        this.sdfKontextstrukturen = new ArrayList();
        ArrayList<SyntaxElement> templates = new ArrayList<SyntaxElement>();
        ArrayList<SyntaxElement> keywords = new ArrayList<SyntaxElement>();
        this.setReleatedTypes(SyntaxElement.getRelatedTypes(scopeType));
        char[] relatedCodeFragment = code.substring(0, offset).toCharArray();
        scopeType = this.updateLastWhiteSpacePos(relatedCodeFragment, scopeType);
        this.updateIdentifierInfo(relatedCodeFragment);
        this.updateLocalVarInfo(relatedCodeFragment);
        if (scope != null) {
            Hashtable scopeDump = scope.dumpToHashtable();
            Enumeration enumeration = scopeDump.keys();
            while (enumeration.hasMoreElements()) {
                String currentKey = (String)enumeration.nextElement();
                Map map = (Map)scopeDump.get(currentKey);
                SymbolDescriptor sd = (SymbolDescriptor)map.get("SymbolDescriptor");
                SymbolDescriptor rootSd = null;
                int secondIndexOfDot = currentKey.indexOf(46, currentKey.indexOf(46) + 1);
                if (secondIndexOfDot > 0) {
                    Map rootMap = (Map)scopeDump.get(currentKey.substring(0, secondIndexOfDot));
                    rootSd = (SymbolDescriptor)rootMap.get("SymbolDescriptor");
                }
                if (rootSd != null && rootSd.isMaterial()) continue;
                this.addSyntaxElement(currentKey, sd);
            }
            if (scopeType != 0) {
                SyntaxElement[] syntaxElements = SyntaxTemplate.getRelatedTemplates(scopeType);
                if (syntaxElements != null) {
                    int i = 0;
                    while (i < syntaxElements.length) {
                        if (syntaxElements[i].getReplaceText().toLowerCase().startsWith(this.filter)) {
                            templates.add(syntaxElements[i]);
                        }
                        ++i;
                    }
                }
                if ((syntaxElements = SyntaxKeyword.getRelatedKeywords(scopeType)) != null) {
                    int i = 0;
                    while (i < syntaxElements.length) {
                        if (syntaxElements[i].getReplaceText().toLowerCase().startsWith(this.filter)) {
                            keywords.add(syntaxElements[i]);
                        }
                        ++i;
                    }
                }
            }
        }
        Collections.sort(this.localVars);
        Collections.sort(this.ablaeufe);
        Collections.sort(this.auspraegungen);
        Collections.sort(this.eigenschaften);
        Collections.sort(this.funktionen);
        Collections.sort(this.initwerte);
        Collections.sort(this.materialreferenzen);
        Collections.sort(this.plParameter);
        Collections.sort(this.plVariablen);
        Collections.sort(this.pruefungen);
        Collections.sort(this.tbFelder);
        Collections.sort(this.themenbereiche);
        Collections.sort(templates);
        Collections.sort(keywords);
        Collections.sort(this.dsbFelder);
        Collections.sort(this.dsbStrukturen);
        Collections.sort(this.sdfFelder);
        Collections.sort(this.sdfStrukturen);
        Collections.sort(this.sdfKontextfelder);
        Collections.sort(this.sdfKontextstrukturen);
        if (customChoices != null && customChoices.length > 0) {
            int i = 0;
            while (i < customChoices.length) {
                if (this.isTypeRelated(customChoices[i].getType()) && (this.filter.length() == 0 || this.filter.startsWith(customChoices[i].getReplaceText()))) {
                    switch (customChoices[i].getType()) {
                        case 1: {
                            this.localVars.add(customChoices[i]);
                            break;
                        }
                        case 2: {
                            this.ablaeufe.add(customChoices[i]);
                            break;
                        }
                        case 3: 
                        case 4: {
                            this.auspraegungen.add(customChoices[i]);
                            break;
                        }
                        case 5: {
                            this.eigenschaften.add(customChoices[i]);
                            break;
                        }
                        case 7: {
                            this.funktionen.add(customChoices[i]);
                            break;
                        }
                        case 10: {
                            this.initwerte.add(customChoices[i]);
                            break;
                        }
                        case 9: {
                            this.materialreferenzen.add(customChoices[i]);
                            break;
                        }
                        case 11: {
                            this.plParameter.add(customChoices[i]);
                            break;
                        }
                        case 12: {
                            this.plVariablen.add(customChoices[i]);
                            break;
                        }
                        case 13: {
                            this.pruefungen.add(customChoices[i]);
                            break;
                        }
                        case 6: {
                            this.tbFelder.add(customChoices[i]);
                            break;
                        }
                        case 14: {
                            this.themenbereiche.add(customChoices[i]);
                            break;
                        }
                        case 16: {
                            templates.add(customChoices[i]);
                            break;
                        }
                        case 15: {
                            keywords.add(customChoices[i]);
                            break;
                        }
                        case 17: {
                            this.dsbFelder.add(customChoices[i]);
                            break;
                        }
                        case 18: 
                        case 19: {
                            this.dsbStrukturen.add(customChoices[i]);
                            break;
                        }
                        case 20: {
                            this.sdfFelder.add(customChoices[i]);
                            break;
                        }
                        case 21: {
                            this.sdfStrukturen.add(customChoices[i]);
                            break;
                        }
                        case 22: {
                            this.sdfKontextfelder.add(customChoices[i]);
                            break;
                        }
                        case 23: {
                            this.sdfKontextstrukturen.add(customChoices[i]);
                        }
                    }
                }
                ++i;
            }
        }
        ArrayList<SyntaxElement> list = new ArrayList<SyntaxElement>();
        list.addAll(this.dsbFelder);
        list.addAll(this.dsbStrukturen);
        list.addAll(this.sdfKontextfelder);
        list.addAll(this.sdfKontextstrukturen);
        list.addAll(this.sdfFelder);
        list.addAll(this.sdfStrukturen);
        list.addAll(this.localVars);
        list.addAll(this.plParameter);
        list.addAll(this.plVariablen);
        list.addAll(this.initwerte);
        list.addAll(this.tbFelder);
        list.addAll(this.themenbereiche);
        list.addAll(this.materialreferenzen);
        list.addAll(this.eigenschaften);
        list.addAll(this.funktionen);
        list.addAll(this.pruefungen);
        list.addAll(this.ablaeufe);
        list.addAll(templates);
        list.addAll(keywords);
        list.addAll(this.auspraegungen);
        return new CodeAssistantResult(list, this.lastWhiteSpacePos);
    }

    private void setReleatedTypes(int[] relatedTypes) {
        this.relatedTypes = relatedTypes;
    }

    private boolean isTypeRelated(int type) {
        if (this.relatedTypes != null) {
            int i = 0;
            while (i < this.relatedTypes.length) {
                if (this.relatedTypes[i] == type) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void updateLocalVarInfo(char[] code) {
        if (this.isTypeRelated(1)) {
            this.localVars = new ArrayList();
            StringBuffer codeBuf = new StringBuffer(code.length);
            boolean readCode = true;
            int i = 0;
            while (i < this.lastWhiteSpacePos) {
                if (code[i] == '\"') {
                    readCode = !readCode;
                } else if (readCode) {
                    codeBuf.append(code[i]);
                }
                ++i;
            }
            String cleanCode = codeBuf.toString();
            if (cleanCode.length() > 0) {
                StringTokenizer wordTokenizer = new StringTokenizer(cleanCode);
                if (!wordTokenizer.hasMoreTokens()) {
                    return;
                }
                String word = wordTokenizer.nextToken();
                do {
                    if (word.equals("VAR")) {
                        boolean withinDeclaration = true;
                        boolean commaExpected = false;
                        block2: while (withinDeclaration && wordTokenizer.hasMoreTokens()) {
                            word = wordTokenizer.nextToken();
                            StringTokenizer varTokenizer = new StringTokenizer(word, ",", true);
                            while (varTokenizer.hasMoreTokens()) {
                                String var = varTokenizer.nextToken();
                                if (var.equals(",")) {
                                    if (!commaExpected) {
                                        withinDeclaration = false;
                                        continue block2;
                                    }
                                    commaExpected = false;
                                    continue;
                                }
                                if (commaExpected) {
                                    withinDeclaration = false;
                                    continue block2;
                                }
                                commaExpected = true;
                                if (!var.toLowerCase().startsWith(this.filter)) continue;
                                SyntaxElement element = new SyntaxElement(1, var, var);
                                this.localVars.add(element);
                            }
                        }
                    } else {
                        word = wordTokenizer.hasMoreTokens() ? wordTokenizer.nextToken() : null;
                    }
                } while (word != null);
            }
        }
    }

    private int updateLastWhiteSpacePos(char[] code, int scopeType) {
        int newScopeType = scopeType;
        this.codeBeforeWhiteSpace = "";
        this.lastWhiteSpacePos = this.getLastWhiteSpacePos(code);
        if (this.lastWhiteSpacePos > 0) {
            this.codeBeforeWhiteSpace = new String(code, 0, this.lastWhiteSpacePos).trim();
            if (this.isFieldCheckContext()) {
                this.setReleatedTypes(new int[]{6, 14});
                newScopeType = 0;
            } else if (this.isFlowContext()) {
                this.setReleatedTypes(new int[]{2});
                newScopeType = 0;
            } else if (this.isTopicContext()) {
                this.setReleatedTypes(new int[]{14, 2});
                newScopeType = 0;
            } else if (this.isFunctionContext()) {
                this.setReleatedTypes(new int[]{7, 8, 14});
                newScopeType = 0;
            } else if (this.isPropertyContext()) {
                this.setReleatedTypes(new int[]{5, 14});
                newScopeType = 0;
            } else if (this.isCheckContext()) {
                this.setReleatedTypes(new int[]{13, 14});
                newScopeType = 0;
            } else if (this.isVarContext()) {
                this.setReleatedTypes(null);
                newScopeType = 0;
            } else if (this.isMaterialContext()) {
                this.setReleatedTypes(new int[]{9});
                newScopeType = 0;
            }
        }
        return newScopeType;
    }

    private int getLastWhiteSpacePos(char[] code) {
        int result = 0;
        int i = 0;
        while (i < code.length) {
            switch (code[i]) {
                case '\"': {
                    int pos = this.goToEndOfBlock('\"', code, i);
                    if (pos > -1) {
                        i = pos;
                        result = i + 1;
                        break;
                    }
                    i = code.length - 1;
                    break;
                }
                case '\'': {
                    int pos = this.goToEndOfBlock('\'', code, i);
                    if (pos > -1) {
                        i = pos;
                        result = i + 1;
                        break;
                    }
                    i = code.length - 1;
                    break;
                }
                case '[': {
                    int pos = this.goToEndOfBlock(']', code, i);
                    if (pos > -1) {
                        i = pos;
                        break;
                    }
                    String blockCode = new String(code, i + 1, code.length - (i + 1));
                    pos = this.getLastWhiteSpacePos(blockCode.toCharArray());
                    if (pos > -1) {
                        result = i + pos + 1;
                    }
                    i = code.length - 1;
                    break;
                }
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': 
                case '&': 
                case '(': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '/': 
                case ';': 
                case '<': 
                case '=': 
                case '>': {
                    result = i + 1;
                }
            }
            ++i;
        }
        return result;
    }

    private void updateIdentifierInfo(char[] code) {
        StringBuffer buffer = new StringBuffer();
        int i = this.lastWhiteSpacePos;
        while (i < code.length) {
            switch (code[i]) {
                case '[': {
                    int endOfBlock = this.goToEndOfBlock(']', code, i);
                    if (endOfBlock > -1) {
                        i = endOfBlock;
                        break;
                    }
                    i = code.length - 1;
                    break;
                }
                default: {
                    buffer.append(code[i]);
                }
            }
            ++i;
        }
        this.prefix = new String(code, this.lastWhiteSpacePos, code.length - this.lastWhiteSpacePos);
        this.prefix = this.prefix.indexOf(46) > 0 ? this.prefix.substring(0, this.prefix.lastIndexOf(46) + 1) : "";
        this.filter = buffer.toString().toLowerCase();
        this.checkForWithOperator(code);
    }

    private boolean isFieldCheckContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.FELD.getReplaceText());
    }

    private boolean isFlowContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.ABLAUF.getReplaceText());
    }

    private boolean isTopicContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.THEMENBEREICH.getReplaceText());
    }

    private boolean isFunctionContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.FUNKTION.getReplaceText()) || this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.AMP.getReplaceText());
    }

    private boolean isCheckContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.PRUEFE.getReplaceText());
    }

    private boolean isPropertyContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.EIGENSCHAFT.getReplaceText()) || this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.IST.getReplaceText());
    }

    private boolean isVarContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.VAR.getReplaceText());
    }

    private boolean isMaterialContext() {
        return this.codeBeforeWhiteSpace.endsWith(SyntaxKeyword.MATERIAL.getReplaceText());
    }

    private void addSyntaxElement(String key, SymbolDescriptor sd) {
        String text = key.substring(key.indexOf(46) + 1);
        String completeFilter = this.context.length() > 0 && (sd.isTbField() || sd.isPruefung() || sd.isEigenschaft() || sd.isFunction() && !InternalFunctions.instance().isInternalFunction(text)) ? String.valueOf(this.context) + "." + this.filter : this.filter;
        if (text.toLowerCase().startsWith(completeFilter) && (text = text.substring(completeFilter.lastIndexOf(46) + 1)).indexOf(46) < 0) {
            if (sd.isTbField()) {
                if (sd.fieldReferencesTb()) {
                    List list;
                    int syntaxElementTyp;
                    if (sd.isDsbKontext()) {
                        syntaxElementTyp = sd.isDsbSatzart() ? 19 : 18;
                        list = this.dsbStrukturen;
                    } else if (sd.isSdfKontext()) {
                        if (sd.isSdfKontextdaten()) {
                            syntaxElementTyp = 23;
                            list = this.sdfKontextstrukturen;
                        } else {
                            syntaxElementTyp = 21;
                            list = this.sdfStrukturen;
                        }
                    } else {
                        syntaxElementTyp = 14;
                        list = this.themenbereiche;
                    }
                    if (this.isTypeRelated(syntaxElementTyp)) {
                        SyntaxElement element = new SyntaxElement(syntaxElementTyp, text, String.valueOf(this.prefix) + text);
                        if (sd.isArray()) {
                            element.setDisplayText(String.valueOf(element.getDisplayText()) + "[]");
                            element.setReplaceText(String.valueOf(element.getReplaceText()) + "[]");
                            element.setCaretPosition(element.getCaretPosition() - 1);
                        }
                        list.add(element);
                    }
                } else {
                    List list;
                    int syntaxElementTyp;
                    if (sd.isDsbKontext()) {
                        syntaxElementTyp = 17;
                        list = this.dsbFelder;
                    } else if (sd.isSdfKontext()) {
                        if (sd.isSdfKontextdaten()) {
                            syntaxElementTyp = 22;
                            list = this.sdfKontextfelder;
                        } else {
                            syntaxElementTyp = 20;
                            list = this.sdfFelder;
                        }
                    } else {
                        syntaxElementTyp = 6;
                        list = this.tbFelder;
                    }
                    if (this.isTypeRelated(syntaxElementTyp)) {
                        SyntaxElement element = new SyntaxElement(syntaxElementTyp, text, String.valueOf(this.prefix) + text);
                        if (sd.isArray()) {
                            element.setDisplayText(String.valueOf(element.getDisplayText()) + "[]");
                            element.setReplaceText(String.valueOf(element.getReplaceText()) + "[]");
                            element.setCaretPosition(element.getCaretPosition() - 1);
                        }
                        list.add(element);
                    }
                }
            } else if (sd.isEigenschaft()) {
                if (this.isTypeRelated(5)) {
                    SyntaxElement element = new SyntaxElement(5, text, String.valueOf(this.prefix) + text);
                    if (!this.isPropertyContext()) {
                        element.setReplaceText(String.valueOf(SyntaxKeyword.IST.getReplaceText()) + " " + element.getReplaceText());
                    }
                    this.eigenschaften.add(element);
                }
            } else if (sd.isPruefung()) {
                if (this.isTypeRelated(13)) {
                    SyntaxElement element = new SyntaxElement(13, text, String.valueOf(this.prefix) + text);
                    if (!this.isCheckContext()) {
                        element.setReplaceText(String.valueOf(SyntaxKeyword.PRUEFE.getReplaceText()) + " " + element.getReplaceText());
                    }
                    this.pruefungen.add(element);
                }
            } else if (sd.isAblauf()) {
                if (this.isTypeRelated(2)) {
                    SyntaxElement element = new SyntaxElement(2, text, String.valueOf(this.prefix) + text);
                    if (!this.isTopicContext()) {
                        if (!this.isFlowContext()) {
                            if (element.getReplaceText().indexOf(46) < 0) {
                                element.setReplaceText(String.valueOf(SyntaxKeyword.ABLAUF.getReplaceText()) + " " + element.getReplaceText());
                            } else {
                                String replacedText = element.getReplaceText();
                                String structure = replacedText.substring(0, replacedText.lastIndexOf(46));
                                String flow = replacedText.substring(replacedText.lastIndexOf(46) + 1);
                                element.setReplaceText(String.valueOf(SyntaxKeyword.THEMENBEREICH.getReplaceText()) + " " + structure + " " + SyntaxKeyword.MIT.getReplaceText() + " " + SyntaxKeyword.ABLAUF.getReplaceText() + " " + flow);
                            }
                        }
                    } else if (element.getReplaceText().indexOf(46) < 0) {
                        this.lastWhiteSpacePos = this.codeBeforeWhiteSpace.length() - SyntaxKeyword.THEMENBEREICH.getReplaceText().length();
                        element.setReplaceText(String.valueOf(SyntaxKeyword.ABLAUF.getReplaceText()) + " " + element.getReplaceText());
                    } else {
                        String replacedText = element.getReplaceText();
                        String structure = replacedText.substring(0, replacedText.lastIndexOf(46));
                        String flow = replacedText.substring(replacedText.lastIndexOf(46) + 1);
                        element.setReplaceText(String.valueOf(structure) + " " + SyntaxKeyword.MIT.getReplaceText() + " " + SyntaxKeyword.ABLAUF.getReplaceText() + " " + flow);
                    }
                    this.ablaeufe.add(element);
                }
            } else if (sd.isFunction()) {
                SyntaxElement element = InternalFunctions.instance().isInternalFunction(text) ? new SyntaxElement(8, String.valueOf(text) + "()", String.valueOf(this.prefix) + text) : new SyntaxElement(7, String.valueOf(text) + "()", String.valueOf(this.prefix) + text);
                if (!this.isFunctionContext()) {
                    element.setReplaceText(String.valueOf(SyntaxKeyword.FUNKTION.getReplaceText()) + " " + element.getReplaceText());
                }
                if (sd.numberOfFunctionParameters() > 0) {
                    int caretPosition = element.getCaretPosition();
                    int selectionLength = element.getSelectionLength();
                    StringBuffer parameter = new StringBuffer("(");
                    int i = 0;
                    while (i < sd.numberOfFunctionParameters()) {
                        SymbolDescriptor paramSd = sd.functionParameterAt(i);
                        parameter.append("<");
                        if (paramSd.getDisplayName() != null && paramSd.getDisplayName().length() > 0) {
                            parameter.append(paramSd.getDisplayName());
                        } else {
                            parameter.append("Parameter");
                            if (sd.numberOfFunctionParameters() > 1) {
                                parameter.append(i + 1);
                            }
                        }
                        parameter.append(">");
                        if (i == 0) {
                            selectionLength = parameter.length() - 1;
                        }
                        if (i < sd.numberOfFunctionParameters() - 1) {
                            parameter.append(", ");
                        }
                        ++i;
                    }
                    parameter.append(")");
                    element.setReplaceText(String.valueOf(element.getReplaceText()) + parameter.toString());
                    element.setCaretPosition(caretPosition + 1);
                    element.setSelectionLength(selectionLength);
                } else {
                    element.setReplaceText(String.valueOf(element.getReplaceText()) + "()");
                }
                if (this.isTypeRelated(element.getType())) {
                    this.funktionen.add(element);
                }
            } else if (sd.isHilfsvariable()) {
                if (this.isTypeRelated(12)) {
                    this.plVariablen.add(new SyntaxElement(12, text, String.valueOf(this.prefix) + text));
                }
            } else if (sd.isInitwert()) {
                if (this.isTypeRelated(10)) {
                    this.initwerte.add(new SyntaxElement(10, text, String.valueOf(this.prefix) + text));
                }
            } else if (sd.isParameter()) {
                if (this.isTypeRelated(11)) {
                    this.plParameter.add(new SyntaxElement(11, text, String.valueOf(this.prefix) + text));
                }
            } else if (sd.isClassificationGroup()) {
                if (this.isTypeRelated(4)) {
                    this.auspraegungen.add(new SyntaxElement(4, text.substring(1), String.valueOf(this.prefix) + text));
                }
            } else if (sd.isClassification()) {
                if (this.isTypeRelated(3)) {
                    this.auspraegungen.add(new SyntaxElement(3, text, String.valueOf(this.prefix) + text));
                }
            } else if (sd.isMaterial() && sd.isReference()) {
                if (this.isTypeRelated(9)) {
                    SyntaxElement element = new SyntaxElement(9, text, String.valueOf(this.prefix) + text);
                    if (!this.isMaterialContext()) {
                        element.setReplaceText(String.valueOf(SyntaxKeyword.MATERIAL.getReplaceText()) + " " + element.getReplaceText());
                    }
                    this.materialreferenzen.add(element);
                }
            } else {
                System.err.println("Unbekannter Typ in " + sd.getClass() + "(Typmaske: " + ((GenericSymbolDescriptor)sd).type() + ")");
            }
        }
    }

    private void checkForWithOperator(char[] code) {
        this.context = "";
        int index = code.length;
        StringBuffer buf = new StringBuffer();
        while ((index = this.getIndexOfWithBlock(code, index)) > -1) {
            index = this.readStructureNameOfWithBlock(code, index, buf);
            if (this.context.length() > 0) {
                buf.append('.');
            }
            buf.append(this.context);
            this.context = buf.toString().toLowerCase();
            buf.setLength(0);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getIndexOfWithBlock(char[] code, int index) {
        Vector<String> tokens = new Vector<String>();
        StringBuffer buf = new StringBuffer();
        boolean codeEndsWithWhiteSpaceChar = false;
        block6: while (index > 0) {
            if (--index == code.length - 1) {
                codeEndsWithWhiteSpaceChar = this.isWhiteSpaceChar(code[index]);
            }
            switch (code[index]) {
                case ')': {
                    index = this.goToStartOfBlock('(', code, index);
                    break;
                }
                case ']': {
                    index = this.goToStartOfBlock('[', code, index);
                    break;
                }
                case '}': {
                    index = this.goToStartOfBlock('{', code, index);
                    break;
                }
                case '\"': {
                    index = this.goToStartOfBlock('\"', code, index);
                    break;
                }
                default: {
                    if (this.isWhiteSpaceChar(code[index])) {
                        String identifer = buf.toString();
                        if (identifer.equals(SyntaxKeyword.GLOBAL.getReplaceText()) || identifer.equals(SyntaxKeyword.MATERIAL.getReplaceText())) {
                            if (tokens.size() <= 1 && (tokens.size() != 1 || !codeEndsWithWhiteSpaceChar)) return -1;
                            tokens.remove(0);
                        } else if (identifer.equals(SyntaxKeyword.MIT.getReplaceText())) {
                            int i_tmp = index + SyntaxKeyword.MIT.getReplaceText().length() + 1;
                            if (i_tmp < code.length && this.isStringSeparatorChar(code[i_tmp])) {
                                tokens.insertElementAt(identifer, 0);
                            }
                        } else if (identifer.length() > 0) {
                            tokens.insertElementAt(identifer, 0);
                        }
                        buf.setLength(0);
                        if (code[index] != '[') continue block6;
                        if (tokens.size() <= 0 || !((String)tokens.get(0)).equals(SyntaxKeyword.MIT.getReplaceText())) return -1;
                        return index;
                    }
                    buf.insert(0, code[index]);
                }
            }
        }
        return -1;
    }

    private int readStructureNameOfWithBlock(char[] code, int index, StringBuffer name) {
        boolean nameIsCompleted = false;
        while (index > 0) {
            switch (code[--index]) {
                case ']': {
                    index = this.goToStartOfBlock('[', code, index);
                    break;
                }
                case '\"': {
                    index = this.goToStartOfBlock('\"', code, index);
                    break;
                }
                default: {
                    if (this.isWhiteSpaceChar(code[index])) {
                        nameIsCompleted = name.length() > 0;
                        break;
                    }
                    name.insert(0, code[index]);
                    boolean bl = nameIsCompleted = index == 0;
                }
            }
            if (nameIsCompleted) break;
        }
        return index;
    }

    private int goToStartOfBlock(char blockStartChar, char[] code, int index) {
        int result = -1;
        while (index > 0 && result == -1) {
            --index;
            if (blockStartChar == '\'') {
                if (code[index] != '\'' || index != 0 && code[index - 1] == '\\') continue;
                result = index;
                continue;
            }
            if (blockStartChar == '\"') {
                if (code[index] != '\"') continue;
                result = index;
                continue;
            }
            if (code[index] == blockStartChar) {
                result = index;
                continue;
            }
            switch (code[index]) {
                case ')': {
                    index = this.goToStartOfBlock('(', code, index);
                    break;
                }
                case ']': {
                    index = this.goToStartOfBlock('[', code, index);
                    break;
                }
                case '}': {
                    index = this.goToStartOfBlock('{', code, index);
                    break;
                }
                case '\'': {
                    index = this.goToStartOfBlock('\'', code, index);
                    break;
                }
                case '\"': {
                    index = this.goToStartOfBlock('\"', code, index);
                }
            }
        }
        return result;
    }

    private int goToEndOfBlock(char blockEndChar, char[] code, int index) {
        int result = -1;
        while (index < code.length - 1 && result == -1) {
            ++index;
            if (blockEndChar == '\'') {
                if (code[index] != '\'' || code[index - 1] == '\\') continue;
                result = index;
                continue;
            }
            if (blockEndChar == '\"') {
                if (code[index] != '\"') continue;
                result = index;
                continue;
            }
            if (code[index] == blockEndChar) {
                result = index;
                continue;
            }
            switch (code[index]) {
                case '[': {
                    index = this.goToEndOfBlock(']', code, index);
                    break;
                }
                case '{': {
                    index = this.goToEndOfBlock('}', code, index);
                    break;
                }
                case '(': {
                    index = this.goToEndOfBlock(')', code, index);
                    break;
                }
                case '\'': {
                    index = this.goToEndOfBlock('\'', code, index);
                    break;
                }
                case '\"': {
                    index = this.goToEndOfBlock('\"', code, index);
                }
            }
            if (index == -1) break;
        }
        return result;
    }

    private boolean isWhiteSpaceChar(char ch) {
        boolean result = false;
        switch (ch) {
            case '\t': 
            case '\n': 
            case '\f': 
            case '\r': 
            case ' ': 
            case '&': 
            case '\'': 
            case '(': 
            case '*': 
            case '+': 
            case ',': 
            case '-': 
            case '/': 
            case ';': 
            case '<': 
            case '=': 
            case '>': 
            case '[': 
            case ']': {
                result = true;
                break;
            }
            default: {
                result = false;
            }
        }
        return result;
    }

    private boolean isStringSeparatorChar(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\r' || ch == '\t' || ch == '\f';
    }
}

