/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codeassist.ui;

import de.statspez.pleditor.generator.codeassist.CodeAssistant;
import de.statspez.pleditor.generator.codeassist.CodeAssistantResult;
import de.statspez.pleditor.generator.codeassist.CustomSyntaxElement;
import de.statspez.pleditor.generator.codeassist.SyntaxElement;
import de.statspez.pleditor.generator.codeassist.ui.ScopeProvider;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import javax.swing.border.BevelBorder;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;

public class CodeAssistantWindow
extends JWindow
implements KeyListener,
MouseListener,
HierarchyListener,
CaretListener {
    private static final Icon localVarIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/lokalvar.gif"));
    private static final Icon categoryGroupIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/auspraegungsgruppe.gif"));
    private static final Icon categoryIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/auspraegung.gif"));
    private static final Icon flowIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/ablauf.gif"));
    private static final Icon checkIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/pruefung.gif"));
    private static final Icon propertyIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/eigenschaft.gif"));
    private static final Icon functionIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/funktion.gif"));
    private static final Icon functionIntIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/funktion_intern.gif"));
    private static final Icon structIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/subthemenbereich.gif"));
    private static final Icon fieldIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/tbfeld.gif"));
    private static final Icon initValueIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/initwert.gif"));
    private static final Icon helpVarIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/plvar.gif"));
    private static final Icon paramIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/param.gif"));
    private static final Icon materialRefIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/images/materialref.gif"));
    private static final Icon templateIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/template.gif"));
    private static final Icon keywordIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/keyword.gif"));
    private static final Icon dsbStructIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/feldgruppe.gif"));
    private static final Icon dsbSatzartIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/satzart.gif"));
    private static final Icon dsbFieldIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/einzelfeld.gif"));
    private static final Icon sdfStructIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/sdfmerkmalsgruppe.gif"));
    private static final Icon sdfFieldIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/sdfmerkmal.gif"));
    private static final Icon kontextdatenFieldIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/kontextdatenfeld.gif"));
    private static final Icon kontextdatenStructIcon = new ImageIcon(CodeAssistant.class.getResource("/de/statspez/pleditor/generator/codeassist/images/kontextdatenstruktur.gif"));
    private JTextComponent codeTextComponent;
    private ScopeProvider scopeProvider;
    private CodeAssistant codeAssistant;
    private CodeAssistantListModel codeAssistListModel;
    private JList list;

    public CodeAssistantWindow(JTextComponent codeTextComponent, ScopeProvider scopeProvider) {
        super(SwingUtilities.getWindowAncestor(codeTextComponent));
        this.codeTextComponent = codeTextComponent;
        this.scopeProvider = scopeProvider;
        this.codeAssistant = new CodeAssistant();
        this.codeAssistListModel = new CodeAssistantListModel();
        this.list = new JList();
        this.codeTextComponent.addHierarchyListener(this);
        this.codeTextComponent.addKeyListener(this);
        this.codeTextComponent.addCaretListener(this);
        this.codeTextComponent.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                CodeAssistantWindow.this.closeWindow(false);
            }
        });
        this.codeTextComponent.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent event) {
                CodeAssistantWindow.this.closeWindow(false);
            }
        });
        this.setFocusableWindowState(false);
        this.list.setModel(this.codeAssistListModel);
        this.list.setCellRenderer(new SyntaxCellRenderer());
        this.list.setSelectionMode(0);
        this.list.addMouseListener(this);
        JScrollPane scrollPane = new JScrollPane(this.list, 20, 30);
        int red = SystemColor.control.getRed();
        int green = SystemColor.control.getGreen();
        int blue = SystemColor.control.getBlue();
        red = red >= 10 ? red - 10 : 0;
        green = green >= 10 ? green - 10 : 0;
        blue = blue >= 10 ? blue - 10 : 0;
        scrollPane.setBorder(new CompoundBorder(new BevelBorder(0), new LineBorder(new Color(red, green, blue), 1)));
        this.getContentPane().add(scrollPane);
    }

    private void updateList() {
        Cursor cursor = this.codeTextComponent.getCursor();
        this.codeTextComponent.setCursor(Cursor.getPredefinedCursor(3));
        try {
            StringBuffer text = new StringBuffer();
            int selectionStart = this.codeTextComponent.getSelectionStart();
            if (this.codeTextComponent.getText() != null) {
                text.append(this.codeTextComponent.getText());
            }
            if (this.codeTextComponent instanceof JTextPane) {
                int i = text.length() - 1;
                while (i >= 0) {
                    if (text.charAt(i) == '\r') {
                        text.deleteCharAt(i);
                    }
                    --i;
                }
            }
            this.codeAssistListModel.setCodeAssistantResult(this.codeAssistant.computeChoices(this.scopeProvider.getScope(), this.scopeProvider.getScopeType(), this.scopeProvider.getCustomChoices(), text.toString(), selectionStart));
        }
        finally {
            this.codeTextComponent.setCursor(cursor);
        }
    }

    private void openWindow() {
        this.updateList();
        if (this.codeAssistListModel.getSize() > 0) {
            Rectangle caretPos;
            try {
                caretPos = this.codeTextComponent.modelToView(this.codeTextComponent.getCaret().getDot());
            }
            catch (BadLocationException e) {
                throw new RuntimeException(e);
            }
            int x = this.codeTextComponent.getLocationOnScreen().x + caretPos.x;
            int y = this.codeTextComponent.getLocationOnScreen().y + caretPos.y + this.codeTextComponent.getFont().getSize() + 5;
            this.pack();
            this.setLocation(x, y);
            this.setVisible(true);
            this.list.ensureIndexIsVisible(0);
            this.list.setSelectedIndex(0);
        }
    }

    private void updateWindow() {
        int currentOffset = this.codeAssistListModel.getCodeAssistantResult().getOffset();
        this.updateList();
        if (this.codeAssistListModel.getSize() == 0 || this.codeAssistListModel.getCodeAssistantResult().getOffset() != currentOffset) {
            this.setVisible(false);
        }
    }

    private void closeWindow(boolean selectionOk) {
        if (selectionOk && this.list.getSelectedIndex() >= 0) {
            CodeAssistantResult result = this.codeAssistListModel.getCodeAssistantResult();
            SyntaxElement element = result.getChoice(this.list.getSelectedIndex());
            boolean shouldReplace = true;
            if (element instanceof CustomSyntaxElement) {
                shouldReplace = this.scopeProvider.handleCustomChoice((CustomSyntaxElement)element);
            }
            if (shouldReplace) {
                try {
                    this.codeTextComponent.getDocument().remove(result.getOffset(), this.codeTextComponent.getSelectionEnd() - result.getOffset());
                    this.codeTextComponent.getDocument().insertString(result.getOffset(), element.getReplaceText(), null);
                }
                catch (BadLocationException badLocationException) {
                    // empty catch block
                }
                this.codeTextComponent.setCaretPosition(result.getOffset() + element.getCaretPosition());
                this.codeTextComponent.setSelectionStart(result.getOffset() + element.getSelectionStart());
                this.codeTextComponent.setSelectionEnd(this.codeTextComponent.getSelectionStart() + element.getSelectionLength());
            }
        }
        this.setVisible(false);
    }

    private void changeSelectedElement(int delta) {
        int selIndex;
        int listSize = this.codeAssistListModel.getSize();
        if (Math.abs(delta) >= listSize) {
            selIndex = delta > 0 ? listSize - 1 : 0;
        } else {
            selIndex = this.list.getSelectedIndex() + delta;
            if (selIndex < 0) {
                selIndex = listSize + selIndex;
            } else if (selIndex >= listSize) {
                selIndex -= listSize;
            }
        }
        this.list.ensureIndexIsVisible(selIndex);
        this.list.setSelectedIndex(selIndex);
    }

    @Override
    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 32 && e.isControlDown()) {
            if (!this.isShowing()) {
                this.openWindow();
            }
        } else if (this.isShowing()) {
            switch (e.getKeyCode()) {
                case 10: {
                    this.closeWindow(true);
                    e.consume();
                    break;
                }
                case 27: {
                    this.closeWindow(false);
                    e.consume();
                    break;
                }
                case 38: {
                    this.changeSelectedElement(-1);
                    e.consume();
                    break;
                }
                case 40: {
                    this.changeSelectedElement(1);
                    e.consume();
                    break;
                }
                case 33: {
                    this.changeSelectedElement(-this.list.getVisibleRowCount());
                    e.consume();
                    break;
                }
                case 34: {
                    this.changeSelectedElement(this.list.getVisibleRowCount());
                    e.consume();
                }
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() == 2) {
            this.closeWindow(true);
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void hierarchyChanged(HierarchyEvent e) {
        if (this.isShowing() && !this.codeTextComponent.isShowing()) {
            this.closeWindow(false);
        }
    }

    @Override
    public void caretUpdate(CaretEvent e) {
        if (this.isShowing()) {
            this.updateWindow();
        }
    }

    private class CodeAssistantListModel
    extends AbstractListModel {
        private CodeAssistantResult result = null;

        public void setCodeAssistantResult(CodeAssistantResult result) {
            int oldSize = this.getSize();
            this.result = result;
            int newSize = this.getSize();
            this.fireContentsChanged(this, 0, newSize);
            if (oldSize > newSize) {
                this.fireIntervalRemoved(this, newSize, oldSize - 1);
            } else if (oldSize < newSize) {
                this.fireIntervalAdded(this, oldSize, newSize - 1);
            }
        }

        public CodeAssistantResult getCodeAssistantResult() {
            return this.result;
        }

        @Override
        public int getSize() {
            if (this.result != null) {
                return this.result.getChoicesCount();
            }
            return 0;
        }

        @Override
        public Object getElementAt(int index) {
            return this.result.getChoice(index);
        }
    }

    private class SyntaxCellRenderer
    extends DefaultListCellRenderer {
        private SyntaxCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList aList, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)aList, value, index, isSelected, cellHasFocus);
            if (value instanceof SyntaxElement) {
                SyntaxElement element = (SyntaxElement)value;
                this.setText(element.toString());
                switch (element.getType()) {
                    case 1: {
                        this.setIcon(localVarIcon);
                        break;
                    }
                    case 4: {
                        this.setIcon(categoryGroupIcon);
                        break;
                    }
                    case 3: {
                        this.setIcon(categoryIcon);
                        break;
                    }
                    case 2: {
                        this.setIcon(flowIcon);
                        break;
                    }
                    case 13: {
                        this.setIcon(checkIcon);
                        break;
                    }
                    case 5: {
                        this.setIcon(propertyIcon);
                        break;
                    }
                    case 7: {
                        this.setIcon(functionIntIcon);
                        break;
                    }
                    case 8: {
                        this.setIcon(functionIcon);
                        break;
                    }
                    case 14: {
                        this.setIcon(structIcon);
                        break;
                    }
                    case 6: {
                        this.setIcon(fieldIcon);
                        break;
                    }
                    case 10: {
                        this.setIcon(initValueIcon);
                        break;
                    }
                    case 12: {
                        this.setIcon(helpVarIcon);
                        break;
                    }
                    case 11: {
                        this.setIcon(paramIcon);
                        break;
                    }
                    case 9: {
                        this.setIcon(materialRefIcon);
                        break;
                    }
                    case 16: {
                        this.setIcon(templateIcon);
                        break;
                    }
                    case 15: {
                        this.setIcon(keywordIcon);
                        break;
                    }
                    case 18: {
                        this.setIcon(dsbStructIcon);
                        break;
                    }
                    case 19: {
                        this.setIcon(dsbSatzartIcon);
                        break;
                    }
                    case 17: {
                        this.setIcon(dsbFieldIcon);
                        break;
                    }
                    case 21: {
                        this.setIcon(sdfStructIcon);
                        break;
                    }
                    case 20: {
                        this.setIcon(sdfFieldIcon);
                        break;
                    }
                    case 22: {
                        this.setIcon(kontextdatenFieldIcon);
                        break;
                    }
                    case 23: {
                        this.setIcon(kontextdatenStructIcon);
                    }
                }
            }
            return this;
        }
    }
}

