/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.cpp;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.cpp.CppClassificationCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppMappingsCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppPlausiElementCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppProgramCodeGenerator;
import de.statspez.pleditor.generator.codegen.cpp.CppThemenbereichCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.StringHelper;
import de.statspez.pleditor.generator.codegen.support.CodegenUtil;
import de.statspez.pleditor.generator.codegen.support.DefaultTextResource;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.NamespaceHelper;
import de.statspez.pleditor.generator.codegen.support.PruefungIterator;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.TextResource;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.common.MessageContextInterface;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAblauf;
import de.statspez.pleditor.generator.meta.generated.MetaPLFunktion;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLParameter;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Vector;

public class CppPlausiCodeGenerator
extends CppPlausiElementCodeGenerator {
    public static final int MAX_NESTED_TB = 1000;
    private Scope scope = null;
    private Hashtable scopes = null;
    private TextResource textResource = new DefaultTextResource();
    private String classNameSuffix = null;
    private Vector generatedTopics = new Vector();

    public void setTextResource(TextResource textResource) {
        if (textResource != null) {
            this.textResource = textResource;
        }
    }

    public void setClassNameSuffix(String classNameSuffix) {
        this.classNameSuffix = classNameSuffix;
    }

    public synchronized void generate(MetaPlausibilisierung aPlausi) {
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        this.scopes = new Hashtable();
        this.scope = scopeBuilder.createScopes(aPlausi, this.scopes);
        if (!((MetaCustomPlausibilisierung)aPlausi).hasUsedMappings()) {
            this.warning(aPlausi, "keine Mappings definiert");
        }
        aPlausi.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    public synchronized void generate(MetaPlausibilisierung aPlausi, Scope plausiScope, Hashtable tbScopes) {
        this.scopes = tbScopes;
        this.scope = plausiScope;
        if (!((MetaCustomPlausibilisierung)aPlausi).hasUsedMappings()) {
            this.warning(aPlausi, "keine Mappings definiert");
        }
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(aPlausi, this.scope, this.scopes);
        aPlausi.accept(this);
        this.checkForErrors();
        this.out.flush();
    }

    @Override
    public void visitPlausibilisierung(MetaPlausibilisierung plausi) {
        this.out.print("#include \"Plausi.h\"");
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("using namespace pl;");
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("namespace ");
        this.out.print(this.namespaceForPlausi(plausi));
        this.openBlock();
        this.createPlausiFehlerFactoryMethod(plausi);
        this.indentNewLine();
        this.processPlausiElements(plausi);
        this.defineClass(this.classForPlausi(plausi), "Plausi");
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("public:");
        this.increaseIndentLevel();
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        this.indentNewLine();
        this.out.print(this.getTbClass(rootTb));
        this.out.print("* ");
        this.out.print("root");
        this.out.print(";");
        this.indentNewLine();
        this.createPlausiConstructor(plausi);
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("const PL_STRING getName()");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return \"");
        this.out.print(plausi.getName());
        this.out.print("\";");
        this.closeBlock();
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("PL_REAL getSystemVersion()");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return 1.0;");
        this.closeBlock();
        this.indentNewLine();
        String genDateStr = "";
        Date genDate = ((MetaCustomPlausibilisierung)plausi).getGenDate();
        if (genDate != null) {
            SimpleDateFormat time_formatter = new SimpleDateFormat("yyyyMMdd_HHmmss", Locale.GERMANY);
            genDateStr = time_formatter.format(genDate);
        }
        this.indentNewLine();
        this.out.print("const PL_STRING getVersionString()");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return \"");
        this.out.print(genDateStr);
        this.out.print("\";");
        this.closeBlock();
        this.indentNewLine();
        this.decreaseIndentLevel();
        this.indentNewLine();
        this.out.print("protected:");
        this.increaseIndentLevel();
        this.createAblaufInvocationMethod(plausi);
        this.indentNewLine();
        this.createFunctionInvocationMethod(plausi);
        this.endClassDefinition();
        this.closeBlock();
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("extern \"C\"");
        this.openBlock();
        this.indentNewLine();
        this.out.print("__declspec(dllexport) ");
        this.out.print("Plausi");
        this.out.print("* loadPlausi");
        this.out.print(this.namespaceForPlausi(plausi));
        this.out.print("()");
        this.openBlock();
        this.indentNewLine();
        this.out.print("return new ");
        this.out.print(this.namespaceForPlausi(plausi));
        this.out.print("::");
        this.out.print(this.classForPlausi(plausi));
        this.out.print("();");
        this.closeBlock();
        this.indentNewLine();
        this.indentNewLine();
        this.out.print("__declspec(dllexport) void unloadPlausi");
        this.out.print(this.namespaceForPlausi(plausi));
        this.out.print("(");
        this.out.print("Plausi");
        this.out.print("* plausi)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("delete plausi;");
        this.closeBlock();
        this.closeBlock();
    }

    @Override
    public void visitMerkmal(MetaMerkmal aMerkmal) {
        MetaCustomMerkmal merkmal = (MetaCustomMerkmal)aMerkmal;
        if (merkmal.referencedByErhebung()) {
            this.createFehlerMethod(this.scope, merkmal.getMetaSpezifikation().name(), merkmal.getName(), this.textResource.getFehlertextKurzProgram(merkmal), this.textResource.getFehlertextLangProgram(merkmal), this.textResource.getKorrekturhinweisProgram(merkmal), "Merkmalpruefung", null, null, null, (short)1);
            this.indentNewLine();
            CppProgramCodeGenerator prgGen = new CppProgramCodeGenerator();
            prgGen.setOutput(this.out);
            prgGen.setIndentLevel(this.indentLevel());
            prgGen.setErrorContext(new ElementMessageContext(5, merkmal.getId(), merkmal.getName()));
            prgGen.generate(merkmal.getMetaSpezifikation(), new ScopeImpl(this.scope), true);
        }
    }

    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        if (this.generatedTopics.contains(tb)) {
            return;
        }
        this.generatedTopics.add(tb);
        Iterator iter = tb.getFelder();
        while (iter.hasNext()) {
            MetaTBFeld feld = (MetaTBFeld)iter.next();
            if (!(feld.getKlasse() instanceof MetaThemenbereich)) continue;
            feld.getKlasse().accept(this);
        }
        CppThemenbereichCodeGenerator tbGen = new CppThemenbereichCodeGenerator();
        tbGen.setOutput(this.out);
        tbGen.setIndentLevel(this.indentLevel());
        tbGen.setTextResource(this.textResource);
        tbGen.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
        tbGen.generate(tb, (Scope)this.scopes.get(tb.getName()));
        this.indentNewLine();
    }

    private void createPlausiConstructor(MetaPlausibilisierung aPlausi) {
        MetaCustomPlausibilisierung plausi = (MetaCustomPlausibilisierung)aPlausi;
        this.defineMethod("", this.classForPlausi(plausi), "");
        this.openBlock();
        this.declareClassifications(plausi);
        this.declareMappings(plausi);
        this.declareFeatures(plausi);
        this.declareMaterials(plausi);
        this.indentNewLine();
        this.out.print("root");
        this.out.print(" = new ");
        this.out.print(this.getTbClass(plausi.rootThemenbereich()));
        this.out.print("(new ");
        this.out.print("TypeDescriptor");
        this.out.print("(PL_NULL, getMapping(), \"");
        this.out.print("__root_tb__");
        this.out.print("\", PL_NULL, fieldTypeStructure, PL_NULL, 0), PL_NULL, this);");
        this.indentNewLine();
        this.out.print("setRootTopic(");
        this.out.print("root");
        this.out.print(");");
        this.closeBlock();
    }

    private void declareClassifications(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        CppClassificationCodeGenerator codeGen = new CppClassificationCodeGenerator(this);
        codeGen.preGeneration();
        Iterator it = plausi.getAuspraegungsgruppen();
        while (it.hasNext()) {
            ((MetaAuspraegungsgruppe)it.next()).accept(codeGen);
        }
    }

    private void declareMappings(MetaPlausibilisierung plausi) {
        CppMappingsCodeGenerator codeGen = new CppMappingsCodeGenerator(this);
        codeGen.preGeneration();
        plausi.accept(codeGen);
    }

    private void declareMaterials(MetaPlausibilisierung plausi) {
        MetaPLMaterial[] materials = CodegenUtil.getUsedMaterials(plausi);
        if (materials != null && materials.length > 0) {
            this.indentNewLine();
            this.out.print("Topic");
            this.out.print("* material;");
            this.indentNewLine();
            int i = 0;
            while (i < materials.length) {
                this.indentNewLine();
                this.out.print("material = new ");
                this.out.print(this.getTbClass(materials[i].getThemenbereich()));
                this.out.print("(new ");
                this.out.print("TypeDescriptor");
                this.out.print("(PL_NULL, getMappingForMaterial(\"");
                this.out.print(materials[i].getName());
                this.out.print("\"), \"");
                this.out.print(materials[i].getMapping().getThemenbereich().getName());
                this.out.print("\", PL_NULL, fieldTypeStructure, PL_NULL, 0), PL_NULL, this);");
                this.indentNewLine();
                this.out.print("material->setMaterialName(\"");
                this.out.print(materials[i].getName());
                this.out.print("\");");
                this.indentNewLine();
                this.out.print("material->setMaterialNameDataset(\"");
                this.out.print(materials[i].getDSB().getName());
                this.out.print("\");");
                this.indentNewLine();
                this.out.print("setMaterial(\"");
                this.out.print(materials[i].getName());
                this.out.print("\", material);");
                this.indentNewLine();
                ++i;
            }
        }
    }

    private void declareFeatures(MetaPlausibilisierung plausi) {
        ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(new Traverser(){
            private NamespaceHelper helper = new NamespaceHelper();

            @Override
            public void visitTBFeld(MetaTBFeld anObject) {
                this.helper.enterSubNamespace(anObject.getName());
                if (anObject.getKlasse() instanceof MetaThemenbereich) {
                    anObject.getKlasse().accept(this);
                } else {
                    MetaCustomMerkmal merkmal = (MetaCustomMerkmal)anObject.getKlasse();
                    CppPlausiCodeGenerator.this.indentNewLine();
                    CppPlausiCodeGenerator.this.out.print("setFieldCheckProc(\"");
                    CppPlausiCodeGenerator.this.out.print(this.helper.prettyNamespace());
                    CppPlausiCodeGenerator.this.out.print("\", ");
                    CppPlausiCodeGenerator.this.out.print("prg_");
                    CppPlausiCodeGenerator.this.out.print(StringHelper.getEscapedName(merkmal.getMetaSpezifikation().name()));
                    CppPlausiCodeGenerator.this.out.print(");");
                }
                this.helper.leaveSubNamespace();
            }
        });
        this.indentNewLine();
    }

    private void createAblaufInvocationMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("PL_VOID", "performFlow", "RuntimeContext* context, const PL_STRING flow");
        this.openBlock();
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        MetaPLAblauf stdAblauf = ((MetaCustomPlausibilisierung)plausi).standardAblauf();
        this.indentNewLine();
        this.out.print("if (flow == PL_NULL)");
        this.openBlock();
        if (stdAblauf != null) {
            if (rootTb.sizeOfInitialisierungswerte() > 0) {
                this.indentNewLine();
                this.out.print("root");
                this.out.print("->");
                this.out.print("init");
                this.out.print("(context");
                Iterator iter = rootTb.getInitialisierungswerte();
                while (iter.hasNext()) {
                    MetaCustomInitwert initwert = (MetaCustomInitwert)iter.next();
                    this.out.print(", context->getInitParam(\"");
                    this.out.print(initwert.getName());
                    this.out.print("\")");
                }
                this.out.print(");");
            }
            this.indentNewLine();
            this.out.print("root");
            this.out.print("->");
            this.out.print("prg_");
            this.out.print(StringHelper.getEscapedName(stdAblauf.getName()));
            this.out.print("(context);");
        } else {
            this.indentNewLine();
            this.out.print("throw PlausiException(exceptionTypeNoSuchProc, \"Es wurde kein Ablauf vorgegeben und es konnte kein Standard-Ablauf ermittelt werden.\");");
            this.warning(plausi, "es konnte kein Standard-Ablauf ermittelt werden");
        }
        this.closeBlock();
        this.indentNewLine();
        this.out.print("else");
        this.openBlock();
        Iterator it = rootTb.getAblaeufe();
        boolean firstIf = true;
        while (it.hasNext()) {
            MetaPLAblauf ablauf = (MetaPLAblauf)it.next();
            this.indentNewLine();
            if (!firstIf) {
                this.out.print("else ");
            } else {
                firstIf = false;
            }
            this.out.print("if (strcmp(flow, \"");
            this.out.print(ablauf.getName());
            this.out.print("\") == 0)");
            this.openBlock();
            if (rootTb.sizeOfInitialisierungswerte() > 0) {
                this.indentNewLine();
                this.out.print("root");
                this.out.print("->");
                this.out.print("init");
                this.out.print("(context");
                Iterator iter = rootTb.getInitialisierungswerte();
                while (iter.hasNext()) {
                    MetaCustomInitwert initwert = (MetaCustomInitwert)iter.next();
                    this.out.print(", context->getInitParam(\"");
                    this.out.print(initwert.getName());
                    this.out.print("\")");
                }
                this.out.print(");");
            }
            this.indentNewLine();
            this.out.print("root");
            this.out.print("->");
            this.out.print("prg_");
            this.out.print(StringHelper.getEscapedName(ablauf.getName()));
            this.out.print("(context);");
            this.closeBlock();
        }
        this.indentNewLine();
        this.out.print("else");
        this.openBlock();
        this.indentNewLine();
        this.out.print("throw PlausiException(exceptionTypeNoSuchProc, flow);");
        this.closeBlock();
        this.closeBlock();
        this.closeBlock();
    }

    private void createPlausiFehlerFactoryMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("PlausiProblem*", "createPlausiProblem", "RuntimeContext* context, const PL_STRING key");
        this.openBlock();
        PruefungIterator pruefungIt = new PruefungIterator(plausi);
        pruefungIt.eachPruefung(new PruefungIterator.CodeBlock(){
            private HashSet definierteSchluessel = new HashSet();

            @Override
            public void doForPruefung(MetaCustomPruefung pruefung, MetaCustomThemenbereich tb) {
                CppPlausiCodeGenerator.this.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
                if (this.definierteSchluessel.contains(pruefung.getPruefschluessel())) {
                    CppPlausiCodeGenerator.this.error(pruefung, "Der Pruefschluessel " + pruefung.getPruefschluessel() + " wird in dieser Plausibilisierung bereits verwendet");
                } else {
                    this.definierteSchluessel.add(pruefung.getPruefschluessel());
                }
                CppPlausiCodeGenerator.this.indentNewLine();
                CppPlausiCodeGenerator.this.out.print("if (strcmp(\"");
                CppPlausiCodeGenerator.this.out.print(pruefung.getPruefschluessel());
                CppPlausiCodeGenerator.this.out.print("\", key) == 0)");
                CppPlausiCodeGenerator.this.openBlock();
                CppPlausiCodeGenerator.this.createPlausiFehlerErzeugung(pruefung.getPruefschluessel(), CppPlausiCodeGenerator.this.textResource.getFehlertextKurz(pruefung), CppPlausiCodeGenerator.this.textResource.getFehlertextLang(pruefung), CppPlausiCodeGenerator.this.textResource.getKorrekturhinweis(pruefung), pruefung.getThemenbereich().getName(), pruefung.getFehlergewicht(), pruefung.getPruefungsart(), pruefung.hauptbezugsfeldIndex(), (short)0, null, 0L, null, null);
                CppPlausiCodeGenerator.this.indentNewLine();
                CppPlausiCodeGenerator.this.out.print("return problem;");
                CppPlausiCodeGenerator.this.closeBlock();
            }
        });
        this.setErrorContext((MessageContextInterface)null);
        this.indentNewLine();
        Iterator merkmalIt = plausi.getMerkmale();
        while (merkmalIt.hasNext()) {
            MetaCustomMerkmal merkmal = (MetaCustomMerkmal)merkmalIt.next();
            this.out.print("if (strcmp(\"");
            this.out.print(merkmal.getName());
            this.out.print("\", key) == 0)");
            this.openBlock();
            this.createPlausiFehlerErzeugung(merkmal.getName(), this.textResource.getFehlertextKurz(merkmal), this.textResource.getFehlertextLang(merkmal), this.textResource.getKorrekturhinweis(merkmal), "Merkmalpruefung", (short)9, (short)1, null, merkmal.getTyp(), merkmal.getMaske(), merkmal.getLaenge(), CodegenUtil.getValueSpaceAsString(merkmal), CodegenUtil.getDisplayName(this.textResource, merkmal));
            this.indentNewLine();
            this.out.print("return problem;");
            this.closeBlock();
            if (!merkmalIt.hasNext()) continue;
            this.indentNewLine();
        }
        this.indentNewLine();
        this.out.print("throw PlausiException(exceptionTypeWrongParameter, \"Ungueltiger Pruefschluessel.\");");
        this.closeBlock();
    }

    private void createFunctionInvocationMethod(MetaPlausibilisierung plausi) {
        assert (plausi != null);
        this.defineMethod("Value*", "performFunction", "RuntimeContext* context, const PL_STRING function");
        this.openBlock();
        this.indentNewLine();
        this.out.print("if (function == PL_NULL)");
        this.openBlock();
        this.indentNewLine();
        this.out.print("throw PlausiException(exceptionTypeWrongParameter, \"Kein Funktionsname angegeben.\");");
        this.closeBlock();
        MetaThemenbereich rootTb = ((MetaCustomPlausibilisierung)plausi).rootThemenbereich();
        Iterator it = rootTb.getFunktionen();
        while (it.hasNext()) {
            MetaPLFunktion funktion = (MetaPLFunktion)it.next();
            this.indentNewLine();
            this.out.print("if (strcmp(function, \"");
            this.out.print(funktion.getName());
            this.out.print("\") == 0)");
            this.openBlock();
            this.indentNewLine();
            this.out.print("return ");
            this.out.print("root");
            this.out.print("->");
            this.out.print("prg_");
            this.out.print(StringHelper.getEscapedName(funktion.getName()));
            this.out.print("(context");
            if (funktion.sizeOfParameter() > 0) {
                Iterator params = funktion.getParameter();
                while (params.hasNext()) {
                    MetaPLParameter param = (MetaPLParameter)params.next();
                    this.out.print(", context->getInitParam(\"");
                    this.out.print(param.getName());
                    this.out.print("\")");
                }
            }
            this.out.print(");");
            this.closeBlock();
        }
        this.indentNewLine();
        this.out.print("throw PlausiException(exceptionTypeNoSuchProc, function);");
        this.closeBlock();
    }

    private String namespaceForPlausi(MetaPlausibilisierung plausi) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(StringHelper.getEscapedName(plausi.getPLName()));
        return buffer.toString();
    }

    private String classForPlausi(MetaPlausibilisierung plausi) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Plausi_");
        buffer.append(StringHelper.getEscapedName(plausi.getPLName()));
        if (this.classNameSuffix != null && this.classNameSuffix.length() > 0) {
            buffer.append('_');
            buffer.append(this.classNameSuffix);
        }
        return buffer.toString();
    }

    private void processPlausiElements(MetaPlausibilisierung plausi) {
        Iterator it = plausi.getMerkmale();
        while (it.hasNext()) {
            MetaMerkmal aMerkmal = (MetaMerkmal)it.next();
            aMerkmal.accept(this);
            this.indentNewLine();
        }
        this.generatedTopics.clear();
        ((MetaCustomPlausibilisierung)plausi).rootThemenbereich().accept(this);
    }
}

