/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffElement;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.meta.MetaElement;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class DiffResultTreeNode {
    private List childNodeList = null;
    private Map childNodeMap = null;
    private String context = null;
    private List diffResultList = null;
    private DiffResultTree diffResultTree = null;
    private MetaElement metaElement1 = null;
    private MetaElement metaElement2 = null;
    private DiffResultTreeNode parent = null;
    private String toString = null;

    DiffResultTreeNode(String context, MetaElement metaElement1, MetaElement metaElement2, DiffResultTree diffResultTree) {
        if (context == null || diffResultTree == null) {
            throw new NullPointerException();
        }
        this.context = context;
        this.metaElement1 = metaElement1;
        this.metaElement2 = metaElement2;
        this.diffResultTree = diffResultTree;
        this.childNodeMap = new HashMap();
        this.childNodeList = new LinkedList();
        this.diffResultList = new LinkedList();
    }

    public final String toString() {
        if (this.toString == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.getSimpleContext(this.getContext()));
            if (!this.isHeaderNode()) {
                buffer.append(" (");
                if (this.getMetaElement1() != null && this.getMetaElement2() != null) {
                    if (this.getMetaElement1().getClass() != this.getMetaElement2().getClass()) {
                        buffer.append(DiffElement.getDiffElement(this.getMetaElement1()).getShortName());
                        buffer.append(" => ");
                        buffer.append(DiffElement.getDiffElement(this.getMetaElement2()).getShortName());
                    } else {
                        buffer.append(DiffElement.getDiffElement(this.getMetaElement1()).getShortName());
                    }
                } else if (this.getMetaElement1() != null) {
                    buffer.append(DiffElement.getDiffElement(this.getMetaElement1()).getShortName());
                } else if (this.getMetaElement2() != null) {
                    buffer.append(DiffElement.getDiffElement(this.getMetaElement2()).getShortName());
                }
                buffer.append(")");
            }
            this.toString = buffer.toString();
        }
        return this.toString;
    }

    void addChildNode(DiffResultTreeNode diffTreeNode) {
        if (diffTreeNode == null) {
            throw new NullPointerException();
        }
        String simpleContext = this.getSimpleContext(diffTreeNode.getContext());
        this.childNodeMap.put(simpleContext, diffTreeNode);
        this.childNodeList.add(diffTreeNode);
        diffTreeNode.setParent(this);
    }

    void addDiffResult(DiffResult diffResult) {
        if (diffResult == null) {
            throw new NullPointerException();
        }
        this.diffResultList.add(diffResult);
    }

    DiffResultTreeNode getChildNode(String context) {
        String simpleContext = this.getSimpleContext(context);
        return (DiffResultTreeNode)this.childNodeMap.get(simpleContext);
    }

    List getChildNodes() {
        return new LinkedList(this.childNodeList);
    }

    String getContext() {
        return this.context;
    }

    List getDiffResults() {
        return new LinkedList(this.diffResultList);
    }

    DiffResultTree getDiffResultTree() {
        return this.diffResultTree;
    }

    MetaElement getMetaElement1() {
        return this.metaElement1;
    }

    MetaElement getMetaElement2() {
        return this.metaElement2;
    }

    List getNodeChildren() {
        LinkedList<DiffResultTreeNode> children = new LinkedList<DiffResultTreeNode>();
        for (DiffResultTreeNode node : this.childNodeList) {
            children.add(node);
            children.addAll(node.getNodeChildren());
        }
        return children;
    }

    DiffResultTreeNode getParent() {
        return this.parent;
    }

    boolean isHeaderNode() {
        return this.diffResultTree.isHeaderNode(this);
    }

    private String getSimpleContext(String context) {
        String simpleContext = context;
        int lastIndex = context.lastIndexOf(46);
        if (lastIndex >= 0) {
            simpleContext = context.substring(lastIndex + 1, context.length());
        }
        return simpleContext;
    }

    private void setParent(DiffResultTreeNode parent) {
        if (parent == null) {
            throw new NullPointerException();
        }
        this.parent = parent;
    }
}

