/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;

public class DiffUITreeNode
implements TreeNode {
    private List childNodes = null;
    private List childUIAllNodes = null;
    private List childUIVisibleNodes = null;
    private DiffResultTreeNode diffResultTreeNode = null;
    private DiffUITreeNode parent = null;
    private Comparator comparator = null;

    DiffUITreeNode(DiffUITreeNode parent, DiffResultTreeNode diffResultTreeNode) {
        if (diffResultTreeNode == null) {
            throw new NullPointerException();
        }
        this.diffResultTreeNode = diffResultTreeNode;
        this.childNodes = this.diffResultTreeNode.getChildNodes();
        this.initChildren();
    }

    public Enumeration children() {
        return new Enumeration(){
            private int count = 0;

            @Override
            public boolean hasMoreElements() {
                return this.count < DiffUITreeNode.this.getChildCount();
            }

            public Object nextElement() {
                return DiffUITreeNode.this.getChildAt(this.count++);
            }
        };
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public TreeNode getChildAt(int childIndex) {
        return (TreeNode)this.childUIVisibleNodes.get(childIndex);
    }

    @Override
    public int getChildCount() {
        return this.childUIVisibleNodes.size();
    }

    @Override
    public int getIndex(TreeNode node) {
        return this.childUIVisibleNodes.indexOf(node);
    }

    @Override
    public TreeNode getParent() {
        return this.parent;
    }

    @Override
    public boolean isLeaf() {
        return this.childNodes.size() == 0;
    }

    public String toString() {
        return this.diffResultTreeNode.toString();
    }

    DiffResultTreeNode getDiffResultTreeNode() {
        return this.diffResultTreeNode;
    }

    void hideNoDiff(boolean hide) {
        Iterator iterator = this.childUIAllNodes.iterator();
        this.childUIVisibleNodes.clear();
        while (iterator.hasNext()) {
            DiffUITreeNode diffUINode = (DiffUITreeNode)iterator.next();
            DiffResultTreeNode diffResultNode = diffUINode.getDiffResultTreeNode();
            boolean add = true;
            if (hide && !diffResultNode.isHeaderNode()) {
                add = false;
                if (diffResultNode.getDiffResults().size() > 0) {
                    add = true;
                } else {
                    List children = diffResultNode.getNodeChildren();
                    for (DiffResultTreeNode child : children) {
                        if (child.getDiffResults().size() <= 0) continue;
                        add = true;
                        break;
                    }
                }
            }
            if (!add) continue;
            this.childUIVisibleNodes.add(diffUINode);
        }
        if (this.comparator != null) {
            Collections.sort(this.childUIVisibleNodes, this.comparator);
        }
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DiffUITreeNode child = (DiffUITreeNode)enumeration.nextElement();
            child.hideNoDiff(hide);
        }
    }

    void sortChildren(Comparator comparator) {
        if (comparator == null) {
            throw new NullPointerException();
        }
        this.comparator = comparator;
        Collections.sort(this.childUIVisibleNodes, comparator);
        Enumeration enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            DiffUITreeNode child = (DiffUITreeNode)enumeration.nextElement();
            child.sortChildren(comparator);
        }
    }

    private void initChildren() {
        this.childUIAllNodes = new ArrayList(this.childNodes.size());
        for (DiffResultTreeNode diffResultNode : this.childNodes) {
            DiffUITreeNode diffUINode = new DiffUITreeNode(this, diffResultNode);
            this.childUIAllNodes.add(diffUINode);
        }
        this.childUIVisibleNodes = new ArrayList(this.childNodes.size());
        this.childUIVisibleNodes.addAll(this.childUIAllNodes);
    }
}

