/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.diff;

import de.statspez.pleditor.generator.codegen.diff.DiffConfig;
import de.statspez.pleditor.generator.codegen.diff.DiffElement;
import de.statspez.pleditor.generator.codegen.diff.DiffResult;
import de.statspez.pleditor.generator.codegen.diff.DiffResultContainer;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementAdded;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementChanged;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementRemoved;
import de.statspez.pleditor.generator.codegen.diff.DiffResultElementTypeChanged;
import de.statspez.pleditor.generator.codegen.diff.DiffResultPlausiDiffers;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTree;
import de.statspez.pleditor.generator.codegen.diff.DiffResultTreeNode;
import de.statspez.pleditor.generator.codegen.diff.DiffStructure;
import de.statspez.pleditor.generator.codegen.diff.DiffStructureBuilder;
import de.statspez.pleditor.generator.meta.ILTypes;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomInitwert;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.MetaCustomVariable;
import de.statspez.pleditor.generator.meta.MetaElement;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBMaterialReferenz;
import java.io.File;
import java.io.FileReader;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class EdtDiffFacade {
    public static synchronized DiffResultContainer diff(DiffStructure diffStructure1, DiffStructure diffStructure2, DiffConfig diffConfig) {
        if (diffStructure1 == null || diffStructure2 == null) {
            throw new NullPointerException();
        }
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        DiffResultContainer diffResult = new DiffResultContainer(diffStructure1, diffStructure2);
        diffResult.setDiffConfig(diffConfig);
        MetaCustomPlausibilisierung plausi1 = diffStructure1.getMetaPlausibilisierung();
        MetaCustomPlausibilisierung plausi2 = diffStructure2.getMetaPlausibilisierung();
        DiffResultTree tree = new DiffResultTree(plausi1, plausi2);
        if (plausi1.getName().equals(plausi2.getName())) {
            MetaElement element2;
            Map elementMap1 = diffStructure1.getMetaElementMap();
            Map elementMap2 = diffStructure2.getMetaElementMap();
            for (Map.Entry entry : elementMap1.entrySet()) {
                DiffResultTreeNode node;
                String context = (String)entry.getKey();
                MetaElement element1 = (MetaElement)entry.getValue();
                element2 = (MetaElement)elementMap2.get(context);
                if (element2 != null) {
                    node = tree.getNode(String.valueOf(tree.getPLStrukturContext()) + "." + context);
                    if (node == null) {
                        node = tree.addNode(String.valueOf(tree.getPLStrukturContext()) + "." + context, element1, element2);
                    }
                    List changedDiffResults = EdtDiffFacade.diffElement(element1, element2, diffConfig);
                    for (DiffResult changedDiffResult : changedDiffResults) {
                        node.addDiffResult(changedDiffResult);
                    }
                    continue;
                }
                node = tree.getNode(String.valueOf(tree.getPLStrukturContext()) + "." + context);
                if (node == null) {
                    node = tree.addNode(String.valueOf(tree.getPLStrukturContext()) + "." + context, element1, null);
                }
                DiffResultElementRemoved removedDiffResult = new DiffResultElementRemoved(element1, DiffElement.getDiffElement(element1).getDtRemoved(), diffConfig.getContextType());
                node.addDiffResult(removedDiffResult);
            }
            for (Map.Entry entry : elementMap2.entrySet()) {
                String context = (String)entry.getKey();
                element2 = (MetaElement)entry.getValue();
                MetaElement element1 = (MetaElement)elementMap1.get(context);
                if (element1 != null) continue;
                DiffResultTreeNode node = tree.getNode(String.valueOf(tree.getPLStrukturContext()) + "." + context);
                if (node == null) {
                    node = tree.addNode(String.valueOf(tree.getPLStrukturContext()) + "." + context, null, element2);
                }
                DiffResultElementAdded addedDiffResult = new DiffResultElementAdded(element2, DiffElement.getDiffElement(element2).getDtAdded(), diffConfig.getContextType());
                node.addDiffResult(addedDiffResult);
            }
            if (diffConfig.isCheckGlobal()) {
                diffConfig.setContextType(1);
                DiffResultTreeNode node = tree.addNode(tree.getPlausiTBsContext(), null, null);
                List diffResults = EdtDiffFacade.diffGlobalThemenbereiche(diffStructure1.getMetaPlausibilisierung(), diffStructure2.getMetaPlausibilisierung(), diffConfig);
                for (DiffResult diffResultTB : diffResults) {
                    node.addDiffResult(diffResultTB);
                }
            }
        } else {
            DiffResultTreeNode node = tree.getNode(tree.getRootContext());
            if (node == null) {
                node = tree.addNode(tree.getRootContext(), plausi1, plausi2);
            }
            DiffResultPlausiDiffers plausiDiffResult = new DiffResultPlausiDiffers(plausi1, plausi2);
            node.addDiffResult(plausiDiffResult);
        }
        diffResult.setDiffResultTree(tree);
        return diffResult;
    }

    public static synchronized DiffResultContainer diff(File edtFile1, File edtFile2, DiffConfig diffConfig) {
        if (edtFile1 == null || edtFile2 == null) {
            throw new NullPointerException();
        }
        if (!edtFile1.exists() || !edtFile2.exists()) {
            throw new IllegalArgumentException("Dateien muessen existieren!");
        }
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        DiffStructure diffStructure1 = null;
        DiffStructure diffStructure2 = null;
        try {
            diffStructure1 = DiffStructureBuilder.build(new FileReader(edtFile1), diffConfig);
            diffStructure2 = DiffStructureBuilder.build(new FileReader(edtFile2), diffConfig);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return EdtDiffFacade.diff(diffStructure1, diffStructure2, diffConfig);
    }

    public static synchronized DiffResultContainer diff(MetaCustomPlausibilisierung plausi1, MetaCustomPlausibilisierung plausi2, DiffConfig diffConfig) {
        if (plausi1 == null || plausi2 == null) {
            throw new NullPointerException();
        }
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        DiffStructure diffStructure1 = null;
        DiffStructure diffStructure2 = null;
        diffStructure1 = DiffStructureBuilder.build(plausi1, diffConfig);
        diffStructure2 = DiffStructureBuilder.build(plausi2, diffConfig);
        return EdtDiffFacade.diff(diffStructure1, diffStructure2, diffConfig);
    }

    public static List diffElement(MetaCustomAblauf ablauf1, MetaCustomAblauf ablauf2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueStr1 = ablauf1.getSpezifikation();
        valueStr2 = ablauf2.getSpezifikation();
        EdtDiffFacade.checkDiff((MetaElement)ablauf1, (MetaElement)ablauf2, "Spezifikation", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = ablauf1.getStatus();
        valueLong2 = ablauf2.getStatus();
        EdtDiffFacade.checkDiff((MetaElement)ablauf1, (MetaElement)ablauf2, "Status", valueLong1, valueLong2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomFunktion function1, MetaCustomFunktion function2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueStr1 = function1.getAnweisungen();
        valueStr2 = function2.getAnweisungen();
        EdtDiffFacade.checkDiff((MetaElement)function1, (MetaElement)function2, "Anweisung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = function1.getArt();
        valueStr2 = function2.getArt();
        EdtDiffFacade.checkDiff((MetaElement)function1, (MetaElement)function2, "Art", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = function1.getFunctionType();
        valueLong2 = function2.getFunctionType();
        EdtDiffFacade.checkDiff((MetaElement)function1, (MetaElement)function2, "Funktions-Typ", valueLong1, valueLong2, diffResults, diffConfig);
        valueLong1 = function1.getRueckgabeTyp();
        valueLong2 = function2.getRueckgabeTyp();
        EdtDiffFacade.checkDiff((MetaElement)function1, (MetaElement)function2, "R\u00fcckgabe-Typ", valueLong1, valueLong2, diffResults, diffConfig);
        valueLong1 = function1.getStatus();
        valueLong2 = function2.getStatus();
        EdtDiffFacade.checkDiff((MetaElement)function1, (MetaElement)function2, "Status", valueLong1, valueLong2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomInitwert init1, MetaCustomInitwert init2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        boolean valueBool1 = false;
        boolean valueBool2 = false;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueStr1 = init1.getBeschreibung();
        valueStr2 = init2.getBeschreibung();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Beschreibung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = init1.getDimension();
        valueStr2 = init2.getDimension();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Dimension", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = init1.getKommentar();
        valueStr2 = init2.getKommentar();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Kommentar", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = init1.getLaenge();
        valueLong2 = init2.getLaenge();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "L\u00e4nge", valueLong1, valueLong2, diffResults, diffConfig);
        valueBool1 = init1.getListe();
        valueBool2 = init2.getListe();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Liste", valueBool1, valueBool2, diffResults, diffConfig);
        valueStr1 = init1.getName();
        valueStr2 = init2.getName();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Name", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = init1.getStatus();
        valueLong2 = init2.getStatus();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Status", valueLong1, valueLong2, diffResults, diffConfig);
        valueLong1 = init1.getTyp();
        valueLong2 = init2.getTyp();
        EdtDiffFacade.checkDiff((MetaElement)init1, (MetaElement)init2, "Typ", valueLong1, valueLong2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaTBMaterialReferenz matref1, MetaTBMaterialReferenz matref2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        valueStr1 = matref1.getBeschreibung();
        valueStr2 = matref2.getBeschreibung();
        EdtDiffFacade.checkDiff((MetaElement)matref1, (MetaElement)matref2, "Beschreibung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = matref1.getName();
        valueStr2 = matref2.getName();
        EdtDiffFacade.checkDiff((MetaElement)matref1, (MetaElement)matref2, "Name", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = matref1.getMaterialbeschreibung() == null ? "" : matref1.getMaterialbeschreibung().getName();
        valueStr2 = matref2.getMaterialbeschreibung() == null ? "" : matref2.getMaterialbeschreibung().getName();
        EdtDiffFacade.checkDiff((MetaElement)matref1, (MetaElement)matref2, "Materialbeschreibung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = matref1.getKommentar();
        valueStr2 = matref2.getKommentar();
        EdtDiffFacade.checkDiff((MetaElement)matref1, (MetaElement)matref2, "Kommentar", valueStr1, valueStr2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomMerkmal merkmal1, MetaCustomMerkmal merkmal2, DiffConfig diffConfig) {
        LinkedList<DiffResultElementChanged> diffResults = new LinkedList<DiffResultElementChanged>();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        boolean valueBool1 = false;
        boolean valueBool2 = false;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueStr1 = merkmal1.getBezeichnung();
        valueStr2 = merkmal2.getBezeichnung();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Bezeichnung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = merkmal1.getFehlertextLang();
        valueStr2 = merkmal2.getFehlertextLang();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Fehlertext lang", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = merkmal1.getFrage();
        valueStr2 = merkmal2.getFrage();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Frage", valueStr1, valueStr2, diffResults, diffConfig);
        valueBool1 = merkmal1.getFuehrendeNullen();
        valueBool2 = merkmal2.getFuehrendeNullen();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Fuehrende Nullen", valueBool1, valueBool2, diffResults, diffConfig);
        valueStr1 = merkmal1.getKorrekturhinweis();
        valueStr2 = merkmal2.getKorrekturhinweis();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Korrekturhinweis", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = merkmal1.getLaenge();
        valueLong2 = merkmal2.getLaenge();
        if (valueLong1 != valueLong2) {
            diffResults.add(new DiffResultElementChanged(merkmal1, merkmal2, "L\u00e4nge", String.valueOf(valueLong1), String.valueOf(valueLong2), 30, diffConfig.getContextType()));
        }
        valueBool1 = merkmal1.getLeer();
        valueBool2 = merkmal2.getLeer();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Leer erlaubt", valueBool1, valueBool2, diffResults, diffConfig);
        valueStr1 = merkmal1.getMaske();
        valueStr2 = merkmal2.getMaske();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Maske", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = merkmal1.getNachkommastellen();
        valueLong2 = merkmal2.getNachkommastellen();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Nachkomma-Stellen", valueLong1, valueLong2, diffResults, diffConfig);
        valueBool1 = merkmal1.getNichtWissen();
        valueBool2 = merkmal2.getNichtWissen();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Nicht wissen", valueBool1, valueBool2, diffResults, diffConfig);
        short typ1 = merkmal1.getTyp();
        short typ2 = merkmal2.getTyp();
        if (typ1 != typ2) {
            diffResults.add(new DiffResultElementChanged(merkmal1, merkmal2, "Typ", ILTypes.TYPE_NAMES[typ1 - 1], ILTypes.TYPE_NAMES[typ2 - 1], 30, diffConfig.getContextType()));
        }
        valueBool1 = merkmal1.getVerweigerung();
        valueBool2 = merkmal2.getVerweigerung();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Verweigerung", valueBool1, valueBool2, diffResults, diffConfig);
        valueLong1 = merkmal1.getVorkommastellen();
        valueLong2 = merkmal2.getVorkommastellen();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Vorkomma-Stellen", valueLong1, valueLong2, diffResults, diffConfig);
        valueBool1 = merkmal1.getVorzeichen();
        valueBool2 = merkmal2.getVorzeichen();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Vorzeichen", valueBool1, valueBool2, diffResults, diffConfig);
        valueStr1 = merkmal1.getWertebereich();
        valueStr2 = merkmal2.getWertebereich();
        EdtDiffFacade.checkDiff((MetaElement)merkmal1, (MetaElement)merkmal2, "Wertebereich", valueStr1, valueStr2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomPruefung pruefung1, MetaCustomPruefung pruefung2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueStr1 = pruefung1.getAnweisung();
        valueStr2 = pruefung2.getAnweisung();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Anweisung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = pruefung1.getBedingung();
        valueStr2 = pruefung2.getBedingung();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Bedingung", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = pruefung1.getFehlergewicht();
        valueLong2 = pruefung2.getFehlergewicht();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Fehlergewicht", valueLong1, valueLong2, diffResults, diffConfig);
        valueStr1 = pruefung1.getFehlertextLang();
        valueStr2 = pruefung2.getFehlertextLang();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Fehlertext lang", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = pruefung1.getFehlertextKurz();
        valueStr2 = pruefung2.getFehlertextKurz();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Fehlertext kurz", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = pruefung1.getHauptbezugsfeldIndex();
        valueStr2 = pruefung2.getHauptbezugsfeldIndex();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Hauptbezugsfeld-Index", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = pruefung1.getKorrekturart();
        valueLong2 = pruefung2.getKorrekturart();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Korrektur-Art", valueLong1, valueLong2, diffResults, diffConfig);
        valueStr1 = pruefung1.getKorrekturhinweis();
        valueStr2 = pruefung2.getKorrekturhinweis();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Korrektur-Hinweis", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = pruefung1.getLfdNr();
        valueLong2 = pruefung2.getLfdNr();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Laufende Nummer", valueLong1, valueLong2, diffResults, diffConfig);
        valueLong1 = pruefung1.getMethodenKategorieID();
        valueLong2 = pruefung2.getMethodenKategorieID();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Methoden-Kategorie-Id", valueLong1, valueLong2, diffResults, diffConfig);
        valueStr1 = pruefung1.getPruefschluessel();
        valueStr2 = pruefung2.getPruefschluessel();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Pr\u00fcfschl\u00fcssel", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = pruefung1.getPruefungsart();
        valueLong2 = pruefung2.getPruefungsart();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Pr\u00fcfungsart", valueLong1, valueLong2, diffResults, diffConfig);
        valueLong1 = pruefung1.getStatus();
        valueLong2 = pruefung2.getStatus();
        EdtDiffFacade.checkDiff((MetaElement)pruefung1, (MetaElement)pruefung2, "Status", valueLong1, valueLong2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomTBFeld field1, MetaCustomTBFeld field2, DiffConfig diffConfig) {
        LinkedList<DiffResultElementChanged> diffResults = new LinkedList<DiffResultElementChanged>();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        boolean valueBool1 = false;
        boolean valueBool2 = false;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueLong1 = field1.getArt();
        if (valueLong1 != (valueLong2 = (long)field2.getArt())) {
            diffResults.add(new DiffResultElementChanged(field1, field2, "Art", String.valueOf(valueLong1), String.valueOf(valueLong2), 31, diffConfig.getContextType()));
        }
        valueStr1 = field1.getBelegung();
        valueStr2 = field2.getBelegung();
        EdtDiffFacade.checkDiff((MetaElement)field1, (MetaElement)field2, "Belegung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = field1.getBezeichnung();
        valueStr2 = field2.getBezeichnung();
        EdtDiffFacade.checkDiff((MetaElement)field1, (MetaElement)field2, "Bezeichnung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = field1.getDimensionLaenge();
        valueStr2 = field2.getDimensionLaenge();
        if (EdtDiffFacade.attributeDiffers(valueStr1, valueStr2)) {
            diffResults.add(new DiffResultElementChanged(field1, field2, "Dimension", valueStr1, valueStr2, 31, diffConfig.getContextType()));
        }
        valueBool1 = field1.getMehrfachantworten();
        valueBool2 = field2.getMehrfachantworten();
        EdtDiffFacade.checkDiff((MetaElement)field1, (MetaElement)field2, "Mehrfach-Antworten", valueBool1, valueBool2, diffResults, diffConfig);
        valueLong1 = field1.getStatus();
        valueLong2 = field2.getStatus();
        EdtDiffFacade.checkDiff((MetaElement)field1, (MetaElement)field2, "Status", valueLong1, valueLong2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomThemenbereich tb1, MetaCustomThemenbereich tb2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        valueStr1 = tb1.getBezeichnung();
        valueStr2 = tb2.getBezeichnung();
        EdtDiffFacade.checkDiff((MetaElement)tb1, (MetaElement)tb2, "Bezeichnung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = tb1.getVersion();
        valueStr2 = tb2.getVersion();
        EdtDiffFacade.checkDiff((MetaElement)tb1, (MetaElement)tb2, "Version", valueStr1, valueStr2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaCustomVariable var1, MetaCustomVariable var2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        boolean valueBool1 = false;
        boolean valueBool2 = false;
        long valueLong1 = -1L;
        long valueLong2 = -1L;
        valueStr1 = var1.getBelegung();
        valueStr2 = var2.getBelegung();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Belegung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = var1.getBeschreibung();
        valueStr2 = var2.getBeschreibung();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Beschreibung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = var1.getDimension();
        valueStr2 = var2.getDimension();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Dimension", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = var1.getKommentar();
        valueStr2 = var2.getKommentar();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Kommentar", valueStr1, valueStr2, diffResults, diffConfig);
        valueLong1 = var1.getLaenge();
        valueLong2 = var2.getLaenge();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "L\u00e4nge", valueLong1, valueLong2, diffResults, diffConfig);
        valueBool1 = var1.getListe();
        valueBool2 = var2.getListe();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Liste", valueBool1, valueBool2, diffResults, diffConfig);
        valueStr1 = var1.getName();
        valueStr2 = var2.getName();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Name", valueStr1, valueStr2, diffResults, diffConfig);
        valueBool1 = var1.getPersistent();
        valueBool2 = var2.getPersistent();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Persistent", valueBool1, valueBool2, diffResults, diffConfig);
        valueLong1 = var1.getStatus();
        valueLong2 = var2.getStatus();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Status", valueLong1, valueLong2, diffResults, diffConfig);
        valueLong1 = var1.getTyp();
        valueLong2 = var2.getTyp();
        EdtDiffFacade.checkDiff((MetaElement)var1, (MetaElement)var2, "Typ", valueLong1, valueLong2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffElement(MetaElement element1, MetaElement element2, DiffConfig diffConfig) {
        LinkedList<DiffResult> diffResults = new LinkedList<DiffResult>();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        if (element1.getClass() == element2.getClass()) {
            if (diffConfig.isCheckId()) {
                String id1 = element1.getId();
                String id2 = element2.getId();
                if (id1 != null && !id1.equals(id2)) {
                    DiffResultElementChanged changedDiffResult = new DiffResultElementChanged(element1, element2, "ID", id1, id2, DiffElement.getDiffElement(element1).getDtChanged(), diffConfig.getContextType());
                    diffResults.add(changedDiffResult);
                }
            }
            if (element1 instanceof MetaStatspezObjekt) {
                diffResults.addAll(EdtDiffFacade.diffElement((MetaStatspezObjekt)element1, (MetaStatspezObjekt)element2, diffConfig));
            }
            diffResults.addAll(DiffElement.getDiffElement(element1).getDiffFunction().diff(element1, element2, diffConfig));
        } else {
            DiffResultElementTypeChanged changedDiffResult = new DiffResultElementTypeChanged(element1, element2, 1, diffConfig.getContextType());
            diffResults.add(changedDiffResult);
        }
        return diffResults;
    }

    public static List diffElement(MetaPLMaterial material1, MetaPLMaterial material2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        return diffResults;
    }

    public static List diffElement(MetaStatspezObjekt object1, MetaStatspezObjekt object2, DiffConfig diffConfig) {
        LinkedList diffResults = new LinkedList();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
        }
        String valueStr1 = null;
        String valueStr2 = null;
        valueStr1 = object1.getBeschreibung();
        valueStr2 = object2.getBeschreibung();
        EdtDiffFacade.checkDiff((MetaElement)object1, (MetaElement)object2, "Beschreibung", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = object1.getKommentar();
        valueStr2 = object2.getKommentar();
        EdtDiffFacade.checkDiff((MetaElement)object1, (MetaElement)object2, "Kommentar", valueStr1, valueStr2, diffResults, diffConfig);
        valueStr1 = object1.getName();
        valueStr2 = object2.getName();
        EdtDiffFacade.checkDiff((MetaElement)object1, (MetaElement)object2, "Name", valueStr1, valueStr2, diffResults, diffConfig);
        return diffResults;
    }

    public static List diffGlobalThemenbereiche(MetaCustomPlausibilisierung plausi1, MetaCustomPlausibilisierung plausi2, DiffConfig diffConfig) {
        MetaElement element2;
        LinkedList<DiffResult> diffResults = new LinkedList<DiffResult>();
        if (diffConfig == null) {
            diffConfig = new DiffConfig();
            diffConfig.setContextType(1);
        }
        TreeMap<String, MetaCustomThemenbereich> tbMap1 = new TreeMap<String, MetaCustomThemenbereich>();
        Iterator iterator = plausi1.getThemenbereiche();
        while (iterator.hasNext()) {
            MetaCustomThemenbereich tb = (MetaCustomThemenbereich)iterator.next();
            tbMap1.put(tb.getName(), tb);
        }
        TreeMap<String, MetaCustomThemenbereich> tbMap2 = new TreeMap<String, MetaCustomThemenbereich>();
        iterator = plausi2.getThemenbereiche();
        while (iterator.hasNext()) {
            MetaCustomThemenbereich tb = (MetaCustomThemenbereich)iterator.next();
            tbMap2.put(tb.getName(), tb);
        }
        for (Map.Entry entry : tbMap1.entrySet()) {
            String context = (String)entry.getKey();
            MetaCustomThemenbereich element1 = (MetaCustomThemenbereich)entry.getValue();
            element2 = (MetaCustomThemenbereich)tbMap2.get(context);
            if (element2 != null) continue;
            diffResults.add(new DiffResultElementRemoved(element1, DiffElement.getDiffElement(element1).getDtRemoved(), diffConfig.getContextType()));
        }
        for (Map.Entry entry : tbMap2.entrySet()) {
            String context = (String)entry.getKey();
            element2 = (MetaElement)entry.getValue();
            MetaElement element1 = (MetaElement)tbMap1.get(context);
            if (element1 != null) continue;
            diffResults.add(new DiffResultElementAdded(element2, DiffElement.getDiffElement(element2).getDtAdded(), diffConfig.getContextType()));
        }
        return diffResults;
    }

    private static boolean attributeDiffers(String attribute1, String attribute2) {
        boolean differs = false;
        differs = attribute1 != null && attribute2 != null ? !attribute1.equals(attribute2) : (attribute1 != null && attribute2 == null ? true : attribute1 == null && attribute2 != null);
        return differs;
    }

    private static void checkDiff(MetaElement element1, MetaElement element2, String attribute, boolean value1, boolean value2, List diffResults, DiffConfig diffConfig) {
        if (value1 != value2) {
            diffResults.add(EdtDiffFacade.createChangedResult(element1, element2, attribute, String.valueOf(value1), String.valueOf(value2), diffConfig));
        }
    }

    private static void checkDiff(MetaElement element1, MetaElement element2, String attribute, long value1, long value2, List diffResults, DiffConfig diffConfig) {
        if (value1 != value2) {
            diffResults.add(EdtDiffFacade.createChangedResult(element1, element2, attribute, String.valueOf(value1), String.valueOf(value2), diffConfig));
        }
    }

    private static void checkDiff(MetaElement element1, MetaElement element2, String attribute, String value1, String value2, List diffResults, DiffConfig diffConfig) {
        if (EdtDiffFacade.attributeDiffers(value1, value2)) {
            diffResults.add(EdtDiffFacade.createChangedResult(element1, element2, attribute, value1, value2, diffConfig));
        }
    }

    private static DiffResultElementChanged createChangedResult(MetaElement metaElement1, MetaElement metaElement2, String attribute, String value1, String value2, DiffConfig diffConfig) {
        return new DiffResultElementChanged(metaElement1, metaElement2, attribute, value1, value2, DiffElement.getDiffElement(metaElement1).getDtChanged(), diffConfig.getContextType());
    }

    private EdtDiffFacade() {
    }
}

