/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.CustomDokuElement;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaAblaufStatement;
import de.statspez.pleditor.generator.meta.MetaCheckFeldStatement;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaFunctionCall;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.MetaPruefeStatement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Stack;

public class AblaufListBuilder
extends Traverser {
    private int pruefIndex = 0;
    private HashSet verzweigendeAbl = new HashSet();
    private HashSet ablaufElementHash = new HashSet();
    private Hashtable idMerkmalHash = new Hashtable();
    private ArrayList feldElementList = new ArrayList();
    private ArrayList pruefElementList = new ArrayList();
    private ArrayList testElementList = new ArrayList();
    private ArrayList funcElementList = new ArrayList();
    private ArrayList feldPruefElementList = new ArrayList();
    private Hashtable aufgerufeneAblaeufe = new Hashtable();
    private ArrayList alreadyStoredElements = new ArrayList();
    private Stack nameSpace = new Stack();
    private Stack ablaeufe = new Stack();
    private Stack ablaufIds = new Stack();
    private String tbId = "";

    public synchronized void generateAblaufLists(MetaCustomAblauf ablauf) {
        this.alreadyStoredElements.clear();
        this.nameSpace.push(ablauf.getThemenbereich().getName());
        this.ablaeufe.push(ablauf.getName());
        this.ablaufIds.push(ablauf.getId());
        this.tbId = ablauf.getThemenbereich().getId();
        ablauf.getMetaSpezifikation().statements().accept(this);
    }

    public Hashtable getAufgerufeneAblaeufe() {
        return this.aufgerufeneAblaeufe;
    }

    public HashSet getAblaufElements() {
        return this.ablaufElementHash;
    }

    public ArrayList getFeldElementList() {
        return this.feldElementList;
    }

    public ArrayList getFeldPruefElementList() {
        return this.feldPruefElementList;
    }

    public Hashtable getMerkamlElementHash() {
        return this.idMerkmalHash;
    }

    public ArrayList getPruefElementList() {
        return this.pruefElementList;
    }

    public ArrayList getTestElementList() {
        return this.testElementList;
    }

    public ArrayList getFuncElementList() {
        return this.funcElementList;
    }

    @Override
    public void visitAblaufStatement(MetaAblaufStatement statement) {
        MetaCustomAblauf abl = (MetaCustomAblauf)statement.referredElement();
        MetaProgram prg = abl.getMetaSpezifikation();
        this.erfasseAblauf(abl);
        this.nameSpace.push(abl.getThemenbereich().getName());
        this.ablaeufe.push(abl.getName());
        this.ablaufIds.push(abl.getId());
        String oldTbId = this.tbId;
        this.tbId = abl.getThemenbereich().getId();
        int oldPruefIndex = this.pruefIndex;
        this.pruefIndex = 0;
        if (!this.verzweigendeAbl.contains(abl.getId())) {
            this.verzweigendeAbl.add(abl.getId());
            prg.statements().accept(this);
            this.verzweigendeAbl.remove(abl.getId());
        } else {
            System.err.println("Ablauf " + abl.getName() + " in Thememenbereich " + abl.getThemenbereich().getName() + " wird nicht Ueberpr\u00fcft. (Zirkelbezug)");
        }
        this.nameSpace.pop();
        this.ablaeufe.pop();
        this.ablaufIds.pop();
        this.tbId = oldTbId;
        this.pruefIndex = oldPruefIndex;
        super.visitAblaufStatement(statement);
    }

    @Override
    public void visitCheckFeldStatement(MetaCheckFeldStatement statement) {
        MetaCustomTBFeld f = (MetaCustomTBFeld)statement.referredElement();
        if (f != null) {
            CustomDokuElement fcde = new CustomDokuElement(f.getId(), String.valueOf(f.getThemenbereich().getName()) + "." + f.getName());
            fcde.setTbId(f.getThemenbereich().getId());
            fcde.setAblauf(this.nameSpace.peek() + "." + this.ablaeufe.peek(), (String)this.ablaufIds.peek());
            fcde.setElement(f);
            this.feldElementList.add(fcde);
            this.feldPruefElementList.add(fcde);
            if (f.getKlasse() instanceof MetaCustomMerkmal) {
                MetaCustomMerkmal m = (MetaCustomMerkmal)f.getKlasse();
                CustomDokuElement mde = new CustomDokuElement(m.getId(), m.getName());
                mde.setElement(m);
                this.idMerkmalHash.put(mde.getId(), mde);
            }
        }
        super.visitCheckFeldStatement(statement);
    }

    @Override
    public void visitPruefeStatement(MetaPruefeStatement statement) {
        MetaCustomPruefung p = (MetaCustomPruefung)statement.referredElement();
        if (!this.alreadyStoredElements.contains(p.getId())) {
            this.alreadyStoredElements.add(p.getId());
            CustomDokuElement cde = new CustomDokuElement(p.getId(), p.getName());
            cde.setTbId(p.getThemenbereich().getId());
            cde.setAblauf(this.nameSpace.peek() + "." + this.ablaeufe.peek(), (String)this.ablaufIds.peek());
            cde.setLocalIndex(++this.pruefIndex);
            cde.setElement(p);
            this.pruefElementList.add(cde);
            this.feldPruefElementList.add(cde);
            p.getMetaSpezifikation().accept(this);
        }
    }

    @Override
    public void visitFunctionCall(MetaFunctionCall statement) {
        MetaCustomFunktion f = (MetaCustomFunktion)statement.referredElement();
        if (f.getId() != null && f.getThemenbereich() != null && !this.alreadyStoredElements.contains(f.getId())) {
            this.alreadyStoredElements.add(f.getId());
            CustomDokuElement cde = new CustomDokuElement(f.getId(), String.valueOf(f.getThemenbereich().getName()) + "." + f.getName());
            cde.setTbId(f.getThemenbereich().getId());
            cde.setAblauf(this.nameSpace.peek() + "." + this.ablaeufe.peek(), (String)this.ablaufIds.peek());
            cde.setElement(f);
            if (f.getFunctionType() == 1) {
                this.testElementList.add(cde);
            } else {
                this.funcElementList.add(cde);
            }
            f.getMetaSpezifikation().accept(this);
        }
    }

    private void erfasseAblauf(MetaCustomAblauf abl) {
        if (this.aufgerufeneAblaeufe.get(this.ablaufIds.peek()) == null) {
            this.aufgerufeneAblaeufe.put(this.ablaufIds.peek(), new ArrayList());
        }
        DokuElement de = new DokuElement(abl.getId(), String.valueOf(abl.getThemenbereich().getName()) + "." + abl.getName());
        de.setTbId(abl.getThemenbereich().getId());
        de.setElement(abl);
        this.ablaufElementHash.add(de);
        ((ArrayList)this.aufgerufeneAblaeufe.get(this.ablaufIds.peek())).add(de);
    }
}

