/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AbstractStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;

public class FeldStat
extends AbstractStat {
    private Hashtable contextIdTable = new Hashtable();
    private Hashtable feldTbTable = new Hashtable();
    private Hashtable idKontexteTable = new Hashtable();
    private HashSet emptyFields = new HashSet();
    private HashSet inDSB = new HashSet();
    private HashSet referencedByFlows = new HashSet();
    private ArrayList emptyFieldsList = null;
    private ArrayList notInDSBList = null;
    private ArrayList notReferencedByFlowsList = null;

    @Override
    public void add(MetaStatspezObjekt feld) {
        MetaCustomTBFeld f = (MetaCustomTBFeld)feld;
        String id = f.getId();
        if (!this.idElementTable.containsKey(id)) {
            String name = String.valueOf(f.getThemenbereich().getName()) + "." + f.getName();
            DokuElement de = new DokuElement(id, name, f.dimensions());
            de.setTbId(f.getThemenbereich().getId());
            de.setElement(f);
            this.idElementTable.put(id, de);
            this.contextIdTable.put(String.valueOf(f.getThemenbereich().getId()) + "." + f.getName(), id);
            this.idKontexteTable.put(id, new HashSet());
            if (f.getFreigabeStatus() == 0) {
                this.addToLocked(id);
            }
            if (f.getKlasse() == null) {
                this.emptyFields.add(id);
            }
            if (f.getKommentar() != null && f.getKommentar().trim().length() > 0) {
                this.addToWithAnnotation(id);
            }
        }
    }

    public boolean addToInDSB(String fieldId) {
        assert (this.idElementTable.containsKey(fieldId)) : "Das Feld mit der ID" + fieldId + " ist nicht noch nicht erfasst worden.";
        return this.inDSB.add(fieldId);
    }

    public boolean addKontext(String feldID, String kontext) {
        HashSet set = (HashSet)this.idKontexteTable.get(feldID);
        return set.add(kontext);
    }

    public String getBaseContext(String context) {
        int lastInd = context.lastIndexOf(46);
        if (lastInd == context.length() - 1 || lastInd < 0) {
            System.err.println("FeldStat: Der Kontext (\"" + context + "\") enthaelt kein Feld.");
            return null;
        }
        String _context = context;
        int ind = context.indexOf(46);
        if (ind == lastInd && this.feldTbTable.get(context) == null) {
            return context;
        }
        String id = context.substring(0, ind);
        context = context.substring(ind + 1);
        do {
            if ((ind = context.indexOf(46)) < 0) {
                ind = context.length();
            }
            String feld = context.substring(0, ind);
            String newId = (String)this.feldTbTable.get(String.valueOf(id) + "." + feld);
            if (newId == null) break;
            if (context.indexOf(46) <= 0) {
                System.err.println("FeldStat: Der Kontext " + _context + " verweist auf einen Themenbereich.");
                return null;
            }
            id = newId;
        } while ((context = context.substring(ind + 1)).indexOf(46) > 0);
        return String.valueOf(id) + "." + context;
    }

    public HashSet getEmptyFields() {
        return this.emptyFields;
    }

    public int getEmptyFieldsCount() {
        return this.emptyFields.size();
    }

    public List getEmptyFieldsList() {
        if (this.emptyFieldsList == null) {
            return this.resolveIds(this.emptyFields);
        }
        return this.emptyFieldsList;
    }

    public String getFieldIdFromContext(String context) {
        if (context.lastIndexOf(46) != context.indexOf(46)) {
            context = this.getBaseContext(context);
        }
        return (String)this.contextIdTable.get(context);
    }

    public String getFromFeldTbHash(String context) {
        return (String)this.feldTbTable.get(context);
    }

    public List getKontexts(String feldID) {
        ArrayList liste = new ArrayList();
        HashSet set = (HashSet)this.idKontexteTable.get(feldID);
        if (set != null) {
            liste.addAll(set);
        }
        Collections.sort(liste);
        return liste;
    }

    public HashSet getNotInDSB() {
        HashSet<String> notInDSB = new HashSet<String>();
        for (String id : this.idElementTable.keySet()) {
            DokuElement de = (DokuElement)this.idElementTable.get(id);
            String context = String.valueOf(de.getTbId()) + "." + de.getBaseName();
            if (this.inDSB.contains(id) || this.feldTbTable.containsKey(context)) continue;
            notInDSB.add(id);
        }
        return notInDSB;
    }

    public int getNotInDSBCount() {
        return this.getNotInDSB().size();
    }

    public List getNotInDSBList() {
        if (this.notInDSBList == null) {
            return this.resolveIds(this.getNotInDSB());
        }
        return this.notInDSBList;
    }

    public HashSet getNotReferencedByFlows() {
        HashSet<String> notReferencedByFlows = new HashSet<String>();
        for (String id : this.idElementTable.keySet()) {
            DokuElement de = (DokuElement)this.idElementTable.get(id);
            String context = String.valueOf(de.getTbId()) + "." + de.getBaseName();
            if (this.referencedByFlows.contains(id) || this.feldTbTable.containsKey(context)) continue;
            notReferencedByFlows.add(id);
        }
        return notReferencedByFlows;
    }

    public int getNotReferencedByFlowsCount() {
        return this.getNotReferencedByFlows().size();
    }

    public List getNotReferencedByFlowsList() {
        if (this.notInDSBList == null) {
            return this.resolveIds(this.getNotReferencedByFlows());
        }
        return this.notReferencedByFlowsList;
    }

    public HashSet getReferencedByFlows() {
        return this.referencedByFlows;
    }

    @Override
    public void initializeLists() {
        this.initializeLists(false);
    }

    @Override
    public void initializeLists(boolean force) {
        if (this.emptyFieldsList == null || force) {
            this.emptyFieldsList = new ArrayList();
            this.emptyFieldsList.addAll(this.resolveIds(this.emptyFields));
        }
        if (this.notInDSBList == null || force) {
            this.notInDSBList = new ArrayList();
            this.notInDSBList.addAll(this.resolveIds(this.getNotInDSB()));
        }
        if (this.notReferencedByFlowsList == null || force) {
            this.notReferencedByFlowsList = new ArrayList();
            this.notReferencedByFlowsList.addAll(this.resolveIds(this.getNotReferencedByFlows()));
        }
        super.initializeLists(force);
    }

    public void putToFeldTbHash(String feldKontext, String tbId) {
        this.feldTbTable.put(feldKontext, tbId);
    }

    public void setReferencedByFlows(HashSet set) {
        this.referencedByFlows = set;
    }

    @Override
    public void sortLists() {
        this.initializeLists();
        Collections.sort(this.emptyFieldsList);
        Collections.sort(this.notInDSBList);
        Collections.sort(this.notReferencedByFlowsList);
        super.sortListsOnly();
    }
}

