/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaDatBObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;

public class KommentarStat {
    private int annotationCount = 0;
    private int elementCount = 0;
    private Hashtable checkAnnotations = new Hashtable();
    private Hashtable classificationAnnotations = new Hashtable();
    private Hashtable dsbAnnotations = new Hashtable();
    private Hashtable datBAnnotations = new Hashtable();
    private Hashtable fieldAnnotations = new Hashtable();
    private Hashtable flowAnnotations = new Hashtable();
    private Hashtable functionAnnotations = new Hashtable();
    private Hashtable mappingAnnotations = new Hashtable();
    private Hashtable materialAnnotations = new Hashtable();
    private Hashtable statVarAnnotations = new Hashtable();
    private Hashtable testAnnotations = new Hashtable();
    private Hashtable topicAnnotations = new Hashtable();
    private ArrayList datBList = new ArrayList();
    private ArrayList mappingList = new ArrayList();
    private String plausiAnnotation = null;
    private String plausiName = null;

    public void addToCheckAnnotations(MetaCustomPruefung pruefung) {
        if (!this.checkAnnotations.containsKey(pruefung.getId())) {
            String annotation = pruefung.getKommentar();
            if (annotation != null && annotation.trim().length() > 0) {
                ++this.annotationCount;
                this.checkAnnotations.put(pruefung.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToClassificationAnnotations(MetaAuspraegungsgruppe mag) {
        if (!this.classificationAnnotations.containsKey(mag.getId())) {
            String annotation = mag.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.classificationAnnotations.put(mag.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToDatBAnnotations(MetaDatBObjekt mdb) {
        String id = mdb.getId();
        if (!this.datBAnnotations.containsKey(id)) {
            String annotation = mdb.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.datBAnnotations.put(id, annotation);
                this.datBList.add(new DokuElement(id, mdb.getName()));
            }
            ++this.elementCount;
        }
    }

    public void addToDsbAnnotations(MetaDsbObjekt dsb) {
        if (!this.dsbAnnotations.containsKey(dsb.getId())) {
            String annotation = dsb.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.dsbAnnotations.put(dsb.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToFieldAnnotations(MetaCustomTBFeld feld) {
        if (!this.fieldAnnotations.containsKey(feld.getId())) {
            String annotation = feld.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.fieldAnnotations.put(feld.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToFlowAnnotations(MetaCustomAblauf ablauf) {
        if (!this.flowAnnotations.containsKey(ablauf.getId())) {
            String annotation = ablauf.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.flowAnnotations.put(ablauf.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToFunctionAnnotations(MetaCustomFunktion funktion) {
        String annotation = funktion.getKommentar();
        String id = funktion.getId();
        if (!this.testAnnotations.containsKey(id) && !this.functionAnnotations.containsKey(id)) {
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                if (funktion.getFunctionType() == 0) {
                    this.functionAnnotations.put(id, annotation);
                } else if (funktion.getFunctionType() == 1) {
                    this.testAnnotations.put(id, annotation);
                } else {
                    System.err.println("Unbekannter Funktionstyp: " + funktion.getThemenbereich().getName() + "." + funktion.getName() + " (ID: " + id + ", Typ: " + funktion.getFunctionType() + ")");
                }
            }
            ++this.elementCount;
        }
    }

    public void addToMappingAnnotations(MetaMapping mapping) {
        String id = mapping.getId();
        if (!this.mappingAnnotations.containsKey(id)) {
            String annotation = mapping.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.mappingAnnotations.put(id, annotation);
                this.mappingList.add(new DokuElement(id, mapping.getName()));
            }
            ++this.elementCount;
        }
    }

    public void addToMaterialAnnotations(MetaPLMaterial material) {
        if (!this.materialAnnotations.containsKey(material.getId())) {
            String annotation = material.getKommentar();
            if (annotation != null && annotation.trim().length() > 0) {
                ++this.annotationCount;
                this.materialAnnotations.put(material.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToStatVarAnnotations(MetaMerkmal aMerkmal) {
        if (!this.statVarAnnotations.containsKey(aMerkmal.getId())) {
            String annotation = aMerkmal.getKommentar();
            if (annotation != null && annotation.length() > 0) {
                ++this.annotationCount;
                this.statVarAnnotations.put(aMerkmal.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public void addToTopicAnnotations(MetaThemenbereich tb) {
        if (!this.topicAnnotations.containsKey(tb.getId())) {
            String annotation = tb.getKommentar();
            if (annotation != null && annotation.trim().length() > 0) {
                ++this.annotationCount;
                this.topicAnnotations.put(tb.getId(), annotation);
            }
            ++this.elementCount;
        }
    }

    public int getAnnotationsCount() {
        return this.annotationCount;
    }

    public Hashtable getCheckAnnotations() {
        return this.checkAnnotations;
    }

    public int getCheckAnnotationsCount() {
        return this.checkAnnotations.size();
    }

    public Hashtable getClassificationsAnnotations() {
        return this.classificationAnnotations;
    }

    public int getClassificationsAnnotationsCount() {
        return this.classificationAnnotations.size();
    }

    public Hashtable getDatBAnnotations() {
        return this.datBAnnotations;
    }

    public int getDatBAnnotationsCount() {
        return this.datBAnnotations.size();
    }

    public ArrayList getDatBList() {
        return this.datBList;
    }

    public Hashtable getDsbAnnotations() {
        return this.dsbAnnotations;
    }

    public int getDsbAnnotationCount() {
        return this.dsbAnnotations.size();
    }

    public int getElementCount() {
        return this.elementCount;
    }

    public Hashtable getFieldAnnotations() {
        return this.fieldAnnotations;
    }

    public int getFieldAnnotationsCount() {
        return this.fieldAnnotations.size();
    }

    public Hashtable getFlowAnnotations() {
        return this.flowAnnotations;
    }

    public int getFlowAnnotationsCount() {
        return this.flowAnnotations.size();
    }

    public Hashtable getFunctionAnnotations() {
        return this.functionAnnotations;
    }

    public int getFunctionAnnotationsCount() {
        return this.functionAnnotations.size();
    }

    public Hashtable getMappingAnnotations() {
        return this.mappingAnnotations;
    }

    public int getMappingAnnotationsCount() {
        return this.mappingAnnotations.size();
    }

    public ArrayList getMappingList() {
        return this.mappingList;
    }

    public Hashtable getMaterialAnnotations() {
        return this.materialAnnotations;
    }

    public int getMaterialAnnotationsCount() {
        return this.materialAnnotations.size();
    }

    public String getPlausiAnnotation() {
        return this.plausiAnnotation;
    }

    public String getPlausiName() {
        return this.plausiName;
    }

    public Hashtable getStatVarAnnotations() {
        return this.statVarAnnotations;
    }

    public int getStatVarAnnotationsCount() {
        return this.statVarAnnotations.size();
    }

    public Hashtable getTestAnnotations() {
        return this.testAnnotations;
    }

    public int getTestAnnotationsCount() {
        return this.testAnnotations.size();
    }

    public Hashtable getTopicAnnotations() {
        return this.topicAnnotations;
    }

    public int getTopicAnnotationsCount() {
        return this.topicAnnotations.size();
    }

    public void setPlausiAnnotation(String name, String annotation) {
        if (this.plausiName == null) {
            ++this.elementCount;
        }
        this.plausiName = name;
        this.plausiAnnotation = annotation != null ? annotation.trim() : "";
    }

    public void sortLists() {
        Collections.sort(this.datBList);
        Collections.sort(this.mappingList);
    }
}

