/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.analysis.CrossReferenceBuilder;
import de.statspez.pleditor.generator.codegen.analysis.ErhebungsTBReferenceBuilder;
import de.statspez.pleditor.generator.codegen.doku.AblaufStat;
import de.statspez.pleditor.generator.codegen.doku.ClassificationDokuGenerator;
import de.statspez.pleditor.generator.codegen.doku.CustomDokuElement;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.DokugenUtil;
import de.statspez.pleditor.generator.codegen.doku.DsbStat;
import de.statspez.pleditor.generator.codegen.doku.EinzelfeldStat;
import de.statspez.pleditor.generator.codegen.doku.FeldStat;
import de.statspez.pleditor.generator.codegen.doku.FunktionStat;
import de.statspez.pleditor.generator.codegen.doku.KlassifikationStat;
import de.statspez.pleditor.generator.codegen.doku.KommentarStat;
import de.statspez.pleditor.generator.codegen.doku.MaterialStat;
import de.statspez.pleditor.generator.codegen.doku.MerkmalStat;
import de.statspez.pleditor.generator.codegen.doku.PlausiStat;
import de.statspez.pleditor.generator.codegen.doku.PruefungStat;
import de.statspez.pleditor.generator.codegen.doku.Settings;
import de.statspez.pleditor.generator.codegen.doku.TbFeldErsetzer;
import de.statspez.pleditor.generator.codegen.doku.TbStat;
import de.statspez.pleditor.generator.codegen.doku.ThemenbereichDokuGenerator;
import de.statspez.pleditor.generator.codegen.doku.XMLCodeGenerator;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.common.ElementMessageContext;
import de.statspez.pleditor.generator.meta.MetaCustomAblauf;
import de.statspez.pleditor.generator.meta.MetaCustomFunktion;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomMappingElement;
import de.statspez.pleditor.generator.meta.MetaCustomMerkmal;
import de.statspez.pleditor.generator.meta.MetaCustomPlausibilisierung;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.MetaCustomTBFeld;
import de.statspez.pleditor.generator.meta.MetaCustomThemenbereich;
import de.statspez.pleditor.generator.meta.generated.MetaAuspraegungsgruppe;
import de.statspez.pleditor.generator.meta.generated.MetaDatBObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaDsbFeld;
import de.statspez.pleditor.generator.meta.generated.MetaDsbObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaEinzelfeld;
import de.statspez.pleditor.generator.meta.generated.MetaMapping;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLAuspraegung;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPLPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaSatzart;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import de.statspez.pleditor.generator.meta.generated.MetaTBFeld;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.uebersetzer.Tags;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class PlausiDokuGenerator
extends XMLCodeGenerator {
    private AblaufStat ablaufStat = null;
    private DsbStat dsbStat = null;
    private EinzelfeldStat efStat = null;
    private FeldStat feldStat = null;
    private KlassifikationStat klassifikationStat = null;
    private KommentarStat kommentarStat = null;
    private MaterialStat materialStat = null;
    private MerkmalStat merkmalStat = null;
    private PlausiStat plausiStat = null;
    private PruefungStat pruefungStat = null;
    private TbStat tbStat = null;
    private FunktionStat funktionStat = null;
    private TbFeldErsetzer tbFeldErsetzer = null;

    public PlausiDokuGenerator() {
        this.setEscapeCSV(false);
    }

    public PlausiDokuGenerator(boolean escapeCsv) {
        this.setEscapeCSV(escapeCsv);
    }

    public synchronized void getAndSortData(MetaCustomPlausibilisierung aPlausi, boolean ersetzeFeldNamen) throws CodegenException {
        if (ersetzeFeldNamen && aPlausi.getUsedDsbObjekt() == null) {
            throw new RuntimeException("Plausibilisierung enth\u00e4lt keine Datensatzbeschreibung.");
        }
        this.ablaufStat = new AblaufStat();
        this.dsbStat = new DsbStat();
        this.efStat = new EinzelfeldStat();
        this.feldStat = new FeldStat();
        this.klassifikationStat = new KlassifikationStat();
        this.kommentarStat = new KommentarStat();
        this.materialStat = new MaterialStat();
        this.merkmalStat = new MerkmalStat();
        this.plausiStat = new PlausiStat();
        this.pruefungStat = new PruefungStat();
        this.tbStat = new TbStat();
        this.funktionStat = new FunktionStat();
        if (ersetzeFeldNamen) {
            this.tbFeldErsetzer = new TbFeldErsetzer(this.efStat);
        }
        this.getData(aPlausi);
        this.merkmalStat.sortLists();
        this.pruefungStat.sortLists();
        this.kommentarStat.sortLists();
        this.ablaufStat.sortLists();
        this.materialStat.sortLists();
        this.tbStat.sortLists();
        this.feldStat.sortLists();
        this.funktionStat.sortLists();
    }

    public synchronized void printDataSetTypeDoc() {
        DokuElement de = this.plausiStat.getDsbElement();
        if (de == null) {
            throw new RuntimeException("Plausibilisierung enth\u00e4lt keine Datensatzbeschreibung.");
        }
        MetaDsbObjekt dsb = (MetaDsbObjekt)de.getElement();
        this.beginDoc();
        this.appendDocHead(null);
        this.beginBlock("doc:dataSetTypeDoc");
        this.beginBlock("doc:context");
        this.appendDataSetTypeDoc(dsb);
        this.endBlock("doc:context");
        this.endBlock("doc:dataSetTypeDoc");
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printFlowDoc(String ablaufId) {
        this.beginDoc();
        this.appendDocHead(ablaufId);
        this.beginBlock("doc:flowDoc");
        this.beginBlock("doc:context");
        this.appendFlowDoc(ablaufId);
        this.endBlock("doc:context");
        this.endBlock("doc:flowDoc");
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printClassificationDoc(String[] statVarIds) {
        ArrayList<String> tmpList = new ArrayList<String>();
        if (statVarIds != null && statVarIds.length != 0) {
            tmpList.addAll(Arrays.asList(statVarIds));
        } else {
            tmpList.addAll(this.merkmalStat.getIDs());
        }
        this.beginDoc();
        this.appendDocHead(null);
        this.beginBlock("doc:classificationDoc");
        this.beginBlock("doc:context");
        this.appendClassificationDoc(tmpList);
        this.endBlock("doc:context");
        this.endBlock("doc:classificationDoc");
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printCheckDoc(String ablaufId) {
        DokuElement de = this.ablaufStat.getElement(ablaufId);
        this.beginDoc();
        this.appendDocHead(ablaufId);
        this.beginBlock("doc:checkSpecificationDoc");
        this.beginBlock("doc:context");
        this.appendCheckDoc(ablaufId);
        this.appendTestDoc(this.ablaufStat.getTestAblauf(de.getId()));
        this.appendFunctionDoc(this.ablaufStat.getFuncAblauf(de.getId()));
        this.endBlock("doc:context");
        this.endBlock("doc:checkSpecificationDoc");
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printCheckOrder(String ablaufId) {
        DokuElement de = this.ablaufStat.getElement(ablaufId);
        Iterator it = this.ablaufStat.getFeldPruefAblauf(de.getId()).iterator();
        this.beginDoc();
        this.appendDocHead(ablaufId);
        this.beginBlock("doc:checkOrderDoc");
        this.beginBlock("doc:context");
        this.appendCheckOrder(it);
        this.appendTestDoc(this.ablaufStat.getTestAblauf(de.getId()));
        this.appendFunctionDoc(this.ablaufStat.getFuncAblauf(de.getId()));
        this.endBlock("doc:context");
        this.endBlock("doc:checkOrderDoc");
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printAllAnalysis() {
        this.beginDoc();
        this.appendAnalysisHead();
        this.appendStatVarAnalysis();
        this.appendFieldAnalysis();
        this.appendCheckAnalysis();
        this.appendAnnotationAnalysis();
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printStatVarAnalysis() {
        this.beginDoc();
        this.appendAnalysisHead();
        this.appendStatVarAnalysis();
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printStatVarDoc() {
        ArrayList merkmale = this.merkmalStat.getElementList();
        this.beginDoc();
        this.appendDocHead(null);
        this.beginBlock("doc:statisticVariableDoc");
        this.beginBlock("doc:context");
        this.appendStatVarDoc(merkmale);
        this.endBlock("doc:context");
        this.endBlock("doc:statisticVariableDoc");
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printCheckAnalysis() {
        this.beginDoc();
        this.appendAnalysisHead();
        this.appendCheckAnalysis();
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printFieldAnalysis() {
        this.beginDoc();
        this.appendAnalysisHead();
        this.appendFieldAnalysis();
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public synchronized void printAnnotationAnalysis() {
        this.beginDoc();
        this.appendAnalysisHead();
        this.appendAnnotationAnalysis();
        this.endDoc();
        this.out.flush();
        this.checkForErrors();
    }

    public AblaufStat getAblaufStat() {
        return this.ablaufStat;
    }

    public DsbStat getDsbStat() {
        return this.dsbStat;
    }

    public EinzelfeldStat getEfStat() {
        return this.efStat;
    }

    public FeldStat getFeldStat() {
        return this.feldStat;
    }

    public KlassifikationStat getKlassifikationStat() {
        return this.klassifikationStat;
    }

    public KommentarStat getKommentarStat() {
        return this.kommentarStat;
    }

    public MaterialStat getMaterialStat() {
        return this.materialStat;
    }

    public MerkmalStat getMerkmalStat() {
        return this.merkmalStat;
    }

    public PlausiStat getPlausiStat() {
        return this.plausiStat;
    }

    public PruefungStat getPruefungStat() {
        return this.pruefungStat;
    }

    public TbStat getTbStat() {
        return this.tbStat;
    }

    public FunktionStat getFunktionStat() {
        return this.funktionStat;
    }

    public boolean isErsetzeFeldNamen() {
        return this.tbFeldErsetzer != null;
    }

    public void setErsetzeFeldNamen(boolean ersetzeFeldNamen) {
        if (ersetzeFeldNamen) {
            if (this.tbFeldErsetzer == null) {
                this.tbFeldErsetzer = new TbFeldErsetzer(this.efStat);
            }
        } else {
            this.tbFeldErsetzer = null;
        }
    }

    @Override
    public void visitMerkmal(MetaMerkmal aMerkmal) {
        if (((MetaCustomMerkmal)aMerkmal).referencedByErhebung()) {
            this.merkmalStat.add(aMerkmal);
            if (aMerkmal.getKlasseWertebereich() != null) {
                this.klassifikationStat.addStatVarAccess(aMerkmal.getKlasseWertebereich(), aMerkmal.getId());
            }
            this.kommentarStat.addToStatVarAnnotations(aMerkmal);
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void visitThemenbereich(MetaThemenbereich tb) {
        block5: {
            System.out.println("### visitThemenbereich " + tb.getName());
            if (tb instanceof MetaCustomThemenbereich && ((MetaCustomThemenbereich)tb).referencedByErhebung()) {
                tbGen = new ThemenbereichDokuGenerator();
                tbGen.setOutput(this.out);
                tbGen.setIndentLevel(this.indentLevel());
                tbGen.setErrorContext(new ElementMessageContext(6, tb.getId(), tb.getName()));
                tbGen.setMerkmalStat(this.merkmalStat);
                tbGen.setPruefungStat(this.pruefungStat);
                tbGen.setKommentarStat(this.kommentarStat);
                tbGen.setAblaufStat(this.ablaufStat);
                tbGen.setTbStat(this.tbStat);
                tbGen.setFeldStat(this.feldStat);
                tbGen.setFunktionStat(this.funktionStat);
                try {
                    tbGen.generate(tb);
                    break block5;
                }
                catch (CodegenException e) {
                    i = 0;
                    ** while (i < e.errors().length)
                }
lbl-1000:
                // 1 sources

                {
                    this.error(e.errors()[i]);
                    ++i;
                    continue;
                }
lbl23:
                // 1 sources

                i = 0;
                while (i < e.warnings().length) {
                    this.warning(e.warnings()[i]);
                    ++i;
                }
            }
        }
    }

    private void appendAnalysisHead() {
        this.beginBlock("doc:head");
        this.appendBlock("doc:date", Settings.getCurrentDate());
        this.appendBlock("doc:statspezLevel", this.plausiStat.getEbene());
        this.appendBlock("doc:EVAS", this.plausiStat.getEVASNr());
        this.appendBlock("doc:surveyName", this.plausiStat.getName());
        this.appendBlock("doc:BZR", this.plausiStat.getBerichtszeitraum());
        this.endBlock("doc:head");
        this.out.flush();
    }

    private void appendAnnotationAnalysis() {
        this.beginBlock("doc:annotationDoc");
        this.beginBlock("doc:summary");
        this.appendCount("doc:annotations", this.kommentarStat.getAnnotationsCount());
        this.appendCount("doc:statisticVariableAnnotations", this.kommentarStat.getStatVarAnnotationsCount());
        this.appendCount("doc:classificationAnnotations", this.kommentarStat.getClassificationsAnnotationsCount());
        this.appendCount("doc:topicAnnotations", this.kommentarStat.getTopicAnnotationsCount());
        this.appendCount("doc:fieldAnnotations", this.kommentarStat.getFieldAnnotationsCount());
        this.appendCount("doc:checkAnnotations", this.kommentarStat.getCheckAnnotationsCount());
        this.appendCount("doc:functionAnnotations", this.kommentarStat.getFunctionAnnotationsCount());
        this.appendCount("doc:flowAnnotations", this.kommentarStat.getFlowAnnotationsCount());
        this.appendCount("doc:dataSetTypeAnnotations", this.kommentarStat.getDsbAnnotationCount());
        this.appendCount("doc:mappingAnnotations", this.kommentarStat.getMappingAnnotationsCount());
        this.appendCount("doc:materialAnnotations", this.kommentarStat.getMaterialAnnotationsCount());
        this.appendCount("doc:testAnnotations", this.kommentarStat.getTestAnnotationsCount());
        this.appendCount("doc:element", this.kommentarStat.getElementCount());
        this.endBlock("doc:summary");
        this.beginBlock("doc:context");
        this.beginBlock("doc:survey");
        if (this.kommentarStat.getPlausiAnnotation().length() > 0) {
            this.appendBlock("doc:name", this.kommentarStat.getPlausiName());
            this.appendBlock("doc:annotation", this.kommentarStat.getPlausiAnnotation());
        }
        this.endBlock("doc:survey");
        this.appendValueList("doc:statisticVariables", "statisticVariable", "doc:annotation", this.merkmalStat.getElementList(), this.kommentarStat.getStatVarAnnotations());
        this.appendValueList("doc:classifications", "classification", "doc:annotation", this.klassifikationStat.getElementList(), this.kommentarStat.getClassificationsAnnotations());
        this.appendValueList("doc:topics", "topic", "doc:annotation", this.tbStat.getElementList(), this.kommentarStat.getTopicAnnotations());
        this.appendValueList("doc:fields", "field", "doc:annotation", this.feldStat.getElementList(), this.kommentarStat.getFieldAnnotations());
        this.appendValueList("doc:checks", "check", "doc:annotation", this.pruefungStat.getElementList(), this.kommentarStat.getCheckAnnotations());
        this.appendValueList("doc:functions", "function", "doc:annotation", this.funktionStat.getFunktionen(true), this.kommentarStat.getFunctionAnnotations());
        this.appendValueList("doc:flows", "flow", "doc:annotation", this.ablaufStat.getElementList(), this.kommentarStat.getFlowAnnotations());
        this.appendValueList("doc:dataSetTypes", "dataSetType", "doc:annotation", this.dsbStat.getElementList(), this.kommentarStat.getDsbAnnotations());
        this.appendValueList("doc:mappings", "mapping", "doc:annotation", this.kommentarStat.getMappingList(), this.kommentarStat.getMappingAnnotations());
        this.appendValueList("doc:materials", "material", "doc:annotation", this.materialStat.getElementList(), this.kommentarStat.getMaterialAnnotations());
        this.appendValueList("doc:tests", "test", "doc:annotation", this.funktionStat.getEigenschften(true), this.kommentarStat.getTestAnnotations());
        this.endBlock("doc:context");
        this.endBlock("doc:annotationDoc");
        this.out.flush();
    }

    private void appendCheckAnalysis() {
        this.beginBlock("doc:checkDoc");
        this.beginBlock("doc:summary");
        this.beginBlock("doc:statisticVariables");
        this.appendCount("doc:allVariables", this.merkmalStat.getCount());
        this.appendCount("doc:withCheckVariables", this.merkmalStat.getChecksCount());
        this.appendCount("doc:neverCheckedVariables", this.merkmalStat.getNeverCheckedCount());
        this.endBlock("doc:statisticVariables");
        this.beginBlock("doc:checks");
        this.appendCount("doc:allChecks", this.pruefungStat.getCount());
        this.appendCount("doc:manualVerificationChecks", this.pruefungStat.getManualVerificationChecksCount());
        this.appendCount("doc:automaticVerificationChecks", this.pruefungStat.getAutomaticVerificationChecksCount());
        this.appendCount("doc:errorChecks", this.pruefungStat.getErrorVerificationChecksCount());
        this.appendCount("doc:warningChecks", this.pruefungStat.getWarninigVerificationChecksCount());
        this.appendCount("doc:lockedChecks", this.pruefungStat.getLockedCount());
        this.appendCount("doc:withAnnotationChecks", this.pruefungStat.getWithAnnotationCount());
        this.appendCount("doc:noCorrectionOrErrorTextChecks", this.pruefungStat.getNoCorrectionOrErrorTextCount());
        this.appendCount("doc:notReferencedChecks", this.pruefungStat.getNotReferencedCount());
        this.appendCount("doc:nonCompilableChecks", this.pruefungStat.getFehlerhafteElementeCount());
        this.endBlock("doc:checks");
        this.beginBlock("doc:topics");
        this.appendCount("doc:topicsWithoutChecks", this.tbStat.getWithoutChecksCount());
        this.endBlock("doc:topics");
        this.beginBlock("doc:functions");
        this.appendCount("doc:allFunctions", this.funktionStat.getFunktionen(false).size());
        this.appendCount("doc:allTests", this.funktionStat.getEigenschften(false).size());
        this.endBlock("doc:functions");
        this.endBlock("doc:summary");
        this.beginBlock("doc:context");
        this.beginBlock("doc:statisticVariables");
        this.appendList("doc:noCheckVariables", "statisticVariable", this.merkmalStat.getNoChecksList());
        this.appendList("doc:neverCheckedVariables", "statisticVariable", this.merkmalStat.getNeverCheckedList());
        this.endBlock("doc:statisticVariables");
        this.beginBlock("doc:checks");
        this.appendElementWithDescriptionList("doc:allChecks", "check", this.pruefungStat.getElementList());
        this.appendElementWithDescriptionList("doc:lockedChecks", "check", this.pruefungStat.getLockedList());
        this.appendElementWithDescriptionList("doc:withAnnotationChecks", "check", this.pruefungStat.getWithAnnotationList());
        this.appendElementWithDescriptionList("doc:noCorrectionOrErrorTextChecks", "check", this.pruefungStat.getNoCorrectionOrErrorTextList());
        this.appendElementWithDescriptionList("doc:notReferencedChecks", "check", this.pruefungStat.getNotReferencedList());
        this.appendElementWithDescriptionList("doc:nonCompilableChecks", "check", this.pruefungStat.getFehlerhafteElementeAsList(true));
        this.endBlock("doc:checks");
        this.beginBlock("doc:topics");
        this.appendList("doc:topicsWithoutChecks", "topic", this.tbStat.getWithoutChecksList());
        this.endBlock("doc:topics");
        this.beginBlock("doc:functions");
        this.appendList("doc:allFunctions", "function", this.funktionStat.getFunktionen(true));
        this.appendList("doc:allTests", "test", this.funktionStat.getEigenschften(true));
        this.endBlock("doc:functions");
        this.endBlock("doc:context");
        this.endBlock("doc:checkDoc");
        this.out.flush();
    }

    private void appendCheckDoc(String ablaufId) {
        TbFeldErsetzer tbFeldErsetzer = new TbFeldErsetzer(this.efStat);
        ArrayList pruefElemente = new ArrayList();
        pruefElemente.addAll(this.ablaufStat.getFeldAblauf(ablaufId));
        pruefElemente.addAll(this.ablaufStat.getPruefAblauf(ablaufId));
        this.beginBlock("doc:checks");
        Iterator it = pruefElemente.iterator();
        while (it.hasNext()) {
            short freigabestatus;
            short pruefArt;
            String beschreibung;
            String pakage;
            String kommentar;
            String korrekturhinweis;
            String fehlertextLang;
            String fehlertextKurz;
            String fehlergewicht;
            String anweisung;
            String bedingung;
            this.out.flush();
            CustomDokuElement cde = (CustomDokuElement)it.next();
            if (cde.getElement() instanceof MetaCustomPruefung) {
                MetaCustomPruefung mcp = (MetaCustomPruefung)cde.getElement();
                String[] ifThenAnw = this.isErsetzeFeldNamen() ? this.pruefungStat.splitConditionalStatement(tbFeldErsetzer.erstetzeTBFeldNamen(mcp.getMetaSpezifikation(), mcp.getPLSpezifikation())) : this.pruefungStat.splitConditionalStatement(mcp.getPLSpezifikation());
                bedingung = ifThenAnw[0];
                anweisung = ifThenAnw[1];
                fehlergewicht = "" + mcp.getFehlergewicht();
                fehlertextKurz = mcp.getFehlertextKurz();
                fehlertextLang = mcp.getFehlertextLang();
                korrekturhinweis = mcp.getKorrekturhinweis();
                kommentar = mcp.getKommentar();
                pakage = mcp.getMetaObjectContext().getObjectPakage();
                beschreibung = mcp.getBeschreibung();
                pruefArt = mcp.getPruefungsart();
                freigabestatus = mcp.getFreigabeStatus();
            } else {
                MetaCustomTBFeld metaTBFeld = (MetaCustomTBFeld)cde.getElement();
                MetaCustomMerkmal mm = (MetaCustomMerkmal)metaTBFeld.getKlasse();
                bedingung = DokugenUtil.getFieldSpecificationAsString(metaTBFeld);
                anweisung = null;
                fehlergewicht = null;
                fehlertextKurz = mm.getFehlertextKurz();
                fehlertextLang = mm.getFehlertextLang();
                korrekturhinweis = mm.getKorrekturhinweis();
                kommentar = metaTBFeld.getKommentar();
                pakage = metaTBFeld.getMetaObjectContext().getObjectPakage();
                beschreibung = metaTBFeld.getBeschreibung();
                pruefArt = 1;
                freigabestatus = metaTBFeld.getFreigabeStatus();
            }
            this.beginElementBlock(cde.getName(), cde.getId(), "check", cde.getZusatz());
            this.beginBlock("doc:flow");
            this.appendEmptyElement(cde.getAblaufName(), cde.getAblaufId(), "flow", "");
            this.endBlock("doc:flow");
            this.appendBlock("doc:flowIndex", cde.getLocalIndex());
            this.appendBlock("doc:checkType", Settings.FEHLERTEXTE[pruefArt - 1]);
            this.appendBlock("doc:error-weight", fehlergewicht);
            this.appendBlock("doc:condition", bedingung);
            if (pruefArt == 3) {
                this.appendBlock("doc:statement", anweisung);
            }
            this.appendBlock("doc:errorTextShort", fehlertextKurz);
            this.appendBlock("doc:errorTextLong", fehlertextLang);
            this.appendBlock("doc:status", Settings.FREIGABESTATUS[freigabestatus]);
            this.appendBlock("doc:correctionDescription", korrekturhinweis);
            this.appendBlock("doc:description", beschreibung);
            this.appendBlock("doc:objectPackage", Tags.dekodierePunkten((String)pakage));
            this.appendBlock("doc:annotation", kommentar);
            this.endElementBlock();
        }
        this.endBlock("doc:checks");
    }

    private void appendCheckOrder(Iterator it) {
        this.beginBlock("doc:checks");
        while (it.hasNext()) {
            MetaStatspezObjekt mcp;
            this.out.flush();
            CustomDokuElement cde = (CustomDokuElement)it.next();
            DokuElement feldOderPruefDe = this.pruefungStat.getElement(cde.getId());
            if (feldOderPruefDe == null) {
                feldOderPruefDe = this.feldStat.getElement(cde.getId());
            }
            if (feldOderPruefDe.getElement() != null && feldOderPruefDe.getElement() instanceof MetaCustomPruefung) {
                mcp = (MetaCustomPruefung)feldOderPruefDe.getElement();
                short pruefArt = ((MetaPLPruefung)mcp).getPruefungsart();
                String[] ifThenAnw = this.pruefungStat.splitConditionalStatement(((MetaCustomPruefung)mcp).getPLSpezifikation());
                this.beginElementBlock(mcp.getName(), mcp.getId(), "check", feldOderPruefDe.getZusatz());
                this.appendBlock("doc:checkType", Settings.FEHLERTEXTE[pruefArt - 1]);
                this.beginBlock("doc:flow");
                this.appendEmptyElement(cde.getAblaufName(), cde.getAblaufId(), "flow", "");
                this.endBlock("doc:flow");
                this.beginBlock("doc:topic");
                this.appendEmptyElement(((MetaCustomPruefung)mcp).getThemenbereich().getName(), ((MetaCustomPruefung)mcp).getThemenbereich().getId(), "topic", cde.getZusatz());
                this.endBlock("doc:topic");
                this.appendBlock("doc:condition", ifThenAnw[0]);
                if (pruefArt == 3) {
                    this.appendBlock("doc:statement", ifThenAnw[1]);
                }
                this.appendBlock("doc:errorTextShort", ((MetaPLPruefung)mcp).getFehlertextKurz());
                this.endElementBlock();
                continue;
            }
            if (feldOderPruefDe.getElement() == null || !(feldOderPruefDe.getElement() instanceof MetaCustomTBFeld) || ((MetaTBFeld)(mcp = (MetaCustomTBFeld)feldOderPruefDe.getElement())).getKlasse() == null || !(((MetaTBFeld)mcp).getKlasse() instanceof MetaCustomMerkmal)) continue;
            MetaCustomMerkmal mm = (MetaCustomMerkmal)((MetaTBFeld)mcp).getKlasse();
            String plSpezifikation = DokugenUtil.getFieldSpecificationAsString((MetaCustomTBFeld)mcp);
            if (plSpezifikation == null) {
                plSpezifikation = "";
            }
            this.beginElementBlock(feldOderPruefDe.getName(), mcp.getId(), "check", feldOderPruefDe.getZusatz());
            this.appendBlock("doc:checkType", Settings.FEHLERTEXTE[0]);
            this.beginBlock("doc:flow");
            this.appendEmptyElement(cde.getAblaufName(), cde.getAblaufId(), "flow", "");
            this.endBlock("doc:flow");
            this.beginBlock("doc:topic");
            this.appendEmptyElement(((MetaCustomTBFeld)mcp).getThemenbereich().getName(), ((MetaCustomTBFeld)mcp).getThemenbereich().getId(), "topic", cde.getZusatz());
            this.endBlock("doc:topic");
            this.appendBlock("doc:condition", plSpezifikation);
            this.appendBlock("doc:errorTextShort", mm.getFehlertextKurz());
            this.endElementBlock();
        }
        this.endBlock("doc:checks");
        this.appendList("doc:nonCompilableChecks", "check", this.pruefungStat.getFehlerhafteElementeAsList(true));
    }

    private void appendClassificationDoc(List tmpList) {
        ClassificationDokuGenerator cdg = new ClassificationDokuGenerator(this.klassifikationStat, this.merkmalStat);
        cdg.setOutput(this.out);
        cdg.setIndentLevel(this.indentLevel());
        cdg.generate(tmpList);
    }

    private void appendClassificationElements(Iterator auspraegungen) {
        this.beginBlock("doc:classificationElements");
        ClassificationDokuGenerator cdg = new ClassificationDokuGenerator(this.klassifikationStat, this.merkmalStat);
        cdg.setOutput(this.out);
        cdg.setIndentLevel(this.indentLevel());
        while (auspraegungen.hasNext()) {
            cdg.visitPLAuspraegung((MetaPLAuspraegung)auspraegungen.next());
        }
        this.endBlock("doc:classificationElements");
    }

    private void appendDocHead(String ablaufId) {
        this.beginBlock("doc:head");
        this.appendBlock("doc:EVAS", this.plausiStat.getEVASNr());
        this.appendBlock("doc:statspezLevel", this.plausiStat.getEbene());
        this.appendBlock("doc:surveyName", this.plausiStat.getName());
        this.appendBlock("doc:BZR", this.plausiStat.getBerichtszeitraum());
        if (ablaufId != null && ablaufId.length() > 0) {
            DokuElement de = this.ablaufStat.getElement(ablaufId);
            MetaCustomAblauf mca = (MetaCustomAblauf)de.getElement();
            this.beginBlock("doc:flow");
            this.beginElementBlock(String.valueOf(mca.getThemenbereich().getName()) + "." + mca.getName(), mca.getId(), "flow", de.getZusatz());
            this.appendBlock("doc:annotation", mca.getKommentar());
            this.appendBlock("doc:description", mca.getBeschreibung());
            this.endElementBlock();
            this.endBlock("doc:flow");
        }
        this.appendBlock("doc:user", System.getProperty("user.name"));
        this.appendBlock("doc:date", Settings.getCurrentDate());
        this.endBlock("doc:head");
        this.out.flush();
    }

    private void appendDataSetTypeDoc(MetaDsbObjekt dsb) {
        this.beginBlock("doc:dataSetTypes");
        this.beginElementBlock(dsb.getName(), dsb.getId(), "dataSetType", "");
        this.appendBlock("doc:annotation", dsb.getKommentar());
        this.appendBlock("doc:description", dsb.getBeschreibung());
        this.appendBlock("doc:recordFormat", dsb.getSatzformat());
        this.appendBlock("doc:recordLength", dsb.getSatzlaenge());
        this.beginBlock("doc:single-fields");
        Iterator it = dsb.getComps().getCompList();
        if (it != null) {
            this.appendSingleFieldsDoc(it);
        }
        this.endBlock("doc:single-fields");
        if (dsb.getComps().sizeOfSatzList() > 0) {
            this.beginBlock("doc:dataRecords");
            Iterator satzartenIt = dsb.getComps().getSatzList();
            while (satzartenIt != null && satzartenIt.hasNext()) {
                MetaSatzart satzart = (MetaSatzart)satzartenIt.next();
                this.beginElementBlock(satzart.getName(), satzart.getId(), "dataRecord", "");
                String identField = "";
                if (satzart.getEf() != null) {
                    identField = satzart.getEf().getName();
                }
                this.appendBlock("doc:identField", identField);
                this.appendBlock("doc:prefix", satzart.getPraefix());
                this.appendBlock("doc:recordName", satzart.getName());
                this.appendBlock("doc:recordKey", satzart.getKey());
                this.beginBlock("doc:single-fields");
                Iterator efIt = satzart.getFelder();
                if (efIt != null) {
                    this.appendSingleFieldsDoc(efIt);
                }
                this.endBlock("doc:single-fields");
                this.endElementBlock();
            }
            this.endBlock("doc:dataRecords");
        }
        this.endElementBlock();
        this.endBlock("doc:dataSetTypes");
        this.out.flush();
    }

    private void appendSingleFieldsDoc(Iterator fields) {
        Iterator it = fields;
        while (it.hasNext()) {
            String statVarId;
            MetaDsbFeld mdf = (MetaDsbFeld)it.next();
            if (!(mdf instanceof MetaEinzelfeld)) continue;
            MetaEinzelfeld ef = (MetaEinzelfeld)mdf;
            this.beginElementBlock(ef.getName(), ef.getId(), "single-field", "");
            this.appendBlock("doc:offset", ef.getSatzVon());
            this.appendBlock("doc:upTo", ef.getSatzBis());
            this.appendBlock("doc:length", ef.getSatzAnz());
            this.appendBlock("doc:dataType", ef.getTypIntern());
            DokuElement fde = null;
            this.beginBlock("doc:referencedField");
            String fieldId = this.efStat.getFieldIdFromEFId(ef.getId());
            if (fieldId != null) {
                fde = this.feldStat.getElement(fieldId);
                MetaTBFeld mtbf = (MetaTBFeld)fde.getElement();
                this.beginElementBlock(fde.getName(), fde.getId(), "field", fde.getZusatz());
                this.appendBlock("doc:objectPackage", Tags.dekodierePunkten((String)mtbf.getMetaObjectContext().getObjectPakage()));
                this.endElementBlock();
            }
            this.endBlock("doc:referencedField");
            this.beginBlock("doc:referencedStatisticVariable");
            if (fde != null && (statVarId = this.merkmalStat.getIdFromFieldContext(String.valueOf(fde.getTbId()) + "." + fde.getBaseName())) != null) {
                DokuElement mde = this.merkmalStat.getElement(statVarId);
                MetaCustomMerkmal merkmal = (MetaCustomMerkmal)mde.getElement();
                this.beginElementBlock(mde.getName(), mde.getId(), "statisticVariable", mde.getZusatz());
                this.appendBlock("doc:values", merkmal.getWertebereich());
                this.beginBlock("doc:classification");
                if (merkmal.getKlasseWertebereich() != null) {
                    this.beginElementBlock(merkmal.getKlasseWertebereich().getName(), merkmal.getKlasseWertebereich().getId(), "classification", "");
                    this.appendClassificationElements(merkmal.getKlasseWertebereich().getAuspraegungsComps().getAuspraegungen());
                    this.endElementBlock();
                }
                this.endBlock("doc:classification");
                this.appendBlock("doc:annotation", merkmal.getKommentar());
                this.appendBlock("doc:objectPackage", Tags.dekodierePunkten((String)merkmal.getMetaObjectContext().getObjectPakage()));
                this.endElementBlock();
            }
            this.endBlock("doc:referencedStatisticVariable");
            this.endElementBlock();
        }
    }

    private void appendFieldAnalysis() {
        this.beginBlock("doc:fieldDoc");
        this.beginBlock("doc:summary");
        this.appendCount("doc:dataSetTypes", this.plausiStat.isTb() ? 0 : this.dsbStat.getCount());
        this.beginBlock("doc:fields");
        this.appendCount("doc:allFields", this.feldStat.getCount());
        this.appendCount("doc:lockedFields", this.feldStat.getLockedCount());
        this.appendCount("doc:notInDSBFields", this.feldStat.getNotInDSBCount());
        this.appendCount("doc:emptyFields", this.feldStat.getEmptyFieldsCount());
        this.appendCount("doc:notInBasePackage", this.feldStat.getNotInBasePackageCount(this.plausiStat.getEbene()));
        this.appendCount("doc:withAnnotationFields", this.feldStat.getWithAnnotationCount());
        this.appendCount("doc:notInFlowFields", this.feldStat.getNotReferencedByFlowsCount());
        this.endBlock("doc:fields");
        this.endBlock("doc:summary");
        this.beginBlock("doc:context");
        Iterator it = this.feldStat.getElementList().iterator();
        this.beginBlock("doc:allFields");
        while (it.hasNext()) {
            DokuElement fde = (DokuElement)it.next();
            MetaCustomTBFeld feld = (MetaCustomTBFeld)fde.getElement();
            this.beginElementBlock(fde.getName(), fde.getId(), "field", fde.getZusatz());
            DokuElement mde = this.merkmalStat.getElementFromField(feld);
            if (mde != null) {
                this.beginBlock("doc:references");
                this.appendEmptyElement(mde.getName(), mde.getId(), "statisticVariable", mde.getZusatz());
                this.endBlock("doc:references");
            }
            this.endElementBlock();
        }
        this.endBlock("doc:allFields");
        this.appendList("doc:notInDSBFields", "field", this.feldStat.getNotInDSBList());
        this.appendList("doc:lockedFields", "field", this.feldStat.getLockedList());
        this.appendList("doc:withAnnotationFields", "field", this.feldStat.getWithAnnotationList());
        this.appendList("doc:emptyFields", "field", this.feldStat.getEmptyFieldsList());
        this.appendList("doc:notInBasePackage", "statisticVariable", this.feldStat.getNotInBasePackageList(this.plausiStat.getEbene()));
        this.appendList("doc:notInFlowFields", "field", this.feldStat.getNotReferencedByFlowsList());
        this.endBlock("doc:context");
        this.endBlock("doc:fieldDoc");
        this.out.flush();
    }

    private void appendFlowDoc(String ablaufId) {
        DokuElement de = this.ablaufStat.getElement(ablaufId);
        this.ablaufStat.generateAblaufLists(ablaufId, true);
        ArrayList<DokuElement> besuchteAbl = new ArrayList<DokuElement>(this.ablaufStat.getBesuchteAblaeufe());
        Collections.sort(besuchteAbl);
        besuchteAbl.add(0, de);
        TbFeldErsetzer tbFeldErsetzer = new TbFeldErsetzer(this.efStat);
        this.beginBlock("doc:flows");
        Iterator it = besuchteAbl.iterator();
        while (it.hasNext()) {
            this.out.flush();
            DokuElement ablDe = (DokuElement)it.next();
            MetaCustomAblauf ablauf = (MetaCustomAblauf)ablDe.getElement();
            this.beginElementBlock(ablDe.getName(), ablDe.getId(), "flow", ablDe.getZusatz());
            String tbName = ablDe.getName().substring(0, ablDe.getName().indexOf(46));
            this.beginBlock("doc:topic");
            this.appendEmptyElement(tbName, ablDe.getTbId(), "topic", ablDe.getZusatz());
            this.endBlock("doc:topic");
            this.beginBlock("doc:fields");
            Iterator eIt = this.ablaufStat.getFeldAblauf(ablDe.getId()).iterator();
            while (eIt.hasNext()) {
                this.out.flush();
                CustomDokuElement cde = (CustomDokuElement)eIt.next();
                this.appendEmptyElement(cde.getName(), cde.getId(), "field", cde.getZusatz());
            }
            this.endBlock("doc:fields");
            eIt = this.ablaufStat.getPruefAblauf(ablDe.getId()).iterator();
            this.appendCheckOrder(eIt);
            this.appendBlock("doc:description", ablauf.getBeschreibung());
            this.appendBlock("doc:annotation", ablauf.getKommentar());
            if (this.isErsetzeFeldNamen()) {
                this.appendBlock("doc:spec", tbFeldErsetzer.erstetzeTBFeldNamen(ablauf.getMetaSpezifikation(), ablauf.getSpezifikation()));
            } else {
                this.appendBlock("doc:spec", ablauf.getSpezifikation());
            }
            this.appendList("doc:invokedFlows", "flow", this.ablaufStat.getAufgerufeneAblaeufe(ablDe.getId()));
            this.endElementBlock();
        }
        this.endBlock("doc:flows");
    }

    private void appendStatVarAnalysis() {
        this.beginBlock("doc:statisticVariableDoc");
        this.beginBlock("doc:summary");
        this.appendCount("doc:dataSetTypes", this.plausiStat.isTb() ? 0 : this.dsbStat.getCount());
        this.beginBlock("doc:statisticVariables");
        this.appendCount("doc:allVariables", this.merkmalStat.getCount());
        this.appendCount("doc:lockedVariables", this.merkmalStat.getLockedCount());
        this.appendCount("doc:notInBasePackage", this.merkmalStat.getNotInBasePackageCount(this.plausiStat.getEbene()));
        this.appendCount("doc:withAnnotationVariables", this.merkmalStat.getWithAnnotationCount());
        this.appendCount("doc:noCheckVariables", this.merkmalStat.getNoChecksCount());
        this.appendCount("doc:notInDSBVariables", this.merkmalStat.getNotInDSBCount());
        this.appendCount("doc:VariablesWithoutDisplayText", this.merkmalStat.getKeinFormulartextCount());
        this.appendCount("doc:VariablesWithoutErrorTexts", this.merkmalStat.getKeinFehlertextCount());
        this.appendCount("doc:nonCompilableVariables", this.merkmalStat.getFehlerhafteElementeCount());
        this.endBlock("doc:statisticVariables");
        this.endBlock("doc:summary");
        this.beginBlock("doc:context");
        this.appendList("doc:allVariables", "statisticVariable", this.merkmalStat.getElementList());
        this.appendValueList("doc:withAnnotationVariables", "statisticVariable", "doc:annotation", this.merkmalStat.getWithAnnotationList(), this.kommentarStat.getStatVarAnnotations());
        this.appendList("doc:noCheckVariables", "statisticVariable", this.merkmalStat.getNoChecksList());
        this.appendList("doc:lockedVariables", "statisticVariable", this.merkmalStat.getLockedList());
        this.appendList("doc:notInBasePackage", "statisticVariable", this.merkmalStat.getNotInBasePackageList(this.plausiStat.getEbene()));
        this.appendList("doc:notInDSBVariables", "statisticVariable", this.merkmalStat.getNotInDSBList());
        this.appendList("doc:VariablesWithoutDisplayText", "statisticVariable", this.merkmalStat.getKeinFormulartextList());
        this.appendList("doc:VariablesWithoutErrorTexts", "statisticVariable", this.merkmalStat.getKeinFehlertextList());
        this.endBlock("doc:context");
        this.endBlock("doc:statisticVariableDoc");
        this.out.flush();
    }

    private void appendStatVarDoc(ArrayList merkmale) {
        this.beginBlock("doc:statisticVariables");
        for (DokuElement mde : merkmale) {
            MetaCustomMerkmal mcm = (MetaCustomMerkmal)mde.getElement();
            this.out.flush();
            this.beginElementBlock(mde.getBaseName(), mde.getId(), "statisticVariable", mde.getZusatz());
            this.appendBlock("doc:displayName", mcm.getBezeichnung());
            this.appendBlock("doc:description", mcm.getBeschreibung());
            this.appendBlock("doc:question", mcm.getFrage());
            this.appendList("doc:referencingFields", "field", this.createFieldElements(this.merkmalStat.getFeldReferenzen(mcm.getId())));
            this.beginBlock("doc:classification");
            if (mcm.getKlasseWertebereich() != null) {
                this.appendEmptyElement(mcm.getKlasseWertebereich().getName(), mcm.getKlasseWertebereich().getId(), "classification", "");
                this.appendClassificationElements(mcm.getKlasseWertebereich().getAuspraegungsComps().getAuspraegungen());
            }
            this.endBlock("doc:classification");
            this.appendBlock("doc:values", mcm.getWertebereich());
            this.appendBlock("doc:emptyAllowed", Boolean.toString(mcm.getLeer()));
            this.appendBlock("doc:correctionDescription", mcm.getKorrekturhinweis());
            this.appendBlock("doc:status", Settings.FREIGABESTATUS[mcm.getFreigabeStatus()]);
            this.appendBlock("doc:statisticVariableType", Settings.FELD_TYP[mcm.getTyp() - 1]);
            this.appendBlock("doc:length", mcm.getLaenge());
            this.appendBlock("doc:annotation", mcm.getKommentar());
            ArrayList list = this.tbStat.resolveIds(this.merkmalStat.getTopicReferences(mde.getId()));
            Collections.sort(list);
            this.appendList("doc:referencingTopics", "topic", list);
            this.endElementBlock();
        }
        this.endBlock("doc:statisticVariables");
        this.out.flush();
    }

    private void appendFunctionDoc(List filteredFunctions) {
        TbFeldErsetzer tbFeldErsetzer = new TbFeldErsetzer(this.efStat);
        this.beginBlock("doc:functions");
        List funktionen = filteredFunctions;
        if (funktionen == null) {
            funktionen = this.funktionStat.getFunktionen(true);
        }
        for (DokuElement de : funktionen) {
            MetaCustomFunktion mcf = (MetaCustomFunktion)de.getElement();
            this.beginElementBlock(de.getName(), de.getId(), "function", de.getZusatz());
            if (this.isErsetzeFeldNamen()) {
                this.appendBlock("doc:spec", tbFeldErsetzer.erstetzeTBFeldNamen(mcf.getMetaSpezifikation(), mcf.getAnweisungen()));
            } else {
                this.appendBlock("doc:spec", mcf.getAnweisungen());
            }
            this.appendBlock("doc:annotation", mcf.getKommentar());
            this.appendBlock("doc:description", mcf.getBeschreibung());
            this.appendBlock("doc:objectPackage", Tags.dekodierePunkten((String)mcf.getMetaObjectContext().getObjectPakage()));
            this.endElementBlock();
        }
        this.endBlock("doc:functions");
    }

    private void appendTestDoc(List filteredTests) {
        TbFeldErsetzer tbFeldErsetzer = new TbFeldErsetzer(this.efStat);
        this.beginBlock("doc:tests");
        List eigenschaften = filteredTests;
        if (eigenschaften == null) {
            eigenschaften = this.funktionStat.getEigenschften(true);
        }
        for (DokuElement de : eigenschaften) {
            MetaCustomFunktion mcf = (MetaCustomFunktion)de.getElement();
            this.beginElementBlock(de.getName(), de.getId(), "test", de.getZusatz());
            if (this.isErsetzeFeldNamen()) {
                this.appendBlock("doc:spec", tbFeldErsetzer.erstetzeTBFeldNamen(mcf.getMetaSpezifikation(), mcf.getAnweisungen()));
            } else {
                this.appendBlock("doc:spec", mcf.getAnweisungen());
            }
            this.appendBlock("doc:annotation", mcf.getKommentar());
            this.appendBlock("doc:description", mcf.getBeschreibung());
            this.appendBlock("doc:objectPackage", Tags.dekodierePunkten((String)mcf.getMetaObjectContext().getObjectPakage()));
            this.endElementBlock();
        }
        this.endBlock("doc:tests");
    }

    private ArrayList createFieldElements(HashSet ids) {
        ArrayList<DokuElement> result = new ArrayList<DokuElement>();
        for (String id : ids) {
            List kontexte = this.feldStat.getKontexts(id);
            DokuElement origDe = this.feldStat.getElement(id);
            for (String kontext : kontexte) {
                DokuElement currDe = new DokuElement(id, kontext, origDe.getDimensionen());
                currDe.setElement(origDe.getElement());
                currDe.setTbId(origDe.getTbId());
                currDe.setZusatz(origDe.getZusatz());
                result.add(currDe);
            }
        }
        Collections.sort(result);
        return result;
    }

    private void getData(MetaCustomPlausibilisierung aPlausi) {
        System.out.println("### GetData (MetaPlausibilisierung: " + aPlausi.getName() + ")");
        Hashtable tbScopes = new Hashtable();
        Scope plausiScope = this.createPlausiScopes(aPlausi, tbScopes);
        CrossReferenceBuilder crefBuilder = new CrossReferenceBuilder();
        crefBuilder.buildCrossReference(aPlausi, plausiScope, tbScopes);
        ErhebungsTBReferenceBuilder erhebungRefBuilder = new ErhebungsTBReferenceBuilder();
        erhebungRefBuilder.buildErhebungsTBReferences(aPlausi);
        this.plausiStat.setPlausi(aPlausi);
        this.kommentarStat.setPlausiAnnotation(aPlausi.getName(), aPlausi.getKommentar());
        if (this.plausiStat.getDsbElement() != null) {
            this.efStat.addAll((MetaDsbObjekt)this.plausiStat.getDsbElement().getElement());
        }
        this.visitElements(aPlausi.getMerkmale());
        this.processPlausiThemenBereiche(aPlausi);
        this.processPlausiMappings(aPlausi);
        Iterator it = aPlausi.getPLMaterialien();
        while (it.hasNext()) {
            MetaPLMaterial mat = (MetaPLMaterial)it.next();
            this.materialStat.add(mat);
            this.kommentarStat.addToMaterialAnnotations(mat);
        }
        it = aPlausi.getAuspraegungsgruppen();
        while (it.hasNext()) {
            MetaAuspraegungsgruppe mag = (MetaAuspraegungsgruppe)it.next();
            this.klassifikationStat.add(mag);
            this.kommentarStat.addToClassificationAnnotations(mag);
        }
        it = aPlausi.getDsbs();
        while (it.hasNext()) {
            MetaDsbObjekt dsb = (MetaDsbObjekt)it.next();
            this.dsbStat.add(dsb);
            this.kommentarStat.addToDsbAnnotations(dsb);
        }
        it = aPlausi.getDatBs();
        while (it.hasNext()) {
            this.kommentarStat.addToDatBAnnotations((MetaDatBObjekt)it.next());
        }
    }

    private void processPlausiThemenBereiche(MetaPlausibilisierung plausi) {
        Iterator it = plausi.getThemenbereiche();
        while (it.hasNext()) {
            MetaThemenbereich aTb = (MetaThemenbereich)it.next();
            aTb.accept(this);
        }
        this.merkmalStat.resolveAndAddReferencedByChecksFields(this.pruefungStat.getReferencedFieldContexts());
        this.pruefungStat.setReferenced(this.ablaufStat.getReferencedChecks());
        this.feldStat.setReferencedByFlows(this.ablaufStat.getReferencedFields());
    }

    private void processPlausiMappings(MetaCustomPlausibilisierung plausi) {
        System.out.println("### verarbeite die Mappings der Plausibilisierung " + plausi.getName());
        Iterator it = plausi.getMappings();
        while (it.hasNext()) {
            MetaCustomMapping aMapping = (MetaCustomMapping)it.next();
            if (aMapping.isVirtual() || !((MetaCustomThemenbereich)aMapping.getThemenbereich()).referencedByErhebung()) continue;
            this.kommentarStat.addToMappingAnnotations(aMapping);
        }
        MetaMapping mapping = plausi.usedMappings();
        if (mapping != null) {
            String currentTopicId = mapping.getThemenbereich().getId();
            Iterator mIt = mapping.getMappingliste();
            while (mIt.hasNext()) {
                MetaCustomMappingElement aMapElement = (MetaCustomMappingElement)mIt.next();
                if (aMapElement.getMappingTyp() != 0) continue;
                String currentContext = String.valueOf(currentTopicId) + "." + aMapElement.getTBFeldListeAlsName();
                String curBaseContext = this.feldStat.getBaseContext(currentContext);
                if (curBaseContext != null) {
                    String efId = aMapElement.getFeldDSB().getId();
                    String statVarId = this.merkmalStat.getIdFromFieldContext(curBaseContext);
                    String fieldId = this.feldStat.getFieldIdFromContext(curBaseContext);
                    if (fieldId != null && statVarId != null) {
                        this.feldStat.addToInDSB(this.feldStat.getFieldIdFromContext(curBaseContext));
                        this.efStat.addEfFieldReference(efId, fieldId);
                        this.merkmalStat.addToInDSB(statVarId);
                        continue;
                    }
                    this.error(mapping, "Der Kontext \"" + currentContext + "\"" + " im Mapping " + "\"" + mapping.getName() + "\"" + " des Themenbereichs " + "\"" + mapping.getThemenbereich().getName() + "\"" + " verweist auf ein nicht vorhandenes Feld." + " Die Referenz wurde nicht erfasst.");
                    continue;
                }
                this.error(mapping, "Der Basiskontext von \"" + currentContext + "\"" + " im Mapping " + "\"" + mapping.getName() + "\"" + " des Themenbereichs " + "\"" + mapping.getThemenbereich().getName() + "\"" + " konnte nicht ermittelt werden." + " Die Referenz wurde nicht erfasst.");
            }
        }
    }

    protected Scope createPlausiScopes(MetaPlausibilisierung plausi, Hashtable tbScopes) {
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        return scopeBuilder.createScopes(plausi, tbScopes, true);
    }
}

