/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.doku;

import de.statspez.pleditor.generator.codegen.doku.AbstractStat;
import de.statspez.pleditor.generator.codegen.doku.DokuElement;
import de.statspez.pleditor.generator.codegen.doku.ReferenceGetter;
import de.statspez.pleditor.generator.meta.MetaCustomPruefung;
import de.statspez.pleditor.generator.meta.generated.MetaStatspezObjekt;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public class PruefungStat
extends AbstractStat {
    private HashSet imputationChecks = new HashSet();
    private HashSet mandatoryChecks = new HashSet();
    private HashSet noCorrectionOrErrorText = new HashSet();
    private HashSet optionalChecks = new HashSet();
    private HashSet referencedFieldContexts = new HashSet();
    private ArrayList automaticVerificationList = null;
    private ArrayList errorVerificationList = null;
    private ArrayList manualVerificationList = null;
    private ArrayList noCorrectionOrErrorTextList = null;
    private ArrayList warningVerificationList = null;

    @Override
    public void add(MetaStatspezObjekt pruefung) {
        MetaCustomPruefung p = (MetaCustomPruefung)pruefung;
        if (!this.idElementTable.containsKey(p.getId())) {
            boolean keinKorrekturHinweis;
            DokuElement de = new DokuElement(p.getId(), p.getName());
            de.setElement(p);
            this.idElementTable.put(p.getId(), de);
            if (p.getKommentar() != null && p.getKommentar().trim().length() > 0) {
                this.addToWithAnnotation(p.getId());
            }
            boolean manuell = p.getPruefungsart() == 1 || p.getPruefungsart() == 2;
            boolean keinFehlerText = p.getFehlertextKurz().trim().length() == 0 && p.getFehlertextLang().trim().length() == 0;
            boolean bl = keinKorrekturHinweis = p.getKorrekturhinweis().trim().length() == 0;
            if (manuell && (keinFehlerText || keinKorrekturHinweis)) {
                this.addToNoCorrectionOrErrorText(pruefung.getId());
            }
            switch (p.getPruefungsart()) {
                case 1: {
                    this.mandatoryChecks.add(p.getId());
                    break;
                }
                case 2: {
                    this.optionalChecks.add(p.getId());
                    break;
                }
                case 3: {
                    this.imputationChecks.add(p.getId());
                }
            }
            if (p.getFreigabeStatus() == 0) {
                this.addToLocked(p.getId());
            }
            ReferenceGetter rg = new ReferenceGetter();
            rg.generateReferencedSet(p);
            this.referencedFieldContexts.addAll(rg.getFeldNamen());
            if (!p.istKompilierbar()) {
                this.fehlerHafteElemente.add(de);
                de.setZusatz("fehlerhaft");
            }
        }
    }

    public boolean addToNoCorrectionOrErrorText(String id) {
        return this.noCorrectionOrErrorText.add(id);
    }

    public int getAutomaticVerificationChecksCount() {
        return this.imputationChecks.size();
    }

    public List getAutomaticVerificationList() {
        if (this.automaticVerificationList == null) {
            return this.resolveIds(this.imputationChecks);
        }
        return this.automaticVerificationList;
    }

    public int getErrorVerificationChecksCount() {
        return this.mandatoryChecks.size() + this.imputationChecks.size();
    }

    public List getErrorVerificationList() {
        if (this.errorVerificationList == null) {
            ArrayList tmpList = new ArrayList();
            tmpList.addAll(this.resolveIds(this.mandatoryChecks));
            tmpList.addAll(this.resolveIds(this.imputationChecks));
            return tmpList;
        }
        return this.errorVerificationList;
    }

    public int getManualVerificationChecksCount() {
        return this.mandatoryChecks.size() + this.optionalChecks.size();
    }

    public List getManualVerificationList() {
        if (this.noCorrectionOrErrorTextList == null) {
            ArrayList tmpList = new ArrayList();
            tmpList.addAll(this.resolveIds(this.mandatoryChecks));
            tmpList.addAll(this.resolveIds(this.optionalChecks));
            return tmpList;
        }
        return this.noCorrectionOrErrorTextList;
    }

    public String[] splitConditionalStatement(String conditionalStatement) {
        String cs = conditionalStatement.replaceAll("\n", " ");
        if (!cs.trim().startsWith("WENN") || cs.indexOf("DANN") == -1 || conditionalStatement.indexOf("\nFEHLER\nENDE") == -1) {
            return null;
        }
        int von = PruefungStat.indexOf(cs, "WENN", 0) + "WENN".length() + 1;
        int ifCnt = 1;
        int bis = 0;
        int tmp = von;
        while (ifCnt > 0) {
            bis = PruefungStat.indexOf(cs, " ", tmp);
            String tmpStr = cs.substring(tmp, bis);
            if (tmpStr.equalsIgnoreCase("DANN")) {
                --ifCnt;
            } else if (tmpStr.equalsIgnoreCase("WENN")) {
                ++ifCnt;
            }
            tmp = bis + 1;
        }
        int ende = PruefungStat.indexOf(conditionalStatement, "\nFEHLER\nENDE", 0);
        String dannTeil = conditionalStatement.substring(bis, ende).trim();
        bis = bis - "DANN".length() - 1;
        String wennTeil = conditionalStatement.substring(von, bis).trim();
        return new String[]{wennTeil, dannTeil};
    }

    public static int indexOf(String statement, String searchString, int fromIndex) {
        boolean inComment = false;
        int possible_index = -1;
        int erg_index = -1;
        int lauf_index = fromIndex;
        possible_index = statement.indexOf(searchString, fromIndex);
        while (possible_index >= 0 && erg_index == -1 && lauf_index < statement.length()) {
            if (statement.charAt(lauf_index) == '\"') {
                inComment = !inComment;
            } else if (!inComment && lauf_index >= possible_index && (possible_index = statement.indexOf(searchString, lauf_index)) - lauf_index == 0) {
                erg_index = lauf_index;
            }
            ++lauf_index;
        }
        return erg_index;
    }

    public HashSet getNoCorrectionOrErrorText() {
        return this.noCorrectionOrErrorText;
    }

    public int getNoCorrectionOrErrorTextCount() {
        return this.noCorrectionOrErrorText.size();
    }

    public List getNoCorrectionOrErrorTextList() {
        if (this.noCorrectionOrErrorTextList == null) {
            return this.resolveIds(this.noCorrectionOrErrorText);
        }
        return this.noCorrectionOrErrorTextList;
    }

    public HashSet getReferencedFieldContexts() {
        return this.referencedFieldContexts;
    }

    public List getWarningVerificationList() {
        if (this.warningVerificationList == null) {
            return this.resolveIds(this.optionalChecks);
        }
        return this.warningVerificationList;
    }

    public int getWarninigVerificationChecksCount() {
        return this.optionalChecks.size();
    }

    @Override
    public void initializeLists() {
        this.initializeLists(false);
    }

    @Override
    public void initializeLists(boolean force) {
        if (this.noCorrectionOrErrorTextList == null | force) {
            this.noCorrectionOrErrorTextList = new ArrayList();
            this.noCorrectionOrErrorTextList.addAll(this.resolveIds(this.noCorrectionOrErrorText));
        }
        if (this.automaticVerificationList == null | force) {
            this.automaticVerificationList = new ArrayList();
            this.automaticVerificationList.addAll(this.resolveIds(this.imputationChecks));
        }
        if (this.manualVerificationList == null | force) {
            this.manualVerificationList = new ArrayList();
            this.manualVerificationList.addAll(this.resolveIds(this.mandatoryChecks));
            this.manualVerificationList.addAll(this.resolveIds(this.optionalChecks));
        }
        if (this.errorVerificationList == null | force) {
            this.errorVerificationList = new ArrayList();
            this.errorVerificationList.addAll(this.resolveIds(this.mandatoryChecks));
            this.errorVerificationList.addAll(this.resolveIds(this.imputationChecks));
        }
        if (this.warningVerificationList == null | force) {
            this.warningVerificationList = new ArrayList();
            this.warningVerificationList.addAll(this.resolveIds(this.optionalChecks));
        }
        super.initializeLists(force);
    }

    @Override
    public void sortLists() {
        this.sortLists(null);
    }

    public void sortLists(List folge) {
        if (folge == null) {
            this.initializeLists();
            Collections.sort(this.noCorrectionOrErrorTextList);
            super.sortListsOnly();
        } else {
            this.elementList = new ArrayList();
            this.lockedList = new ArrayList();
            this.withAnnotationList = new ArrayList();
            this.referencedList = new ArrayList();
            this.noChecksList = new ArrayList();
            this.noCorrectionOrErrorTextList = new ArrayList();
            this.automaticVerificationList = new ArrayList();
            this.manualVerificationList = new ArrayList();
            this.errorVerificationList = new ArrayList();
            this.warningVerificationList = new ArrayList();
            Iterator it = folge.iterator();
            while (it.hasNext()) {
                DokuElement aktPruefung = this.getElement((String)it.next());
                this.elementList.add(aktPruefung);
                if (this.locked.contains(aktPruefung)) {
                    this.lockedList.add(aktPruefung);
                }
                if (this.withAnnotation.contains(aktPruefung)) {
                    this.withAnnotationList.add(aktPruefung);
                }
                if (this.referenced.contains(aktPruefung)) {
                    this.referencedList.add(aktPruefung);
                }
                if (this.noChecks.contains(aktPruefung)) {
                    this.noChecksList.add(aktPruefung);
                }
                if (this.noCorrectionOrErrorText.contains(aktPruefung)) {
                    this.noCorrectionOrErrorTextList.add(aktPruefung);
                }
                if (this.imputationChecks.contains(aktPruefung)) {
                    this.automaticVerificationList.add(aktPruefung);
                }
                if (this.mandatoryChecks.contains(aktPruefung) || this.optionalChecks.contains(aktPruefung)) {
                    this.manualVerificationList.add(aktPruefung);
                }
                if (this.mandatoryChecks.contains(aktPruefung) || this.imputationChecks.contains(aktPruefung)) {
                    this.errorVerificationList.add(aktPruefung);
                }
                if (!this.optionalChecks.contains(aktPruefung)) continue;
                this.warningVerificationList.add(aktPruefung);
            }
        }
    }
}

