/*
 * Decompiled with CFR 0.152.
 */
package de.statspez.pleditor.generator.codegen.java;

import de.statspez.pleditor.generator.codegen.analysis.ErhebungsTBReferenceBuilder;
import de.statspez.pleditor.generator.codegen.analysis.MaterialNamenPruefer;
import de.statspez.pleditor.generator.codegen.java.CodegenContext;
import de.statspez.pleditor.generator.codegen.java.DefaultCodegenContext;
import de.statspez.pleditor.generator.codegen.java.PlausiCodeGenerator;
import de.statspez.pleditor.generator.codegen.java.PlausiDescriptorGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.DSBScopeGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.PlausiMappingGenerator;
import de.statspez.pleditor.generator.codegen.java.mapping.RAWScopeGenerator;
import de.statspez.pleditor.generator.codegen.mapping.MappingProgramGenerator;
import de.statspez.pleditor.generator.codegen.mapping.structure.Mapping;
import de.statspez.pleditor.generator.codegen.mapping.structure.MappingMeta;
import de.statspez.pleditor.generator.codegen.semantic.SemanticCheck;
import de.statspez.pleditor.generator.codegen.semantic.SemanticCheckResult;
import de.statspez.pleditor.generator.codegen.support.CodegenException;
import de.statspez.pleditor.generator.codegen.support.GenericSymbolDescriptorFactory;
import de.statspez.pleditor.generator.codegen.support.Scope;
import de.statspez.pleditor.generator.codegen.support.ScopeImpl;
import de.statspez.pleditor.generator.codegen.support.TbScopeBuilder;
import de.statspez.pleditor.generator.codegen.support.Traverser;
import de.statspez.pleditor.generator.meta.MetaCustomMapping;
import de.statspez.pleditor.generator.meta.MetaCustomPLMaterial;
import de.statspez.pleditor.generator.meta.MetaProgram;
import de.statspez.pleditor.generator.meta.generated.MetaMerkmal;
import de.statspez.pleditor.generator.meta.generated.MetaPLMaterial;
import de.statspez.pleditor.generator.meta.generated.MetaPlausibilisierung;
import de.statspez.pleditor.generator.meta.generated.MetaThemenbereich;
import de.statspez.pleditor.generator.parser.Helper;
import java.io.IOException;
import java.util.Hashtable;

public class CodegenFacade {
    public SemanticCheckResult semanticCheck(MetaProgram prg, Scope prgScope) throws CodegenException {
        SemanticCheck scopeChecker = new SemanticCheck();
        scopeChecker.setErrorContext(prg.contextInfos());
        return scopeChecker.checkProgram(prg, prgScope);
    }

    public SemanticCheckResult semanticCheck(Mapping mapping, Scope scopeForReadAccess, Scope scopeForWriteAccess) throws CodegenException {
        String mappingProgram = new MappingProgramGenerator().createMappingProgram(mapping);
        MetaProgram program = Helper.metaStructureFor(mappingProgram);
        return this.semanticCheck(program, scopeForReadAccess, scopeForWriteAccess, true);
    }

    public SemanticCheckResult semanticCheck(MetaProgram prg, Scope scopeForReadAccess, Scope scopeForWriteAccess, boolean mappingContext) throws CodegenException {
        SemanticCheck semanticCheck = new SemanticCheck();
        semanticCheck.setMappingContext(mappingContext);
        semanticCheck.setErrorContext(prg.contextInfos());
        return semanticCheck.checkProgram(prg, scopeForReadAccess, scopeForWriteAccess);
    }

    public void semanticCheck(MetaPlausibilisierung plausi) throws CodegenException {
        this.semanticCheck(plausi, false, false);
    }

    public void semanticCheck(MetaPlausibilisierung plausi, final boolean checkDsbMapping, final boolean checkRawMapping) throws CodegenException {
        final Hashtable tbScopes = new Hashtable();
        final Scope plausiScope = this.createPlausiScopes(plausi, tbScopes);
        plausi.accept(new Traverser(){
            private Scope prgScope = null;

            @Override
            public void visitThemenbereich(MetaThemenbereich aTb) {
                this.prgScope = (Scope)tbScopes.get(aTb.getName());
                super.visitThemenbereich(aTb);
                if (!$assertionsDisabled && this.prgScope == null) {
                    throw new AssertionError((Object)("kein Scope fuer Tb " + aTb.getName()));
                }
            }

            @Override
            public void visitMerkmal(MetaMerkmal aMerkmal) {
                this.prgScope = new ScopeImpl(plausiScope);
                super.visitMerkmal(aMerkmal);
            }

            @Override
            public void visitProgram(MetaProgram aProgram) {
                if (!$assertionsDisabled && this.prgScope == null) {
                    throw new AssertionError((Object)"kein Programm-Scope");
                }
                SemanticCheck scopeChecker = new SemanticCheck();
                scopeChecker.setErrorContext(aProgram.contextInfos());
                scopeChecker.checkProgram(aProgram, this.prgScope);
            }

            @Override
            public void visitPLMaterial(MetaPLMaterial aPlMaterial) {
                MetaCustomPLMaterial plMaterial = (MetaCustomPLMaterial)aPlMaterial;
                MetaCustomMapping mapping = (MetaCustomMapping)plMaterial.getMapping();
                if (checkDsbMapping && mapping != null) {
                    MappingMeta mappingMeta = new MappingMeta(103, mapping);
                    String mappingProgram = new MappingProgramGenerator().createMappingProgram(mappingMeta);
                    this.checkMapping(mapping, mappingProgram, 103);
                    mappingMeta = new MappingMeta(102, mapping);
                    mappingProgram = new MappingProgramGenerator().createMappingProgram(mappingMeta);
                    this.checkMapping(mapping, mappingProgram, 102);
                }
                MetaCustomMapping rawMapping = (MetaCustomMapping)plMaterial.getUsedRawMapping();
                if (checkRawMapping && rawMapping != null) {
                    MappingMeta mappingMeta = new MappingMeta(101, rawMapping);
                    String mappingProgram = new MappingProgramGenerator().createMappingProgram(mappingMeta);
                    this.checkMapping(rawMapping, mappingProgram, 101);
                    mappingMeta = new MappingMeta(100, rawMapping);
                    mappingProgram = new MappingProgramGenerator().createMappingProgram(mappingMeta);
                    this.checkMapping(rawMapping, mappingProgram, 100);
                }
            }

            public void checkMapping(MetaCustomMapping mapping, String mappingProgram, int direction) {
                Scope tbScope = (Scope)tbScopes.get(mapping.getThemenbereich().getName());
                Scope fromScope = null;
                Scope toScope = null;
                String kontext = "Mapping " + mapping.getName();
                if (mapping.isVirtual()) {
                    ScopeImpl mapScope = new RAWScopeGenerator().generate(mapping.getRawDataSet());
                    if (direction == 101) {
                        fromScope = tbScope;
                        toScope = mapScope;
                        kontext = String.valueOf(kontext) + " TB nach RAW";
                    } else {
                        fromScope = mapScope;
                        toScope = tbScope;
                        kontext = String.valueOf(kontext) + " RAW nach TB";
                    }
                } else {
                    ScopeImpl mapScope = new DSBScopeGenerator().generate(mapping.getDSB());
                    if (direction == 103) {
                        fromScope = tbScope;
                        toScope = mapScope;
                        kontext = String.valueOf(kontext) + " TB nach DSB";
                    } else {
                        fromScope = mapScope;
                        toScope = tbScope;
                        kontext = String.valueOf(kontext) + " DSB nach TB";
                    }
                }
                if (fromScope != tbScope) {
                    TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
                    scopeBuilder.includeInternalFunctionsIn(fromScope);
                }
                MetaProgram program = Helper.metaStructureFor(mappingProgram);
                SemanticCheck semanticCheck = new SemanticCheck();
                semanticCheck.setMappingContext(true);
                semanticCheck.setErrorContext(kontext);
                semanticCheck.checkProgram(program, fromScope, toScope);
            }
        });
    }

    public void generate(MetaPlausibilisierung plausi, String outputDir) throws IOException {
        this.generate(plausi, outputDir, false, false);
    }

    public void generate(MetaPlausibilisierung plausi, String outputDir, boolean generateDsbMapping, boolean generateRawMapping) throws IOException {
        this.generate(plausi, outputDir, true, generateDsbMapping, generateRawMapping);
    }

    public void generate(MetaPlausibilisierung plausi, String outputDir, boolean createPackageDirectories) throws IOException {
        this.generate(plausi, outputDir, createPackageDirectories, false, false);
    }

    public void generate(MetaPlausibilisierung plausi, String outputDir, boolean createPackageDirectories, boolean generateDsbMapping, boolean generateRawMapping) throws IOException {
        DefaultCodegenContext codegenContext = new DefaultCodegenContext(plausi, outputDir, createPackageDirectories);
        codegenContext.setGenerateDSBMapping(generateDsbMapping);
        codegenContext.setGenerateRAWMapping(generateRawMapping);
        this.generate(codegenContext);
    }

    public void generate(CodegenContext context) throws IOException {
        this.semanticCheck(context.getPlausi(), context.isGenerateDSBMapping(), context.isGenerateRAWMapping());
        this.generateCodeOnly(context);
    }

    public void generateCodeOnly(MetaPlausibilisierung plausi, String outputDir) throws IOException {
        this.generateCodeOnly(new DefaultCodegenContext(plausi, outputDir));
    }

    public void generateCodeOnly(CodegenContext context) throws IOException {
        ErhebungsTBReferenceBuilder erhebungRefBuilder = new ErhebungsTBReferenceBuilder();
        erhebungRefBuilder.buildErhebungsTBReferences(context.getPlausi());
        MaterialNamenPruefer materialNamenPruefer = new MaterialNamenPruefer();
        materialNamenPruefer.checkForDuplicates(context.getPlausi());
        PlausiCodeGenerator codeGen = new PlausiCodeGenerator();
        codeGen.generate(context);
        PlausiMappingGenerator plausiMappingGenerator = new PlausiMappingGenerator();
        plausiMappingGenerator.generate(context);
        PlausiDescriptorGenerator descriptorGen = new PlausiDescriptorGenerator();
        descriptorGen.generate(context);
    }

    protected Scope createPlausiScopes(MetaPlausibilisierung plausi, Hashtable tbScopes) {
        TbScopeBuilder scopeBuilder = new TbScopeBuilder(new GenericSymbolDescriptorFactory());
        return scopeBuilder.createScopes(plausi, tbScopes);
    }
}

